/*
 * Decompiled with CFR 0.152.
 */
package org.nanocontainer.booter;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;

public class NanoContainerBooter {
    private static final String COMMON_PATH = "lib/common";
    private static final String HIDDEN_PATH = "lib/hidden";

    public static void main(String[] args) throws Exception {
        new NanoContainerBooter(args);
    }

    public NanoContainerBooter(String[] args) throws ClassNotFoundException, IllegalAccessException, InvocationTargetException, InstantiationException, IOException {
        URLClassLoader commonClassLoader = new URLClassLoader(this.toURLs(COMMON_PATH), NanoContainerBooter.class.getClassLoader().getParent());
        URLClassLoader hiddenClassLoader = new URLClassLoader(this.toURLs(HIDDEN_PATH), (ClassLoader)commonClassLoader);
        System.out.println("NanoContainer Booter: Booting...");
        this.newStandalone(hiddenClassLoader, args);
        System.out.println("NanoContainer Booter: Booted.");
    }

    private void newStandalone(URLClassLoader classLoader, String[] args) throws ClassNotFoundException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Class<?> nanoStandalone = classLoader.loadClass("org.nanocontainer.Standalone");
        Constructor<?> constructor = nanoStandalone.getConstructors()[0];
        constructor.newInstance(new Object[]{args});
    }

    private URL[] toURLs(String path) throws MalformedURLException {
        File[] files = new File(path).listFiles();
        URL[] urls = new URL[files.length];
        for (int i = 0; i < files.length; ++i) {
            urls[i] = files[i].toURL();
        }
        return urls;
    }
}

