/*
 * Decompiled with CFR 0.152.
 */
package org.nanocontainer.script.groovy.buildernodes;

import java.util.Iterator;
import java.util.Map;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.nanocontainer.NanoContainer;
import org.nanocontainer.script.NanoContainerMarkupException;
import org.nanocontainer.script.groovy.buildernodes.AbstractBuilderNode;
import org.picocontainer.MutablePicoContainer;

public class BeanNode
extends AbstractBuilderNode {
    public static final String NODE_NAME = "bean";
    public static final String BEAN_CLASS = "beanClass";

    public BeanNode() {
        super(NODE_NAME);
    }

    public Object createNewNode(Object current, Map attributes) {
        MutablePicoContainer pico = ((NanoContainer)current).getPico();
        Object bean = this.createBean(attributes);
        pico.registerComponentInstance(bean);
        return bean;
    }

    protected Object createBean(Map attributes) {
        Class type = (Class)attributes.remove(BEAN_CLASS);
        if (type == null) {
            throw new NanoContainerMarkupException("Bean must have a beanClass attribute");
        }
        try {
            Object bean = type.newInstance();
            Iterator iter = attributes.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                String name = entry.getKey().toString();
                Object value = entry.getValue();
                InvokerHelper.setProperty(bean, (String)name, value);
            }
            return bean;
        }
        catch (IllegalAccessException e) {
            throw new NanoContainerMarkupException("Failed to create bean of type '" + type + "'. Reason: " + e, (Throwable)e);
        }
        catch (InstantiationException e) {
            throw new NanoContainerMarkupException("Failed to create bean of type " + type + "'. Reason: " + e, (Throwable)e);
        }
    }

    public void validateScriptedAttributes(Map specifiedAttributes) throws NanoContainerMarkupException {
        if (!specifiedAttributes.containsKey(BEAN_CLASS)) {
            throw new NanoContainerMarkupException("Attribute beanClass is required.");
        }
    }
}

