/*
 * Decompiled with CFR 0.152.
 */
package org.nanocontainer.script.groovy.buildernodes;

import java.util.List;
import java.util.Map;
import org.nanocontainer.NanoContainer;
import org.nanocontainer.script.ComponentElementHelper;
import org.nanocontainer.script.NodeBuilderDecorationDelegate;
import org.nanocontainer.script.groovy.buildernodes.AbstractBuilderNode;
import org.picocontainer.Parameter;
import org.picocontainer.defaults.ConstantParameter;

public class ComponentNode
extends AbstractBuilderNode {
    public static final String NODE_NAME = "component";
    public static final String KEY = "key";
    private static final String CLASS = "class";
    private static final String CLASS_NAME_KEY = "classNameKey";
    private static final String INSTANCE = "instance";
    private static final String PARAMETERS = "parameters";
    private final NodeBuilderDecorationDelegate delegate;

    public ComponentNode(NodeBuilderDecorationDelegate builderDelegate) {
        super(NODE_NAME);
        this.delegate = builderDelegate;
        this.addAttribute(KEY).addAttribute(CLASS).addAttribute(CLASS_NAME_KEY).addAttribute(INSTANCE).addAttribute(PARAMETERS);
    }

    public Object createNewNode(Object current, Map attributes) {
        this.delegate.rememberComponentKey(attributes);
        Object key = attributes.remove(KEY);
        Object cnkey = attributes.remove(CLASS_NAME_KEY);
        Object classValue = attributes.remove(CLASS);
        Object instance = attributes.remove(INSTANCE);
        List parameters = (List)attributes.remove(PARAMETERS);
        ComponentElementHelper.makeComponent(cnkey, key, (Parameter[])ComponentNode.getParameters(parameters), classValue, (NanoContainer)((NanoContainer)current), instance);
        return this.getNodeName();
    }

    private static Parameter[] getParameters(List paramsList) {
        if (paramsList == null) {
            return null;
        }
        int n = paramsList.size();
        Parameter[] parameters = new Parameter[n];
        for (int i = 0; i < n; ++i) {
            parameters[i] = ComponentNode.toParameter(paramsList.get(i));
        }
        return parameters;
    }

    private static Parameter toParameter(Object obj) {
        return obj instanceof Parameter ? (Parameter)obj : new ConstantParameter(obj);
    }
}

