/*
 * Decompiled with CFR 0.152.
 */
package org.nanocontainer.script;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.nanocontainer.ClassPathElement;
import org.nanocontainer.NanoContainer;
import org.nanocontainer.script.NanoContainerMarkupException;

public class ClassPathElementHelper {
    public static final String HTTP = "http://";

    public static ClassPathElement addClassPathElement(final String path, NanoContainer nanoContainer) {
        URL pathURL = null;
        try {
            if (path.toLowerCase().startsWith(HTTP)) {
                pathURL = new URL(path);
            } else {
                Object rVal = AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        try {
                            File file = new File(path);
                            if (!file.exists()) {
                                return new NanoContainerMarkupException("classpath '" + path + "' does not exist ");
                            }
                            return file.toURL();
                        }
                        catch (MalformedURLException e) {
                            return e;
                        }
                    }
                });
                if (rVal instanceof MalformedURLException) {
                    throw (MalformedURLException)rVal;
                }
                if (rVal instanceof NanoContainerMarkupException) {
                    throw (NanoContainerMarkupException)((Object)rVal);
                }
                pathURL = (URL)rVal;
            }
        }
        catch (MalformedURLException e) {
            throw new NanoContainerMarkupException("classpath '" + path + "' malformed ", e);
        }
        return nanoContainer.addClassLoaderURL(pathURL);
    }
}

