/*
 * Decompiled with CFR 0.152.
 */
package org.nanocontainer.script;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import org.nanocontainer.integrationkit.LifecycleContainerBuilder;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.PicoContainer;

public abstract class ScriptedContainerBuilder
extends LifecycleContainerBuilder {
    private final Reader scriptReader;
    private final URL scriptURL;
    private final ClassLoader classLoader;

    public ScriptedContainerBuilder(Reader script, ClassLoader classLoader) {
        this.scriptReader = script;
        if (script == null) {
            throw new NullPointerException("script");
        }
        this.scriptURL = null;
        this.classLoader = classLoader;
        if (classLoader == null) {
            throw new NullPointerException("classLoader");
        }
    }

    public ScriptedContainerBuilder(URL script, ClassLoader classLoader) {
        this.scriptReader = null;
        this.scriptURL = script;
        if (script == null) {
            throw new NullPointerException("script");
        }
        this.classLoader = classLoader;
        if (classLoader == null) {
            throw new NullPointerException("classLoader");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final PicoContainer createContainer(PicoContainer parentContainer, Object assemblyScope) {
        try {
            PicoContainer picoContainer = this.createContainerFromScript(parentContainer, assemblyScope);
            return picoContainer;
        }
        finally {
            try {
                Reader reader = this.getScriptReader();
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException e) {}
        }
    }

    protected final ClassLoader getClassLoader() {
        return this.classLoader;
    }

    protected final InputStream getScriptInputStream() throws IOException {
        if (this.scriptReader != null) {
            return new InputStream(){

                public int read() throws IOException {
                    return ScriptedContainerBuilder.this.scriptReader.read();
                }
            };
        }
        return this.scriptURL.openStream();
    }

    protected final Reader getScriptReader() throws IOException {
        if (this.scriptReader != null) {
            return this.scriptReader;
        }
        return new InputStreamReader(this.scriptURL.openStream());
    }

    protected abstract PicoContainer createContainerFromScript(PicoContainer var1, Object var2);

    protected void composeContainer(MutablePicoContainer container, Object assemblyScope) {
    }
}

