/*
 * Decompiled with CFR 0.152.
 */
package org.nanocontainer.script;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.net.URL;
import org.nanocontainer.DefaultNanoContainer;
import org.nanocontainer.script.ScriptBuilderResolver;
import org.nanocontainer.script.ScriptedContainerBuilder;
import org.nanocontainer.script.UnsupportedScriptTypeException;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.PicoContainer;
import org.picocontainer.defaults.DefaultPicoContainer;

public class ScriptedContainerBuilderFactory {
    public static final String GROOVY = ".groovy";
    public static final String BEANSHELL = ".bsh";
    public static final String JAVASCRIPT = ".js";
    public static final String JYTHON = ".py";
    public static final String XML = ".xml";
    private ScriptedContainerBuilder containerBuilder;

    public ScriptedContainerBuilderFactory(File compositionFile, ClassLoader classLoader) throws IOException, ClassNotFoundException {
        this(compositionFile, classLoader, new ScriptBuilderResolver());
    }

    public ScriptedContainerBuilderFactory(File compositionFile, ClassLoader classLoader, ScriptBuilderResolver builderClassResolver) throws IOException, ClassNotFoundException, UnsupportedScriptTypeException {
        this(new FileReader(ScriptedContainerBuilderFactory.fileExists(compositionFile)), builderClassResolver.getBuilderClassName(compositionFile), classLoader);
    }

    public ScriptedContainerBuilderFactory(File compositionFile) throws IOException, ClassNotFoundException {
        this(compositionFile, Thread.currentThread().getContextClassLoader());
    }

    public ScriptedContainerBuilderFactory(URL compositionURL) throws ClassNotFoundException {
        this(compositionURL, Thread.currentThread().getContextClassLoader(), new ScriptBuilderResolver());
    }

    public ScriptedContainerBuilderFactory(URL compositionURL, ClassLoader classLoader, ScriptBuilderResolver builderClassResolver) throws ClassNotFoundException, UnsupportedScriptTypeException {
        this(compositionURL, builderClassResolver.getBuilderClassName(compositionURL), classLoader);
    }

    public ScriptedContainerBuilderFactory(URL compositionURL, String builderClassName, ClassLoader contextClassLoader) throws ClassNotFoundException {
        this.createContainerBuilder(compositionURL, contextClassLoader, builderClassName);
    }

    public ScriptedContainerBuilderFactory(Reader composition, String builderClass) throws ClassNotFoundException {
        this(composition, builderClass, Thread.currentThread().getContextClassLoader());
    }

    public ScriptedContainerBuilderFactory(Reader composition, String builderClass, ClassLoader classLoader) throws ClassNotFoundException {
        this.createContainerBuilder(composition, classLoader, builderClass);
    }

    private void createContainerBuilder(Object composition, ClassLoader classLoader, String builderClass) throws ClassNotFoundException {
        DefaultPicoContainer factory = new DefaultPicoContainer();
        if (composition == null) {
            throw new NullPointerException("composition can't be null");
        }
        factory.registerComponentInstance(composition);
        if (classLoader == null) {
            classLoader = this.getClass().getClassLoader();
        }
        factory.registerComponentInstance((Object)classLoader);
        DefaultNanoContainer defaultNanoContainer = new DefaultNanoContainer(classLoader, (MutablePicoContainer)factory);
        ComponentAdapter componentAdapter = defaultNanoContainer.registerComponentImplementation(builderClass);
        this.containerBuilder = (ScriptedContainerBuilder)componentAdapter.getComponentInstance((PicoContainer)defaultNanoContainer.getPico());
    }

    private static File fileExists(File file) throws FileNotFoundException {
        if (file.exists()) {
            return file;
        }
        throw new FileNotFoundException("File " + file.getAbsolutePath() + " does not exist.");
    }

    public static String getBuilderClassName(String extension) {
        return new ScriptBuilderResolver().getBuilderClassName(extension);
    }

    public ScriptedContainerBuilder getContainerBuilder() {
        return this.containerBuilder;
    }
}

