/*
 * Decompiled with CFR 0.152.
 */
package org.nanocontainer.script.xml;

import java.net.MalformedURLException;
import java.util.Map;
import java.util.Properties;
import org.nanocontainer.script.xml.XMLComponentInstanceFactory;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.Parameter;
import org.picocontainer.PicoContainer;
import org.picocontainer.defaults.BeanPropertyComponentAdapter;
import org.picocontainer.defaults.DefaultComponentAdapterFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class BeanComponentInstanceFactory
implements XMLComponentInstanceFactory {
    private static final String NAME_ATTRIBUTE = "name";

    public Object makeInstance(PicoContainer pico, Element element, ClassLoader classLoader) throws ClassNotFoundException, MalformedURLException {
        String className = element.getNodeName();
        Object instance = null;
        if (element.getChildNodes().getLength() == 1) {
            instance = BeanPropertyComponentAdapter.convert((String)className, (String)element.getFirstChild().getNodeValue(), (ClassLoader)classLoader);
        } else {
            BeanPropertyComponentAdapter propertyComponentAdapter = new BeanPropertyComponentAdapter(this.createComponentAdapter(className, classLoader));
            Properties properties = this.createProperties(element.getChildNodes());
            propertyComponentAdapter.setProperties((Map)properties);
            instance = propertyComponentAdapter.getComponentInstance(pico);
        }
        return instance;
    }

    private ComponentAdapter createComponentAdapter(String className, ClassLoader classLoader) throws ClassNotFoundException {
        Class<?> implementation = classLoader.loadClass(className);
        DefaultComponentAdapterFactory factory = new DefaultComponentAdapterFactory();
        return factory.createComponentAdapter((Object)className, implementation, new Parameter[0]);
    }

    private Properties createProperties(NodeList nodes) {
        Properties properties = new Properties();
        for (int i = 0; i < nodes.getLength(); ++i) {
            String mappedName;
            Node n = nodes.item(i);
            if (n.getNodeType() != 1) continue;
            String name = n.getNodeName();
            if (n.hasAttributes() && (mappedName = n.getAttributes().getNamedItem(NAME_ATTRIBUTE).getNodeValue()) != null) {
                name = mappedName;
            }
            String value = n.getFirstChild().getNodeValue();
            properties.setProperty(name, value);
        }
        return properties;
    }
}

