/*
 * Decompiled with CFR 0.152.
 */
package org.nanocontainer.script.xml;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.xml.DomDriver;
import com.thoughtworks.xstream.io.xml.DomReader;
import java.io.IOException;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.nanocontainer.DefaultNanoContainer;
import org.nanocontainer.integrationkit.ContainerPopulator;
import org.nanocontainer.script.NanoContainerMarkupException;
import org.nanocontainer.script.ScriptedContainerBuilder;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.Parameter;
import org.picocontainer.PicoContainer;
import org.picocontainer.defaults.ComponentAdapterFactory;
import org.picocontainer.defaults.ComponentParameter;
import org.picocontainer.defaults.ConstantParameter;
import org.picocontainer.defaults.DefaultComponentAdapterFactory;
import org.picocontainer.defaults.DefaultPicoContainer;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XStreamContainerBuilder
extends ScriptedContainerBuilder
implements ContainerPopulator {
    private final Element rootElement;
    private static final String IMPLEMENTATION = "implementation";
    private static final String INSTANCE = "instance";
    private static final String ADAPTER = "adapter";
    private static final String CLASS = "class";
    private static final String KEY = "key";
    private static final String CONSTANT = "constant";
    private static final String DEPENDENCY = "dependency";
    private static final String CONSTRUCTOR = "constructor";
    private final HierarchicalStreamDriver xsdriver;

    public XStreamContainerBuilder(Reader script) {
        this(script, Thread.currentThread().getContextClassLoader());
    }

    public XStreamContainerBuilder(Reader script, ClassLoader classLoader) {
        this(script, classLoader, (HierarchicalStreamDriver)new DomDriver());
    }

    public XStreamContainerBuilder(Reader script, ClassLoader classLoader, HierarchicalStreamDriver driver) {
        super(script, classLoader);
        this.xsdriver = driver;
        InputSource inputSource = new InputSource(script);
        try {
            this.rootElement = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(inputSource).getDocumentElement();
        }
        catch (SAXException e) {
            throw new NanoContainerMarkupException(e);
        }
        catch (IOException e) {
            throw new NanoContainerMarkupException(e);
        }
        catch (ParserConfigurationException e) {
            throw new NanoContainerMarkupException(e);
        }
    }

    public XStreamContainerBuilder(URL script, ClassLoader classLoader, HierarchicalStreamDriver driver) {
        super(script, classLoader);
        this.xsdriver = driver;
        try {
            InputSource inputSource = new InputSource(this.getScriptReader());
            this.rootElement = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(inputSource).getDocumentElement();
        }
        catch (SAXException e) {
            throw new NanoContainerMarkupException(e);
        }
        catch (IOException e) {
            throw new NanoContainerMarkupException(e);
        }
        catch (ParserConfigurationException e) {
            throw new NanoContainerMarkupException(e);
        }
    }

    public void populateContainer(MutablePicoContainer container) {
        this.populateContainer(container, this.rootElement);
    }

    private void populateContainer(MutablePicoContainer container, Element rootElement) {
        NodeList children = rootElement.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            short type = child.getNodeType();
            if (type != 1) continue;
            String name = child.getNodeName();
            if (IMPLEMENTATION.equals(name)) {
                try {
                    this.insertImplementation(container, (Element)child);
                    continue;
                }
                catch (ClassNotFoundException e) {
                    throw new NanoContainerMarkupException(e);
                }
            }
            if (INSTANCE.equals(name)) {
                this.insertInstance(container, (Element)child);
                continue;
            }
            if (ADAPTER.equals(name)) {
                this.insertAdapter(container, (Element)child);
                continue;
            }
            throw new NanoContainerMarkupException("Unsupported element:" + name);
        }
    }

    protected void insertAdapter(MutablePicoContainer container, Element rootElement) {
        String key = rootElement.getAttribute(KEY);
        String klass = rootElement.getAttribute(CLASS);
        try {
            DefaultPicoContainer nested = new DefaultPicoContainer();
            this.populateContainer((MutablePicoContainer)nested, rootElement);
            if (key != null) {
                container.registerComponent((ComponentAdapter)nested.getComponentInstance((Object)key));
            } else if (klass != null) {
                Class<?> clazz = this.getClassLoader().loadClass(klass);
                container.registerComponent((ComponentAdapter)nested.getComponentInstanceOfType(clazz));
            } else {
                container.registerComponent((ComponentAdapter)nested.getComponentInstanceOfType(ComponentAdapter.class));
            }
        }
        catch (ClassNotFoundException ex) {
            throw new NanoContainerMarkupException(ex);
        }
    }

    protected void insertImplementation(MutablePicoContainer container, Element rootElement) throws ClassNotFoundException {
        String key = rootElement.getAttribute(KEY);
        String klass = rootElement.getAttribute(CLASS);
        String constructor = rootElement.getAttribute(CONSTRUCTOR);
        if (klass == null || "".equals(klass)) {
            throw new NanoContainerMarkupException("class specification is required for component implementation");
        }
        Class<?> clazz = this.getClassLoader().loadClass(klass);
        ArrayList<Object> parameters = new ArrayList<Object>();
        NodeList children = rootElement.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child.getNodeType() != 1) continue;
            String name = child.getNodeName();
            if (CONSTANT.equals(name)) {
                Object parseResult = this.parseElementChild((Element)child);
                if (parseResult == null) {
                    throw new NanoContainerMarkupException("could not parse constant parameter");
                }
                parameters.add(new ConstantParameter(parseResult));
                continue;
            }
            if (!DEPENDENCY.equals(name)) continue;
            String dependencyKey = ((Element)child).getAttribute(KEY);
            if (dependencyKey == null || "".equals(dependencyKey)) {
                String dependencyClass = ((Element)child).getAttribute(CLASS);
                if (dependencyClass == null || "".equals(dependencyClass)) {
                    throw new NanoContainerMarkupException("either key or class must be present for dependency");
                }
                parameters.add(new ComponentParameter(this.getClassLoader().loadClass(dependencyClass)));
                continue;
            }
            parameters.add(new ComponentParameter((Object)dependencyKey));
        }
        Parameter[] parameterArray = parameters.toArray(new Parameter[parameters.size()]);
        if (parameters.size() > 0 || "default".equals(constructor)) {
            if (key == null || "".equals(key)) {
                container.registerComponentImplementation(clazz, clazz, parameterArray);
            } else {
                container.registerComponentImplementation((Object)key, clazz, parameterArray);
            }
        } else if (key == null || "".equals(key)) {
            container.registerComponentImplementation(clazz, clazz);
        } else {
            container.registerComponentImplementation((Object)key, clazz);
        }
    }

    protected void insertInstance(MutablePicoContainer container, Element rootElement) {
        String key = rootElement.getAttribute(KEY);
        Object result = this.parseElementChild(rootElement);
        if (result == null) {
            throw new NanoContainerMarkupException("no content could be parsed in instance");
        }
        if (key != null && !"".equals(key)) {
            container.registerComponentInstance((Object)key, result);
        } else {
            container.registerComponentInstance(result);
        }
    }

    protected Object parseElementChild(Element rootElement) {
        NodeList children = rootElement.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child.getNodeType() != 1) continue;
            return new XStream(this.xsdriver).unmarshal((HierarchicalStreamReader)new DomReader((Element)child));
        }
        return null;
    }

    protected PicoContainer createContainerFromScript(PicoContainer parentContainer, Object assemblyScope) {
        try {
            String cafName = this.rootElement.getAttribute("componentadapterfactory");
            if ("".equals(cafName) || cafName == null) {
                cafName = DefaultComponentAdapterFactory.class.getName();
            }
            Class<?> cafClass = this.getClassLoader().loadClass(cafName);
            ComponentAdapterFactory componentAdapterFactory = (ComponentAdapterFactory)cafClass.newInstance();
            DefaultPicoContainer picoContainer = new DefaultPicoContainer(componentAdapterFactory);
            DefaultNanoContainer nano = new DefaultNanoContainer(this.getClassLoader(), (MutablePicoContainer)picoContainer);
            this.populateContainer(nano.getPico());
            return nano.getPico();
        }
        catch (ClassNotFoundException e) {
            throw new NanoContainerMarkupException(e);
        }
        catch (InstantiationException e) {
            throw new NanoContainerMarkupException(e);
        }
        catch (IllegalAccessException e) {
            throw new NanoContainerMarkupException(e);
        }
    }
}

