/*
 * Decompiled with CFR 0.152.
 */
package dynaop;

import dynaop.Aspects;
import dynaop.InterceptorFactory;
import dynaop.Pointcuts;
import dynaop.ProxyType;
import dynaop.ProxyTypeBuilder;
import dynaop.util.ArrayObject;
import dynaop.util.Classes;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

public class Debug {
    PrintStream out;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$dynaop$Debug;

    public static ProxyType getProxyType(Class clazz) {
        return Debug.getProxyType(Aspects.getInstance(), clazz);
    }

    public static ProxyType getProxyType(Aspects aspects, Class clazz) {
        return Debug.immutable(aspects.createProxyType(clazz, new ProxyTypeBuilder(clazz)));
    }

    static ProxyType immutable(ProxyType proxyType) {
        return new ImmutableProxyType(proxyType);
    }

    void printInterceptorFactory(InterceptorFactory factory) {
        this.out.println("\t\t\t<interceptorFactory>");
        Properties p = factory.getProperties();
        Iterator<Map.Entry<Object, Object>> i = p.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry<Object, Object> entry = i.next();
            this.out.println("\t\t\t\t<property>");
            this.out.println("\t\t\t\t\t<name>" + entry.getKey() + "</name>");
            this.out.println("\t\t\t\t\t<value>" + entry.getValue() + "</value>");
            this.out.println("\t\t\t\t</property>");
        }
        this.out.println("\t\t\t</interceptorFactory>");
    }

    void printMethod(ProxyType type, Method method) {
        this.out.println("\t\t<method>");
        this.out.println("\t\t\t<signature>" + Pointcuts.methodToString(method) + "</signature>");
        InterceptorFactory[] interceptorFactories = type.getInterceptorFactories(method);
        if (interceptorFactories != null) {
            int i = 0;
            while (i < interceptorFactories.length) {
                this.printInterceptorFactory(interceptorFactories[i]);
                ++i;
            }
        }
        this.out.println("\t\t</method>");
    }

    void printMethods(ProxyType type, Class clazz, Set visited) {
        Method[] methods = clazz.getMethods();
        this.out.println("\t<interface class=\"" + clazz.getName() + "\">");
        int i = 0;
        while (i < methods.length) {
            if (!visited.contains(methods[i])) {
                visited.add(methods[i]);
                this.printMethod(type, methods[i]);
            }
            ++i;
        }
        this.out.println("\t</interface>");
    }

    public void printXml(Class clazz, ProxyType type) {
        this.out.println("<proxyType>");
        this.out.println("\t<class>" + clazz.getName() + "</class>");
        if (type != null) {
            Class[] interfaces = type.getInterfaces();
            this.out.println("\t<interface class=\"java.lang.Object\">");
            int i = 0;
            while (i < Classes.OBJECT_METHODS.length) {
                this.printMethod(type, Classes.OBJECT_METHODS[i]);
                ++i;
            }
            this.out.println("\t</interface>");
            HashSet<Method> visited = new HashSet<Method>();
            Class clazz2 = class$java$lang$Object;
            if (clazz2 == null) {
                clazz2 = class$java$lang$Object = Debug.class$("[Ljava.lang.Object;", false);
            }
            visited.addAll(Arrays.asList(clazz2.getMethods()));
            this.printMethods(type, clazz, visited);
            int i2 = 0;
            while (i2 < interfaces.length) {
                this.printMethods(type, interfaces[i2], visited);
                ++i2;
            }
        }
        this.out.println("</proxyType>");
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 1) {
            System.err.println("Usage: Debug [class name]");
            System.exit(0);
        }
        Class<?> clazz = Class.forName(args[0]);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        new Debug(out).printXml(clazz, Debug.getProxyType(clazz));
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Class clazz2 = class$dynaop$Debug;
        if (clazz2 == null) {
            clazz2 = class$dynaop$Debug = Debug.class$("[Ldynaop.Debug;", false);
        }
        Transformer t = transformerFactory.newTransformer(new StreamSource(clazz2.getResourceAsStream("debug.xsl")));
        t.transform(new StreamSource(new ByteArrayInputStream(out.toByteArray())), new StreamResult(System.out));
    }

    static /* synthetic */ Class class$(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public Debug(PrintStream out) {
        this.out = out;
    }

    public Debug(OutputStream out) {
        this.out = new PrintStream(out);
    }

    public Debug() {
        this.out = System.out;
    }

    static class ImmutableProxyType
    implements ProxyType,
    Serializable {
        static long serialVersionUID = 0L;
        private ProxyType proxyType;

        public Class[] getInterfaces() {
            return (Class[])ArrayObject.clone(this.proxyType.getInterfaces());
        }

        public InterceptorFactory[] getInterceptorFactories(Method method) {
            InterceptorFactory[] interceptorFactories = this.proxyType.getInterceptorFactories(method);
            return interceptorFactories == null ? null : (InterceptorFactory[])ArrayObject.clone(interceptorFactories);
        }

        public String toString() {
            return this.proxyType.toString();
        }

        ImmutableProxyType(ProxyType proxyType) {
            this.proxyType = proxyType;
        }
    }
}

