/*
 * Decompiled with CFR 0.152.
 */
package dynaop;

import dynaop.ClassPointcut;
import dynaop.MethodPointcut;
import dynaop.Pointcuts;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;

public class Pointcuts {
    public static final ClassPointcut ALL_CLASSES = new 1();
    public static final MethodPointcut ALL_METHODS = new 2();
    public static final MethodPointcut OBJECT_METHODS;
    public static final MethodPointcut GET_METHODS;
    public static final MethodPointcut IS_METHODS;
    public static final MethodPointcut SET_METHODS;
    static Map methodSignatureCache;
    static /* synthetic */ Class class$java$lang$Object;

    public static ClassPointcut packageName(String packageName) {
        return new ClassPointcut(packageName){
            final /* synthetic */ String val$packageName;

            public final boolean picks(Class clazz) {
                return clazz.getPackage().getName().equals(this.val$packageName);
            }
            {
                this.val$packageName = string;
            }
        };
    }

    public static ClassPointcut union(ClassPointcut a, ClassPointcut b) {
        return new ClassPointcut(a, b){
            final /* synthetic */ ClassPointcut val$a;
            final /* synthetic */ ClassPointcut val$b;

            public final boolean picks(Class clazz) {
                boolean bl = false;
                if (this.val$a.picks(clazz) || this.val$b.picks(clazz)) {
                    bl = true;
                }
                return bl;
            }
            {
                this.val$a = classPointcut;
                this.val$b = classPointcut2;
            }
        };
    }

    public static MethodPointcut union(MethodPointcut a, MethodPointcut b) {
        return new MethodPointcut(a, b){
            final /* synthetic */ MethodPointcut val$a;
            final /* synthetic */ MethodPointcut val$b;

            public final boolean picks(Method method) {
                boolean bl = false;
                if (this.val$a.picks(method) || this.val$b.picks(method)) {
                    bl = true;
                }
                return bl;
            }
            {
                this.val$a = methodPointcut;
                this.val$b = methodPointcut2;
            }
        };
    }

    public static ClassPointcut intersection(ClassPointcut a, ClassPointcut b) {
        return new ClassPointcut(a, b){
            final /* synthetic */ ClassPointcut val$a;
            final /* synthetic */ ClassPointcut val$b;

            public final boolean picks(Class clazz) {
                boolean bl = false;
                if (this.val$a.picks(clazz) && this.val$b.picks(clazz)) {
                    bl = true;
                }
                return bl;
            }
            {
                this.val$a = classPointcut;
                this.val$b = classPointcut2;
            }
        };
    }

    public static MethodPointcut intersection(MethodPointcut a, MethodPointcut b) {
        return new MethodPointcut(a, b){
            final /* synthetic */ MethodPointcut val$a;
            final /* synthetic */ MethodPointcut val$b;

            public final boolean picks(Method method) {
                boolean bl = false;
                if (this.val$a.picks(method) && this.val$b.picks(method)) {
                    bl = true;
                }
                return bl;
            }
            {
                this.val$a = methodPointcut;
                this.val$b = methodPointcut2;
            }
        };
    }

    public static ClassPointcut className(String regex) throws MalformedPatternException {
        Perl5Compiler compiler = new Perl5Compiler();
        Pattern compiled = compiler.compile(regex);
        Perl5Matcher matcher = new Perl5Matcher();
        return new ClassPointcut(compiled, matcher){
            final /* synthetic */ Pattern val$compiled;
            final /* synthetic */ Perl5Matcher val$matcher;

            public final boolean picks(Class clazz) {
                return this.val$matcher.contains(clazz.getName(), this.val$compiled);
            }
            {
                this.val$compiled = pattern;
                this.val$matcher = perl5Matcher;
            }
        };
    }

    public static MethodPointcut signature(String regex) throws MalformedPatternException {
        Perl5Compiler compiler = new Perl5Compiler();
        Pattern compiled = compiler.compile(regex);
        Perl5Matcher matcher = new Perl5Matcher();
        return new MethodPointcut(compiled, matcher){
            final /* synthetic */ Pattern val$compiled;
            final /* synthetic */ Perl5Matcher val$matcher;

            public final boolean picks(Method method) {
                return this.val$matcher.contains(Pointcuts.methodToString(method), this.val$compiled);
            }
            {
                this.val$compiled = pattern;
                this.val$matcher = perl5Matcher;
            }
        };
    }

    public static ClassPointcut instancesOf(Class parent) {
        return new ClassPointcut(parent){
            final /* synthetic */ Class val$parent;

            public final boolean picks(Class clazz) {
                return this.val$parent.isAssignableFrom(clazz);
            }
            {
                this.val$parent = clazz;
            }
        };
    }

    public static ClassPointcut singleton(Class c) {
        return new ClassPointcut(c){
            final /* synthetic */ Class val$c;

            public final boolean picks(Class clazz) {
                return clazz.equals(this.val$c);
            }
            {
                this.val$c = clazz;
            }
        };
    }

    public static MethodPointcut singleton(Method m) {
        return new MethodPointcut(m){
            final /* synthetic */ Method val$m;

            public final boolean picks(Method method) {
                return method.equals(this.val$m);
            }
            {
                this.val$m = method;
            }
        };
    }

    public static ClassPointcut not(ClassPointcut a) {
        return new ClassPointcut(a){
            final /* synthetic */ ClassPointcut val$a;

            public final boolean picks(Class clazz) {
                return this.val$a.picks(clazz) ^ true;
            }
            {
                this.val$a = classPointcut;
            }
        };
    }

    public static MethodPointcut not(MethodPointcut a) {
        return new MethodPointcut(a){
            final /* synthetic */ MethodPointcut val$a;

            public final boolean picks(Method method) {
                return this.val$a.picks(method) ^ true;
            }
            {
                this.val$a = methodPointcut;
            }
        };
    }

    public static MethodPointcut declaringClass(ClassPointcut classPointcut) {
        return new MethodPointcut(classPointcut){
            final /* synthetic */ ClassPointcut val$classPointcut;

            public final boolean picks(Method method) {
                return this.val$classPointcut.picks(method.getDeclaringClass());
            }
            {
                this.val$classPointcut = classPointcut;
            }
        };
    }

    public static MethodPointcut returnType(ClassPointcut classPointcut) {
        return new MethodPointcut(classPointcut){
            final /* synthetic */ ClassPointcut val$classPointcut;

            public final boolean picks(Method method) {
                return this.val$classPointcut.picks(method.getReturnType());
            }
            {
                this.val$classPointcut = classPointcut;
            }
        };
    }

    public static MethodPointcut membersOf(Class clazz) {
        return new MethodPointcut(clazz){
            final /* synthetic */ Class val$clazz;

            public final boolean picks(Method method) {
                try {
                    this.val$clazz.getMethod(method.getName(), method.getParameterTypes());
                    return true;
                }
                catch (NoSuchMethodException e) {
                    return false;
                }
            }
            {
                this.val$clazz = clazz;
            }
        };
    }

    static String getTypeName(Class clazz) {
        String name = clazz.getName();
        return name.startsWith("java.lang.") ? name.substring(10) : name;
    }

    static String methodToString(Method method) {
        String signature = (String)methodSignatureCache.get(method);
        if (signature != null) {
            return signature;
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append(Pointcuts.getTypeName(method.getReturnType()));
        buffer.append(' ');
        buffer.append(method.getName());
        buffer.append('(');
        boolean first = true;
        Class<?>[] types = method.getParameterTypes();
        int i = 0;
        while (i < types.length) {
            if (!first) {
                buffer.append(", ");
            }
            first = false;
            buffer.append(Pointcuts.getTypeName(types[i]));
            ++i;
        }
        buffer.append(')');
        Class<?>[] exceptions = method.getExceptionTypes();
        if (exceptions.length > 0) {
            first = true;
            buffer.append(" throws ");
            int i2 = 0;
            while (i2 < exceptions.length) {
                if (!first) {
                    buffer.append(", ");
                }
                first = false;
                buffer.append(Pointcuts.getTypeName(exceptions[i2]));
                ++i2;
            }
        }
        signature = buffer.toString();
        methodSignatureCache.put(method, signature);
        return signature;
    }

    static /* synthetic */ Class class$(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    Pointcuts() {
    }

    static {
        Class clazz = class$java$lang$Object;
        if (clazz == null) {
            clazz = class$java$lang$Object = Pointcuts.class$("[Ljava.lang.Object;", false);
        }
        OBJECT_METHODS = Pointcuts.declaringClass(Pointcuts.singleton(clazz));
        GET_METHODS = new PropertyMethodPointcut("get");
        IS_METHODS = new PropertyMethodPointcut("is");
        SET_METHODS = new PropertyMethodPointcut("set");
        methodSignatureCache = Collections.synchronizedMap(new WeakHashMap());
    }

    static class PropertyMethodPointcut
    implements MethodPointcut {
        private String prefix;

        public boolean picks(Method method) {
            String name = method.getName();
            boolean bl = false;
            if (name.length() > this.prefix.length() && Character.isUpperCase(name.charAt(this.prefix.length())) && name.startsWith(this.prefix)) {
                bl = true;
            }
            return bl;
        }

        PropertyMethodPointcut(String prefix) {
            this.prefix = prefix;
        }
    }
}

