/*
 * Decompiled with CFR 0.152.
 */
package org.nanocontainer.deployer;

import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystemException;
import org.nanocontainer.deployer.Deployer;
import org.nanocontainer.deployer.DeploymentException;
import org.nanocontainer.deployer.DifferenceAnalysingFolderContentHandler;
import org.nanocontainer.deployer.FolderListener;
import org.picocontainer.Startable;

public class DeployingFolderListener
implements FolderListener,
Startable {
    private final Deployer deployer;
    private final DifferenceAnalysingFolderContentHandler handler;

    public DeployingFolderListener(Deployer deployer, DifferenceAnalysingFolderContentHandler handler) {
        this.deployer = deployer;
        this.handler = handler;
    }

    public void folderAdded(FileObject folder) {
        try {
            this.deployer.deploy(folder, this.getClass().getClassLoader(), null);
        }
        catch (FileSystemException e) {
            throw new DeploymentException(e);
        }
        catch (ClassNotFoundException e) {
            throw new DeploymentException(e);
        }
    }

    public void folderRemoved(FileObject fileObject) {
    }

    public void start() {
        this.handler.addFolderListener(this);
    }

    public void stop() {
        this.handler.removeFolderListener(this);
    }
}

