/*
 * Decompiled with CFR 0.152.
 */
package org.nanocontainer.deployer;

import java.io.InputStreamReader;
import java.io.Reader;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSelectInfo;
import org.apache.commons.vfs.FileSelector;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileSystemManager;
import org.apache.commons.vfs.VFS;
import org.apache.commons.vfs.impl.VFSClassLoader;
import org.nanocontainer.deployer.Deployer;
import org.nanocontainer.script.ScriptBuilderResolver;
import org.nanocontainer.script.ScriptedContainerBuilder;
import org.nanocontainer.script.ScriptedContainerBuilderFactory;
import org.nanocontainer.script.UnsupportedScriptTypeException;
import org.picocontainer.defaults.ObjectReference;
import org.picocontainer.defaults.SimpleReference;

public class NanoContainerDeployer
implements Deployer {
    private final FileSystemManager fileSystemManager;
    private final String fileBasename;
    private ScriptBuilderResolver resolver;

    public NanoContainerDeployer() throws FileSystemException {
        this(VFS.getManager(), new ScriptBuilderResolver());
    }

    public NanoContainerDeployer(FileSystemManager fileSystemManager) {
        this(fileSystemManager, "nanocontainer");
    }

    public NanoContainerDeployer(FileSystemManager fileSystemManager, ScriptBuilderResolver builderResolver) {
        this(fileSystemManager);
        this.resolver = builderResolver;
    }

    public NanoContainerDeployer(FileSystemManager fileSystemManager, String baseFileName) {
        this.fileSystemManager = fileSystemManager;
        this.fileBasename = baseFileName;
        this.resolver = new ScriptBuilderResolver();
    }

    public ObjectReference deploy(FileObject applicationFolder, ClassLoader parentClassLoader, ObjectReference parentContainerRef) throws FileSystemException, ClassNotFoundException {
        return this.deploy(applicationFolder, parentClassLoader, parentContainerRef, null);
    }

    public ObjectReference deploy(FileObject applicationFolder, ClassLoader parentClassLoader, ObjectReference parentContainerRef, Object assemblyScope) throws FileSystemException, ClassNotFoundException {
        VFSClassLoader applicationClassLoader = new VFSClassLoader(applicationFolder, this.fileSystemManager, parentClassLoader);
        FileObject deploymentScript = this.getDeploymentScript(applicationFolder);
        SimpleReference result = new SimpleReference();
        String extension = "." + deploymentScript.getName().getExtension();
        InputStreamReader scriptReader = new InputStreamReader(deploymentScript.getContent().getInputStream());
        String builderClassName = null;
        try {
            builderClassName = this.resolver.getBuilderClassName(extension);
        }
        catch (UnsupportedScriptTypeException ex) {
            throw new FileSystemException("Could not find a suitable builder for: " + deploymentScript.getName() + ".  Known extensions are: [groovy|bsh|js|py|xml]", (Throwable)ex);
        }
        ScriptedContainerBuilderFactory scriptedContainerBuilderFactory = new ScriptedContainerBuilderFactory((Reader)scriptReader, builderClassName, (ClassLoader)applicationClassLoader);
        ScriptedContainerBuilder builder = scriptedContainerBuilderFactory.getContainerBuilder();
        builder.buildContainer((ObjectReference)result, parentContainerRef, assemblyScope, true);
        return result;
    }

    protected FileObject getDeploymentScript(FileObject applicationFolder) throws FileSystemException {
        FileObject metaInf = applicationFolder.getChild("META-INF");
        if (metaInf == null) {
            throw new FileSystemException("Missing META-INF folder in " + applicationFolder.getName().getPath());
        }
        FileObject[] nanocontainerScripts = metaInf.findFiles(new FileSelector(){

            public boolean includeFile(FileSelectInfo fileSelectInfo) throws Exception {
                return fileSelectInfo.getFile().getName().getBaseName().startsWith(NanoContainerDeployer.this.getFileBasename());
            }

            public boolean traverseDescendents(FileSelectInfo fileSelectInfo) throws Exception {
                return fileSelectInfo.getDepth() <= 1;
            }
        });
        if (nanocontainerScripts == null || nanocontainerScripts.length < 1) {
            throw new FileSystemException("No deployment script (" + this.getFileBasename() + ".[groovy|bsh|js|py|xml]) in " + applicationFolder.getName().getPath() + "/META-INF");
        }
        if (nanocontainerScripts.length == 1) {
            return nanocontainerScripts[0];
        }
        throw new FileSystemException("Found more than one candidate config script in : " + applicationFolder.getName().getPath() + "/META-INF." + "Please only have one " + this.getFileBasename() + ".[groovy|bsh|js|py|xml] this directory.");
    }

    public String getFileBasename() {
        return this.fileBasename;
    }
}

