/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.io.StringReader;
import java.security.AccessControlException;
import java.util.Hashtable;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Stack;
import org.jruby.IRuby;
import org.jruby.MetaClass;
import org.jruby.NativeException;
import org.jruby.RubyArray;
import org.jruby.RubyBinding;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyComparable;
import org.jruby.RubyDir;
import org.jruby.RubyEnumerable;
import org.jruby.RubyException;
import org.jruby.RubyFileStat;
import org.jruby.RubyFileTest;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyGC;
import org.jruby.RubyGlobal;
import org.jruby.RubyIO;
import org.jruby.RubyKernel;
import org.jruby.RubyMarshal;
import org.jruby.RubyMatchData;
import org.jruby.RubyMath;
import org.jruby.RubyMethod;
import org.jruby.RubyModule;
import org.jruby.RubyNameError;
import org.jruby.RubyNil;
import org.jruby.RubyNumeric;
import org.jruby.RubyObjectSpace;
import org.jruby.RubyPrecision;
import org.jruby.RubyProc;
import org.jruby.RubyProcess;
import org.jruby.RubyRange;
import org.jruby.RubyRegexp;
import org.jruby.RubyString;
import org.jruby.RubyStruct;
import org.jruby.RubySymbol;
import org.jruby.RubyThread;
import org.jruby.RubyThreadGroup;
import org.jruby.RubyTime;
import org.jruby.RubyUnboundMethod;
import org.jruby.TopSelfFactory;
import org.jruby.ast.Node;
import org.jruby.ast.executable.InstructionCompiler2;
import org.jruby.ast.executable.Script;
import org.jruby.common.RubyWarnings;
import org.jruby.evaluator.EvaluationState;
import org.jruby.exceptions.JumpException;
import org.jruby.exceptions.RaiseException;
import org.jruby.ext.Readline;
import org.jruby.ext.openssl.RubyOpenSSL;
import org.jruby.internal.runtime.GlobalVariables;
import org.jruby.internal.runtime.ThreadService;
import org.jruby.internal.runtime.ValueAccessor;
import org.jruby.javasupport.Java;
import org.jruby.javasupport.JavaSupport;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.libraries.BigDecimalLibrary;
import org.jruby.libraries.DigestLibrary;
import org.jruby.libraries.EnumeratorLibrary;
import org.jruby.libraries.IConvLibrary;
import org.jruby.libraries.JRubyLibrary;
import org.jruby.libraries.RbConfigLibrary;
import org.jruby.libraries.SocketLibrary;
import org.jruby.libraries.StringIOLibrary;
import org.jruby.libraries.StringScannerLibrary;
import org.jruby.libraries.YamlLibrary;
import org.jruby.libraries.ZlibLibrary;
import org.jruby.parser.Parser;
import org.jruby.runtime.Block;
import org.jruby.runtime.CacheMap;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.GlobalVariable;
import org.jruby.runtime.IAccessor;
import org.jruby.runtime.ObjectSpace;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.builtin.meta.ArrayMetaClass;
import org.jruby.runtime.builtin.meta.BignumMetaClass;
import org.jruby.runtime.builtin.meta.BindingMetaClass;
import org.jruby.runtime.builtin.meta.FileMetaClass;
import org.jruby.runtime.builtin.meta.FixnumMetaClass;
import org.jruby.runtime.builtin.meta.HashMetaClass;
import org.jruby.runtime.builtin.meta.IOMetaClass;
import org.jruby.runtime.builtin.meta.IntegerMetaClass;
import org.jruby.runtime.builtin.meta.ModuleMetaClass;
import org.jruby.runtime.builtin.meta.NumericMetaClass;
import org.jruby.runtime.builtin.meta.ObjectMetaClass;
import org.jruby.runtime.builtin.meta.ProcMetaClass;
import org.jruby.runtime.builtin.meta.StringMetaClass;
import org.jruby.runtime.builtin.meta.SymbolMetaClass;
import org.jruby.runtime.builtin.meta.TimeMetaClass;
import org.jruby.runtime.load.Library;
import org.jruby.runtime.load.LoadService;
import org.jruby.util.BuiltinScript;
import org.jruby.util.JRubyClassLoader;
import org.jruby.util.JRubyFile;
import org.jruby.util.SwallowingOutputStream;
import org.jruby.util.collections.SinglyLinkedList;

public final class Ruby
implements IRuby {
    private static String[] BUILTIN_LIBRARIES;
    private CacheMap cacheMap = new CacheMap();
    private ThreadService threadService = new ThreadService(this);
    private int stackTraces = 0;
    private ObjectSpace objectSpace = new ObjectSpace();
    private final RubyFixnum[] fixnumCache = new RubyFixnum[256];
    private final RubySymbol.SymbolTable symbolTable = new RubySymbol.SymbolTable();
    private Hashtable ioHandlers = new Hashtable();
    private long randomSeed = 0L;
    private long randomSeedSequence = 0L;
    private Random random = new Random();
    private RubyProc traceFunction;
    private boolean globalAbortOnExceptionEnabled = false;
    private boolean doNotReverseLookupEnabled = false;
    private final boolean objectSpaceEnabled;
    private String encoding = "ISO8859_1";
    private int safeLevel = 0;
    private IRubyObject nilObject;
    private RubyBoolean trueObject;
    private RubyBoolean falseObject;
    private RubyClass objectClass;
    private StringMetaClass stringClass;
    private RubyClass systemCallError = null;
    private RubyModule errnoModule = null;
    private IRubyObject topSelf;
    private String currentDirectory;
    private long startTime = System.currentTimeMillis();
    private InputStream in;
    private PrintStream out;
    private PrintStream err;
    private IRubyObject verbose;
    private IRubyObject debug;
    private JavaSupport javaSupport;
    private Parser parser = new Parser(this);
    private LoadService loadService;
    private GlobalVariables globalVariables = new GlobalVariables(this);
    private RubyWarnings warnings = new RubyWarnings(this);
    private Stack atExitBlocks = new Stack();
    private RubyModule kernelModule;
    private RubyClass nilClass;
    private FixnumMetaClass fixnumClass;
    private IRubyObject tmsStruct;
    private ThreadLocal inspect = new ThreadLocal();
    static final /* synthetic */ boolean $assertionsDisabled;

    private Ruby(InputStream in, PrintStream out, PrintStream err) {
        this.in = in;
        this.out = out;
        this.err = err;
        this.objectSpaceEnabled = true;
        try {
            this.currentDirectory = JRubyFile.getFileProperty("user.dir");
        }
        catch (AccessControlException accessEx) {
            this.currentDirectory = "/";
        }
    }

    private Ruby(InputStream in, PrintStream out, PrintStream err, boolean osEnabled) {
        this.in = in;
        this.out = out;
        this.err = err;
        this.objectSpaceEnabled = osEnabled;
        try {
            this.currentDirectory = JRubyFile.getFileProperty("user.dir");
        }
        catch (AccessControlException accessEx) {
            this.currentDirectory = "/";
        }
    }

    public static IRuby getDefaultInstance() {
        Ruby ruby = System.getProperty("jruby.objectspace.enabled") != null ? new Ruby(System.in, System.out, System.err, Boolean.getBoolean("jruby.objectspace.enabled")) : new Ruby(System.in, System.out, System.err);
        ruby.init();
        return ruby;
    }

    public static IRuby newInstance(InputStream in, PrintStream out, PrintStream err, boolean osEnabled) {
        Ruby ruby = new Ruby(in, out, err, osEnabled);
        ruby.init();
        return ruby;
    }

    public static IRuby newInstance(InputStream in, PrintStream out, PrintStream err) {
        return Ruby.newInstance(in, out, err, true);
    }

    public IRubyObject evalScript(String script) {
        return this.eval(this.parse(script, "<script>", this.getCurrentContext().getCurrentScope()));
    }

    public IRubyObject eval(Node node) {
        try {
            ThreadContext tc = this.getCurrentContext();
            return EvaluationState.eval(tc, node, tc.getFrameSelf());
        }
        catch (JumpException je) {
            if (je.getJumpType() == JumpException.JumpType.ReturnJump) {
                return (IRubyObject)je.getSecondaryData();
            }
            throw je;
        }
    }

    public IRubyObject compileAndRun(Node node) {
        try {
            ThreadContext tc = this.getCurrentContext();
            String classname = node.getPosition().getFile();
            if (classname.endsWith(".rb")) {
                classname = classname.substring(0, classname.length() - 3);
            }
            InstructionCompiler2 compiler = new InstructionCompiler2();
            compiler.compile(classname, node.getPosition().getFile(), node);
            JRubyClassLoader loader = new JRubyClassLoader();
            Class scriptClass = compiler.loadClasses(loader);
            Script script = (Script)scriptClass.newInstance();
            return script.run(tc, tc.getFrameSelf());
        }
        catch (JumpException je) {
            if (je.getJumpType() == JumpException.JumpType.ReturnJump) {
                return (IRubyObject)je.getSecondaryData();
            }
            throw je;
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            return null;
        }
        catch (InstantiationException e) {
            e.printStackTrace();
            return null;
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            return null;
        }
    }

    public RubyClass getObject() {
        return this.objectClass;
    }

    public RubyModule getKernel() {
        return this.kernelModule;
    }

    public RubyClass getString() {
        return this.stringClass;
    }

    public RubyClass getFixnum() {
        return this.fixnumClass;
    }

    public IRubyObject getTmsStruct() {
        return this.tmsStruct;
    }

    public RubyBoolean getTrue() {
        return this.trueObject;
    }

    public RubyBoolean getFalse() {
        return this.falseObject;
    }

    public IRubyObject getNil() {
        return this.nilObject;
    }

    public RubyClass getNilClass() {
        return this.nilClass;
    }

    public RubyModule getModule(String name) {
        return (RubyModule)this.objectClass.getConstantAt(name);
    }

    public RubyClass getClass(String name) {
        try {
            return this.objectClass.getClass(name);
        }
        catch (ClassCastException e) {
            throw this.newTypeError(name + " is not a Class");
        }
    }

    public RubyClass defineClass(String name, RubyClass superClass) {
        return this.defineClassUnder(name, superClass, this.objectClass.getCRef());
    }

    public RubyClass defineClassUnder(String name, RubyClass superClass, SinglyLinkedList parentCRef) {
        if (superClass == null) {
            superClass = this.objectClass;
        }
        return superClass.newSubClass(name, parentCRef);
    }

    public RubyModule defineModule(String name) {
        return this.defineModuleUnder(name, this.objectClass.getCRef());
    }

    public RubyModule defineModuleUnder(String name, SinglyLinkedList parentCRef) {
        RubyModule newModule = RubyModule.newModule(this, name, parentCRef);
        ((RubyModule)parentCRef.getValue()).setConstant(name, newModule);
        return newModule;
    }

    public RubyModule getOrCreateModule(String name) {
        ThreadContext tc = this.getCurrentContext();
        RubyModule module = (RubyModule)tc.getRubyClass().getConstantAt(name);
        if (module == null) {
            module = (RubyModule)tc.getRubyClass().setConstant(name, this.defineModule(name));
        } else if (this.getSafeLevel() >= 4) {
            throw this.newSecurityError("Extending module prohibited.");
        }
        if (tc.getWrapper() != null) {
            module.getSingletonClass().includeModule(tc.getWrapper());
            module.includeModule(tc.getWrapper());
        }
        return module;
    }

    public int getSafeLevel() {
        return this.safeLevel;
    }

    public void setSafeLevel(int safeLevel) {
        this.safeLevel = safeLevel;
    }

    public void secure(int level) {
        if (level <= this.safeLevel) {
            throw this.newSecurityError("Insecure operation '" + this.getCurrentContext().getFrameLastFunc() + "' at level " + this.safeLevel);
        }
    }

    public CacheMap getCacheMap() {
        return this.cacheMap;
    }

    public void defineGlobalConstant(String name, IRubyObject value) {
        this.objectClass.defineConstant(name, value);
    }

    public IRubyObject getTopConstant(String name) {
        IRubyObject constant = this.getModule(name);
        if (constant == null) {
            constant = this.getLoadService().autoload(name);
        }
        return constant;
    }

    public boolean isClassDefined(String name) {
        return this.getModule(name) != null;
    }

    public IRubyObject getTopSelf() {
        return this.topSelf;
    }

    public void setCurrentDirectory(String dir) {
        this.currentDirectory = dir;
    }

    public String getCurrentDirectory() {
        return this.currentDirectory;
    }

    private void init() {
        ThreadContext tc = this.getCurrentContext();
        this.nilObject = new RubyNil(this);
        this.trueObject = new RubyBoolean((IRuby)this, true);
        this.falseObject = new RubyBoolean((IRuby)this, false);
        this.verbose = this.falseObject;
        this.debug = this.falseObject;
        this.javaSupport = new JavaSupport(this);
        this.initLibraries();
        tc.preInitCoreClasses();
        this.initCoreClasses();
        this.topSelf = TopSelfFactory.createTopSelf(this);
        tc.preInitBuiltinClasses(this.objectClass, this.topSelf);
        RubyGlobal.createGlobals(this);
        this.initBuiltinClasses();
        this.getObject().defineConstant("TOPLEVEL_BINDING", this.newBinding());
        this.getLoadService().smartLoad("builtin/etc.rb");
    }

    private void initLibraries() {
        this.loadService = new LoadService(this);
        this.loadService.registerBuiltin("java.rb", new Library(){

            public void load(IRuby runtime) throws IOException {
                Java.createJavaModule(runtime);
                new BuiltinScript("javasupport").load(runtime);
            }
        });
        this.loadService.registerBuiltin("socket.rb", new SocketLibrary());
        this.loadService.registerBuiltin("rbconfig.rb", new RbConfigLibrary());
        for (int i = 0; i < BUILTIN_LIBRARIES.length; ++i) {
            this.loadService.registerRubyBuiltin(BUILTIN_LIBRARIES[i]);
        }
        this.loadService.registerBuiltin("jruby.rb", new JRubyLibrary());
        this.loadService.registerBuiltin("iconv.rb", new IConvLibrary());
        this.loadService.registerBuiltin("stringio.rb", new StringIOLibrary());
        this.loadService.registerBuiltin("strscan.rb", new StringScannerLibrary());
        this.loadService.registerBuiltin("zlib.rb", new ZlibLibrary());
        this.loadService.registerBuiltin("yaml_internal.rb", new YamlLibrary());
        this.loadService.registerBuiltin("enumerator.rb", new EnumeratorLibrary());
        this.loadService.registerBuiltin("readline.rb", new Readline.Service());
        this.loadService.registerBuiltin("openssl.so", new RubyOpenSSL.Service());
        this.loadService.registerBuiltin("digest.so", new DigestLibrary());
        this.loadService.registerBuiltin("digest.rb", new DigestLibrary());
        this.loadService.registerBuiltin("digest/md5.rb", new DigestLibrary.MD5());
        this.loadService.registerBuiltin("digest/rmd160.rb", new DigestLibrary.RMD160());
        this.loadService.registerBuiltin("digest/sha1.rb", new DigestLibrary.SHA1());
        this.loadService.registerBuiltin("digest/sha2.rb", new DigestLibrary.SHA2());
        this.loadService.registerBuiltin("bigdecimal.rb", new BigDecimalLibrary());
    }

    private void initCoreClasses() {
        ObjectMetaClass objectMetaClass = new ObjectMetaClass(this);
        objectMetaClass.initializeClass();
        this.objectClass = objectMetaClass;
        this.objectClass.setConstant("Object", this.objectClass);
        ModuleMetaClass moduleClass = new ModuleMetaClass(this, this.objectClass);
        this.objectClass.setConstant("Module", moduleClass);
        RubyClass classClass = new RubyClass(this, null, moduleClass, null, "Class");
        this.objectClass.setConstant("Class", classClass);
        MetaClass metaClass = this.objectClass.makeMetaClass(classClass, objectMetaClass.getCRef());
        metaClass = moduleClass.makeMetaClass(metaClass, objectMetaClass.getCRef());
        metaClass = classClass.makeMetaClass(metaClass, objectMetaClass.getCRef());
        ((ObjectMetaClass)moduleClass).initializeBootstrapClass();
        this.kernelModule = RubyKernel.createKernelModule(this);
        this.objectClass.includeModule(this.kernelModule);
        RubyClass.createClassClass(classClass);
        this.nilClass = RubyNil.createNilClass(this);
        this.objectClass.defineConstant("NIL", this.getNil());
        RubyBoolean.createFalseClass(this);
        RubyBoolean.createTrueClass(this);
        RubyComparable.createComparable(this);
        RubyEnumerable.createEnumerableModule(this);
        this.stringClass = new StringMetaClass(this);
        this.stringClass.initializeClass();
        new SymbolMetaClass(this).initializeClass();
        RubyThreadGroup.createThreadGroupClass(this);
        RubyThread.createThreadClass(this);
        RubyException.createExceptionClass(this);
        RubyPrecision.createPrecisionModule(this);
        new NumericMetaClass(this).initializeClass();
        new IntegerMetaClass(this).initializeClass();
        this.fixnumClass = new FixnumMetaClass(this);
        this.fixnumClass.initializeClass();
        new HashMetaClass(this).initializeClass();
        new IOMetaClass(this).initializeClass();
        new ArrayMetaClass(this).initializeClass();
        RubyClass structClass = RubyStruct.createStructClass(this);
        this.tmsStruct = RubyStruct.newInstance(structClass, new IRubyObject[]{this.newString("Tms"), this.newSymbol("utime"), this.newSymbol("stime"), this.newSymbol("cutime"), this.newSymbol("cstime")});
        RubyFloat.createFloatClass(this);
        new BignumMetaClass(this).initializeClass();
        new BindingMetaClass(this).initializeClass();
        RubyMath.createMathModule(this);
        RubyRegexp.createRegexpClass(this);
        RubyRange.createRangeClass(this);
        RubyObjectSpace.createObjectSpaceModule(this);
        RubyGC.createGCModule(this);
        new ProcMetaClass(this).initializeClass();
        RubyMethod.createMethodClass(this);
        RubyMatchData.createMatchDataClass(this);
        RubyMarshal.createMarshalModule(this);
        RubyDir.createDirClass(this);
        RubyFileTest.createFileTestModule(this);
        new FileMetaClass(this).initializeClass();
        RubyProcess.createProcessModule(this);
        new TimeMetaClass(this).initializeClass();
        RubyUnboundMethod.defineUnboundMethodClass(this);
        RubyClass exceptionClass = this.getClass("Exception");
        RubyClass standardError = this.defineClass("StandardError", exceptionClass);
        RubyClass runtimeError = this.defineClass("RuntimeError", standardError);
        RubyClass ioError = this.defineClass("IOError", standardError);
        RubyClass scriptError = this.defineClass("ScriptError", exceptionClass);
        RubyClass nameError = RubyNameError.createNameErrorClass(this, standardError);
        RubyClass rangeError = this.defineClass("RangeError", standardError);
        this.defineClass("SystemExit", exceptionClass);
        this.defineClass("Fatal", exceptionClass);
        this.defineClass("Interrupt", exceptionClass);
        this.defineClass("SignalException", exceptionClass);
        this.defineClass("TypeError", standardError);
        this.defineClass("ArgumentError", standardError);
        this.defineClass("IndexError", standardError);
        this.defineClass("SyntaxError", scriptError);
        this.defineClass("LoadError", scriptError);
        this.defineClass("NotImplementedError", scriptError);
        this.defineClass("NoMethodError", nameError);
        this.defineClass("SecurityError", standardError);
        this.defineClass("NoMemoryError", exceptionClass);
        this.defineClass("RegexpError", standardError);
        this.defineClass("EOFError", ioError);
        this.defineClass("LocalJumpError", standardError);
        this.defineClass("ThreadError", standardError);
        this.defineClass("SystemStackError", exceptionClass);
        this.defineClass("ZeroDivisionError", standardError);
        this.defineClass("FloatDomainError", rangeError);
        NativeException.createClass(this, runtimeError);
        this.systemCallError = this.defineClass("SystemCallError", standardError);
        this.errnoModule = this.defineModule("Errno");
        this.initErrnoErrors();
        this.defineClass("Data", this.objectClass);
    }

    private void initBuiltinClasses() {
        try {
            new BuiltinScript("FalseClass").load(this);
            new BuiltinScript("TrueClass").load(this);
        }
        catch (IOException e) {
            throw new Error("builtin scripts are missing", e);
        }
    }

    private void initErrnoErrors() {
        this.createSysErr(1, "ENOTEMPTY");
        this.createSysErr(2, "ERANGE");
        this.createSysErr(3, "ESPIPE");
        this.createSysErr(4, "ENFILE");
        this.createSysErr(5, "EXDEV");
        this.createSysErr(6, "ENOMEM");
        this.createSysErr(7, "E2BIG");
        this.createSysErr(8, "ENOENT");
        this.createSysErr(9, "ENOSYS");
        this.createSysErr(10, "EDOM");
        this.createSysErr(11, "ENOSPC");
        this.createSysErr(42, "EINVAL");
        this.createSysErr(43, "EEXIST");
        this.createSysErr(44, "EAGAIN");
        this.createSysErr(45, "ENXIO");
        this.createSysErr(46, "EILSEQ");
        this.createSysErr(47, "ENOLCK");
        this.createSysErr(48, "EPIPE");
        this.createSysErr(49, "EFBIG");
        this.createSysErr(50, "EISDIR");
        this.createSysErr(51, "EBUSY");
        this.createSysErr(52, "ECHILD");
        this.createSysErr(53, "EIO");
        this.createSysErr(54, "EPERM");
        this.createSysErr(55, "EDEADLOCK");
        this.createSysErr(56, "ENAMETOOLONG");
        this.createSysErr(57, "EMLINK");
        this.createSysErr(58, "ENOTTY");
        this.createSysErr(59, "ENOTDIR");
        this.createSysErr(60, "EFAULT");
        this.createSysErr(61, "EBADF");
        this.createSysErr(62, "EINTR");
        this.createSysErr(63, "EWOULDBLOCK");
        this.createSysErr(64, "EDEADLK");
        this.createSysErr(65, "EROFS");
        this.createSysErr(66, "EMFILE");
        this.createSysErr(67, "ENODEV");
        this.createSysErr(68, "EACCES");
        this.createSysErr(69, "ENOEXEC");
        this.createSysErr(70, "ESRCH");
        this.createSysErr(71, "ECONNREFUSED");
        this.createSysErr(72, "ECONNRESET");
        this.createSysErr(73, "EADDRINUSE");
    }

    private void createSysErr(int i, String name) {
        this.errnoModule.defineClassUnder(name, this.systemCallError).defineConstant("Errno", this.newFixnum(i));
    }

    public IRubyObject getVerbose() {
        return this.verbose;
    }

    public void setVerbose(IRubyObject verbose) {
        this.verbose = verbose;
    }

    public IRubyObject getDebug() {
        return this.debug;
    }

    public void setDebug(IRubyObject debug) {
        this.debug = debug;
    }

    public JavaSupport getJavaSupport() {
        return this.javaSupport;
    }

    public void defineVariable(final GlobalVariable variable) {
        this.globalVariables.define(variable.name(), new IAccessor(){

            public IRubyObject getValue() {
                return variable.get();
            }

            public IRubyObject setValue(IRubyObject newValue) {
                return variable.set(newValue);
            }
        });
    }

    public void defineReadonlyVariable(String name, IRubyObject value) {
        this.globalVariables.defineReadonly(name, new ValueAccessor(value));
    }

    public Node parse(Reader content, String file, DynamicScope scope) {
        return this.parser.parse(file, content, scope);
    }

    public Node parse(String content, String file, DynamicScope scope) {
        return this.parser.parse(file, content, scope);
    }

    public ThreadService getThreadService() {
        return this.threadService;
    }

    public ThreadContext getCurrentContext() {
        return this.threadService.getCurrentContext();
    }

    public LoadService getLoadService() {
        return this.loadService;
    }

    public RubyWarnings getWarnings() {
        return this.warnings;
    }

    public PrintStream getErrorStream() {
        OutputStream os = ((RubyIO)this.getGlobalVariables().get("$stderr")).getOutStream();
        if (null != os) {
            return new PrintStream(os);
        }
        return new PrintStream(new SwallowingOutputStream());
    }

    public InputStream getInputStream() {
        return ((RubyIO)this.getGlobalVariables().get("$stdin")).getInStream();
    }

    public PrintStream getOutputStream() {
        return new PrintStream(((RubyIO)this.getGlobalVariables().get("$stdout")).getOutStream());
    }

    public RubyModule getClassFromPath(String path) {
        if (path.charAt(0) == '#') {
            throw this.newArgumentError("can't retrieve anonymous class " + path);
        }
        IRubyObject type = this.evalScript(path);
        if (!(type instanceof RubyModule)) {
            throw this.newTypeError("class path " + path + " does not point class");
        }
        return (RubyModule)type;
    }

    public void printError(RubyException excp) {
        if (excp == null || excp.isNil()) {
            return;
        }
        ThreadContext tc = this.getCurrentContext();
        IRubyObject backtrace = excp.callMethod(tc, "backtrace");
        PrintStream errorStream = this.getErrorStream();
        if (backtrace.isNil() || !(backtrace instanceof RubyArray)) {
            if (tc.getSourceFile() != null) {
                errorStream.print(tc.getPosition());
            } else {
                errorStream.print(tc.getSourceLine());
            }
        } else if (((RubyArray)backtrace).getLength() == 0) {
            this.printErrorPos(errorStream);
        } else {
            IRubyObject mesg = ((RubyArray)backtrace).first(IRubyObject.NULL_ARRAY);
            if (mesg.isNil()) {
                this.printErrorPos(errorStream);
            } else {
                errorStream.print(mesg);
            }
        }
        RubyClass type = excp.getMetaClass();
        String info = excp.toString();
        if (type == this.getClass("RuntimeError") && (info == null || info.length() == 0)) {
            errorStream.print(": unhandled exception\n");
        } else {
            String path = type.getName();
            if (info.length() == 0) {
                errorStream.print(": " + path + '\n');
            } else {
                if (path.startsWith("#")) {
                    path = null;
                }
                String tail = null;
                if (info.indexOf("\n") != -1) {
                    tail = info.substring(info.indexOf("\n") + 1);
                    info = info.substring(0, info.indexOf("\n"));
                }
                errorStream.print(": " + info);
                if (path != null) {
                    errorStream.print(" (" + path + ")\n");
                }
                if (tail != null) {
                    errorStream.print(tail + '\n');
                }
            }
        }
        excp.printBacktrace(errorStream);
    }

    private void printErrorPos(PrintStream errorStream) {
        ThreadContext tc = this.getCurrentContext();
        if (tc.getSourceFile() != null) {
            if (tc.getFrameLastFunc() != null) {
                errorStream.print(tc.getPosition());
                errorStream.print(":in '" + tc.getFrameLastFunc() + '\'');
            } else if (tc.getSourceLine() != 0) {
                errorStream.print(tc.getPosition());
            } else {
                errorStream.print(tc.getSourceFile());
            }
        }
    }

    public void loadScript(RubyString scriptName, RubyString source, boolean wrap) {
        this.loadScript(scriptName.toString(), new StringReader(source.toString()), wrap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadScript(String scriptName, Reader source, boolean wrap) {
        block8: {
            IRubyObject self = this.getTopSelf();
            ThreadContext context = this.getCurrentContext();
            RubyModule wrapper = context.getWrapper();
            try {
                if (!wrap) {
                    this.secure(4);
                    context.preNodeEval(null, this.objectClass, self);
                } else {
                    context.preNodeEval(RubyModule.newModule(this, null), context.getWrapper(), self);
                    self = this.getTopSelf().rbClone();
                    self.extendObject(context.getRubyClass());
                }
                Node node = this.parse(source, scriptName, null);
                self.eval(node);
            }
            catch (JumpException je) {
                if (je.getJumpType() == JumpException.JumpType.ReturnJump) {
                    break block8;
                }
                throw je;
            }
            finally {
                context.postNodeEval(wrapper);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadNode(String scriptName, Node node, boolean wrap) {
        block8: {
            IRubyObject self = this.getTopSelf();
            ThreadContext context = this.getCurrentContext();
            RubyModule wrapper = context.getWrapper();
            try {
                if (!wrap) {
                    this.secure(4);
                    context.preNodeEval(null, this.objectClass, self);
                } else {
                    context.preNodeEval(RubyModule.newModule(this, null), context.getWrapper(), self);
                    self = this.getTopSelf().rbClone();
                    self.extendObject(context.getRubyClass());
                }
                self.eval(node);
            }
            catch (JumpException je) {
                if (je.getJumpType() == JumpException.JumpType.ReturnJump) {
                    break block8;
                }
                throw je;
            }
            finally {
                context.postNodeEval(wrapper);
            }
        }
    }

    public void loadFile(File file, boolean wrap) {
        if (!$assertionsDisabled && file == null) {
            throw new AssertionError((Object)"No such file to load");
        }
        try {
            BufferedReader source = new BufferedReader(new FileReader(file));
            this.loadScript(file.getPath().replace(File.separatorChar, '/'), source, wrap);
            source.close();
        }
        catch (IOException ioExcptn) {
            throw this.newIOErrorFromException(ioExcptn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void callTraceFunction(ThreadContext context, String event, ISourcePosition position, IRubyObject self, String name, IRubyObject type) {
        if (this.traceFunction == null) {
            return;
        }
        if (!context.isWithinTrace()) {
            context.setWithinTrace(true);
            ISourcePosition savePosition = context.getPosition();
            String file = position.getFile();
            if (file == null) {
                file = "(ruby)";
            }
            if (type == null) {
                type = this.getFalse();
            }
            context.preTrace();
            try {
                this.traceFunction.call(new IRubyObject[]{this.newString(event), this.newString(file), this.newFixnum(position.getEndLine()), name != null ? RubySymbol.newSymbol(this, name) : this.getNil(), self != null ? self : this.getNil(), type});
            }
            finally {
                context.postTrace();
                context.setPosition(savePosition);
                context.setWithinTrace(false);
            }
        }
    }

    public RubyProc getTraceFunction() {
        return this.traceFunction;
    }

    public void setTraceFunction(RubyProc traceFunction) {
        this.traceFunction = traceFunction;
    }

    public GlobalVariables getGlobalVariables() {
        return this.globalVariables;
    }

    public void setGlobalVariables(GlobalVariables globalVariables) {
        this.globalVariables = globalVariables;
    }

    public CallbackFactory callbackFactory(Class type) {
        return CallbackFactory.createFactory(type);
    }

    public IRubyObject pushExitBlock(RubyProc proc) {
        this.atExitBlocks.push(proc);
        return proc;
    }

    public void tearDown() {
        while (!this.atExitBlocks.empty()) {
            RubyProc proc = (RubyProc)this.atExitBlocks.pop();
            proc.call(IRubyObject.NULL_ARRAY);
        }
    }

    public RubyArray newArray() {
        return RubyArray.newArray(this);
    }

    public RubyArray newArray(IRubyObject object) {
        return RubyArray.newArray((IRuby)this, object);
    }

    public RubyArray newArray(IRubyObject car, IRubyObject cdr) {
        return RubyArray.newArray(this, car, cdr);
    }

    public RubyArray newArray(IRubyObject[] objects) {
        return RubyArray.newArray((IRuby)this, objects);
    }

    public RubyArray newArray(List list) {
        return RubyArray.newArray((IRuby)this, list);
    }

    public RubyArray newArray(int size) {
        return RubyArray.newArray((IRuby)this, size);
    }

    public RubyBoolean newBoolean(boolean value) {
        return RubyBoolean.newBoolean(this, value);
    }

    public RubyFileStat newRubyFileStat(File file) {
        return new RubyFileStat((IRuby)this, JRubyFile.create(this.currentDirectory, file.getPath()));
    }

    public RubyFixnum newFixnum(long value) {
        return RubyFixnum.newFixnum(this, value);
    }

    public RubyFloat newFloat(double value) {
        return RubyFloat.newFloat(this, value);
    }

    public RubyNumeric newNumeric() {
        return RubyNumeric.newNumeric(this);
    }

    public RubyProc newProc() {
        return RubyProc.newProc(this, false);
    }

    public RubyBinding newBinding() {
        return RubyBinding.newBinding(this);
    }

    public RubyBinding newBinding(Block block) {
        return RubyBinding.newBinding(this, block);
    }

    public RubyString newString(String string) {
        return RubyString.newString((IRuby)this, string);
    }

    public RubySymbol newSymbol(String string) {
        return RubySymbol.newSymbol(this, string);
    }

    public RubyTime newTime(long milliseconds) {
        return RubyTime.newTime((IRuby)this, milliseconds);
    }

    public RaiseException newArgumentError(String message) {
        return this.newRaiseException(this.getClass("ArgumentError"), message);
    }

    public RaiseException newArgumentError(int got, int expected) {
        return this.newRaiseException(this.getClass("ArgumentError"), "wrong # of arguments(" + got + " for " + expected + ")");
    }

    public RaiseException newErrnoEBADFError() {
        return this.newRaiseException(this.getModule("Errno").getClass("EBADF"), "Bad file descriptor");
    }

    public RaiseException newErrnoEINVALError() {
        return this.newRaiseException(this.getModule("Errno").getClass("EINVAL"), "Invalid file");
    }

    public RaiseException newErrnoENOENTError() {
        return this.newRaiseException(this.getModule("Errno").getClass("ENOENT"), "File not found");
    }

    public RaiseException newErrnoESPIPEError() {
        return this.newRaiseException(this.getModule("Errno").getClass("ESPIPE"), "Illegal seek");
    }

    public RaiseException newErrnoEBADFError(String message) {
        return this.newRaiseException(this.getModule("Errno").getClass("EBADF"), message);
    }

    public RaiseException newErrnoEINVALError(String message) {
        return this.newRaiseException(this.getModule("Errno").getClass("EINVAL"), message);
    }

    public RaiseException newErrnoENOENTError(String message) {
        return this.newRaiseException(this.getModule("Errno").getClass("ENOENT"), message);
    }

    public RaiseException newErrnoESPIPEError(String message) {
        return this.newRaiseException(this.getModule("Errno").getClass("ESPIPE"), message);
    }

    public RaiseException newErrnoEEXISTError(String message) {
        return this.newRaiseException(this.getModule("Errno").getClass("EEXIST"), message);
    }

    public RaiseException newIndexError(String message) {
        return this.newRaiseException(this.getClass("IndexError"), message);
    }

    public RaiseException newSecurityError(String message) {
        return this.newRaiseException(this.getClass("SecurityError"), message);
    }

    public RaiseException newSystemCallError(String message) {
        return this.newRaiseException(this.getClass("SystemCallError"), message);
    }

    public RaiseException newTypeError(String message) {
        return this.newRaiseException(this.getClass("TypeError"), message);
    }

    public RaiseException newThreadError(String message) {
        return this.newRaiseException(this.getClass("ThreadError"), message);
    }

    public RaiseException newSyntaxError(String message) {
        return this.newRaiseException(this.getClass("SyntaxError"), message);
    }

    public RaiseException newRangeError(String message) {
        return this.newRaiseException(this.getClass("RangeError"), message);
    }

    public RaiseException newNotImplementedError(String message) {
        return this.newRaiseException(this.getClass("NotImplementedError"), message);
    }

    public RaiseException newNoMethodError(String message, String name) {
        return new RaiseException(new RubyNameError(this, this.getClass("NoMethodError"), message, name), true);
    }

    public RaiseException newNameError(String message, String name) {
        return new RaiseException(new RubyNameError(this, this.getClass("NameError"), message, name), true);
    }

    public RaiseException newLocalJumpError(String message) {
        return this.newRaiseException(this.getClass("LocalJumpError"), message);
    }

    public RaiseException newLoadError(String message) {
        return this.newRaiseException(this.getClass("LoadError"), message);
    }

    public RaiseException newFrozenError(String objectType) {
        return this.newRaiseException(this.getClass("TypeError"), "can't modify frozen " + objectType);
    }

    public RaiseException newSystemStackError(String message) {
        return this.newRaiseException(this.getClass("SystemStackError"), message);
    }

    public RaiseException newSystemExit(int status) {
        RaiseException re = this.newRaiseException(this.getClass("SystemExit"), "");
        re.getException().setInstanceVariable("status", this.newFixnum(status));
        return re;
    }

    public RaiseException newIOError(String message) {
        return this.newRaiseException(this.getClass("IOError"), message);
    }

    public RaiseException newIOErrorFromException(IOException ioe) {
        return this.newRaiseException(this.getClass("IOError"), ioe.getMessage());
    }

    public RaiseException newTypeError(IRubyObject receivedObject, RubyClass expectedType) {
        return this.newRaiseException(this.getClass("TypeError"), "wrong argument type " + receivedObject.getMetaClass() + " (expected " + expectedType);
    }

    public RaiseException newEOFError() {
        return this.newRaiseException(this.getClass("EOFError"), "End of file reached");
    }

    public RaiseException newZeroDivisionError() {
        return this.newRaiseException(this.getClass("ZeroDivisionError"), "divided by 0");
    }

    private RaiseException newRaiseException(RubyClass exceptionClass, String message) {
        RaiseException re = new RaiseException(this, exceptionClass, message, true);
        return re;
    }

    public RubySymbol.SymbolTable getSymbolTable() {
        return this.symbolTable;
    }

    public void setStackTraces(int stackTraces) {
        this.stackTraces = stackTraces;
    }

    public int getStackTraces() {
        return this.stackTraces;
    }

    public void setRandomSeed(long randomSeed) {
        this.randomSeed = randomSeed;
    }

    public long getRandomSeed() {
        return this.randomSeed;
    }

    public Random getRandom() {
        return this.random;
    }

    public ObjectSpace getObjectSpace() {
        return this.objectSpace;
    }

    public Hashtable getIoHandlers() {
        return this.ioHandlers;
    }

    public RubyFixnum[] getFixnumCache() {
        return this.fixnumCache;
    }

    public long incrementRandomSeedSequence() {
        return this.randomSeedSequence++;
    }

    public InputStream getIn() {
        return this.in;
    }

    public PrintStream getOut() {
        return this.out;
    }

    public PrintStream getErr() {
        return this.err;
    }

    public boolean isGlobalAbortOnExceptionEnabled() {
        return this.globalAbortOnExceptionEnabled;
    }

    public void setGlobalAbortOnExceptionEnabled(boolean enable) {
        this.globalAbortOnExceptionEnabled = enable;
    }

    public boolean isDoNotReverseLookupEnabled() {
        return this.doNotReverseLookupEnabled;
    }

    public void setDoNotReverseLookupEnabled(boolean b) {
        this.doNotReverseLookupEnabled = b;
    }

    public boolean registerInspecting(Object obj) {
        IdentityHashMap<Object, Object> val = (IdentityHashMap<Object, Object>)this.inspect.get();
        if (null == val) {
            val = new IdentityHashMap<Object, Object>();
            this.inspect.set(val);
        }
        if (val.containsKey(obj)) {
            return false;
        }
        val.put(obj, null);
        return true;
    }

    public void unregisterInspecting(Object obj) {
        Map val = (Map)this.inspect.get();
        val.remove(obj);
    }

    public boolean isObjectSpaceEnabled() {
        return this.objectSpaceEnabled;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getEncoding() {
        return this.encoding;
    }

    static {
        $assertionsDisabled = !Ruby.class.desiredAssertionStatus();
        BUILTIN_LIBRARIES = new String[]{"fcntl", "yaml", "etc", "nkf"};
    }
}

