/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import org.jruby.IRuby;
import org.jruby.RubyArray;
import org.jruby.RubyFile;
import org.jruby.RubyNil;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class RubyArgsFile
extends RubyObject {
    private IRubyObject currentFile = null;
    private int currentLineNumber;

    public RubyArgsFile(IRuby runtime) {
        super(runtime, runtime.getObject());
    }

    public void setCurrentLineNumber(int newLineNumber) {
        this.currentLineNumber = newLineNumber;
    }

    public void initArgsFile() {
        this.extendObject(this.getRuntime().getModule("Enumerable"));
        this.getRuntime().defineReadonlyVariable("$<", this);
        this.getRuntime().defineGlobalConstant("ARGF", this);
        CallbackFactory callbackFactory = this.getRuntime().callbackFactory(RubyArgsFile.class);
        this.defineSingletonMethod("each", callbackFactory.getOptMethod("each_line"));
        this.defineSingletonMethod("each_line", callbackFactory.getOptMethod("each_line"));
        this.defineSingletonMethod("filename", callbackFactory.getMethod("filename"));
        this.defineSingletonMethod("to_s", callbackFactory.getMethod("filename"));
        this.getRuntime().defineReadonlyVariable("$FILENAME", this.getRuntime().newString("-"));
    }

    protected boolean nextArgsFile() {
        RubyArray args = (RubyArray)this.getRuntime().getGlobalVariables().get("$*");
        if (args.getLength() == 0) {
            if (this.currentFile == null) {
                this.currentFile = this.getRuntime().getGlobalVariables().get("$stdin");
                ((RubyString)this.getRuntime().getGlobalVariables().get("$FILENAME")).setValue(new StringBuffer("-"));
                this.currentLineNumber = 0;
                return true;
            }
            return false;
        }
        String filename = ((RubyString)args.shift()).toString();
        ((RubyString)this.getRuntime().getGlobalVariables().get("$FILENAME")).setValue(new StringBuffer(filename));
        this.currentFile = filename.equals("-") ? this.getRuntime().getGlobalVariables().get("$stdin") : new RubyFile(this.getRuntime(), filename);
        return true;
    }

    public IRubyObject internalGets(IRubyObject[] args) {
        if (this.currentFile == null && !this.nextArgsFile()) {
            return this.getRuntime().getNil();
        }
        ThreadContext context = this.getRuntime().getCurrentContext();
        IRubyObject line = this.currentFile.callMethod(context, "gets", args);
        while (line instanceof RubyNil) {
            this.currentFile.callMethod(context, "close");
            if (!this.nextArgsFile()) {
                this.currentFile = null;
                return line;
            }
            line = this.currentFile.callMethod(context, "gets", args);
        }
        ++this.currentLineNumber;
        this.getRuntime().getGlobalVariables().set("$.", this.getRuntime().newFixnum(this.currentLineNumber));
        return line;
    }

    public IRubyObject each_line(IRubyObject[] args) {
        IRubyObject nextLine = this.internalGets(args);
        while (!nextLine.isNil()) {
            this.getRuntime().getCurrentContext().yield(nextLine);
            nextLine = this.internalGets(args);
        }
        return this;
    }

    public RubyString filename() {
        return (RubyString)this.getRuntime().getGlobalVariables().get("$FILENAME");
    }
}

