/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.EOFException;
import java.io.IOException;
import java.nio.channels.Channel;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import org.jruby.IRuby;
import org.jruby.RubyClass;
import org.jruby.RubyIO;
import org.jruby.RubyNumeric;
import org.jruby.javasupport.JavaObject;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.IOHandler;
import org.jruby.util.IOHandlerNio;

public class RubyBasicSocket
extends RubyIO {
    private Channel socketChannel;

    public RubyBasicSocket(IRuby runtime, RubyClass type) {
        super(runtime, type);
    }

    public IRubyObject initialize(IRubyObject arg) {
        this.socketChannel = this.extractSocketChannel(arg);
        try {
            this.handler = new IOHandlerNio(this.getRuntime(), this.socketChannel);
            this.handler.setIsSync(true);
        }
        catch (IOException e) {
            throw this.getRuntime().newIOError(e.getMessage());
        }
        this.registerIOHandler(this.handler);
        this.modes = this.handler.getModes();
        return this;
    }

    private Channel extractSocketChannel(IRubyObject proxyObject) {
        IRubyObject javaObject = proxyObject.getInstanceVariable("@java_object");
        return (Channel)((JavaObject)javaObject).getValue();
    }

    public IRubyObject write_send(IRubyObject[] args) {
        return this.syswrite(args[0]);
    }

    public IRubyObject recv(IRubyObject[] args) {
        try {
            return this.getRuntime().newString(((IOHandlerNio)this.handler).recv(RubyNumeric.fix2int(args[0])));
        }
        catch (IOHandler.BadDescriptorException e) {
            throw this.getRuntime().newErrnoEBADFError();
        }
        catch (EOFException e) {
            return this.getRuntime().getNil();
        }
        catch (IOException e) {
            if ("Socket not open".equals(e.getMessage())) {
                throw this.getRuntime().newIOError(e.getMessage());
            }
            throw this.getRuntime().newSystemCallError(e.getMessage());
        }
    }

    public IRubyObject getsockname() {
        if (this.socketChannel instanceof SocketChannel) {
            return JavaObject.wrap(this.getRuntime(), ((SocketChannel)this.socketChannel).socket().getLocalSocketAddress());
        }
        if (this.socketChannel instanceof ServerSocketChannel) {
            return JavaObject.wrap(this.getRuntime(), ((ServerSocketChannel)this.socketChannel).socket().getLocalSocketAddress());
        }
        throw this.getRuntime().newIOError("Not Supported");
    }

    public IRubyObject getpeername() {
        if (this.socketChannel instanceof SocketChannel) {
            return JavaObject.wrap(this.getRuntime(), ((SocketChannel)this.socketChannel).socket().getRemoteSocketAddress());
        }
        throw this.getRuntime().newIOError("Not Supported");
    }

    public IRubyObject shutdown(IRubyObject[] args) {
        if (this.getRuntime().getSafeLevel() >= 4 && this.tainted().isFalse()) {
            throw this.getRuntime().newSecurityError("Insecure: can't shutdown socket");
        }
        int how = 2;
        if (args.length > 0) {
            how = RubyNumeric.fix2int(args[0]);
        }
        if (how < 0 || 2 < how) {
            throw this.getRuntime().newArgumentError("`how' should be either 0, 1, 2");
        }
        if (how != 2) {
            throw this.getRuntime().newNotImplementedError("Shutdown currently only works with how=2");
        }
        return this.close();
    }
}

