/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.IOException;
import org.jruby.IRuby;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyObject;
import org.jruby.runtime.marshal.MarshalStream;

public class RubyBoolean
extends RubyObject {
    private final IRuby runtime;
    private final boolean value;

    public RubyBoolean(IRuby runtime, boolean value) {
        super(runtime, null, false);
        this.value = value;
        this.runtime = runtime;
    }

    public IRuby getRuntime() {
        return this.runtime;
    }

    public boolean isImmediate() {
        return true;
    }

    public Class getJavaClass() {
        return Boolean.TYPE;
    }

    public RubyClass getMetaClass() {
        return this.value ? this.getRuntime().getClass("TrueClass") : this.getRuntime().getClass("FalseClass");
    }

    public boolean isTrue() {
        return this.value;
    }

    public boolean isFalse() {
        return !this.value;
    }

    public RubyFixnum id() {
        return this.getRuntime().newFixnum(this.value ? 2L : 0L);
    }

    public static RubyClass createFalseClass(IRuby runtime) {
        RubyClass falseClass = runtime.defineClass("FalseClass", runtime.getObject());
        falseClass.defineMethod("type", runtime.callbackFactory(RubyBoolean.class).getMethod("type"));
        runtime.defineGlobalConstant("FALSE", runtime.getFalse());
        return falseClass;
    }

    public static RubyClass createTrueClass(IRuby runtime) {
        RubyClass trueClass = runtime.defineClass("TrueClass", runtime.getObject());
        trueClass.defineMethod("type", runtime.callbackFactory(RubyBoolean.class).getMethod("type"));
        runtime.defineGlobalConstant("TRUE", runtime.getTrue());
        return trueClass;
    }

    public static RubyBoolean newBoolean(IRuby runtime, boolean value) {
        return value ? runtime.getTrue() : runtime.getFalse();
    }

    public RubyClass type() {
        return this.getMetaClass();
    }

    public void marshalTo(MarshalStream output) throws IOException {
        output.write(this.isTrue() ? 84 : 70);
    }
}

