/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.IOException;
import org.jruby.IRuby;
import org.jruby.RubyArray;
import org.jruby.RubyBignum;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyInteger;
import org.jruby.RubyNumeric;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.marshal.MarshalStream;
import org.jruby.runtime.marshal.UnmarshalStream;

public class RubyFloat
extends RubyNumeric {
    private final double value;

    public RubyFloat(IRuby runtime) {
        this(runtime, 0.0);
    }

    public RubyFloat(IRuby runtime, double value) {
        super(runtime, runtime.getClass("Float"));
        this.value = value;
    }

    public Class getJavaClass() {
        return Double.TYPE;
    }

    public double getValue() {
        return this.value;
    }

    public double getDoubleValue() {
        return this.value;
    }

    public long getLongValue() {
        return (long)this.value;
    }

    public RubyFloat convertToFloat() {
        return this;
    }

    public static RubyClass createFloatClass(IRuby runtime) {
        RubyClass result = runtime.defineClass("Float", runtime.getClass("Numeric"));
        CallbackFactory callbackFactory = runtime.callbackFactory(RubyFloat.class);
        result.defineMethod("+", callbackFactory.getMethod("op_plus", IRubyObject.class));
        result.defineMethod("-", callbackFactory.getMethod("op_minus", IRubyObject.class));
        result.defineMethod("*", callbackFactory.getMethod("op_mul", IRubyObject.class));
        result.defineMethod("/", callbackFactory.getMethod("op_div", IRubyObject.class));
        result.defineMethod("%", callbackFactory.getMethod("op_mod", IRubyObject.class));
        result.defineMethod("**", callbackFactory.getMethod("op_pow", IRubyObject.class));
        result.defineMethod("==", callbackFactory.getMethod("equal", IRubyObject.class));
        result.defineMethod("<=>", callbackFactory.getMethod("cmp", IRubyObject.class));
        result.defineMethod(">", callbackFactory.getMethod("op_gt", IRubyObject.class));
        result.defineMethod(">=", callbackFactory.getMethod("op_ge", IRubyObject.class));
        result.defineMethod("<", callbackFactory.getMethod("op_lt", IRubyObject.class));
        result.defineMethod("<=", callbackFactory.getMethod("op_le", IRubyObject.class));
        result.defineMethod("ceil", callbackFactory.getMethod("ceil"));
        result.defineMethod("finite?", callbackFactory.getMethod("finite_p"));
        result.defineMethod("floor", callbackFactory.getMethod("floor"));
        result.defineMethod("hash", callbackFactory.getMethod("hash"));
        result.defineMethod("infinite?", callbackFactory.getMethod("infinite_p"));
        result.defineMethod("nan?", callbackFactory.getMethod("nan_p"));
        result.defineMethod("round", callbackFactory.getMethod("round"));
        result.defineMethod("to_i", callbackFactory.getMethod("to_i"));
        result.defineAlias("to_int", "to_i");
        result.defineMethod("to_f", callbackFactory.getMethod("to_f"));
        result.defineMethod("to_s", callbackFactory.getMethod("to_s"));
        result.defineMethod("truncate", callbackFactory.getMethod("truncate"));
        result.getMetaClass().undefineMethod("new");
        result.defineSingletonMethod("induced_from", callbackFactory.getSingletonMethod("induced_from", IRubyObject.class));
        return result;
    }

    protected int compareValue(RubyNumeric other) {
        double otherVal = other.getDoubleValue();
        return this.getValue() > otherVal ? 1 : (this.getValue() < otherVal ? -1 : 0);
    }

    public RubyFixnum hash() {
        return this.getRuntime().newFixnum(new Double(this.value).hashCode());
    }

    public static RubyFloat newFloat(IRuby runtime, double value) {
        return new RubyFloat(runtime, value);
    }

    public static RubyFloat induced_from(IRubyObject recv, IRubyObject number) {
        if (number instanceof RubyFloat) {
            return (RubyFloat)number;
        }
        if (number instanceof RubyInteger) {
            return (RubyFloat)number.callMethod(number.getRuntime().getCurrentContext(), "to_f");
        }
        throw recv.getRuntime().newTypeError("failed to convert " + number.getMetaClass() + " into Float");
    }

    public RubyArray coerce(RubyNumeric other) {
        return this.getRuntime().newArray(RubyFloat.newFloat(this.getRuntime(), other.getDoubleValue()), this);
    }

    public RubyInteger ceil() {
        double val = Math.ceil(this.getDoubleValue());
        if (val < -4.611686018427388E18 || val > 4.611686018427388E18) {
            return RubyBignum.newBignum(this.getRuntime(), val);
        }
        return this.getRuntime().newFixnum((long)val);
    }

    public RubyInteger floor() {
        double val = Math.floor(this.getDoubleValue());
        if (val < -9.223372036854776E18 || val > 9.223372036854776E18) {
            return RubyBignum.newBignum(this.getRuntime(), val);
        }
        return this.getRuntime().newFixnum((long)val);
    }

    public RubyInteger round() {
        double decimal = this.value % 1.0;
        double round = Math.round(this.value);
        if (this.value < 0.0 && decimal == -0.5) {
            round -= 1.0;
        }
        if (this.value < -4.611686018427388E18 || this.value > 4.611686018427388E18) {
            return RubyBignum.newBignum(this.getRuntime(), round);
        }
        return this.getRuntime().newFixnum((long)round);
    }

    public RubyInteger truncate() {
        if (this.value > 0.0) {
            return this.floor();
        }
        if (this.value < 0.0) {
            return this.ceil();
        }
        return RubyFixnum.zero(this.getRuntime());
    }

    public RubyNumeric multiplyWith(RubyNumeric other) {
        return other.multiplyWith(this);
    }

    public RubyNumeric multiplyWith(RubyFloat other) {
        return RubyFloat.newFloat(this.getRuntime(), this.getDoubleValue() * other.getDoubleValue());
    }

    public RubyNumeric multiplyWith(RubyInteger other) {
        return other.multiplyWith(this);
    }

    public RubyNumeric multiplyWith(RubyBignum other) {
        return other.multiplyWith(this);
    }

    public IRubyObject op_div(IRubyObject other) {
        if (other instanceof RubyNumeric) {
            return RubyFloat.newFloat(this.getRuntime(), this.getDoubleValue() / ((RubyNumeric)other).getDoubleValue());
        }
        return this.callCoerced("/", other);
    }

    public IRubyObject op_mod(IRubyObject other) {
        if (other instanceof RubyNumeric) {
            double y;
            double x = this.getDoubleValue();
            double mod = x % (y = ((RubyNumeric)other).getDoubleValue());
            if (mod < 0.0 && y > 0.0 || mod > 0.0 && y < 0.0) {
                mod += y;
            }
            return RubyFloat.newFloat(this.getRuntime(), mod);
        }
        return this.callCoerced("%", other);
    }

    public IRubyObject op_minus(IRubyObject other) {
        if (other instanceof RubyNumeric) {
            return RubyFloat.newFloat(this.getRuntime(), this.getDoubleValue() - ((RubyNumeric)other).getDoubleValue());
        }
        return this.callCoerced("-", other);
    }

    public IRubyObject op_mul(IRubyObject other) {
        if (other instanceof RubyNumeric) {
            return ((RubyNumeric)other).multiplyWith(this);
        }
        return this.callCoerced("*", other);
    }

    public IRubyObject op_plus(IRubyObject other) {
        if (other instanceof RubyNumeric) {
            return RubyFloat.newFloat(this.getRuntime(), this.getDoubleValue() + ((RubyNumeric)other).getDoubleValue());
        }
        return this.callCoerced("+", other);
    }

    public IRubyObject op_pow(IRubyObject other) {
        if (other instanceof RubyNumeric) {
            return RubyFloat.newFloat(this.getRuntime(), Math.pow(this.getDoubleValue(), ((RubyNumeric)other).getDoubleValue()));
        }
        return this.callCoerced("**", other);
    }

    public IRubyObject op_uminus() {
        return RubyFloat.newFloat(this.getRuntime(), -this.value);
    }

    public IRubyObject to_s() {
        return this.getRuntime().newString("" + this.getValue());
    }

    public RubyFloat to_f() {
        return this;
    }

    public RubyInteger to_i() {
        if (this.value > 2.147483647E9) {
            return RubyBignum.newBignum(this.getRuntime(), this.getValue());
        }
        return this.getRuntime().newFixnum(this.getLongValue());
    }

    public IRubyObject infinite_p() {
        if (this.getValue() == Double.POSITIVE_INFINITY) {
            return this.getRuntime().newFixnum(1L);
        }
        if (this.getValue() == Double.NEGATIVE_INFINITY) {
            return this.getRuntime().newFixnum(-1L);
        }
        return this.getRuntime().getNil();
    }

    public RubyBoolean finite_p() {
        if (!this.infinite_p().isNil()) {
            return this.getRuntime().getFalse();
        }
        if (this.nan_p().isTrue()) {
            return this.getRuntime().getFalse();
        }
        return this.getRuntime().getTrue();
    }

    public RubyBoolean nan_p() {
        return this.getRuntime().newBoolean(Double.isNaN(this.getValue()));
    }

    public RubyBoolean zero_p() {
        return this.getRuntime().newBoolean(this.getValue() == 0.0);
    }

    public void marshalTo(MarshalStream output) throws IOException {
        output.write(102);
        String strValue = this.toString();
        if (Double.isInfinite(this.value)) {
            strValue = this.value < 0.0 ? "-inf" : "inf";
        } else if (Double.isNaN(this.value)) {
            strValue = "nan";
        }
        output.dumpString(strValue);
    }

    public static RubyFloat unmarshalFrom(UnmarshalStream input) throws IOException {
        return RubyFloat.newFloat(input.getRuntime(), Double.parseDouble(input.unmarshalString()));
    }

    public IRubyObject equal(IRubyObject other) {
        if (!(other instanceof RubyNumeric)) {
            return other.callMethod(this.getRuntime().getCurrentContext(), "==", this);
        }
        double otherValue = ((RubyNumeric)other).getDoubleValue();
        if (other instanceof RubyFloat && Double.isNaN(otherValue)) {
            return this.getRuntime().getFalse();
        }
        return this.value == otherValue ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
    }

    public IRubyObject cmp(IRubyObject other) {
        if (!(other instanceof RubyNumeric)) {
            IRubyObject[] tmp = this.getCoerced(other, false);
            if (tmp == null) {
                return this.getRuntime().getNil();
            }
            return tmp[1].callMethod(this.getRuntime().getCurrentContext(), "<=>", tmp[0]);
        }
        return this.doubleCompare(((RubyNumeric)other).getDoubleValue());
    }

    private void cmperr(IRubyObject other) {
        String message = "comparison of " + this.getType() + " with " + other.getType() + " failed";
        throw this.getRuntime().newArgumentError(message);
    }

    public IRubyObject op_gt(IRubyObject other) {
        if (Double.isNaN(this.value)) {
            return this.getRuntime().getFalse();
        }
        if (!(other instanceof RubyNumeric)) {
            IRubyObject[] tmp = this.getCoerced(other, false);
            if (tmp == null) {
                this.cmperr(other);
            }
            return tmp[1].callMethod(this.getRuntime().getCurrentContext(), "<=>", tmp[0]);
        }
        double oth = ((RubyNumeric)other).getDoubleValue();
        if (other instanceof RubyFloat && Double.isNaN(oth)) {
            return this.getRuntime().getFalse();
        }
        return this.value > oth ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
    }

    public IRubyObject op_ge(IRubyObject other) {
        if (Double.isNaN(this.value)) {
            return this.getRuntime().getFalse();
        }
        if (!(other instanceof RubyNumeric)) {
            IRubyObject[] tmp = this.getCoerced(other, false);
            if (tmp == null) {
                this.cmperr(other);
            }
            return tmp[1].callMethod(this.getRuntime().getCurrentContext(), "<=>", tmp[0]);
        }
        double oth = ((RubyNumeric)other).getDoubleValue();
        if (other instanceof RubyFloat && Double.isNaN(oth)) {
            return this.getRuntime().getFalse();
        }
        return this.value >= oth ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
    }

    public IRubyObject op_lt(IRubyObject other) {
        if (Double.isNaN(this.value)) {
            return this.getRuntime().getFalse();
        }
        if (!(other instanceof RubyNumeric)) {
            IRubyObject[] tmp = this.getCoerced(other, false);
            if (tmp == null) {
                this.cmperr(other);
            }
            return tmp[1].callMethod(this.getRuntime().getCurrentContext(), "<=>", tmp[0]);
        }
        double oth = ((RubyNumeric)other).getDoubleValue();
        if (other instanceof RubyFloat && Double.isNaN(oth)) {
            return this.getRuntime().getFalse();
        }
        return this.value < oth ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
    }

    public IRubyObject op_le(IRubyObject other) {
        if (Double.isNaN(this.value)) {
            return this.getRuntime().getFalse();
        }
        if (!(other instanceof RubyNumeric)) {
            IRubyObject[] tmp = this.getCoerced(other, false);
            if (tmp == null) {
                this.cmperr(other);
            }
            return tmp[1].callMethod(this.getRuntime().getCurrentContext(), "<=>", tmp[0]);
        }
        double oth = ((RubyNumeric)other).getDoubleValue();
        if (other instanceof RubyFloat && Double.isNaN(oth)) {
            return this.getRuntime().getFalse();
        }
        return this.value <= oth ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
    }

    private IRubyObject doubleCompare(double oth) {
        if (Double.isNaN(this.value) || Double.isNaN(oth)) {
            return this.getRuntime().getNil();
        }
        if (this.value == oth) {
            return this.getRuntime().newFixnum(0L);
        }
        return this.value > oth ? this.getRuntime().newFixnum(1L) : this.getRuntime().newFixnum(-1L);
    }
}

