/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jruby.IRuby;
import org.jruby.IncludedModuleWrapper;
import org.jruby.RubyArray;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyMethod;
import org.jruby.RubyObject;
import org.jruby.RubyProc;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.RubyUnboundMethod;
import org.jruby.exceptions.RaiseException;
import org.jruby.internal.runtime.methods.AbstractMethod;
import org.jruby.internal.runtime.methods.AliasMethod;
import org.jruby.internal.runtime.methods.CallbackMethod;
import org.jruby.internal.runtime.methods.MethodMethod;
import org.jruby.internal.runtime.methods.ProcMethod;
import org.jruby.internal.runtime.methods.UndefinedMethod;
import org.jruby.internal.runtime.methods.WrapperCallable;
import org.jruby.runtime.Arity;
import org.jruby.runtime.ICallable;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.callback.Callback;
import org.jruby.runtime.marshal.MarshalStream;
import org.jruby.runtime.marshal.UnmarshalStream;
import org.jruby.util.IdUtil;
import org.jruby.util.collections.SinglyLinkedList;

public class RubyModule
extends RubyObject {
    private static final String CVAR_TAINT_ERROR = "Insecure: can't modify class variable";
    private static final String CVAR_FREEZE_ERROR = "class/module";
    private RubyClass superClass;
    public SinglyLinkedList cref;
    private String classId;
    private Map methods = new HashMap();
    static final /* synthetic */ boolean $assertionsDisabled;

    protected RubyModule(IRuby runtime, RubyClass metaClass, RubyClass superClass, SinglyLinkedList parentCRef, String name) {
        super(runtime, metaClass);
        this.superClass = superClass;
        this.setBaseName(name);
        if (parentCRef == null && runtime.getObject() != null) {
            parentCRef = runtime.getObject().getCRef();
        }
        this.cref = new SinglyLinkedList(this, parentCRef);
    }

    public RubyClass getSuperClass() {
        return this.superClass;
    }

    private void setSuperClass(RubyClass superClass) {
        this.superClass = superClass;
    }

    public RubyModule getParent() {
        if (this.cref.getNext() == null) {
            return null;
        }
        return (RubyModule)this.cref.getNext().getValue();
    }

    public void setParent(RubyModule p) {
        this.cref.setNext(p.getCRef());
    }

    public Map getMethods() {
        return this.methods;
    }

    public boolean isModule() {
        return true;
    }

    public boolean isClass() {
        return false;
    }

    public boolean isSingleton() {
        return false;
    }

    public boolean isIncluded() {
        return false;
    }

    public RubyModule getNonIncludedClass() {
        return this;
    }

    public String getBaseName() {
        return this.classId;
    }

    public void setBaseName(String name) {
        this.classId = name;
    }

    public String getName() {
        if (this.getBaseName() == null) {
            if (this.isClass()) {
                return "#<Class:01x" + Integer.toHexString(System.identityHashCode(this)) + ">";
            }
            return "#<Module:01x" + Integer.toHexString(System.identityHashCode(this)) + ">";
        }
        StringBuffer result = new StringBuffer(this.getBaseName());
        RubyClass objectClass = this.getRuntime().getObject();
        for (RubyModule p = this.getParent(); p != null && p != objectClass; p = p.getParent()) {
            result.insert(0, "::").insert(0, p.getBaseName());
        }
        return result.toString();
    }

    public IncludedModuleWrapper newIncludeClass(RubyClass superClazz) {
        IncludedModuleWrapper includedModule = new IncludedModuleWrapper(this.getRuntime(), superClazz, this);
        if (this.getSuperClass() != null) {
            includedModule.includeModule(this.getSuperClass());
        }
        return includedModule;
    }

    private RubyModule getModuleWithInstanceVar(String name) {
        for (RubyModule p = this; p != null; p = p.getSuperClass()) {
            if (p.getInstanceVariable(name) == null) continue;
            return p;
        }
        return null;
    }

    public IRubyObject setClassVar(String name, IRubyObject value) {
        RubyModule module = this.getModuleWithInstanceVar(name);
        if (module == null) {
            module = this;
        }
        return module.setInstanceVariable(name, value, CVAR_TAINT_ERROR, CVAR_FREEZE_ERROR);
    }

    public IRubyObject getClassVar(String name) {
        RubyModule module = this.getModuleWithInstanceVar(name);
        if (module != null) {
            IRubyObject variable = module.getInstanceVariable(name);
            return variable == null ? this.getRuntime().getNil() : variable;
        }
        throw this.getRuntime().newNameError("uninitialized class variable " + name + " in " + this.getName(), name);
    }

    public boolean isClassVarDefined(String name) {
        return this.getModuleWithInstanceVar(name) != null;
    }

    public IRubyObject setConstant(String name, IRubyObject value) {
        RubyModule module;
        IRubyObject result = this.setInstanceVariable(name, value, "Insecure: can't set constant", CVAR_FREEZE_ERROR);
        if (value instanceof RubyModule && (module = (RubyModule)value).getBaseName() == null) {
            module.setBaseName(name);
            module.setParent(this);
        }
        return result;
    }

    public RubyClass getClass(String name) {
        IRubyObject module = this.getConstantAt(name);
        return module instanceof RubyClass ? (RubyClass)module : null;
    }

    public IRubyObject const_missing(IRubyObject name) {
        if (this != this.getRuntime().getObject()) {
            throw this.getRuntime().newNameError("uninitialized constant " + this.getName() + "::" + name.asSymbol(), "" + this.getName() + "::" + name.asSymbol());
        }
        throw this.getRuntime().newNameError("uninitialized constant " + name.asSymbol(), name.asSymbol());
    }

    public synchronized void includeModule(IRubyObject arg) {
        if (!$assertionsDisabled && arg == null) {
            throw new AssertionError();
        }
        this.testFrozen("module");
        if (!this.isTaint()) {
            this.getRuntime().secure(4);
        }
        if (!(arg instanceof RubyModule)) {
            throw this.getRuntime().newTypeError("Wrong argument type " + arg.getMetaClass().getName() + " (expected Module).");
        }
        RubyModule module = (RubyModule)arg;
        if (this.isSame(module)) {
            return;
        }
        this.infectBy(module);
        boolean changed = false;
        boolean skip = false;
        RubyModule c = this;
        while (module != null) {
            if (this.getNonIncludedClass() == module.getNonIncludedClass()) {
                throw this.getRuntime().newArgumentError("cyclic include detected");
            }
            boolean superclassSeen = false;
            for (RubyClass p = this.getSuperClass(); p != null; p = p.getSuperClass()) {
                if (p instanceof IncludedModuleWrapper) {
                    if (p.getNonIncludedClass() != module.getNonIncludedClass()) continue;
                    if (!superclassSeen) {
                        c = p;
                    }
                    skip = true;
                    break;
                }
                superclassSeen = true;
            }
            if (!skip) {
                c.setSuperClass(new IncludedModuleWrapper(this.getRuntime(), c.getSuperClass(), module.getNonIncludedClass()));
                c = c.getSuperClass();
                changed = true;
            }
            module = module.getSuperClass();
            skip = false;
        }
        if (changed) {
            ArrayList methodNames = new ArrayList(((RubyModule)arg).getMethods().keySet());
            Iterator iter = methodNames.iterator();
            while (iter.hasNext()) {
                String methodName = (String)iter.next();
                this.getRuntime().getCacheMap().remove(methodName, this.searchMethod(methodName));
            }
        }
    }

    public void defineMethod(String name, Callback method) {
        Visibility visibility = name.equals("initialize") ? Visibility.PRIVATE : Visibility.PUBLIC;
        this.addMethod(name, new CallbackMethod(this, method, visibility));
    }

    public void definePrivateMethod(String name, Callback method) {
        this.addMethod(name, new CallbackMethod(this, method, Visibility.PRIVATE));
    }

    public void undefineMethod(String name) {
        this.addMethod(name, UndefinedMethod.getInstance());
    }

    public void undef(String name) {
        ICallable method;
        IRuby runtime = this.getRuntime();
        if (this == runtime.getObject()) {
            runtime.secure(4);
        }
        if (runtime.getSafeLevel() >= 4 && !this.isTaint()) {
            throw new SecurityException("Insecure: can't undef");
        }
        this.testFrozen("module");
        if (name.equals("__id__") || name.equals("__send__")) {
            this.getRuntime().getWarnings().warn("undefining `" + name + "' may cause serious problem");
        }
        if ((method = this.searchMethod(name)).isUndefined()) {
            String s0 = " class";
            RubyModule c = this;
            if (c.isSingleton()) {
                IRubyObject obj = this.getInstanceVariable("__attached__");
                if (obj != null && obj instanceof RubyModule) {
                    c = (RubyModule)obj;
                    s0 = "";
                }
            } else if (c.isModule()) {
                s0 = " module";
            }
            throw this.getRuntime().newNameError("Undefined method " + name + " for" + s0 + " '" + c.getName() + "'", name);
        }
        this.addMethod(name, UndefinedMethod.getInstance());
    }

    private void addCachedMethod(String name, ICallable method) {
        if (!this.isIncluded()) {
            this.getMethods().put(name, method);
            this.getRuntime().getCacheMap().add(method, this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMethod(String name, ICallable method) {
        if (this == this.getRuntime().getObject()) {
            this.getRuntime().secure(4);
        }
        if (this.getRuntime().getSafeLevel() >= 4 && !this.isTaint()) {
            throw this.getRuntime().newSecurityError("Insecure: can't define method");
        }
        this.testFrozen(CVAR_FREEZE_ERROR);
        Map map = this.getMethods();
        synchronized (map) {
            ICallable existingMethod = (ICallable)this.getMethods().remove(name);
            if (existingMethod != null) {
                this.getRuntime().getCacheMap().remove(name, existingMethod);
            }
            this.getMethods().put(name, method);
        }
    }

    public void removeCachedMethod(String name) {
        this.getMethods().remove(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMethod(String name) {
        if (this == this.getRuntime().getObject()) {
            this.getRuntime().secure(4);
        }
        if (this.getRuntime().getSafeLevel() >= 4 && !this.isTaint()) {
            throw this.getRuntime().newSecurityError("Insecure: can't remove method");
        }
        this.testFrozen(CVAR_FREEZE_ERROR);
        Map map = this.getMethods();
        synchronized (map) {
            ICallable method = (ICallable)this.getMethods().remove(name);
            if (method == null) {
                throw this.getRuntime().newNameError("method '" + name + "' not defined in " + this.getName(), name);
            }
            this.getRuntime().getCacheMap().remove(name, method);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ICallable searchMethod(String name) {
        for (RubyModule searchModule = this; searchModule != null; searchModule = searchModule.getSuperClass()) {
            Map map = searchModule.getMethods();
            synchronized (map) {
                ICallable method = (ICallable)searchModule.getMethods().get(name);
                if (method != null) {
                    if (searchModule != this) {
                        this.addCachedMethod(name, method);
                    }
                    return method;
                }
                continue;
            }
        }
        return UndefinedMethod.getInstance();
    }

    public ICallable retrieveMethod(String name) {
        return (ICallable)this.getMethods().get(name);
    }

    public RubyModule findImplementer(RubyModule clazz) {
        for (RubyModule searchModule = this; searchModule != null; searchModule = searchModule.getSuperClass()) {
            if (!searchModule.isSame(clazz)) continue;
            return searchModule;
        }
        return null;
    }

    public void addModuleFunction(String name, ICallable method) {
        this.addMethod(name, method);
        this.addSingletonMethod(name, method);
    }

    public void defineModuleFunction(String name, Callback method) {
        this.definePrivateMethod(name, method);
        this.defineSingletonMethod(name, method);
    }

    public void definePublicModuleFunction(String name, Callback method) {
        this.defineMethod(name, method);
        this.defineSingletonMethod(name, method);
    }

    private IRubyObject getConstantInner(String name, boolean exclude) {
        RubyClass objectClass = this.getRuntime().getObject();
        boolean retryForModule = false;
        RubyModule p = this;
        while (true) {
            if (p != null) {
                IRubyObject constant = p.getConstantAt(name);
                if (constant == null && this.getRuntime().getLoadService().autoload(p.getName() + "::" + name) != null) continue;
                if (constant != null) {
                    if (exclude && p == objectClass && this != objectClass) {
                        this.getRuntime().getWarnings().warn("toplevel constant " + name + " referenced by " + this.getName() + "::" + name);
                    }
                    return constant;
                }
                p = p.getSuperClass();
                continue;
            }
            if (exclude || retryForModule || !this.getClass().equals(class$org$jruby$RubyModule == null ? RubyModule.class$("org.jruby.RubyModule") : class$org$jruby$RubyModule)) break;
            retryForModule = true;
            p = this.getRuntime().getObject();
        }
        return this.callMethod(this.getRuntime().getCurrentContext(), "const_missing", RubySymbol.newSymbol(this.getRuntime(), name));
    }

    public IRubyObject getConstant(String name) {
        return this.getConstantInner(name, false);
    }

    public IRubyObject getConstantFrom(String name) {
        return this.getConstantInner(name, true);
    }

    public IRubyObject getConstantAt(String name) {
        return this.getInstanceVariable(name);
    }

    public synchronized void defineAlias(String name, String oldName) {
        ICallable method;
        this.testFrozen("module");
        if (oldName.equals(name)) {
            return;
        }
        if (this == this.getRuntime().getObject()) {
            this.getRuntime().secure(4);
        }
        if ((method = this.searchMethod(oldName)).isUndefined()) {
            if (this.isModule()) {
                method = this.getRuntime().getObject().searchMethod(oldName);
            }
            if (method.isUndefined()) {
                throw this.getRuntime().newNameError("undefined method `" + oldName + "' for " + (this.isModule() ? "module" : "class") + " `" + this.getName() + "'", oldName);
            }
        }
        this.getRuntime().getCacheMap().remove(name, this.searchMethod(name));
        this.getMethods().put(name, new AliasMethod(method, oldName));
    }

    public RubyClass defineOrGetClassUnder(String name, RubyClass superClazz) {
        IRubyObject type = this.getConstantAt(name);
        if (type == null) {
            return (RubyClass)this.setConstant(name, this.getRuntime().defineClassUnder(name, superClazz, this.cref));
        }
        if (!(type instanceof RubyClass)) {
            throw this.getRuntime().newTypeError(name + " is not a class.");
        }
        if (superClazz != null && ((RubyClass)type).getSuperClass().getRealClass() != superClazz) {
            throw this.getRuntime().newTypeError("superclass mismatch for class " + name);
        }
        return (RubyClass)type;
    }

    public RubyClass defineClassUnder(String name, RubyClass superClazz) {
        IRubyObject type = this.getConstantAt(name);
        if (type == null) {
            return (RubyClass)this.setConstant(name, this.getRuntime().defineClassUnder(name, superClazz, this.cref));
        }
        if (!(type instanceof RubyClass)) {
            throw this.getRuntime().newTypeError(name + " is not a class.");
        }
        if (((RubyClass)type).getSuperClass().getRealClass() != superClazz) {
            throw this.getRuntime().newNameError(name + " is already defined.", name);
        }
        return (RubyClass)type;
    }

    public RubyModule defineModuleUnder(String name) {
        IRubyObject type = this.getConstantAt(name);
        if (type == null) {
            return (RubyModule)this.setConstant(name, this.getRuntime().defineModuleUnder(name, this.cref));
        }
        if (!(type instanceof RubyModule)) {
            throw this.getRuntime().newTypeError(name + " is not a module.");
        }
        return (RubyModule)type;
    }

    public void defineConstant(String name, IRubyObject value) {
        if (!$assertionsDisabled && value == null) {
            throw new AssertionError();
        }
        if (this == this.getRuntime().getClass("Class")) {
            this.getRuntime().secure(4);
        }
        if (!IdUtil.isConstant(name)) {
            throw this.getRuntime().newNameError("bad constant name " + name, name);
        }
        this.setConstant(name, value);
    }

    public IRubyObject removeCvar(IRubyObject name) {
        if (!IdUtil.isClassVariable(name.asSymbol())) {
            throw this.getRuntime().newNameError("wrong class variable name " + name.asSymbol(), name.asSymbol());
        }
        if (!this.isTaint() && this.getRuntime().getSafeLevel() >= 4) {
            throw this.getRuntime().newSecurityError("Insecure: can't remove class variable");
        }
        this.testFrozen(CVAR_FREEZE_ERROR);
        IRubyObject value = this.removeInstanceVariable(name.asSymbol());
        if (value != null) {
            return value;
        }
        if (this.isClassVarDefined(name.asSymbol())) {
            throw this.cannotRemoveError(name.asSymbol());
        }
        throw this.getRuntime().newNameError("class variable " + name.asSymbol() + " not defined for " + this.getName(), name.asSymbol());
    }

    private void addAccessor(String name, boolean readable, boolean writeable) {
        ThreadContext tc = this.getRuntime().getCurrentContext();
        Visibility attributeScope = tc.getCurrentVisibility();
        if (!attributeScope.isPrivate() && attributeScope.isModuleFunction()) {
            attributeScope = Visibility.PRIVATE;
        }
        final String variableName = "@" + name;
        final IRuby runtime = this.getRuntime();
        ThreadContext context = this.getRuntime().getCurrentContext();
        if (readable) {
            this.defineMethod(name, new Callback(){

                public IRubyObject execute(IRubyObject self, IRubyObject[] args) {
                    RubyModule.this.checkArgumentCount(args, 0, 0);
                    IRubyObject variable = self.getInstanceVariable(variableName);
                    return variable == null ? runtime.getNil() : variable;
                }

                public Arity getArity() {
                    return Arity.noArguments();
                }
            });
            this.callMethod(context, "method_added", RubySymbol.newSymbol(this.getRuntime(), name));
        }
        if (writeable) {
            name = name + "=";
            this.defineMethod(name, new Callback(){

                public IRubyObject execute(IRubyObject self, IRubyObject[] args) {
                    IRubyObject[] fargs = runtime.getCurrentContext().getFrameArgs();
                    if (fargs.length != 1) {
                        throw runtime.newArgumentError("wrong # of arguments(" + fargs.length + "for 1)");
                    }
                    return self.setInstanceVariable(variableName, fargs[0]);
                }

                public Arity getArity() {
                    return Arity.singleArgument();
                }
            });
            this.callMethod(context, "method_added", RubySymbol.newSymbol(this.getRuntime(), name));
        }
    }

    public void setMethodVisibility(IRubyObject[] methods, Visibility visibility) {
        if (this.getRuntime().getSafeLevel() >= 4 && !this.isTaint()) {
            throw this.getRuntime().newSecurityError("Insecure: can't change method visibility");
        }
        for (int i = 0; i < methods.length; ++i) {
            this.exportMethod(methods[i].asSymbol(), visibility);
        }
    }

    public void exportMethod(String name, Visibility visibility) {
        ICallable method;
        if (this == this.getRuntime().getObject()) {
            this.getRuntime().secure(4);
        }
        if ((method = this.searchMethod(name)).isUndefined()) {
            throw this.getRuntime().newNameError("undefined method '" + name + "' for " + (this.isModule() ? "module" : "class") + " '" + this.getName() + "'", name);
        }
        if (method.getVisibility() != visibility) {
            if (this == method.getImplementationClass()) {
                method.setVisibility(visibility);
            } else {
                final ThreadContext context = this.getRuntime().getCurrentContext();
                this.addMethod(name, new CallbackMethod(this, new Callback(){

                    public IRubyObject execute(IRubyObject self, IRubyObject[] args) {
                        return context.callSuper(context.getFrameArgs());
                    }

                    public Arity getArity() {
                        return Arity.optional();
                    }
                }, visibility));
            }
        }
    }

    public boolean isMethodBound(String name, boolean checkVisibility) {
        ICallable method = this.searchMethod(name);
        if (!method.isUndefined()) {
            return !checkVisibility || !method.getVisibility().isPrivate();
        }
        return false;
    }

    public IRubyObject newMethod(IRubyObject receiver, String name, boolean bound) {
        ICallable method = this.searchMethod(name);
        if (method.isUndefined()) {
            throw this.getRuntime().newNameError("undefined method `" + name + "' for class `" + this.getName() + "'", name);
        }
        RubyMethod newMethod = null;
        newMethod = bound ? RubyMethod.newMethod(method.getImplementationClass(), name, this, name, method, receiver) : RubyUnboundMethod.newUnboundMethod(method.getImplementationClass(), name, this, name, method);
        newMethod.infectBy(this);
        return newMethod;
    }

    public IRubyObject define_method(IRubyObject[] args) {
        RubyObject body;
        if (args.length < 1 || args.length > 2) {
            throw this.getRuntime().newArgumentError("wrong # of arguments(" + args.length + " for 1)");
        }
        String name = args[0].asSymbol();
        AbstractMethod newMethod = null;
        ThreadContext tc = this.getRuntime().getCurrentContext();
        Visibility visibility = tc.getCurrentVisibility();
        if (visibility.isModuleFunction()) {
            visibility = Visibility.PRIVATE;
        }
        if (args.length == 1 || args[1].isKindOf(this.getRuntime().getClass("Proc"))) {
            RubyProc proc;
            body = proc = args.length == 1 ? this.getRuntime().newProc() : (RubyProc)args[1];
            proc.getBlock().isLambda = true;
            proc.getBlock().getFrame().setLastClass(this);
            proc.getBlock().getFrame().setLastFunc(name);
            newMethod = new ProcMethod(this, proc, visibility);
        } else if (args[1].isKindOf(this.getRuntime().getClass("Method"))) {
            RubyMethod method = (RubyMethod)args[1];
            body = method;
            newMethod = new MethodMethod(this, method.unbind(), visibility);
        } else {
            throw this.getRuntime().newTypeError("wrong argument type " + args[0].getType().getName() + " (expected Proc/Method)");
        }
        this.addMethod(name, newMethod);
        RubySymbol symbol = RubySymbol.newSymbol(this.getRuntime(), name);
        ThreadContext context = this.getRuntime().getCurrentContext();
        if (tc.getPreviousVisibility().isModuleFunction()) {
            this.getSingletonClass().addMethod(name, new WrapperCallable(this.getSingletonClass(), newMethod, Visibility.PUBLIC));
            this.callMethod(context, "singleton_method_added", symbol);
        }
        this.callMethod(context, "method_added", symbol);
        return body;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRubyObject executeUnder(Callback method, IRubyObject[] args) {
        ThreadContext context = this.getRuntime().getCurrentContext();
        context.preExecuteUnder(this);
        try {
            IRubyObject iRubyObject = method.execute(this, args);
            return iRubyObject;
        }
        finally {
            context.postExecuteUnder();
        }
    }

    public static RubyModule newModule(IRuby runtime, String name) {
        return RubyModule.newModule(runtime, name, null);
    }

    public static RubyModule newModule(IRuby runtime, String name, SinglyLinkedList parentCRef) {
        RubyModule newModule = new RubyModule(runtime, runtime.getClass("Module"), null, parentCRef, name);
        ThreadContext tc = runtime.getCurrentContext();
        if (tc.isBlockGiven()) {
            tc.yieldCurrentBlock(null, newModule, newModule, false);
        }
        return newModule;
    }

    public RubyString name() {
        return this.getRuntime().newString(this.getBaseName() == null ? "" : this.getName());
    }

    public RubyArray class_variables() {
        RubyArray ary = this.getRuntime().newArray();
        for (RubyModule p = this; p != null; p = p.getSuperClass()) {
            Iterator iter = p.instanceVariableNames();
            while (iter.hasNext()) {
                RubyString kval;
                String id = (String)iter.next();
                if (!IdUtil.isClassVariable(id) || ary.includes(kval = this.getRuntime().newString(id))) continue;
                ary.append(kval);
            }
        }
        return ary;
    }

    public IRubyObject rbClone() {
        return this.cloneMethods((RubyModule)super.rbClone());
    }

    protected IRubyObject cloneMethods(RubyModule clone) {
        RubyModule realType = this.getNonIncludedClass();
        Iterator iter = this.getMethods().entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            ICallable method = (ICallable)entry.getValue();
            if (method.getImplementationClass() != realType) continue;
            ICallable clonedMethod = method.dup();
            clonedMethod.setImplementationClass(clone);
            clone.getMethods().put(entry.getKey(), clonedMethod);
        }
        return clone;
    }

    protected IRubyObject doClone() {
        return RubyModule.newModule(this.getRuntime(), this.getBaseName(), this.cref.getNext());
    }

    public IRubyObject dup() {
        RubyModule dup = (RubyModule)this.rbClone();
        dup.setMetaClass(this.getMetaClass());
        dup.setFrozen(false);
        return dup;
    }

    public RubyArray included_modules() {
        RubyArray ary = this.getRuntime().newArray();
        for (RubyClass p = this.getSuperClass(); p != null; p = p.getSuperClass()) {
            if (!p.isIncluded()) continue;
            ary.append(p.getNonIncludedClass());
        }
        return ary;
    }

    public RubyArray ancestors() {
        RubyArray ary = this.getRuntime().newArray(this.getAncestorList());
        return ary;
    }

    public List getAncestorList() {
        ArrayList<RubyModule> list = new ArrayList<RubyModule>();
        for (RubyModule p = this; p != null; p = p.getSuperClass()) {
            if (p.isSingleton()) continue;
            list.add(p.getNonIncludedClass());
        }
        return list;
    }

    public boolean hasModuleInHierarchy(RubyModule type) {
        for (RubyModule p = this; p != null; p = p.getSuperClass()) {
            if (p.getNonIncludedClass() != type) continue;
            return true;
        }
        return false;
    }

    public IRubyObject to_s() {
        return this.getRuntime().newString(this.getName());
    }

    public RubyBoolean op_eqq(IRubyObject obj) {
        return this.getRuntime().newBoolean(obj.isKindOf(this));
    }

    public IRubyObject op_le(IRubyObject obj) {
        if (!(obj instanceof RubyModule)) {
            throw this.getRuntime().newTypeError("compared with non class/module");
        }
        if (this.isKindOfModule((RubyModule)obj)) {
            return this.getRuntime().getTrue();
        }
        if (((RubyModule)obj).isKindOfModule(this)) {
            return this.getRuntime().getFalse();
        }
        return this.getRuntime().getNil();
    }

    public IRubyObject op_lt(IRubyObject obj) {
        return obj == this ? this.getRuntime().getFalse() : this.op_le(obj);
    }

    public IRubyObject op_ge(IRubyObject obj) {
        if (!(obj instanceof RubyModule)) {
            throw this.getRuntime().newTypeError("compared with non class/module");
        }
        return ((RubyModule)obj).op_le(this);
    }

    public IRubyObject op_gt(IRubyObject obj) {
        return this == obj ? this.getRuntime().getFalse() : this.op_ge(obj);
    }

    public IRubyObject op_cmp(IRubyObject obj) {
        if (this == obj) {
            return this.getRuntime().newFixnum(0L);
        }
        if (!(obj instanceof RubyModule)) {
            throw this.getRuntime().newTypeError("<=> requires Class or Module (" + this.getMetaClass().getName() + " given)");
        }
        RubyModule module = (RubyModule)obj;
        if (module.isKindOfModule(this)) {
            return this.getRuntime().newFixnum(1L);
        }
        if (this.isKindOfModule(module)) {
            return this.getRuntime().newFixnum(-1L);
        }
        return this.getRuntime().getNil();
    }

    public boolean isKindOfModule(RubyModule type) {
        for (RubyModule p = this; p != null; p = p.getSuperClass()) {
            if (!p.isSame(type)) continue;
            return true;
        }
        return false;
    }

    public boolean isSame(RubyModule module) {
        return this == module;
    }

    public IRubyObject initialize(IRubyObject[] args) {
        return this.getRuntime().getNil();
    }

    public IRubyObject attr(IRubyObject[] args) {
        this.checkArgumentCount(args, 1, 2);
        boolean writeable = args.length > 1 ? args[1].isTrue() : false;
        this.addAccessor(args[0].asSymbol(), true, writeable);
        return this.getRuntime().getNil();
    }

    public IRubyObject attr_reader(IRubyObject[] args) {
        for (int i = 0; i < args.length; ++i) {
            this.addAccessor(args[i].asSymbol(), true, false);
        }
        return this.getRuntime().getNil();
    }

    public IRubyObject attr_writer(IRubyObject[] args) {
        for (int i = 0; i < args.length; ++i) {
            this.addAccessor(args[i].asSymbol(), false, true);
        }
        return this.getRuntime().getNil();
    }

    public IRubyObject attr_accessor(IRubyObject[] args) {
        for (int i = 0; i < args.length; ++i) {
            this.addAccessor(args[i].asSymbol(), true, true);
        }
        return this.getRuntime().getNil();
    }

    public IRubyObject const_get(IRubyObject symbol) {
        String name = symbol.asSymbol();
        if (!IdUtil.isConstant(name)) {
            throw this.wrongConstantNameError(name);
        }
        return this.getConstant(name);
    }

    public IRubyObject const_set(IRubyObject symbol, IRubyObject value) {
        String name = symbol.asSymbol();
        if (!IdUtil.isConstant(name)) {
            throw this.wrongConstantNameError(name);
        }
        return this.setConstant(name, value);
    }

    public RubyBoolean const_defined(IRubyObject symbol) {
        String name = symbol.asSymbol();
        if (!IdUtil.isConstant(name)) {
            throw this.wrongConstantNameError(name);
        }
        return this.getRuntime().newBoolean(this.getConstantAt(name) != null);
    }

    private RaiseException wrongConstantNameError(String name) {
        return this.getRuntime().newNameError("wrong constant name " + name, name);
    }

    private RubyArray instance_methods(IRubyObject[] args, Visibility visibility) {
        boolean includeSuper = args.length > 0 ? args[0].isTrue() : true;
        RubyArray ary = this.getRuntime().newArray();
        HashMap<String, Boolean> undefinedMethods = new HashMap<String, Boolean>();
        for (RubyModule type = this; type != null; type = type.getSuperClass()) {
            RubyModule realType = type.getNonIncludedClass();
            Iterator iter = type.getMethods().entrySet().iterator();
            while (iter.hasNext()) {
                RubyString name;
                Map.Entry entry = iter.next();
                ICallable method = (ICallable)entry.getValue();
                String methodName = (String)entry.getKey();
                if (method.isUndefined()) {
                    undefinedMethods.put(methodName, Boolean.TRUE);
                    continue;
                }
                if (method.getImplementationClass() != realType || !method.getVisibility().is(visibility) || undefinedMethods.get(methodName) != null || ary.includes(name = this.getRuntime().newString(methodName))) continue;
                ary.append(name);
            }
            if (!includeSuper) break;
        }
        return ary;
    }

    public RubyArray instance_methods(IRubyObject[] args) {
        return this.instance_methods(args, Visibility.PUBLIC_PROTECTED);
    }

    public RubyArray public_instance_methods(IRubyObject[] args) {
        return this.instance_methods(args, Visibility.PUBLIC);
    }

    public IRubyObject instance_method(IRubyObject symbol) {
        return this.newMethod(null, symbol.asSymbol(), false);
    }

    public RubyArray protected_instance_methods(IRubyObject[] args) {
        return this.instance_methods(args, Visibility.PROTECTED);
    }

    public RubyArray private_instance_methods(IRubyObject[] args) {
        return this.instance_methods(args, Visibility.PRIVATE);
    }

    public RubyArray constants() {
        ArrayList<RubyString> constantNames = new ArrayList<RubyString>();
        RubyClass objectClass = this.getRuntime().getObject();
        if (this.getRuntime().getClass("Module") == this) {
            Iterator vars = objectClass.instanceVariableNames();
            while (vars.hasNext()) {
                String name = (String)vars.next();
                if (!IdUtil.isConstant(name)) continue;
                constantNames.add(this.getRuntime().newString(name));
            }
            return this.getRuntime().newArray(constantNames);
        }
        if (this.getRuntime().getObject() == this) {
            Iterator vars = this.instanceVariableNames();
            while (vars.hasNext()) {
                String name = (String)vars.next();
                if (!IdUtil.isConstant(name)) continue;
                constantNames.add(this.getRuntime().newString(name));
            }
            return this.getRuntime().newArray(constantNames);
        }
        for (RubyModule p = this; p != null; p = p.getSuperClass()) {
            if (objectClass == p) continue;
            Iterator vars = p.instanceVariableNames();
            while (vars.hasNext()) {
                String name = (String)vars.next();
                if (!IdUtil.isConstant(name)) continue;
                constantNames.add(this.getRuntime().newString(name));
            }
        }
        return this.getRuntime().newArray(constantNames);
    }

    public IRubyObject remove_class_variable(IRubyObject name) {
        String id = name.asSymbol();
        if (!IdUtil.isClassVariable(id)) {
            throw this.getRuntime().newNameError("wrong class variable name " + id, id);
        }
        if (!this.isTaint() && this.getRuntime().getSafeLevel() >= 4) {
            throw this.getRuntime().newSecurityError("Insecure: can't remove class variable");
        }
        this.testFrozen(CVAR_FREEZE_ERROR);
        IRubyObject variable = this.removeInstanceVariable(id);
        if (variable != null) {
            return variable;
        }
        if (this.isClassVarDefined(id)) {
            throw this.cannotRemoveError(id);
        }
        throw this.getRuntime().newNameError("class variable " + id + " not defined for " + this.getName(), id);
    }

    private RaiseException cannotRemoveError(String id) {
        return this.getRuntime().newNameError("cannot remove " + id + " for " + this.getName(), id);
    }

    public IRubyObject remove_const(IRubyObject name) {
        String id = name.asSymbol();
        if (!IdUtil.isConstant(id)) {
            throw this.wrongConstantNameError(id);
        }
        if (!this.isTaint() && this.getRuntime().getSafeLevel() >= 4) {
            throw this.getRuntime().newSecurityError("Insecure: can't remove class variable");
        }
        this.testFrozen(CVAR_FREEZE_ERROR);
        IRubyObject variable = this.getInstanceVariable(id);
        if (variable != null) {
            return this.removeInstanceVariable(id);
        }
        if (this.isClassVarDefined(id)) {
            throw this.cannotRemoveError(id);
        }
        throw this.getRuntime().newNameError("constant " + id + " not defined for " + this.getName(), id);
    }

    public RubyModule append_features(IRubyObject module) {
        ((RubyModule)module).includeModule(this);
        return this;
    }

    public IRubyObject extend_object(IRubyObject obj) {
        obj.extendObject(this);
        return obj;
    }

    public RubyModule include(IRubyObject[] modules) {
        ThreadContext context = this.getRuntime().getCurrentContext();
        for (int i = modules.length - 1; i >= 0; --i) {
            modules[i].callMethod(context, "append_features", this);
            modules[i].callMethod(context, "included", this);
        }
        return this;
    }

    public IRubyObject included(IRubyObject other) {
        return this.getRuntime().getNil();
    }

    public IRubyObject extended(IRubyObject other) {
        return this.getRuntime().getNil();
    }

    private void setVisibility(IRubyObject[] args, Visibility visibility) {
        if (this.getRuntime().getSafeLevel() >= 4 && !this.isTaint()) {
            throw this.getRuntime().newSecurityError("Insecure: can't change method visibility");
        }
        if (args.length == 0) {
            this.getRuntime().getCurrentContext().setCurrentVisibility(visibility);
        } else {
            this.setMethodVisibility(args, visibility);
        }
    }

    public RubyModule rbPublic(IRubyObject[] args) {
        this.setVisibility(args, Visibility.PUBLIC);
        return this;
    }

    public RubyModule rbProtected(IRubyObject[] args) {
        this.setVisibility(args, Visibility.PROTECTED);
        return this;
    }

    public RubyModule rbPrivate(IRubyObject[] args) {
        this.setVisibility(args, Visibility.PRIVATE);
        return this;
    }

    public RubyModule module_function(IRubyObject[] args) {
        if (this.getRuntime().getSafeLevel() >= 4 && !this.isTaint()) {
            throw this.getRuntime().newSecurityError("Insecure: can't change method visibility");
        }
        ThreadContext context = this.getRuntime().getCurrentContext();
        if (args.length == 0) {
            context.setCurrentVisibility(Visibility.MODULE_FUNCTION);
        } else {
            this.setMethodVisibility(args, Visibility.PRIVATE);
            for (int i = 0; i < args.length; ++i) {
                String name = args[i].asSymbol();
                ICallable method = this.searchMethod(name);
                if (!$assertionsDisabled && method.isUndefined()) {
                    throw new AssertionError((Object)("undefined method '" + name + "'"));
                }
                this.getSingletonClass().addMethod(name, new WrapperCallable(this.getSingletonClass(), method, Visibility.PUBLIC));
                this.callMethod(context, "singleton_method_added", RubySymbol.newSymbol(this.getRuntime(), name));
            }
        }
        return this;
    }

    public IRubyObject method_added(IRubyObject nothing) {
        return this.getRuntime().getNil();
    }

    public RubyBoolean method_defined(IRubyObject symbol) {
        return this.isMethodBound(symbol.asSymbol(), true) ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
    }

    public RubyModule public_class_method(IRubyObject[] args) {
        this.getMetaClass().setMethodVisibility(args, Visibility.PUBLIC);
        return this;
    }

    public RubyModule private_class_method(IRubyObject[] args) {
        this.getMetaClass().setMethodVisibility(args, Visibility.PRIVATE);
        return this;
    }

    public RubyModule alias_method(IRubyObject newId, IRubyObject oldId) {
        this.defineAlias(newId.asSymbol(), oldId.asSymbol());
        return this;
    }

    public RubyModule undef_method(IRubyObject name) {
        this.undef(name.asSymbol());
        return this;
    }

    public IRubyObject module_eval(IRubyObject[] args) {
        return this.specificEval(this, args);
    }

    public RubyModule remove_method(IRubyObject name) {
        this.removeMethod(name.asSymbol());
        return this;
    }

    public void marshalTo(MarshalStream output) throws IOException {
        output.write(109);
        output.dumpString(this.name().toString());
    }

    public static RubyModule unmarshalFrom(UnmarshalStream input) throws IOException {
        String name = input.unmarshalString();
        IRuby runtime = input.getRuntime();
        RubyModule result = runtime.getClassFromPath(name);
        if (result == null) {
            throw runtime.newNameError("uninitialized constant " + name, name);
        }
        input.registerLinkTarget(result);
        return result;
    }

    public SinglyLinkedList getCRef() {
        return this.cref;
    }

    public IRubyObject inspect() {
        return this.callMethod(this.getRuntime().getCurrentContext(), "to_s");
    }

    static {
        $assertionsDisabled = !RubyModule.class.desiredAssertionStatus();
    }
}

