/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.math.BigInteger;
import org.jruby.IRuby;
import org.jruby.RubyArray;
import org.jruby.RubyBignum;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyComparable;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyInteger;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.exceptions.RaiseException;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class RubyNumeric
extends RubyObject {
    public RubyNumeric(IRuby runtime, RubyClass metaClass) {
        super(runtime, metaClass);
    }

    public double getDoubleValue() {
        return 0.0;
    }

    public long getLongValue() {
        return 0L;
    }

    public RubyNumeric multiplyWith(RubyInteger value) {
        return value;
    }

    public RubyNumeric multiplyWith(RubyFloat value) {
        return value;
    }

    public RubyNumeric multiplyWith(RubyBignum value) {
        return value;
    }

    public long getTruncatedLongValue() {
        return this.getLongValue();
    }

    public static RubyNumeric newNumeric(IRuby runtime) {
        return new RubyNumeric(runtime, runtime.getClass("Numeric"));
    }

    public static long num2long(IRubyObject arg) {
        if (arg instanceof RubyNumeric) {
            return ((RubyNumeric)arg).getLongValue();
        }
        throw arg.getRuntime().newTypeError("argument is not numeric");
    }

    public static long fix2long(IRubyObject arg) {
        if (arg instanceof RubyFixnum) {
            return ((RubyFixnum)arg).getLongValue();
        }
        throw arg.getRuntime().newTypeError("argument is not a Fixnum");
    }

    public static int fix2int(IRubyObject arg) {
        long val = RubyNumeric.fix2long(arg);
        if (val > Integer.MAX_VALUE || val < Integer.MIN_VALUE) {
            throw arg.getRuntime().newTypeError("argument value is too big to convert to int");
        }
        return (int)val;
    }

    public static RubyInteger str2inum(IRuby runtime, RubyString str, int base) {
        return RubyNumeric.str2inum(runtime, str, base, false);
    }

    public static RubyNumeric int2fix(IRuby runtime, long val) {
        return RubyFixnum.newFixnum(runtime, val);
    }

    public static RubyInteger str2inum(IRuby runtime, RubyString str, int base, boolean raise) {
        StringBuffer sbuf = new StringBuffer(str.toString().trim());
        if (sbuf.length() == 0) {
            if (raise) {
                throw runtime.newArgumentError("invalid value for Integer: " + str.callMethod(runtime.getCurrentContext(), "inspect").toString());
            }
            return RubyFixnum.zero(runtime);
        }
        int pos = 0;
        int radix = base != 0 ? base : 10;
        boolean digitsFound = false;
        if (sbuf.charAt(pos) == '-') {
            ++pos;
        } else if (sbuf.charAt(pos) == '+') {
            sbuf.deleteCharAt(pos);
        }
        if (pos == sbuf.length()) {
            if (raise) {
                throw runtime.newArgumentError("invalid value for Integer: " + str.callMethod(runtime.getCurrentContext(), "inspect").toString());
            }
            return RubyFixnum.zero(runtime);
        }
        if (sbuf.charAt(pos) == '0') {
            sbuf.deleteCharAt(pos);
            if (pos == sbuf.length()) {
                return RubyFixnum.zero(runtime);
            }
            if (sbuf.charAt(pos) == 'x' || sbuf.charAt(pos) == 'X') {
                if (base == 0 || base == 16) {
                    radix = 16;
                    sbuf.deleteCharAt(pos);
                }
            } else if (sbuf.charAt(pos) == 'b' || sbuf.charAt(pos) == 'B') {
                if (base == 0 || base == 2) {
                    radix = 2;
                    sbuf.deleteCharAt(pos);
                }
            } else {
                int n = radix = base == 0 ? 8 : base;
            }
        }
        while (pos < sbuf.length()) {
            if (sbuf.charAt(pos) == '_') {
                sbuf.deleteCharAt(pos);
                continue;
            }
            if (Character.digit(sbuf.charAt(pos), radix) == -1) break;
            digitsFound = true;
            ++pos;
        }
        if (!digitsFound) {
            if (raise) {
                throw runtime.newArgumentError("invalid value for Integer: " + str.callMethod(runtime.getCurrentContext(), "inspect").toString());
            }
            return RubyFixnum.zero(runtime);
        }
        try {
            long l = Long.parseLong(sbuf.substring(0, pos), radix);
            return runtime.newFixnum(l);
        }
        catch (NumberFormatException ex) {
            try {
                BigInteger bi = new BigInteger(sbuf.substring(0, pos), radix);
                return new RubyBignum(runtime, bi);
            }
            catch (NumberFormatException e) {
                if (raise) {
                    throw runtime.newArgumentError("invalid value for Integer: " + str.callMethod(runtime.getCurrentContext(), "inspect").toString());
                }
                return RubyFixnum.zero(runtime);
            }
        }
    }

    public static RubyFloat str2fnum(IRuby runtime, RubyString arg) {
        return RubyNumeric.str2fnum(runtime, arg, false);
    }

    public static RubyFloat str2fnum(IRuby runtime, RubyString arg, boolean raise) {
        String str = arg.toString().trim();
        double d = 0.0;
        int pos = str.length();
        for (int i = 0; i < pos; ++i) {
            if ("0123456789eE+-.".indexOf(str.charAt(i)) != -1) continue;
            if (raise) {
                throw runtime.newArgumentError("invalid value for Float(): " + arg.callMethod(runtime.getCurrentContext(), "inspect").toString());
            }
            pos = i + 1;
            break;
        }
        while (pos > 0) {
            try {
                d = Double.parseDouble(str.substring(0, pos));
                break;
            }
            catch (NumberFormatException ex) {
                if (raise) {
                    throw runtime.newArgumentError("invalid value for Float(): " + arg.callMethod(runtime.getCurrentContext(), "inspect").toString());
                }
                --pos;
            }
        }
        return new RubyFloat(runtime, d);
    }

    protected IRubyObject[] getCoerced(IRubyObject other, boolean error) {
        IRubyObject result;
        try {
            result = other.callMethod(this.getRuntime().getCurrentContext(), "coerce", this);
        }
        catch (RaiseException e) {
            if (error) {
                throw this.getRuntime().newTypeError(other.getMetaClass().getName() + " can't be coerced into " + this.getMetaClass().getName());
            }
            return null;
        }
        if (!(result instanceof RubyArray) || ((RubyArray)result).getLength() != 2) {
            throw this.getRuntime().newTypeError("coerce must return [x, y]");
        }
        return ((RubyArray)result).toJavaArray();
    }

    protected IRubyObject callCoerced(String method, IRubyObject other) {
        IRubyObject[] args = this.getCoerced(other, true);
        return args[0].callMethod(this.getRuntime().getCurrentContext(), method, args[1]);
    }

    public RubyNumeric asNumeric() {
        return this;
    }

    public IRubyObject coerce(IRubyObject other) {
        if (this.getMetaClass() == other.getMetaClass()) {
            return this.getRuntime().newArray(other, this);
        }
        return this.getRuntime().newArray(other.convertToFloat(), this.convertToFloat());
    }

    public IRubyObject to_int() {
        return this.callMethod(this.getRuntime().getCurrentContext(), "to_i", IRubyObject.NULL_ARRAY);
    }

    public IRubyObject rbClone() {
        return this;
    }

    public IRubyObject op_ge(IRubyObject other) {
        if (other instanceof RubyNumeric) {
            return this.getRuntime().newBoolean(this.compareValue((RubyNumeric)other) >= 0);
        }
        return RubyComparable.op_ge(this, other);
    }

    public IRubyObject op_gt(IRubyObject other) {
        if (other instanceof RubyNumeric) {
            return this.getRuntime().newBoolean(this.compareValue((RubyNumeric)other) > 0);
        }
        return RubyComparable.op_gt(this, other);
    }

    public IRubyObject op_le(IRubyObject other) {
        if (other instanceof RubyNumeric) {
            return this.getRuntime().newBoolean(this.compareValue((RubyNumeric)other) <= 0);
        }
        return RubyComparable.op_le(this, other);
    }

    public IRubyObject op_lt(IRubyObject other) {
        if (other instanceof RubyNumeric) {
            return this.getRuntime().newBoolean(this.compareValue((RubyNumeric)other) < 0);
        }
        return RubyComparable.op_lt(this, other);
    }

    public IRubyObject op_uplus() {
        return this;
    }

    public IRubyObject op_uminus() {
        RubyArray coerce = (RubyArray)this.coerce(RubyFixnum.zero(this.getRuntime()));
        return (RubyNumeric)coerce.entry(0L).callMethod(this.getRuntime().getCurrentContext(), "-", coerce.entry(1L));
    }

    public IRubyObject cmp(IRubyObject other) {
        if (other instanceof RubyNumeric) {
            return this.getRuntime().newFixnum(this.compareValue((RubyNumeric)other));
        }
        return other.respondsTo("to_int") ? this.callCoerced("<=>", other) : this.getRuntime().getNil();
    }

    public IRubyObject divmod(IRubyObject other) {
        if (other instanceof RubyNumeric) {
            RubyNumeric denominator = (RubyNumeric)other;
            RubyNumeric div = (RubyNumeric)this.callMethod(this.getRuntime().getCurrentContext(), "/", denominator);
            if (div instanceof RubyFloat) {
                double d = Math.floor(((RubyFloat)div).getValue());
                if (((RubyFloat)div).getValue() > d) {
                    div = RubyFloat.newFloat(this.getRuntime(), d);
                }
            }
            return this.getRuntime().newArray(div, this.modulo(denominator));
        }
        return this.callCoerced("divmod", other);
    }

    public IRubyObject modulo(IRubyObject other) {
        if (other instanceof RubyNumeric) {
            return (RubyNumeric)this.callMethod(this.getRuntime().getCurrentContext(), "%", other);
        }
        return this.callCoerced("modulo", other);
    }

    public IRubyObject remainder(IRubyObject other) {
        if (other instanceof RubyNumeric) {
            IRubyObject mod = this.modulo(other);
            RubyFixnum zero = RubyFixnum.zero(this.getRuntime());
            ThreadContext context = this.getRuntime().getCurrentContext();
            if (this.callMethod(context, "<", zero).isTrue() && other.callMethod(context, ">", zero).isTrue() || this.callMethod(context, ">", zero).isTrue() && other.callMethod(context, "<", zero).isTrue()) {
                return (RubyNumeric)mod.callMethod(context, "-", other);
            }
            return mod;
        }
        return this.callCoerced("remainder", other);
    }

    protected int compareValue(RubyNumeric other) {
        return -1;
    }

    public RubyBoolean veryEqual(IRubyObject other) {
        IRubyObject truth = super.equal(other);
        return truth == this.getRuntime().getNil() ? this.getRuntime().getFalse() : (RubyBoolean)truth;
    }

    public IRubyObject equal(IRubyObject other) {
        if (other instanceof RubyNumeric) {
            return this.getRuntime().newBoolean(this.compareValue((RubyNumeric)other) == 0);
        }
        return super.equal(other);
    }

    public RubyBoolean eql(IRubyObject other) {
        if (this.getMetaClass() != other.getMetaClass()) {
            return this.getRuntime().getFalse();
        }
        return (RubyBoolean)this.equal(other);
    }

    public RubyNumeric abs() {
        ThreadContext context = this.getRuntime().getCurrentContext();
        if (this.callMethod(context, "<", RubyFixnum.zero(this.getRuntime())).isTrue()) {
            return (RubyNumeric)this.callMethod(context, "-@");
        }
        return this;
    }

    public RubyBoolean int_p() {
        return this.getRuntime().getFalse();
    }

    public RubyBoolean zero_p() {
        return (RubyBoolean)this.equal(RubyFixnum.zero(this.getRuntime()));
    }

    public IRubyObject nonzero_p() {
        if (this.callMethod(this.getRuntime().getCurrentContext(), "zero?").isTrue()) {
            return this.getRuntime().getNil();
        }
        return this;
    }

    public RubyInteger floor() {
        return RubyFloat.newFloat(this.getRuntime(), this.getDoubleValue()).floor();
    }

    public RubyInteger ceil() {
        return RubyFloat.newFloat(this.getRuntime(), this.getDoubleValue()).ceil();
    }

    public RubyInteger round() {
        return RubyFloat.newFloat(this.getRuntime(), this.getDoubleValue()).round();
    }

    public RubyInteger truncate() {
        return RubyFloat.newFloat(this.getRuntime(), this.getDoubleValue()).truncate();
    }

    public RubyNumeric multiplyWith(RubyFixnum value) {
        return this.multiplyWith((RubyInteger)value);
    }

    public RubyFloat convertToFloat() {
        return this.getRuntime().newFloat(this.getDoubleValue());
    }
}

