/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import org.jruby.IRuby;
import org.jruby.RubyClass;
import org.jruby.RubyFloat;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.RubyStruct;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.builtin.IRubyObject;

public class RubyProcess {
    public static RubyModule createProcessModule(IRuby runtime) {
        RubyModule process = runtime.defineModule("Process");
        RubyClass process_status = process.defineClassUnder("Status", runtime.getObject());
        CallbackFactory processCallbackFactory = runtime.callbackFactory(RubyProcess.class);
        CallbackFactory process_statusCallbackFactory = runtime.callbackFactory(RubyStatus.class);
        process.defineModuleFunction("times", processCallbackFactory.getSingletonMethod("times"));
        process_status.defineMethod("==", process_statusCallbackFactory.getMethod("op_eq", IRubyObject.class));
        process_status.defineMethod(">>", process_statusCallbackFactory.getMethod("rightshift_op", IRubyObject.class));
        process_status.defineMethod("to_i", process_statusCallbackFactory.getMethod("to_i"));
        process_status.defineMethod("to_s", process_statusCallbackFactory.getMethod("to_s"));
        process_status.defineMethod("inspect", process_statusCallbackFactory.getMethod("inspect"));
        process_status.defineMethod("exitstatus", process_statusCallbackFactory.getMethod("exitstatus"));
        process_status.defineMethod("success?", process_statusCallbackFactory.getMethod("success_p"));
        return process;
    }

    public static IRubyObject times(IRubyObject recv) {
        IRuby runtime = recv.getRuntime();
        double currentTime = (double)System.currentTimeMillis() / 1000.0;
        double startTime = (double)runtime.getStartTime() / 1000.0;
        RubyFloat zero = runtime.newFloat(0.0);
        return RubyStruct.newStruct(runtime.getTmsStruct(), new IRubyObject[]{runtime.newFloat(currentTime - startTime), zero, zero, zero});
    }

    public static IRubyObject pid(IRubyObject recv) {
        return recv.getRuntime().newFixnum(0L);
    }

    public static IRubyObject kill(IRubyObject recv, IRubyObject[] args) throws Exception {
        return recv.getRuntime().getNil();
    }

    public static class RubyStatus
    extends RubyObject {
        private long status = 0L;
        private static final long EXIT_SUCCESS = 0L;

        public RubyStatus(IRuby runtime, RubyClass metaClass, long status) {
            super(runtime, metaClass);
            this.status = status;
        }

        public static RubyStatus newProcessStatus(IRuby runtime, long status) {
            return new RubyStatus(runtime, runtime.getModule("Process").getClass("Status"), status);
        }

        public IRubyObject exitstatus() {
            return this.getRuntime().newFixnum(this.status);
        }

        public IRubyObject rightshift_op(IRubyObject other) {
            long shiftValue = other.convertToInteger().getLongValue();
            return this.getRuntime().newFixnum(this.status >> (int)shiftValue);
        }

        public IRubyObject op_eq(IRubyObject other) {
            return other.callMethod(this.getRuntime().getCurrentContext(), "==", this.to_i());
        }

        public IRubyObject to_i() {
            return this.exitstatus();
        }

        public IRubyObject to_s() {
            return this.getRuntime().newString(String.valueOf(this.status));
        }

        public IRubyObject inspect() {
            return this.to_s();
        }

        public IRubyObject success_p() {
            return this.getRuntime().newBoolean(this.status == 0L);
        }
    }
}

