/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.IOException;
import java.util.List;
import org.jruby.IRuby;
import org.jruby.MetaClass;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.exceptions.RaiseException;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.marshal.MarshalStream;
import org.jruby.runtime.marshal.UnmarshalStream;
import org.jruby.util.IdUtil;

public class RubyStruct
extends RubyObject {
    private IRubyObject[] values;
    static final /* synthetic */ boolean $assertionsDisabled;

    public RubyStruct(IRuby runtime, RubyClass rubyClass) {
        super(runtime, rubyClass);
    }

    public static RubyClass createStructClass(IRuby runtime) {
        RubyClass structClass = runtime.defineClass("Struct", runtime.getObject());
        CallbackFactory callbackFactory = runtime.callbackFactory(RubyStruct.class);
        structClass.includeModule(runtime.getModule("Enumerable"));
        structClass.defineSingletonMethod("new", callbackFactory.getOptSingletonMethod("newInstance"));
        structClass.defineMethod("initialize", callbackFactory.getOptMethod("initialize"));
        structClass.defineMethod("clone", callbackFactory.getMethod("rbClone"));
        structClass.defineMethod("==", callbackFactory.getMethod("equal", IRubyObject.class));
        structClass.defineMethod("to_s", callbackFactory.getMethod("to_s"));
        structClass.defineMethod("inspect", callbackFactory.getMethod("inspect"));
        structClass.defineMethod("to_a", callbackFactory.getMethod("to_a"));
        structClass.defineMethod("values", callbackFactory.getMethod("to_a"));
        structClass.defineMethod("size", callbackFactory.getMethod("size"));
        structClass.defineMethod("length", callbackFactory.getMethod("size"));
        structClass.defineMethod("each", callbackFactory.getMethod("each"));
        structClass.defineMethod("[]", callbackFactory.getMethod("aref", IRubyObject.class));
        structClass.defineMethod("[]=", callbackFactory.getMethod("aset", IRubyObject.class, IRubyObject.class));
        structClass.defineMethod("members", callbackFactory.getMethod("members"));
        return structClass;
    }

    private static IRubyObject getInstanceVariable(RubyClass type, String name) {
        RubyClass structClass = type.getRuntime().getClass("Struct");
        while (type != null && type != structClass) {
            IRubyObject variable = type.getInstanceVariable(name);
            if (variable != null) {
                return variable;
            }
            type = type.getSuperClass();
        }
        return type.getRuntime().getNil();
    }

    private RubyClass classOf() {
        return this.getMetaClass() instanceof MetaClass ? this.getMetaClass().getSuperClass() : this.getMetaClass();
    }

    private void modify() {
        this.testFrozen("Struct is frozen");
        if (!this.isTaint() && this.getRuntime().getSafeLevel() >= 4) {
            throw this.getRuntime().newSecurityError("Insecure: can't modify struct");
        }
    }

    private IRubyObject setByName(String name, IRubyObject value) {
        RubyArray member = (RubyArray)RubyStruct.getInstanceVariable(this.classOf(), "__member__");
        if (!$assertionsDisabled && member.isNil()) {
            throw new AssertionError((Object)"uninitialized struct");
        }
        this.modify();
        for (int i = 0; i < member.getLength(); ++i) {
            if (!member.entry(i).asSymbol().equals(name)) continue;
            this.values[i] = value;
            return this.values[i];
        }
        throw this.notStructMemberError(name);
    }

    private IRubyObject getByName(String name) {
        RubyArray member = (RubyArray)RubyStruct.getInstanceVariable(this.classOf(), "__member__");
        if (!$assertionsDisabled && member.isNil()) {
            throw new AssertionError((Object)"uninitialized struct");
        }
        for (int i = 0; i < member.getLength(); ++i) {
            if (!member.entry(i).asSymbol().equals(name)) continue;
            return this.values[i];
        }
        throw this.notStructMemberError(name);
    }

    public static RubyClass newInstance(IRubyObject recv, IRubyObject[] args) {
        int i;
        RubyClass newStruct;
        int i2;
        String name = null;
        if (args.length > 0 && args[0] instanceof RubyString) {
            name = args[0].toString();
        }
        RubyArray member = recv.getRuntime().newArray();
        int n = i2 = name == null ? 0 : 1;
        while (i2 < args.length) {
            member.append(RubySymbol.newSymbol(recv.getRuntime(), args[i2].asSymbol()));
            ++i2;
        }
        if (name == null) {
            newStruct = new RubyClass((RubyClass)recv);
        } else {
            if (!IdUtil.isConstant(name)) {
                throw recv.getRuntime().newNameError("identifier " + name + " needs to be constant", name);
            }
            newStruct = ((RubyClass)recv).defineClassUnder(name, (RubyClass)recv);
        }
        newStruct.setInstanceVariable("__size__", member.length());
        newStruct.setInstanceVariable("__member__", member);
        CallbackFactory callbackFactory = recv.getRuntime().callbackFactory(RubyStruct.class);
        newStruct.defineSingletonMethod("new", callbackFactory.getOptSingletonMethod("newStruct"));
        newStruct.defineSingletonMethod("[]", callbackFactory.getOptSingletonMethod("newStruct"));
        newStruct.defineSingletonMethod("members", callbackFactory.getSingletonMethod("members"));
        int n2 = i = name == null ? 0 : 1;
        while (i < args.length) {
            String memberName = args[i].asSymbol();
            newStruct.defineMethod(memberName, callbackFactory.getMethod("get"));
            newStruct.defineMethod(memberName + "=", callbackFactory.getMethod("set", class$org$jruby$runtime$builtin$IRubyObject == null ? RubyStruct.class$("org.jruby.runtime.builtin.IRubyObject") : class$org$jruby$runtime$builtin$IRubyObject));
            ++i;
        }
        ThreadContext context = recv.getRuntime().getCurrentContext();
        if (context.isBlockGiven()) {
            recv.getRuntime().getCurrentContext().yieldCurrentBlock(null, newStruct, newStruct, false);
        }
        return newStruct;
    }

    public static RubyStruct newStruct(IRubyObject recv, IRubyObject[] args) {
        RubyStruct struct = new RubyStruct(recv.getRuntime(), (RubyClass)recv);
        int size = RubyNumeric.fix2int(RubyStruct.getInstanceVariable((RubyClass)recv, "__size__"));
        struct.values = new IRubyObject[size];
        struct.callInit(args);
        return struct;
    }

    public IRubyObject initialize(IRubyObject[] args) {
        int i;
        this.modify();
        int size = RubyNumeric.fix2int(RubyStruct.getInstanceVariable(this.getMetaClass(), "__size__"));
        if (args.length > size) {
            throw this.getRuntime().newArgumentError("struct size differs (" + args.length + " for " + size + ")");
        }
        for (i = 0; i < args.length; ++i) {
            this.values[i] = args[i];
        }
        for (i = args.length; i < size; ++i) {
            this.values[i] = this.getRuntime().getNil();
        }
        return this.getRuntime().getNil();
    }

    public static RubyArray members(IRubyObject recv) {
        RubyArray member = (RubyArray)RubyStruct.getInstanceVariable((RubyClass)recv, "__member__");
        if (!$assertionsDisabled && member.isNil()) {
            throw new AssertionError((Object)"uninitialized struct");
        }
        RubyArray result = recv.getRuntime().newArray(member.getLength());
        for (int i = 0; i < member.getLength(); ++i) {
            result.append(recv.getRuntime().newString(member.entry(i).asSymbol()));
        }
        return result;
    }

    public RubyArray members() {
        return RubyStruct.members(this.classOf());
    }

    public IRubyObject set(IRubyObject value) {
        String name = this.getRuntime().getCurrentContext().getFrameLastFunc();
        if (name.endsWith("=")) {
            name = name.substring(0, name.length() - 1);
        }
        RubyArray member = (RubyArray)RubyStruct.getInstanceVariable(this.classOf(), "__member__");
        if (!$assertionsDisabled && member.isNil()) {
            throw new AssertionError((Object)"uninitialized struct");
        }
        this.modify();
        for (int i = 0; i < member.getLength(); ++i) {
            if (!member.entry(i).asSymbol().equals(name)) continue;
            this.values[i] = value;
            return this.values[i];
        }
        throw this.notStructMemberError(name);
    }

    private RaiseException notStructMemberError(String name) {
        return this.getRuntime().newNameError(name + " is not struct member", name);
    }

    public IRubyObject get() {
        String name = this.getRuntime().getCurrentContext().getFrameLastFunc();
        RubyArray member = (RubyArray)RubyStruct.getInstanceVariable(this.classOf(), "__member__");
        if (!$assertionsDisabled && member.isNil()) {
            throw new AssertionError((Object)"uninitialized struct");
        }
        for (int i = 0; i < member.getLength(); ++i) {
            if (!member.entry(i).asSymbol().equals(name)) continue;
            return this.values[i];
        }
        throw this.notStructMemberError(name);
    }

    public IRubyObject rbClone() {
        RubyStruct clone = new RubyStruct(this.getRuntime(), this.getMetaClass());
        clone.values = new IRubyObject[this.values.length];
        System.arraycopy(this.values, 0, clone.values, 0, this.values.length);
        clone.setFrozen(this.isFrozen());
        clone.setTaint(this.isTaint());
        return clone;
    }

    public IRubyObject equal(IRubyObject other) {
        if (this == other) {
            return this.getRuntime().getTrue();
        }
        if (!(other instanceof RubyStruct)) {
            return this.getRuntime().getFalse();
        }
        if (this.getMetaClass() != other.getMetaClass()) {
            return this.getRuntime().getFalse();
        }
        for (int i = 0; i < this.values.length; ++i) {
            if (this.values[i].equals(((RubyStruct)other).values[i])) continue;
            return this.getRuntime().getFalse();
        }
        return this.getRuntime().getTrue();
    }

    public IRubyObject to_s() {
        return this.inspect();
    }

    public IRubyObject inspect() {
        RubyArray member = (RubyArray)RubyStruct.getInstanceVariable(this.classOf(), "__member__");
        if (!$assertionsDisabled && member.isNil()) {
            throw new AssertionError((Object)"uninitialized struct");
        }
        StringBuffer sb = new StringBuffer(100);
        sb.append("#<struct ").append(this.getMetaClass().getName()).append(' ');
        for (int i = 0; i < member.getLength(); ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(member.entry(i).asSymbol()).append("=");
            sb.append(this.values[i].callMethod(this.getRuntime().getCurrentContext(), "inspect"));
        }
        sb.append('>');
        return this.getRuntime().newString(sb.toString());
    }

    public RubyArray to_a() {
        return this.getRuntime().newArray(this.values);
    }

    public RubyFixnum size() {
        return this.getRuntime().newFixnum(this.values.length);
    }

    public IRubyObject each() {
        ThreadContext context = this.getRuntime().getCurrentContext();
        for (int i = 0; i < this.values.length; ++i) {
            context.yield(this.values[i]);
        }
        return this;
    }

    public IRubyObject aref(IRubyObject key) {
        if (key instanceof RubyString || key instanceof RubySymbol) {
            return this.getByName(key.asSymbol());
        }
        int idx = RubyNumeric.fix2int(key);
        int n = idx = idx < 0 ? this.values.length + idx : idx;
        if (idx < 0) {
            throw this.getRuntime().newIndexError("offset " + idx + " too large for struct (size:" + this.values.length + ")");
        }
        if (idx >= this.values.length) {
            throw this.getRuntime().newIndexError("offset " + idx + " too large for struct (size:" + this.values.length + ")");
        }
        return this.values[idx];
    }

    public IRubyObject aset(IRubyObject key, IRubyObject value) {
        if (key instanceof RubyString || key instanceof RubySymbol) {
            return this.setByName(key.asSymbol(), value);
        }
        int idx = RubyNumeric.fix2int(key);
        int n = idx = idx < 0 ? this.values.length + idx : idx;
        if (idx < 0) {
            throw this.getRuntime().newIndexError("offset " + idx + " too large for struct (size:" + this.values.length + ")");
        }
        if (idx >= this.values.length) {
            throw this.getRuntime().newIndexError("offset " + idx + " too large for struct (size:" + this.values.length + ")");
        }
        this.modify();
        this.values[idx] = value;
        return this.values[idx];
    }

    public void marshalTo(MarshalStream output) throws IOException {
        output.write(83);
        String className = this.getMetaClass().getName();
        if (className == null) {
            throw this.getRuntime().newArgumentError("can't dump anonymous class");
        }
        output.dumpObject(RubySymbol.newSymbol(this.getRuntime(), className));
        List members = ((RubyArray)RubyStruct.getInstanceVariable(this.classOf(), "__member__")).getList();
        output.dumpInt(members.size());
        for (int i = 0; i < members.size(); ++i) {
            RubySymbol name = (RubySymbol)members.get(i);
            output.dumpObject(name);
            output.dumpObject(this.values[i]);
        }
    }

    public static RubyStruct unmarshalFrom(UnmarshalStream input) throws IOException {
        RubySymbol className;
        IRuby runtime = input.getRuntime();
        RubyClass rbClass = RubyStruct.pathToClass(runtime, (className = (RubySymbol)input.unmarshalObject()).asSymbol());
        if (rbClass == null) {
            throw runtime.newNameError("uninitialized constant " + className, className.asSymbol());
        }
        int size = input.unmarshalInt();
        IRubyObject[] values = new IRubyObject[size];
        for (int i = 0; i < size; ++i) {
            input.unmarshalObject();
            values[i] = input.unmarshalObject();
        }
        RubyStruct result = RubyStruct.newStruct(rbClass, values);
        input.registerLinkTarget(result);
        return result;
    }

    private static RubyClass pathToClass(IRuby runtime, String path) {
        return (RubyClass)runtime.getClassFromPath(path);
    }

    static {
        $assertionsDisabled = !RubyStruct.class.desiredAssertionStatus();
    }
}

