/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.jruby.IRuby;
import org.jruby.RubyFixnum;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.internal.runtime.methods.DirectInvocationMethod;
import org.jruby.runtime.Arity;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.marshal.MarshalStream;
import org.jruby.runtime.marshal.UnmarshalStream;

public class RubySymbol
extends RubyObject {
    private static int lastId = 0;
    private final String symbol;
    private final int id;

    private RubySymbol(IRuby runtime, String symbol) {
        super(runtime, runtime.getClass("Symbol"));
        this.symbol = symbol;
        this.id = ++lastId;
    }

    public String asSymbol() {
        return this.symbol;
    }

    public boolean isImmediate() {
        return true;
    }

    public boolean singletonMethodsAllowed() {
        return false;
    }

    public static String getSymbol(IRuby runtime, long id) {
        RubySymbol result = runtime.getSymbolTable().lookup(id);
        if (result != null) {
            return result.symbol;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RubySymbol newSymbol(IRuby runtime, String name) {
        RubySymbol result;
        Class clazz = RubySymbol.class;
        synchronized (clazz) {
            result = runtime.getSymbolTable().lookup(name);
            if (result == null) {
                result = new RubySymbol(runtime, name);
                runtime.getSymbolTable().store(result);
            }
        }
        return result;
    }

    public RubyFixnum to_i() {
        return this.getRuntime().newFixnum(this.id);
    }

    public IRubyObject inspect() {
        return this.getRuntime().newString(":" + (RubySymbol.isSymbolName(this.symbol) ? this.symbol : this.getRuntime().newString(this.symbol).dump().toString()));
    }

    public IRubyObject to_s() {
        return this.getRuntime().newString(this.symbol);
    }

    public RubyFixnum hash() {
        return this.getRuntime().newFixnum(this.hashCode());
    }

    public int hashCode() {
        return this.symbol.hashCode();
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof RubySymbol) {
            RubySymbol sym = (RubySymbol)other;
            if (sym.symbol == this.symbol) {
                return true;
            }
        }
        return false;
    }

    public IRubyObject to_sym() {
        return this;
    }

    public IRubyObject rbClone() {
        throw this.getRuntime().newTypeError("can't clone Symbol");
    }

    public IRubyObject freeze() {
        return this;
    }

    public IRubyObject taint() {
        return this;
    }

    public void marshalTo(MarshalStream output) throws IOException {
        output.write(58);
        output.dumpString(this.symbol);
    }

    private static boolean isIdentStart(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '_';
    }

    private static boolean isIdentChar(char c) {
        return c >= 'a' && c <= 'z' || c >= '0' && c <= '9' || c >= 'A' && c <= 'Z' || c == '_';
    }

    private static boolean isIdentifier(String s) {
        if (s == null || s.length() <= 0) {
            return false;
        }
        if (!RubySymbol.isIdentStart(s.charAt(0))) {
            return false;
        }
        for (int i = 1; i < s.length(); ++i) {
            if (RubySymbol.isIdentChar(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private static boolean isSpecialGlobalName(String s) {
        if (s == null || s.length() <= 0) {
            return false;
        }
        int length = s.length();
        switch (s.charAt(0)) {
            case '!': 
            case '\"': 
            case '$': 
            case '&': 
            case '\'': 
            case '*': 
            case '+': 
            case ',': 
            case '.': 
            case '/': 
            case '0': 
            case ':': 
            case ';': 
            case '<': 
            case '=': 
            case '>': 
            case '?': 
            case '@': 
            case '\\': 
            case '`': 
            case '~': {
                return length == 1;
            }
            case '-': {
                return length == 1 || length == 2 && RubySymbol.isIdentChar(s.charAt(1));
            }
        }
        for (int i = 0; i < length; ++i) {
            if (Character.isDigit(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private static boolean isSymbolName(String s) {
        char d;
        int last;
        if (s == null || s.length() < 1) {
            return false;
        }
        int length = s.length();
        char c = s.charAt(0);
        switch (c) {
            case '$': {
                return length > 1 && RubySymbol.isSpecialGlobalName(s.substring(1));
            }
            case '@': {
                int offset = 1;
                if (length >= 2 && s.charAt(1) == '@') {
                    ++offset;
                }
                return RubySymbol.isIdentifier(s.substring(offset));
            }
            case '<': {
                return length == 1 || length == 2 && (s.equals("<<") || s.equals("<=")) || length == 3 && s.equals("<=>");
            }
            case '>': {
                return length == 1 || length == 2 && (s.equals(">>") || s.equals(">="));
            }
            case '=': {
                return length == 2 && (s.equals("==") || s.equals("=~")) || length == 3 && s.equals("===");
            }
            case '*': {
                return length == 1 || length == 2 && s.equals("**");
            }
            case '+': {
                return length == 1 || length == 2 && s.equals("+@");
            }
            case '-': {
                return length == 1 || length == 2 && s.equals("-@");
            }
            case '%': 
            case '&': 
            case '/': 
            case '^': 
            case '`': 
            case '|': 
            case '~': {
                return length == 1;
            }
            case '[': {
                return s.equals("[]") || s.equals("[]=");
            }
        }
        if (!RubySymbol.isIdentStart(c)) {
            return false;
        }
        boolean localID = c >= 'a' && c <= 'z';
        for (last = 1; last < length && RubySymbol.isIdentChar(d = s.charAt(last)); ++last) {
        }
        if (last == length) {
            return true;
        }
        if (localID && last == length - 1) {
            d = s.charAt(last);
            return d == '!' || d == '?' || d == '=';
        }
        return false;
    }

    public static RubySymbol unmarshalFrom(UnmarshalStream input) throws IOException {
        RubySymbol result = RubySymbol.newSymbol(input.getRuntime(), input.unmarshalString());
        input.registerLinkTarget(result);
        return result;
    }

    public static class SymbolTable {
        private Map table = new HashMap();

        public IRubyObject[] all_symbols() {
            int length = this.table.size();
            IRubyObject[] array = new IRubyObject[length];
            System.arraycopy(this.table.values().toArray(), 0, array, 0, length);
            return array;
        }

        public RubySymbol lookup(long symbolId) {
            Iterator iter = this.table.values().iterator();
            while (iter.hasNext()) {
                RubySymbol symbol = (RubySymbol)iter.next();
                if (symbol == null || (long)symbol.id != symbolId) continue;
                return symbol;
            }
            return null;
        }

        public RubySymbol lookup(String name) {
            return (RubySymbol)this.table.get(name);
        }

        public void store(RubySymbol symbol) {
            this.table.put(symbol.asSymbol(), symbol);
        }
    }

    public static abstract class SymbolMethod
    extends DirectInvocationMethod {
        public SymbolMethod(RubyModule implementationClass, Arity arity, Visibility visibility) {
            super(implementationClass, arity, visibility);
        }

        public IRubyObject internalCall(ThreadContext context, IRubyObject receiver, RubyModule lastClass, String name, IRubyObject[] args, boolean noSuper) {
            RubySymbol s = (RubySymbol)receiver;
            return this.invoke(s, args);
        }

        public abstract IRubyObject invoke(RubySymbol var1, IRubyObject[] var2);
    }
}

