/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.List;
import org.jruby.ast.Node;
import org.jruby.ast.types.INameNode;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.evaluator.Instruction;
import org.jruby.lexer.yacc.ISourcePosition;

public final class CallNode
extends Node
implements INameNode {
    static final long serialVersionUID = -1993752395320088525L;
    private final Node receiverNode;
    private String name;
    private final Node argsNode;

    public CallNode(ISourcePosition position, Node receiverNode, String name, Node argsNode) {
        super(position, 15);
        this.receiverNode = receiverNode;
        this.name = name.intern();
        this.argsNode = argsNode;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.name = this.name.intern();
    }

    public Instruction accept(NodeVisitor iVisitor) {
        return iVisitor.visitCallNode(this);
    }

    public Node getArgsNode() {
        return this.argsNode;
    }

    public String getName() {
        return this.name;
    }

    public Node getReceiverNode() {
        return this.receiverNode;
    }

    public List childNodes() {
        return Node.createList(this.receiverNode, this.argsNode);
    }
}

