/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.List;
import org.jruby.ast.Node;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.evaluator.Instruction;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.parser.StaticScope;

public class DefsNode
extends Node {
    static final long serialVersionUID = -4472719020304670080L;
    private final Node receiverNode;
    private String name;
    private final Node argsNode;
    private final StaticScope scope;
    private final Node bodyNode;

    public DefsNode(ISourcePosition position, Node receiverNode, String name, Node argsNode, StaticScope scope, Node bodyNode) {
        super(position, 28);
        this.receiverNode = receiverNode;
        this.name = name.intern();
        this.argsNode = argsNode;
        this.scope = scope;
        this.bodyNode = bodyNode;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.name = this.name.intern();
    }

    public Instruction accept(NodeVisitor iVisitor) {
        return iVisitor.visitDefsNode(this);
    }

    public Node getArgsNode() {
        return this.argsNode;
    }

    public StaticScope getScope() {
        return this.scope;
    }

    public Node getBodyNode() {
        return this.bodyNode;
    }

    public String getName() {
        return this.name;
    }

    public Node getReceiverNode() {
        return this.receiverNode;
    }

    public List childNodes() {
        return Node.createList(this.receiverNode, this.argsNode, this.bodyNode);
    }
}

