/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.evaluator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.regex.PatternSyntaxException;
import org.jruby.IRuby;
import org.jruby.MetaClass;
import org.jruby.RubyArray;
import org.jruby.RubyBignum;
import org.jruby.RubyClass;
import org.jruby.RubyException;
import org.jruby.RubyFloat;
import org.jruby.RubyHash;
import org.jruby.RubyKernel;
import org.jruby.RubyModule;
import org.jruby.RubyProc;
import org.jruby.RubyRange;
import org.jruby.RubyRegexp;
import org.jruby.RubyString;
import org.jruby.ast.AliasNode;
import org.jruby.ast.ArgsCatNode;
import org.jruby.ast.ArgsNode;
import org.jruby.ast.ArrayNode;
import org.jruby.ast.BackRefNode;
import org.jruby.ast.BeginNode;
import org.jruby.ast.BignumNode;
import org.jruby.ast.BinaryOperatorNode;
import org.jruby.ast.BlockNode;
import org.jruby.ast.BlockPassNode;
import org.jruby.ast.BreakNode;
import org.jruby.ast.CallNode;
import org.jruby.ast.CaseNode;
import org.jruby.ast.ClassNode;
import org.jruby.ast.ClassVarAsgnNode;
import org.jruby.ast.ClassVarDeclNode;
import org.jruby.ast.ClassVarNode;
import org.jruby.ast.Colon2Node;
import org.jruby.ast.Colon3Node;
import org.jruby.ast.ConstDeclNode;
import org.jruby.ast.ConstNode;
import org.jruby.ast.DAsgnNode;
import org.jruby.ast.DRegexpNode;
import org.jruby.ast.DStrNode;
import org.jruby.ast.DSymbolNode;
import org.jruby.ast.DVarNode;
import org.jruby.ast.DXStrNode;
import org.jruby.ast.DefinedNode;
import org.jruby.ast.DefnNode;
import org.jruby.ast.DefsNode;
import org.jruby.ast.DotNode;
import org.jruby.ast.EnsureNode;
import org.jruby.ast.EvStrNode;
import org.jruby.ast.FCallNode;
import org.jruby.ast.FixnumNode;
import org.jruby.ast.FlipNode;
import org.jruby.ast.FloatNode;
import org.jruby.ast.ForNode;
import org.jruby.ast.GlobalAsgnNode;
import org.jruby.ast.GlobalVarNode;
import org.jruby.ast.HashNode;
import org.jruby.ast.IfNode;
import org.jruby.ast.InstAsgnNode;
import org.jruby.ast.InstVarNode;
import org.jruby.ast.IterNode;
import org.jruby.ast.ListNode;
import org.jruby.ast.LocalAsgnNode;
import org.jruby.ast.LocalVarNode;
import org.jruby.ast.Match2Node;
import org.jruby.ast.Match3Node;
import org.jruby.ast.MatchNode;
import org.jruby.ast.ModuleNode;
import org.jruby.ast.MultipleAsgnNode;
import org.jruby.ast.NewlineNode;
import org.jruby.ast.NextNode;
import org.jruby.ast.Node;
import org.jruby.ast.NotNode;
import org.jruby.ast.NthRefNode;
import org.jruby.ast.OpAsgnNode;
import org.jruby.ast.OpAsgnOrNode;
import org.jruby.ast.OpElementAsgnNode;
import org.jruby.ast.OptNNode;
import org.jruby.ast.OrNode;
import org.jruby.ast.RegexpNode;
import org.jruby.ast.RescueBodyNode;
import org.jruby.ast.RescueNode;
import org.jruby.ast.ReturnNode;
import org.jruby.ast.RootNode;
import org.jruby.ast.SClassNode;
import org.jruby.ast.SValueNode;
import org.jruby.ast.SplatNode;
import org.jruby.ast.StrNode;
import org.jruby.ast.SuperNode;
import org.jruby.ast.SymbolNode;
import org.jruby.ast.ToAryNode;
import org.jruby.ast.UndefNode;
import org.jruby.ast.UntilNode;
import org.jruby.ast.VAliasNode;
import org.jruby.ast.VCallNode;
import org.jruby.ast.WhenNode;
import org.jruby.ast.WhileNode;
import org.jruby.ast.XStrNode;
import org.jruby.ast.YieldNode;
import org.jruby.ast.types.INameNode;
import org.jruby.ast.util.ArgsUtil;
import org.jruby.evaluator.AssignmentVisitor;
import org.jruby.evaluator.CreateJumpTargetVisitor;
import org.jruby.exceptions.JumpException;
import org.jruby.exceptions.RaiseException;
import org.jruby.internal.runtime.methods.DefaultMethod;
import org.jruby.internal.runtime.methods.WrapperCallable;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallType;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.ICallable;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

public class EvaluationState {
    static final /* synthetic */ boolean $assertionsDisabled;

    public static IRubyObject eval(ThreadContext context, Node node, IRubyObject self) {
        try {
            return EvaluationState.evalInternal(context, node, self);
        }
        catch (StackOverflowError sfe) {
            throw context.getRuntime().newSystemStackError("stack level too deep");
        }
    }

    private static String getArgumentDefinition(ThreadContext context, Node node, String type, IRubyObject self) {
        if (node == null) {
            return type;
        }
        if (node instanceof ArrayNode) {
            Iterator iter = ((ArrayNode)node).iterator();
            while (iter.hasNext()) {
                if (EvaluationState.getDefinitionInner(context, (Node)iter.next(), self) != null) continue;
                return null;
            }
        } else if (EvaluationState.getDefinitionInner(context, node, self) == null) {
            return null;
        }
        return type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getDefinition(ThreadContext context, Node node, IRubyObject self) {
        try {
            context.setWithinDefined(true);
            String string = EvaluationState.getDefinitionInner(context, node, self);
            return string;
        }
        finally {
            context.setWithinDefined(false);
        }
    }

    private static String getDefinitionInner(ThreadContext context, Node node, IRubyObject self) {
        if (node == null) {
            return "expression";
        }
        switch (node.nodeId) {
            case 7: {
                return "$" + ((BackRefNode)node).getType();
            }
            case 15: {
                CallNode iVisited = (CallNode)node;
                if (EvaluationState.getDefinitionInner(context, iVisited.getReceiverNode(), self) != null) {
                    try {
                        IRubyObject receiver = EvaluationState.eval(context, iVisited.getReceiverNode(), self);
                        RubyClass metaClass = receiver.getMetaClass();
                        ICallable method = metaClass.searchMethod(iVisited.getName());
                        Visibility visibility = method.getVisibility();
                        if (!visibility.isPrivate() && (!visibility.isProtected() || self.isKindOf(metaClass.getRealClass())) && metaClass.isMethodBound(iVisited.getName(), false)) {
                            return EvaluationState.getArgumentDefinition(context, iVisited.getArgsNode(), "method", self);
                        }
                    }
                    catch (JumpException excptn) {
                        // empty catch block
                    }
                }
                return null;
            }
            case 18: 
            case 19: 
            case 23: 
            case 25: 
            case 43: 
            case 52: 
            case 58: 
            case 66: 
            case 68: {
                return "assignment";
            }
            case 20: {
                ClassVarNode iVisited = (ClassVarNode)node;
                if (context.getRubyClass() == null && self.getMetaClass().isClassVarDefined(iVisited.getName())) {
                    return "class_variable";
                }
                if (!context.getRubyClass().isSingleton() && context.getRubyClass().isClassVarDefined(iVisited.getName())) {
                    return "class_variable";
                }
                RubyModule module = (RubyModule)context.getRubyClass().getInstanceVariable("__attached__");
                if (module != null && module.isClassVarDefined(iVisited.getName())) {
                    return "class_variable";
                }
                return null;
            }
            case 21: {
                Colon2Node iVisited = (Colon2Node)node;
                try {
                    IRubyObject left = EvaluationState.eval(context, iVisited.getLeftNode(), self);
                    if (left instanceof RubyModule && ((RubyModule)left).getConstantAt(iVisited.getName()) != null) {
                        return "constant";
                    }
                    if (left.getMetaClass().isMethodBound(iVisited.getName(), true)) {
                        return "method";
                    }
                }
                catch (JumpException excptn) {
                    // empty catch block
                }
                return null;
            }
            case 24: {
                if (context.getConstantDefined(((ConstNode)node).getName())) {
                    return "constant";
                }
                return null;
            }
            case 33: {
                return "local-variable(in-block)";
            }
            case 37: {
                return "false";
            }
            case 38: {
                FCallNode iVisited = (FCallNode)node;
                if (self.getMetaClass().isMethodBound(iVisited.getName(), false)) {
                    return EvaluationState.getArgumentDefinition(context, iVisited.getArgsNode(), "method", self);
                }
                return null;
            }
            case 44: {
                if (context.getRuntime().getGlobalVariables().isDefined(((GlobalVarNode)node).getName())) {
                    return "global-variable";
                }
                return null;
            }
            case 48: {
                if (self.getInstanceVariable(((InstVarNode)node).getName()) != null) {
                    return "instance-variable";
                }
                return null;
            }
            case 53: {
                return "local-variable";
            }
            case 54: 
            case 55: {
                return "method";
            }
            case 61: {
                return "nil";
            }
            case 64: {
                return "$" + ((NthRefNode)node).getMatchNumber();
            }
            case 80: {
                return "state.getSelf()";
            }
            case 84: {
                SuperNode iVisited = (SuperNode)node;
                String lastMethod = context.getFrameLastFunc();
                RubyModule lastClass = context.getFrameLastClass();
                if (lastMethod != null && lastClass != null && lastClass.getSuperClass().isMethodBound(lastMethod, false)) {
                    return EvaluationState.getArgumentDefinition(context, iVisited.getArgsNode(), "super", self);
                }
                return null;
            }
            case 88: {
                return "true";
            }
            case 92: {
                VCallNode iVisited = (VCallNode)node;
                if (self.getMetaClass().isMethodBound(iVisited.getName(), false)) {
                    return "method";
                }
                return null;
            }
            case 96: {
                return context.isBlockGiven() ? "yield" : null;
            }
            case 99: {
                String lastMethod = context.getFrameLastFunc();
                RubyModule lastClass = context.getFrameLastClass();
                if (lastMethod != null && lastClass != null && lastClass.getSuperClass().isMethodBound(lastMethod, false)) {
                    return "super";
                }
                return null;
            }
        }
        try {
            EvaluationState.eval(context, node, self);
            return "expression";
        }
        catch (JumpException jumpException) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private static IRubyObject evalInternal(ThreadContext context, Node node, IRubyObject self) {
        runtime = context.getRuntime();
        while (true) {
            if (node == null) {
                return runtime.getNil();
            }
            block28 : switch (node.nodeId) {
                case 0: {
                    iVisited = (AliasNode)node;
                    if (context.getRubyClass() == null) {
                        throw runtime.newTypeError("no class to make alias");
                    }
                    context.getRubyClass().defineAlias(iVisited.getNewName(), iVisited.getOldName());
                    context.getRubyClass().callMethod(context, "method_added", runtime.newSymbol(iVisited.getNewName()));
                    return runtime.getNil();
                }
                case 1: {
                    iVisited = (BinaryOperatorNode)node;
                    result = EvaluationState.evalInternal(context, iVisited.getFirstNode(), self);
                    if (!result.isTrue()) {
                        return result;
                    }
                    node = iVisited.getSecondNode();
                    break;
                }
                case 2: {
                    iVisited = (ArgsCatNode)node;
                    args = EvaluationState.evalInternal(context, iVisited.getFirstNode(), self);
                    secondArgs = EvaluationState.splatValue(EvaluationState.evalInternal(context, iVisited.getSecondNode(), self));
                    list = args instanceof RubyArray != false ? (RubyArray)args : runtime.newArray((IRubyObject)args);
                    return list.concat(secondArgs);
                }
                case 5: {
                    iVisited = (ArrayNode)node;
                    array = new IRubyObject[iVisited.size()];
                    i = 0;
                    iterator = iVisited.iterator();
                    while (iterator.hasNext()) {
                        next = (Node)iterator.next();
                        array[i++] = EvaluationState.evalInternal(context, (Node)next, self);
                    }
                    return runtime.newArray(array);
                }
                case 7: {
                    iVisited = (BackRefNode)node;
                    backref = context.getBackref();
                    switch (iVisited.getType()) {
                        case '~': {
                            return backref;
                        }
                        case '&': {
                            return RubyRegexp.last_match(backref);
                        }
                        case '`': {
                            return RubyRegexp.match_pre(backref);
                        }
                        case '\'': {
                            return RubyRegexp.match_post(backref);
                        }
                        case '+': {
                            return RubyRegexp.match_last(backref);
                        }
                    }
                    break;
                }
                case 8: {
                    iVisited = (BeginNode)node;
                    node = iVisited.getBodyNode();
                    break;
                }
                case 9: {
                    iVisited = (BignumNode)node;
                    return RubyBignum.newBignum(runtime, iVisited.getValue());
                }
                case 12: {
                    iVisited = (BlockNode)node;
                    result = runtime.getNil();
                    iter = iVisited.iterator();
                    while (iter.hasNext()) {
                        result = EvaluationState.evalInternal(context, (Node)iter.next(), self);
                    }
                    return result;
                }
                case 13: {
                    iVisited = (BlockPassNode)node;
                    proc = EvaluationState.evalInternal(context, iVisited.getBodyNode(), self);
                    if (proc.isNil()) {
                        context.setNoBlock();
                        try {
                            iter = EvaluationState.evalInternal(context, iVisited.getIterNode(), self);
                            return iter;
                        }
                        finally {
                            context.clearNoBlock();
                        }
                    }
                    if (!(proc instanceof RubyProc) && !((proc = proc.convertToType("Proc", "to_proc", false)) instanceof RubyProc)) {
                        throw runtime.newTypeError("wrong argument type " + proc.getMetaClass().getName() + " (expected Proc)");
                    }
                    block = context.getCurrentBlock();
                    if (block != null && (blockObject = block.getBlockObject()) != null && blockObject == proc) {
                        try {
                            context.setBlockAvailable();
                            next = EvaluationState.evalInternal(context, iVisited.getIterNode(), self);
                            return next;
                        }
                        finally {
                            context.clearBlockAvailable();
                        }
                    }
                    context.preBlockPassEval(((RubyProc)proc).getBlock());
                    try {
                        blockObject = EvaluationState.evalInternal(context, iVisited.getIterNode(), self);
                        return blockObject;
                    }
                    finally {
                        context.postBlockPassEval();
                    }
                }
                case 14: {
                    iVisited = (BreakNode)node;
                    result = EvaluationState.evalInternal(context, iVisited.getValueNode(), self);
                    je = new JumpException(JumpException.JumpType.BreakJump);
                    je.setPrimaryData(result);
                    je.setSecondaryData(node);
                    throw je;
                }
                case 15: {
                    iVisited = (CallNode)node;
                    context.beginCallArgs();
                    receiver = null;
                    args = null;
                    try {
                        receiver = EvaluationState.evalInternal(context, iVisited.getReceiverNode(), self);
                        args = EvaluationState.setupArgs(context, iVisited.getArgsNode(), self);
                    }
                    finally {
                        context.endCallArgs();
                    }
                    if (!EvaluationState.$assertionsDisabled && receiver.getMetaClass() == null) {
                        throw new AssertionError((Object)receiver.getClass().getName());
                    }
                    callType = receiver == self ? CallType.VARIABLE : CallType.NORMAL;
                    return receiver.callMethod(context, iVisited.getName(), args, callType);
                }
                case 16: {
                    iVisited = (CaseNode)node;
                    expression = null;
                    if (iVisited.getCaseNode() != null) {
                        expression = EvaluationState.evalInternal(context, iVisited.getCaseNode(), self);
                    }
                    context.pollThreadEvents();
                    result = runtime.getNil();
                    firstWhenNode = iVisited.getFirstWhenNode();
                    while (firstWhenNode != null) {
                        if (!(firstWhenNode instanceof WhenNode)) {
                            node = firstWhenNode;
                            break block28;
                        }
                        whenNode = (WhenNode)firstWhenNode;
                        if (whenNode.getExpressionNodes() instanceof ArrayNode) {
                            iter = ((ArrayNode)whenNode.getExpressionNodes()).iterator();
                            while (iter.hasNext()) {
                                tag = (Node)iter.next();
                                context.setPosition(tag.getPosition());
                                if (EvaluationState.isTrace(runtime)) {
                                    EvaluationState.callTraceFunction(context, "line", self);
                                }
                                if (tag instanceof WhenNode) {
                                    expressions = (RubyArray)EvaluationState.evalInternal(context, ((WhenNode)tag).getExpressionNodes(), self);
                                    for (j = 0; j < expressions.getLength(); ++j) {
                                        condition = expressions.entry(j);
                                        if ((expression == null || !condition.callMethod(context, "===", expression).isTrue()) && (expression != null || !condition.isTrue())) continue;
                                        node = ((WhenNode)firstWhenNode).getBodyNode();
                                        break block28;
                                    }
                                    continue;
                                }
                                result = EvaluationState.evalInternal(context, tag, self);
                                if ((expression == null || !result.callMethod(context, "===", expression).isTrue()) && (expression != null || !result.isTrue())) continue;
                                node = whenNode.getBodyNode();
                                break block28;
                            }
                        } else {
                            result = EvaluationState.evalInternal(context, whenNode.getExpressionNodes(), self);
                            if (expression != null && result.callMethod(context, "===", expression).isTrue() || expression == null && result.isTrue()) {
                                node = ((WhenNode)firstWhenNode).getBodyNode();
                                break block28;
                            }
                        }
                        context.pollThreadEvents();
                        firstWhenNode = whenNode.getNextCase();
                    }
                    return runtime.getNil();
                }
                case 17: {
                    iVisited = (ClassNode)node;
                    superNode = iVisited.getSuperNode();
                    superClass = superNode == null ? null : (RubyClass)EvaluationState.evalInternal(context, superNode, self);
                    classNameNode = iVisited.getCPath();
                    name = ((INameNode)classNameNode).getName();
                    enclosingClass = EvaluationState.getEnclosingModule(context, classNameNode, self);
                    rubyClass /* !! */  = enclosingClass.defineOrGetClassUnder(name, superClass);
                    if (context.getWrapper() != null) {
                        rubyClass /* !! */ .extendObject(context.getWrapper());
                        rubyClass /* !! */ .includeModule(context.getWrapper());
                    }
                    return EvaluationState.evalClassDefinitionBody(context, iVisited.getScope(), iVisited.getBodyNode(), rubyClass /* !! */ , self);
                }
                case 18: {
                    iVisited = (ClassVarAsgnNode)node;
                    result = EvaluationState.evalInternal(context, iVisited.getValueNode(), self);
                    rubyClass = (RubyModule)context.peekCRef().getValue();
                    if (rubyClass == null) {
                        rubyClass = self.getMetaClass();
                    } else if (rubyClass.isSingleton()) {
                        rubyClass = (RubyModule)rubyClass.getInstanceVariable("__attached__");
                    }
                    rubyClass.setClassVar(iVisited.getName(), result);
                    return result;
                }
                case 19: {
                    iVisited = (ClassVarDeclNode)node;
                    if (context.getRubyClass() == null) {
                        throw runtime.newTypeError("no class/module to define class variable");
                    }
                    result = EvaluationState.evalInternal(context, iVisited.getValueNode(), self);
                    ((RubyModule)context.peekCRef().getValue()).setClassVar(iVisited.getName(), result);
                    return runtime.getNil();
                }
                case 20: {
                    iVisited = (ClassVarNode)node;
                    rubyClass = (RubyModule)context.peekCRef().getValue();
                    if (rubyClass == null) {
                        rubyClass = self.getMetaClass();
                    } else if (rubyClass.isSingleton()) {
                        rubyClass = (RubyModule)rubyClass.getInstanceVariable("__attached__");
                    }
                    return rubyClass.getClassVar(iVisited.getName());
                }
                case 21: {
                    iVisited = (Colon2Node)node;
                    leftNode = iVisited.getLeftNode();
                    if (leftNode == null) {
                        return runtime.getObject().getConstantFrom(iVisited.getName());
                    }
                    result = EvaluationState.evalInternal(context, iVisited.getLeftNode(), self);
                    if (result instanceof RubyModule) {
                        return ((RubyModule)result).getConstantFrom(iVisited.getName());
                    }
                    return result.callMethod(context, iVisited.getName());
                }
                case 22: {
                    iVisited = (Colon3Node)node;
                    return runtime.getObject().getConstantFrom(iVisited.getName());
                }
                case 23: {
                    iVisited = (ConstDeclNode)node;
                    result = EvaluationState.evalInternal(context, iVisited.getValueNode(), self);
                    if (iVisited.getPathNode() != null) {
                        module = EvaluationState.evalInternal(context, iVisited.getPathNode(), self);
                    } else {
                        if (context.getRubyClass() == null) {
                            throw runtime.newTypeError("no class/module to define constant");
                        }
                        module = (RubyModule)context.peekCRef().getValue();
                    }
                    ((RubyModule)module).setConstant(iVisited.getName(), result);
                    return result;
                }
                case 24: {
                    iVisited = (ConstNode)node;
                    return context.getConstant(iVisited.getName());
                }
                case 25: {
                    iVisited = (DAsgnNode)node;
                    result = EvaluationState.evalInternal(context, iVisited.getValueNode(), self);
                    context.getCurrentScope().setValue(iVisited.getIndex(), result, iVisited.getDepth());
                    return result;
                }
                case 26: {
                    iVisited = (DefinedNode)node;
                    definition = EvaluationState.getDefinition(context, iVisited.getExpressionNode(), self);
                    if (definition != null) {
                        return runtime.newString(definition);
                    }
                    return runtime.getNil();
                }
                case 27: {
                    iVisited = (DefnNode)node;
                    containingClass = context.getRubyClass();
                    if (containingClass == null) {
                        throw runtime.newTypeError("No class to add method.");
                    }
                    name = iVisited.getName();
                    if (containingClass == runtime.getObject() && name.equals("initialize")) {
                        runtime.getWarnings().warn("redefining Object#initialize may cause infinite loop");
                    }
                    visibility = context.getCurrentVisibility();
                    if (name.equals("initialize") || visibility.isModuleFunction()) {
                        visibility = Visibility.PRIVATE;
                    }
                    newMethod = new DefaultMethod(containingClass, iVisited.getScope(), iVisited.getBodyNode(), (ArgsNode)iVisited.getArgsNode(), visibility, context.peekCRef());
                    if (iVisited.getBodyNode() != null) {
                        iVisited.getBodyNode().accept(new CreateJumpTargetVisitor(newMethod));
                    }
                    containingClass.addMethod(name, newMethod);
                    if (context.getCurrentVisibility().isModuleFunction()) {
                        containingClass.getSingletonClass().addMethod(name, new WrapperCallable(containingClass.getSingletonClass(), newMethod, Visibility.PUBLIC));
                        containingClass.callMethod(context, "singleton_method_added", runtime.newSymbol(name));
                    }
                    if (containingClass.isSingleton()) {
                        ((MetaClass)containingClass).getAttachedObject().callMethod(context, "singleton_method_added", runtime.newSymbol(iVisited.getName()));
                    } else {
                        containingClass.callMethod(context, "method_added", runtime.newSymbol(name));
                    }
                    return runtime.getNil();
                }
                case 28: {
                    iVisited = (DefsNode)node;
                    receiver = EvaluationState.evalInternal(context, iVisited.getReceiverNode(), self);
                    if (runtime.getSafeLevel() >= 4 && !receiver.isTaint()) {
                        throw runtime.newSecurityError("Insecure; can't define singleton method.");
                    }
                    if (receiver.isFrozen()) {
                        throw runtime.newFrozenError("object");
                    }
                    if (!receiver.singletonMethodsAllowed()) {
                        throw runtime.newTypeError("can't define singleton method \"" + iVisited.getName() + "\" for " + receiver.getType());
                    }
                    rubyClass = receiver.getSingletonClass();
                    if (runtime.getSafeLevel() >= 4 && (method = (ICallable)rubyClass.getMethods().get(iVisited.getName())) != null) {
                        throw runtime.newSecurityError("Redefining method prohibited.");
                    }
                    newMethod = new DefaultMethod(rubyClass, iVisited.getScope(), iVisited.getBodyNode(), (ArgsNode)iVisited.getArgsNode(), Visibility.PUBLIC, context.peekCRef());
                    if (iVisited.getBodyNode() != null) {
                        iVisited.getBodyNode().accept(new CreateJumpTargetVisitor(newMethod));
                    }
                    rubyClass.addMethod(iVisited.getName(), newMethod);
                    receiver.callMethod(context, "singleton_method_added", runtime.newSymbol(iVisited.getName()));
                    return runtime.getNil();
                }
                case 29: {
                    iVisited = (DotNode)node;
                    return RubyRange.newRange(runtime, EvaluationState.evalInternal(context, iVisited.getBeginNode(), self), EvaluationState.evalInternal(context, iVisited.getEndNode(), self), iVisited.isExclusive());
                }
                case 30: {
                    iVisited = (DRegexpNode)node;
                    sb = new StringBuffer();
                    iterator = iVisited.iterator();
                    while (iterator.hasNext()) {
                        iterNode = (Node)iterator.next();
                        sb.append(EvaluationState.evalInternal(context, (Node)iterNode, self).toString());
                    }
                    lang = null;
                    opts = iVisited.getOptions();
                    if ((opts & 16) != 0) {
                        lang = "n";
                    } else if ((opts & 48) != 0) {
                        lang = "s";
                    } else if ((opts & 64) != 0) {
                        lang = "u";
                    }
                    return RubyRegexp.newRegexp(runtime, sb.toString(), iVisited.getOptions(), lang);
                }
                case 31: {
                    iVisited = (DStrNode)node;
                    sb = new StringBuffer();
                    iterator = iVisited.iterator();
                    while (iterator.hasNext()) {
                        iterNode = (Node)iterator.next();
                        sb.append(EvaluationState.evalInternal(context, (Node)iterNode, self).toString());
                    }
                    return runtime.newString(sb.toString());
                }
                case 32: {
                    iVisited = (DSymbolNode)node;
                    sb = new StringBuffer();
                    iterator = iVisited.getNode().iterator();
                    while (iterator.hasNext()) {
                        iterNode = (Node)iterator.next();
                        sb.append(EvaluationState.evalInternal(context, (Node)iterNode, self).toString());
                    }
                    return runtime.newSymbol(sb.toString());
                }
                case 33: {
                    iVisited = (DVarNode)node;
                    obj = context.getCurrentScope().getValue(iVisited.getIndex(), iVisited.getDepth());
                    return obj == null ? runtime.getNil() : obj;
                }
                case 34: {
                    iVisited = (DXStrNode)node;
                    sb = new StringBuffer();
                    iterator = iVisited.iterator();
                    while (iterator.hasNext()) {
                        iterNode = (Node)iterator.next();
                        sb.append(EvaluationState.evalInternal(context, (Node)iterNode, self).toString());
                    }
                    return self.callMethod(context, "`", runtime.newString(sb.toString()));
                }
                case 35: {
                    iVisited = (EnsureNode)node;
                    if (iVisited.getEnsureNode() == null) ** GOTO lbl355
                    result = runtime.getNil();
                    try {
                        result = EvaluationState.evalInternal(context, iVisited.getBodyNode(), self);
                    }
                    finally {
                        EvaluationState.evalInternal(context, iVisited.getEnsureNode(), self);
                    }
                    return result;
lbl355:
                    // 1 sources

                    node = iVisited.getBodyNode();
                    break;
                }
                case 36: {
                    iVisited = (EvStrNode)node;
                    node = iVisited.getBody();
                    break;
                }
                case 37: {
                    context.pollThreadEvents();
                    return runtime.getFalse();
                }
                case 38: {
                    iVisited = (FCallNode)node;
                    context.beginCallArgs();
                    try {
                        args = EvaluationState.setupArgs(context, iVisited.getArgsNode(), self);
                    }
                    finally {
                        context.endCallArgs();
                    }
                    return self.callMethod(context, iVisited.getName(), args, CallType.FUNCTIONAL);
                }
                case 39: {
                    iVisited = (FixnumNode)node;
                    return runtime.newFixnum(iVisited.getValue());
                }
                case 40: {
                    iVisited = (FlipNode)node;
                    result = runtime.getNil();
                    if (iVisited.isExclusive()) {
                        if (!context.getCurrentScope().getValue(iVisited.getIndex(), iVisited.getDepth()).isTrue()) {
                            result = EvaluationState.evalInternal(context, iVisited.getBeginNode(), self).isTrue() != false ? runtime.getFalse() : runtime.getTrue();
                            context.getCurrentScope().setValue(iVisited.getIndex(), result, iVisited.getDepth());
                            return result;
                        }
                        if (EvaluationState.evalInternal(context, iVisited.getEndNode(), self).isTrue()) {
                            context.getCurrentScope().setValue(iVisited.getIndex(), runtime.getFalse(), iVisited.getDepth());
                        }
                        return runtime.getTrue();
                    }
                    if (!context.getCurrentScope().getValue(iVisited.getIndex(), iVisited.getDepth()).isTrue()) {
                        if (EvaluationState.evalInternal(context, iVisited.getBeginNode(), self).isTrue()) {
                            context.getCurrentScope().setValue(iVisited.getIndex(), EvaluationState.evalInternal(context, iVisited.getEndNode(), self).isTrue() != false ? runtime.getFalse() : runtime.getTrue(), iVisited.getDepth());
                            return runtime.getTrue();
                        }
                        return runtime.getFalse();
                    }
                    if (EvaluationState.evalInternal(context, iVisited.getEndNode(), self).isTrue()) {
                        context.getCurrentScope().setValue(iVisited.getIndex(), runtime.getFalse(), iVisited.getDepth());
                    }
                    return runtime.getTrue();
                }
                case 41: {
                    iVisited = (FloatNode)node;
                    return RubyFloat.newFloat(runtime, iVisited.getValue());
                }
                case 42: {
                    iVisited = (ForNode)node;
                    context.preForLoopEval(Block.createBlock(iVisited.getVarNode(), null, iVisited.getCallable(), self));
                    block199: while (true) {
                        try {
                            position = context.getPosition();
                            context.beginCallArgs();
                            recv = null;
                            try {
                                recv = EvaluationState.evalInternal(context, iVisited.getIterNode(), self);
                            }
                            finally {
                                context.setPosition(position);
                                context.endCallArgs();
                            }
                            iterNode = recv.callMethod(context, "each", IRubyObject.NULL_ARRAY, CallType.NORMAL);
                            return iterNode;
                        }
                        catch (JumpException je) {
                            try {
                                switch (je.getJumpType().getTypeId()) {
                                    case 3: {
                                        continue block199;
                                    }
                                }
                                throw je;
                            }
                            catch (JumpException je) {
                                switch (je.getJumpType().getTypeId()) {
                                    case 0: {
                                        breakValue = (IRubyObject)je.getPrimaryData();
                                        iterNode = breakValue == null ? runtime.getNil() : breakValue;
                                        return iterNode;
                                    }
                                }
                                throw je;
                            }
                        }
                        break;
                    }
                    finally {
                        context.postForLoopEval();
                    }
                }
                case 43: {
                    iVisited = (GlobalAsgnNode)node;
                    result = EvaluationState.evalInternal(context, iVisited.getValueNode(), self);
                    runtime.getGlobalVariables().set(iVisited.getName(), result);
                    return result;
                }
                case 44: {
                    iVisited = (GlobalVarNode)node;
                    return runtime.getGlobalVariables().get(iVisited.getName());
                }
                case 45: {
                    iVisited = (HashNode)node;
                    hash = null;
                    if (iVisited.getListNode() != null) {
                        hash = new HashMap<IRubyObject, IRubyObject>(iVisited.getListNode().size() / 2);
                        iterator = iVisited.getListNode().iterator();
                        while (iterator.hasNext()) {
                            key = EvaluationState.evalInternal(context, (Node)iterator.next(), self);
                            value = EvaluationState.evalInternal(context, (Node)iterator.next(), self);
                            hash.put(key, value);
                        }
                    }
                    if (hash == null) {
                        return RubyHash.newHash(runtime);
                    }
                    return RubyHash.newHash(runtime, hash, runtime.getNil());
                }
                case 46: {
                    iVisited = (IfNode)node;
                    result = EvaluationState.evalInternal(context, iVisited.getCondition(), self);
                    if (result.isTrue()) {
                        node = iVisited.getThenBody();
                        break;
                    }
                    node = iVisited.getElseBody();
                    break;
                }
                case 47: {
                    iVisited = (InstAsgnNode)node;
                    result = EvaluationState.evalInternal(context, iVisited.getValueNode(), self);
                    self.setInstanceVariable(iVisited.getName(), result);
                    return result;
                }
                case 48: {
                    iVisited = (InstVarNode)node;
                    variable = self.getInstanceVariable(iVisited.getName());
                    return variable == null ? runtime.getNil() : variable;
                }
                case 50: {
                    iVisited = (IterNode)node;
                    context.preIterEval(Block.createBlock(iVisited.getVarNode(), new DynamicScope(iVisited.getScope(), context.getCurrentScope()), iVisited.getCallable(), self));
                    while (true) lbl-1000:
                    // 3 sources

                    {
                        try {
                            context.setBlockAvailable();
                            variable = EvaluationState.evalInternal(context, iVisited.getIterNode(), self);
                        }
                        catch (JumpException je) {
                            try {
                                try {
                                    switch (je.getJumpType().getTypeId()) {
                                        case 3: {
                                            ** break;
                                        }
                                        default: {
                                            throw je;
                                        }
                                    }
                                }
                                catch (Throwable var18_36) {
                                    throw var18_36;
                                }
                                finally {
                                    context.clearBlockAvailable();
                                    continue;
                                }
                            }
                            catch (JumpException je) {
                                switch (je.getJumpType().getTypeId()) {
                                    case 0: {
                                        breakValue = (IRubyObject)je.getPrimaryData();
                                        key = breakValue == null ? runtime.getNil() : breakValue;
                                        return key;
                                    }
                                }
                                throw je;
                            }
                        }
                        context.clearBlockAvailable();
                        return variable;
                    }
                    finally {
                        context.postIterEval();
                    }
                }
                case 52: {
                    iVisited = (LocalAsgnNode)node;
                    result = EvaluationState.evalInternal(context, iVisited.getValueNode(), self);
                    context.getCurrentScope().setValue(iVisited.getIndex(), result, iVisited.getDepth());
                    return result;
                }
                case 53: {
                    iVisited = (LocalVarNode)node;
                    result = context.getCurrentScope().getValue(iVisited.getIndex(), iVisited.getDepth());
                    return result == null ? runtime.getNil() : result;
                }
                case 54: {
                    iVisited = (Match2Node)node;
                    recv = EvaluationState.evalInternal(context, iVisited.getReceiverNode(), self);
                    value = EvaluationState.evalInternal(context, iVisited.getValueNode(), self);
                    return ((RubyRegexp)recv).match(value);
                }
                case 55: {
                    iVisited = (Match3Node)node;
                    recv = EvaluationState.evalInternal(context, iVisited.getReceiverNode(), self);
                    value = EvaluationState.evalInternal(context, iVisited.getValueNode(), self);
                    if (value instanceof RubyString) {
                        return ((RubyRegexp)recv).match(value);
                    }
                    return value.callMethod(context, "=~", recv);
                }
                case 56: {
                    iVisited = (MatchNode)node;
                    return ((RubyRegexp)EvaluationState.evalInternal(context, iVisited.getRegexpNode(), self)).match2();
                }
                case 57: {
                    iVisited = (ModuleNode)node;
                    classNameNode = iVisited.getCPath();
                    name = ((INameNode)classNameNode).getName();
                    enclosingModule = EvaluationState.getEnclosingModule(context, classNameNode, self);
                    if (enclosingModule == null) {
                        throw runtime.newTypeError("no outer class/module");
                    }
                    module = enclosingModule == runtime.getObject() ? runtime.getOrCreateModule(name) : enclosingModule.defineModuleUnder(name);
                    return EvaluationState.evalClassDefinitionBody(context, iVisited.getScope(), iVisited.getBodyNode(), module, self);
                }
                case 58: {
                    iVisited = (MultipleAsgnNode)node;
                    return AssignmentVisitor.assign(context, self, (Node)iVisited, EvaluationState.evalInternal(context, iVisited.getValueNode(), self), false);
                }
                case 59: {
                    iVisited = (NewlineNode)node;
                    context.setPosition(iVisited.getPosition());
                    if (EvaluationState.isTrace(runtime)) {
                        EvaluationState.callTraceFunction(context, "line", self);
                    }
                    node = iVisited.getNextNode();
                    break;
                }
                case 60: {
                    iVisited = (NextNode)node;
                    context.pollThreadEvents();
                    result = EvaluationState.evalInternal(context, iVisited.getValueNode(), self);
                    je = new JumpException(JumpException.JumpType.NextJump);
                    je.setPrimaryData(result);
                    je.setSecondaryData(iVisited);
                    throw je;
                }
                case 61: {
                    return runtime.getNil();
                }
                case 63: {
                    iVisited = (NotNode)node;
                    result = EvaluationState.evalInternal(context, iVisited.getConditionNode(), self);
                    return result.isTrue() != false ? runtime.getFalse() : runtime.getTrue();
                }
                case 64: {
                    iVisited = (NthRefNode)node;
                    return RubyRegexp.nth_match(iVisited.getMatchNumber(), context.getBackref());
                }
                case 65: {
                    iVisited = (BinaryOperatorNode)node;
                    result = EvaluationState.evalInternal(context, iVisited.getFirstNode(), self);
                    if (!result.isTrue()) {
                        return result;
                    }
                    node = iVisited.getSecondNode();
                    break;
                }
                case 66: {
                    iVisited = (OpAsgnNode)node;
                    receiver = EvaluationState.evalInternal(context, iVisited.getReceiverNode(), self);
                    value = receiver.callMethod(context, iVisited.getVariableName());
                    if (iVisited.getOperatorName().equals("||")) {
                        if (value.isTrue()) {
                            return value;
                        }
                        value = EvaluationState.evalInternal(context, iVisited.getValueNode(), self);
                    } else if (iVisited.getOperatorName().equals("&&")) {
                        if (!value.isTrue()) {
                            return value;
                        }
                        value = EvaluationState.evalInternal(context, iVisited.getValueNode(), self);
                    } else {
                        value = value.callMethod(context, iVisited.getOperatorName(), EvaluationState.evalInternal(context, iVisited.getValueNode(), self));
                    }
                    receiver.callMethod(context, iVisited.getVariableName() + "=", value);
                    context.pollThreadEvents();
                    return value;
                }
                case 67: {
                    iVisited = (OpAsgnOrNode)node;
                    def = EvaluationState.getDefinition(context, iVisited.getFirstNode(), self);
                    result = runtime.getNil();
                    if (def != null) {
                        result = EvaluationState.evalInternal(context, iVisited.getFirstNode(), self);
                    }
                    if (!result.isTrue()) {
                        result = EvaluationState.evalInternal(context, iVisited.getSecondNode(), self);
                    }
                    return result;
                }
                case 68: {
                    iVisited = (OpElementAsgnNode)node;
                    receiver = EvaluationState.evalInternal(context, iVisited.getReceiverNode(), self);
                    args = EvaluationState.setupArgs(context, iVisited.getArgsNode(), self);
                    firstValue = receiver.callMethod(context, "[]", args);
                    if (iVisited.getOperatorName().equals("||")) {
                        if (firstValue.isTrue()) {
                            return firstValue;
                        }
                        firstValue = EvaluationState.evalInternal(context, iVisited.getValueNode(), self);
                    } else if (iVisited.getOperatorName().equals("&&")) {
                        if (!firstValue.isTrue()) {
                            return firstValue;
                        }
                        firstValue = EvaluationState.evalInternal(context, iVisited.getValueNode(), self);
                    } else {
                        firstValue = firstValue.callMethod(context, iVisited.getOperatorName(), EvaluationState.evalInternal(context, iVisited.getValueNode(), self));
                    }
                    expandedArgs = new IRubyObject[args.length + 1];
                    System.arraycopy(args, 0, expandedArgs, 0, args.length);
                    expandedArgs[expandedArgs.length - 1] = firstValue;
                    return receiver.callMethod(context, "[]=", expandedArgs);
                }
                case 69: {
                    iVisited = (OptNNode)node;
                    result = runtime.getNil();
                    block202: while (RubyKernel.gets(runtime.getTopSelf(), IRubyObject.NULL_ARRAY).isTrue()) {
                        block203: while (true) {
                            try {
                                result = EvaluationState.evalInternal(context, iVisited.getBodyNode(), self);
                                continue block202;
                            }
                            catch (JumpException je) {
                                switch (je.getJumpType().getTypeId()) {
                                    case 2: {
                                        continue block203;
                                    }
                                    case 1: {
                                        continue block202;
                                    }
                                    case 0: {
                                        return (IRubyObject)je.getPrimaryData();
                                    }
                                }
                                throw je;
                            }
                            break;
                        }
                    }
                    return result;
                }
                case 70: {
                    iVisited = (OrNode)node;
                    result = EvaluationState.evalInternal(context, iVisited.getFirstNode(), self);
                    if (!result.isTrue()) {
                        result = EvaluationState.evalInternal(context, iVisited.getSecondNode(), self);
                    }
                    return result;
                }
                case 72: {
                    context.pollThreadEvents();
                    je = new JumpException(JumpException.JumpType.RedoJump);
                    je.setSecondaryData(node);
                    throw je;
                }
                case 73: {
                    iVisited = (RegexpNode)node;
                    lang = null;
                    opts = iVisited.getOptions();
                    if ((opts & 16) != 0) {
                        lang = "n";
                    } else if ((opts & 48) != 0) {
                        lang = "s";
                    } else if ((opts & 64) != 0) {
                        lang = "u";
                    }
                    try {
                        return RubyRegexp.newRegexp(runtime, iVisited.getPattern(), lang);
                    }
                    catch (PatternSyntaxException e) {
                        throw runtime.newSyntaxError(e.getMessage());
                    }
                }
                case 74: {
                    iVisited = (RescueBodyNode)node;
                    node = iVisited.getBodyNode();
                    break;
                }
                case 75: {
                    iVisited = (RescueNode)node;
                    block204: while (true) {
                        try {
                            result = EvaluationState.evalInternal(context, iVisited.getBodyNode(), self);
                            if (iVisited.getElseNode() != null) {
                                if (iVisited.getRescueNode() == null) {
                                    runtime.getWarnings().warn(iVisited.getElseNode().getPosition(), "else without rescue is useless");
                                }
                                result = EvaluationState.evalInternal(context, iVisited.getElseNode(), self);
                            }
                            opts = result;
                            return opts;
                        }
                        catch (RaiseException raiseJump) {
                            raisedException = raiseJump.getException();
                            runtime.getGlobalVariables().set("$!", raisedException);
                            for (rescueNode = iVisited.getRescueNode(); rescueNode != null; rescueNode = rescueNode.getOptRescueNode()) {
                                exceptionNodes = rescueNode.getExceptionNodes();
                                exceptionNodesList = exceptionNodes instanceof SplatNode != false ? (ListNode)EvaluationState.evalInternal(context, exceptionNodes, self) : (ListNode)exceptionNodes;
                                if (!EvaluationState.isRescueHandled(context, raisedException, exceptionNodesList, self)) continue;
                                try {
                                    rubyClass /* !! */  = EvaluationState.evalInternal(context, rescueNode, self);
                                    return rubyClass /* !! */ ;
                                }
                                catch (JumpException je) {
                                    if (je.getJumpType() == JumpException.JumpType.RetryJump) continue block204;
                                    throw je;
                                }
                            }
                            throw raiseJump;
                        }
                        finally {
                            runtime.getGlobalVariables().set("$!", runtime.getNil());
                            continue;
                        }
                        break;
                    }
                }
                case 76: {
                    context.pollThreadEvents();
                    je = new JumpException(JumpException.JumpType.RetryJump);
                    throw je;
                }
                case 77: {
                    iVisited = (ReturnNode)node;
                    result = EvaluationState.evalInternal(context, iVisited.getValueNode(), self);
                    je = new JumpException(JumpException.JumpType.ReturnJump);
                    je.setPrimaryData(iVisited.getTarget());
                    je.setSecondaryData(result);
                    je.setTertiaryData(iVisited);
                    throw je;
                }
                case 101: {
                    iVisited = (RootNode)node;
                    scope = iVisited.getScope();
                    if (scope == null) {
                        scope = new DynamicScope(iVisited.getStaticScope(), null);
                    }
                    context.preRootNode(scope);
                    try {
                        je = EvaluationState.eval(context, iVisited.getBodyNode(), self);
                        return je;
                    }
                    finally {
                        context.postRootNode();
                    }
                }
                case 78: {
                    iVisited = (SClassNode)node;
                    receiver = EvaluationState.evalInternal(context, iVisited.getReceiverNode(), self);
                    if (receiver.isNil()) {
                        singletonClass = runtime.getNilClass();
                    } else if (receiver == runtime.getTrue()) {
                        singletonClass = runtime.getClass("TrueClass");
                    } else if (receiver == runtime.getFalse()) {
                        singletonClass = runtime.getClass("FalseClass");
                    } else {
                        if (runtime.getSafeLevel() >= 4 && !receiver.isTaint()) {
                            throw runtime.newSecurityError("Insecure: can't extend object.");
                        }
                        singletonClass = receiver.getSingletonClass();
                    }
                    if (context.getWrapper() != null) {
                        singletonClass.extendObject(context.getWrapper());
                        singletonClass.includeModule(context.getWrapper());
                    }
                    return EvaluationState.evalClassDefinitionBody(context, iVisited.getScope(), iVisited.getBodyNode(), singletonClass, self);
                }
                case 80: {
                    return self;
                }
                case 81: {
                    iVisited = (SplatNode)node;
                    return EvaluationState.splatValue(EvaluationState.evalInternal(context, iVisited.getValue(), self));
                }
                case 83: {
                    iVisited = (StrNode)node;
                    return runtime.newString(iVisited.getValue());
                }
                case 84: {
                    iVisited = (SuperNode)node;
                    if (context.getFrameLastClass() == null) {
                        name = context.getFrameLastFunc();
                        throw runtime.newNameError("Superclass method '" + name + "' disabled.", name);
                    }
                    context.beginCallArgs();
                    args = null;
                    try {
                        args = EvaluationState.setupArgs(context, iVisited.getArgsNode(), self);
                    }
                    finally {
                        context.endCallArgs();
                    }
                    return context.callSuper(args);
                }
                case 85: {
                    iVisited = (SValueNode)node;
                    return EvaluationState.aValueSplat(EvaluationState.evalInternal(context, iVisited.getValue(), self));
                }
                case 86: {
                    iVisited = (SymbolNode)node;
                    return runtime.newSymbol(iVisited.getName());
                }
                case 87: {
                    iVisited = (ToAryNode)node;
                    return EvaluationState.aryToAry(EvaluationState.evalInternal(context, iVisited.getValue(), self));
                }
                case 88: {
                    context.pollThreadEvents();
                    return runtime.getTrue();
                }
                case 89: {
                    iVisited = (UndefNode)node;
                    if (context.getRubyClass() == null) {
                        throw runtime.newTypeError("No class to undef method '" + iVisited.getName() + "'.");
                    }
                    context.getRubyClass().undef(iVisited.getName());
                    return runtime.getNil();
                }
                case 90: {
                    iVisited = (UntilNode)node;
                    result = runtime.getNil();
                    block206: while (!(result = EvaluationState.evalInternal(context, iVisited.getConditionNode(), self)).isTrue()) {
                        block207: while (true) {
                            try {
                                result = EvaluationState.evalInternal(context, iVisited.getBodyNode(), self);
                                continue block206;
                            }
                            catch (JumpException je) {
                                switch (je.getJumpType().getTypeId()) {
                                    case 2: {
                                        continue block207;
                                    }
                                    case 1: {
                                        continue block206;
                                    }
                                    case 0: {
                                        return (IRubyObject)je.getPrimaryData();
                                    }
                                }
                                throw je;
                            }
                            break;
                        }
                    }
                    return result;
                }
                case 91: {
                    iVisited = (VAliasNode)node;
                    runtime.getGlobalVariables().alias(iVisited.getNewName(), iVisited.getOldName());
                    return runtime.getNil();
                }
                case 92: {
                    iVisited = (VCallNode)node;
                    return self.callMethod(context, iVisited.getName(), IRubyObject.NULL_ARRAY, CallType.VARIABLE);
                }
                case 93: {
                    if (!EvaluationState.$assertionsDisabled) {
                        throw new AssertionError();
                    }
                    return null;
                }
                case 94: {
                    iVisited = (WhileNode)node;
                    result = runtime.getNil();
                    firstTest = iVisited.evaluateAtStart();
                    block208: while (!firstTest || (result = EvaluationState.evalInternal(context, iVisited.getConditionNode(), self)).isTrue()) {
                        firstTest = true;
                        block209: while (true) {
                            try {
                                EvaluationState.evalInternal(context, iVisited.getBodyNode(), self);
                                continue block208;
                            }
                            catch (JumpException je) {
                                switch (je.getJumpType().getTypeId()) {
                                    case 2: {
                                        continue block209;
                                    }
                                    case 1: {
                                        continue block208;
                                    }
                                    case 0: {
                                        return result;
                                    }
                                }
                                throw je;
                            }
                            break;
                        }
                    }
                    return result;
                }
                case 95: {
                    iVisited = (XStrNode)node;
                    return self.callMethod(context, "`", runtime.newString(iVisited.getValue()));
                }
                case 96: {
                    iVisited = (YieldNode)node;
                    result = EvaluationState.evalInternal(context, iVisited.getArgsNode(), self);
                    if (iVisited.getArgsNode() == null) {
                        result = null;
                    }
                    return context.yieldCurrentBlock(result, null, null, iVisited.getCheckState());
                }
                case 97: {
                    return runtime.newArray();
                }
                case 99: {
                    if (context.getFrameLastClass() == null) {
                        name = context.getFrameLastFunc();
                        throw runtime.newNameError("superclass method '" + name + "' disabled", name);
                    }
                    return context.callSuper(context.getFrameArgs(), true);
                }
            }
        }
    }

    private static IRubyObject aryToAry(IRubyObject value) {
        if (value instanceof RubyArray) {
            return value;
        }
        if (value.respondsTo("to_ary")) {
            return value.convertToType("Array", "to_ary", false);
        }
        return value.getRuntime().newArray(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static IRubyObject evalClassDefinitionBody(ThreadContext context, StaticScope scope, Node bodyNode, RubyModule type, IRubyObject self) {
        IRuby runtime = context.getRuntime();
        context.preClassEval(scope, type);
        try {
            if (EvaluationState.isTrace(runtime)) {
                EvaluationState.callTraceFunction(context, "class", type);
            }
            IRubyObject iRubyObject = EvaluationState.evalInternal(context, bodyNode, type);
            return iRubyObject;
        }
        finally {
            context.postClassEval();
            if (EvaluationState.isTrace(runtime)) {
                EvaluationState.callTraceFunction(context, "end", null);
            }
        }
    }

    private static boolean isTrace(IRuby runtime) {
        return runtime.getTraceFunction() != null;
    }

    private static void callTraceFunction(ThreadContext context, String event, IRubyObject zelf) {
        IRuby runtime = context.getRuntime();
        String name = context.getFrameLastFunc();
        RubyModule type = context.getFrameLastClass();
        runtime.callTraceFunction(context, event, context.getPosition(), zelf, name, type);
    }

    private static IRubyObject splatValue(IRubyObject value) {
        if (value.isNil()) {
            return value.getRuntime().newArray(value);
        }
        return EvaluationState.arrayValue(value);
    }

    private static IRubyObject aValueSplat(IRubyObject value) {
        IRuby runtime = value.getRuntime();
        if (!(value instanceof RubyArray) || ((RubyArray)value).length().getLongValue() == 0L) {
            return runtime.getNil();
        }
        RubyArray array = (RubyArray)value;
        return array.getLength() == 1 ? array.first(IRubyObject.NULL_ARRAY) : array;
    }

    private static RubyArray arrayValue(IRubyObject value) {
        IRubyObject newValue = value.convertToType("Array", "to_ary", false);
        if (newValue.isNil()) {
            IRuby runtime = value.getRuntime();
            if (value.getType().searchMethod("to_a").getImplementationClass() != runtime.getKernel()) {
                newValue = value.convertToType("Array", "to_a", false);
                if (newValue.getType() != runtime.getClass("Array")) {
                    throw runtime.newTypeError("`to_a' did not return Array");
                }
            } else {
                newValue = runtime.newArray(value);
            }
        }
        return (RubyArray)newValue;
    }

    private static IRubyObject[] setupArgs(ThreadContext context, Node node, IRubyObject self) {
        if (node == null) {
            return IRubyObject.NULL_ARRAY;
        }
        if (node instanceof ArrayNode) {
            ArrayNode argsArrayNode = (ArrayNode)node;
            ISourcePosition position = context.getPosition();
            int size = argsArrayNode.size();
            IRubyObject[] argsArray = new IRubyObject[size];
            ArrayList<IRubyObject> argsList = null;
            boolean hasSplat = false;
            int splatBegins = 0;
            for (int i = 0; i < size; ++i) {
                Node next = argsArrayNode.get(i);
                if (hasSplat) {
                    if (next instanceof SplatNode) {
                        argsList.addAll(((RubyArray)EvaluationState.evalInternal(context, next, self)).getList());
                        continue;
                    }
                    argsList.add(EvaluationState.evalInternal(context, next, self));
                    continue;
                }
                if (next instanceof SplatNode) {
                    argsList = new ArrayList<IRubyObject>();
                    splatBegins = i;
                    hasSplat = true;
                    argsList.addAll(((RubyArray)EvaluationState.evalInternal(context, next, self)).getList());
                    continue;
                }
                argsArray[i] = EvaluationState.evalInternal(context, next, self);
            }
            if (hasSplat) {
                IRubyObject[] argsArray2 = argsList.toArray(new IRubyObject[argsList.size()]);
                IRubyObject[] newArgsArray = new IRubyObject[splatBegins + argsArray2.length];
                System.arraycopy(argsArray, 0, newArgsArray, 0, splatBegins);
                System.arraycopy(argsArray2, 0, newArgsArray, splatBegins, argsArray2.length);
                argsArray = argsArray2;
            }
            context.setPosition(position);
            return argsArray;
        }
        return ArgsUtil.arrayify(EvaluationState.evalInternal(context, node, self));
    }

    private static RubyModule getEnclosingModule(ThreadContext context, Node node, IRubyObject self) {
        RubyModule enclosingModule = null;
        if (node instanceof Colon2Node) {
            IRubyObject result = EvaluationState.evalInternal(context, ((Colon2Node)node).getLeftNode(), self);
            if (result != null && !result.isNil()) {
                enclosingModule = (RubyModule)result;
            }
        } else if (node instanceof Colon3Node) {
            enclosingModule = context.getRuntime().getObject();
        }
        if (enclosingModule == null) {
            enclosingModule = (RubyModule)context.peekCRef().getValue();
        }
        return enclosingModule;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isRescueHandled(ThreadContext context, RubyException currentException, ListNode exceptionNodes, IRubyObject self) {
        IRuby runtime = context.getRuntime();
        if (exceptionNodes == null) {
            return currentException.isKindOf(runtime.getClass("StandardError"));
        }
        context.beginCallArgs();
        IRubyObject[] args = null;
        try {
            args = EvaluationState.setupArgs(context, exceptionNodes, self);
        }
        finally {
            context.endCallArgs();
        }
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].isKindOf(runtime.getClass("Module"))) {
                throw runtime.newTypeError("class or module required for rescue clause");
            }
            if (!args[i].callMethod(context, "===", currentException).isTrue()) continue;
            return true;
        }
        return false;
    }

    static {
        $assertionsDisabled = !EvaluationState.class.desiredAssertionStatus();
    }
}

