/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext;

import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import jline.CandidateListCompletionHandler;
import jline.Completor;
import jline.ConsoleReader;
import jline.FileNameCompletor;
import jline.History;
import org.jruby.IRuby;
import org.jruby.RubyArray;
import org.jruby.RubyModule;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.load.Library;

public class Readline {
    private static ConsoleReader readline;
    private static Completor currentCompletor;
    private static History history;

    public static void createReadline(IRuby runtime) throws IOException {
        history = new History();
        currentCompletor = null;
        RubyModule mReadline = runtime.defineModule("Readline");
        CallbackFactory readlinecb = runtime.callbackFactory(Readline.class);
        mReadline.defineMethod("readline", readlinecb.getSingletonMethod("s_readline", IRubyObject.class, IRubyObject.class));
        mReadline.module_function(new IRubyObject[]{runtime.newSymbol("readline")});
        mReadline.defineMethod("completion_append_character=", readlinecb.getSingletonMethod("s_set_completion_append_character", IRubyObject.class));
        mReadline.module_function(new IRubyObject[]{runtime.newSymbol("completion_append_character=")});
        mReadline.defineMethod("completion_proc=", readlinecb.getSingletonMethod("s_set_completion_proc", IRubyObject.class));
        mReadline.module_function(new IRubyObject[]{runtime.newSymbol("completion_proc=")});
        IRubyObject hist = runtime.getObject().callMethod(runtime.getCurrentContext(), "new");
        mReadline.setConstant("HISTORY", hist);
        hist.defineSingletonMethod("push", readlinecb.getSingletonMethod("s_push", IRubyObject.class));
        hist.defineSingletonMethod("pop", readlinecb.getSingletonMethod("s_pop"));
        hist.defineSingletonMethod("to_a", readlinecb.getSingletonMethod("s_hist_to_a"));
    }

    protected static void initReadline() throws IOException {
        readline = new ConsoleReader();
        readline.setUseHistory(false);
        readline.setUsePagination(true);
        ((CandidateListCompletionHandler)readline.getCompletionHandler()).setAlwaysIncludeNewline(false);
        if (currentCompletor == null) {
            currentCompletor = new RubyFileNameCompletor();
            readline.addCompletor(currentCompletor);
        }
        history = readline.getHistory();
        readline.setHistory(history);
    }

    public static History getHistory() {
        return history;
    }

    public static void setCompletor(Completor completor) {
        if (readline != null) {
            readline.removeCompletor(currentCompletor);
        }
        currentCompletor = completor;
        if (readline != null) {
            readline.addCompletor(currentCompletor);
        }
    }

    public static Completor getCompletor() {
        return currentCompletor;
    }

    public static IRubyObject s_readline(IRubyObject recv, IRubyObject prompt, IRubyObject add_to_hist) throws IOException {
        if (readline == null) {
            Readline.initReadline();
        }
        IRubyObject line = recv.getRuntime().getNil();
        String v = readline.readLine(prompt.toString());
        if (null != v) {
            if (add_to_hist.isTrue()) {
                readline.getHistory().addToHistory(v);
            }
            line = recv.getRuntime().newString(v);
        }
        return line;
    }

    public static IRubyObject s_push(IRubyObject recv, IRubyObject line) throws Exception {
        history.addToHistory(line.toString());
        return recv.getRuntime().getNil();
    }

    public static IRubyObject s_pop(IRubyObject recv) throws Exception {
        return recv.getRuntime().getNil();
    }

    public static IRubyObject s_hist_to_a(IRubyObject recv) throws Exception {
        RubyArray histList = recv.getRuntime().newArray();
        Iterator i = history.getHistoryList().iterator();
        while (i.hasNext()) {
            histList.append(recv.getRuntime().newString((String)i.next()));
        }
        return histList;
    }

    public static IRubyObject s_set_completion_append_character(IRubyObject recv, IRubyObject achar) throws Exception {
        return recv.getRuntime().getNil();
    }

    public static IRubyObject s_set_completion_proc(IRubyObject recv, IRubyObject proc) throws Exception {
        if (!proc.respondsTo("call")) {
            throw recv.getRuntime().newArgumentError("argument must respond to call");
        }
        Readline.setCompletor(new ProcCompletor(proc));
        return recv.getRuntime().getNil();
    }

    public static class RubyFileNameCompletor
    extends FileNameCompletor {
        public int complete(String buffer, int cursor, List candidates) {
            int index = (buffer = buffer.substring(0, cursor)).lastIndexOf(" ");
            if (index != -1) {
                buffer = buffer.substring(index + 1);
            }
            return index + 1 + super.complete(buffer, cursor, candidates);
        }
    }

    public static class ProcCompletor
    implements Completor {
        IRubyObject procCompletor;

        public ProcCompletor(IRubyObject procCompletor) {
            this.procCompletor = procCompletor;
        }

        public int complete(String buffer, int cursor, List candidates) {
            int index = (buffer = buffer.substring(0, cursor)).lastIndexOf(" ");
            if (index != -1) {
                buffer = buffer.substring(index + 1);
            }
            ThreadContext context = this.procCompletor.getRuntime().getCurrentContext();
            IRubyObject comps = this.procCompletor.callMethod(context, "call", new IRubyObject[]{this.procCompletor.getRuntime().newString(buffer)}).callMethod(context, "to_a");
            if (comps instanceof List) {
                Iterator i = ((List)((Object)comps)).iterator();
                while (i.hasNext()) {
                    Object obj = i.next();
                    if (obj == null) continue;
                    candidates.add(obj.toString());
                }
                Collections.sort(candidates);
            }
            return cursor - buffer.length();
        }
    }

    public static class Service
    implements Library {
        public void load(IRuby runtime) throws IOException {
            Readline.createReadline(runtime);
        }
    }
}

