/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.openssl;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.jruby.IRuby;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.ext.openssl.Utils;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.builtin.IRubyObject;

public class Digest
extends RubyObject {
    private MessageDigest md;
    private StringBuffer data = new StringBuffer();
    private String name;

    public static void createDigest(IRuby runtime, RubyModule ossl) {
        RubyModule mDigest = ossl.defineModuleUnder("Digest");
        RubyClass cDigest = mDigest.defineClassUnder("Digest", runtime.getObject());
        mDigest.defineClassUnder("DigestError", ossl.getClass("OpenSSLError"));
        CallbackFactory digestcb = runtime.callbackFactory(Digest.class);
        cDigest.defineSingletonMethod("new", digestcb.getOptSingletonMethod("newInstance"));
        cDigest.defineSingletonMethod("digest", digestcb.getSingletonMethod("s_digest", IRubyObject.class, IRubyObject.class));
        cDigest.defineSingletonMethod("hexdigest", digestcb.getSingletonMethod("s_hexdigest", IRubyObject.class, IRubyObject.class));
        cDigest.defineMethod("initialize", digestcb.getOptMethod("initialize"));
        cDigest.defineMethod("initialize_copy", digestcb.getMethod("initialize_copy", IRubyObject.class));
        cDigest.defineMethod("clone", digestcb.getMethod("rbClone"));
        cDigest.defineMethod("update", digestcb.getMethod("update", IRubyObject.class));
        cDigest.defineMethod("<<", digestcb.getMethod("update", IRubyObject.class));
        cDigest.defineMethod("digest", digestcb.getMethod("digest"));
        cDigest.defineMethod("hexdigest", digestcb.getMethod("hexdigest"));
        cDigest.defineMethod("inspect", digestcb.getMethod("hexdigest"));
        cDigest.defineMethod("to_s", digestcb.getMethod("hexdigest"));
        cDigest.defineMethod("==", digestcb.getMethod("eq", IRubyObject.class));
        cDigest.defineMethod("reset", digestcb.getMethod("reset"));
        cDigest.defineMethod("name", digestcb.getMethod("name"));
        cDigest.defineMethod("size", digestcb.getMethod("size"));
    }

    private static String transformDigest(String inp) {
        String[] sp = inp.split("::");
        if (sp.length > 1) {
            inp = sp[sp.length - 1];
        }
        if ("DSS".equalsIgnoreCase(inp)) {
            return "SHA";
        }
        if ("DSS1".equalsIgnoreCase(inp)) {
            return "SHA1";
        }
        return inp;
    }

    public static IRubyObject newInstance(IRubyObject recv, IRubyObject[] args) {
        Digest result = new Digest(recv.getRuntime(), (RubyClass)recv);
        if (!recv.toString().equals("OpenSSL::Digest::Digest")) {
            try {
                result.name = recv.toString();
                result.md = MessageDigest.getInstance(Digest.transformDigest(recv.toString()));
            }
            catch (NoSuchAlgorithmException e) {
                throw recv.getRuntime().newNotImplementedError("Unsupported digest algorithm (" + recv.toString() + ")");
            }
        }
        result.callInit(args);
        return result;
    }

    public static IRubyObject s_digest(IRubyObject recv, IRubyObject str, IRubyObject data) {
        String name = str.toString();
        try {
            MessageDigest md = MessageDigest.getInstance(Digest.transformDigest(name));
            return recv.getRuntime().newString(new String(md.digest(data.toString().getBytes("PLAIN")), "ISO8859_1"));
        }
        catch (NoSuchAlgorithmException e) {
            throw recv.getRuntime().newNotImplementedError("Unsupported digest algorithm (" + name + ")");
        }
        catch (UnsupportedEncodingException e) {
            throw recv.getRuntime().newNotImplementedError("Unsupported digest algorithm (" + name + ")");
        }
    }

    public static IRubyObject s_hexdigest(IRubyObject recv, IRubyObject str, IRubyObject data) {
        String name = str.toString();
        try {
            MessageDigest md = MessageDigest.getInstance(Digest.transformDigest(name));
            return recv.getRuntime().newString(Utils.toHex(md.digest(data.toString().getBytes("PLAIN"))));
        }
        catch (NoSuchAlgorithmException e) {
            throw recv.getRuntime().newNotImplementedError("Unsupported digest algorithm (" + name + ")");
        }
        catch (UnsupportedEncodingException e) {
            throw recv.getRuntime().newNotImplementedError("Unsupported digest algorithm (" + name + ")");
        }
    }

    public Digest(IRuby runtime, RubyClass type) {
        super(runtime, type);
    }

    public IRubyObject initialize(IRubyObject[] args) {
        IRubyObject data = this.getRuntime().getNil();
        if (this.checkArgumentCount(args, 1, 2) == 2) {
            data = args[1];
        }
        IRubyObject type = args[0];
        this.name = type.toString();
        try {
            this.md = MessageDigest.getInstance(Digest.transformDigest(this.name));
        }
        catch (NoSuchAlgorithmException e) {
            throw this.getRuntime().newNotImplementedError("Unsupported digest algorithm (" + this.name + ")");
        }
        if (!data.isNil()) {
            this.update(data);
        }
        return this;
    }

    public IRubyObject initialize_copy(IRubyObject obj) {
        if (this == obj) {
            return this;
        }
        this.checkFrozen();
        this.data = new StringBuffer(((Digest)obj).data.toString());
        this.name = ((Digest)obj).md.getAlgorithm();
        try {
            this.md = MessageDigest.getInstance(Digest.transformDigest(this.name));
        }
        catch (NoSuchAlgorithmException e) {
            throw this.getRuntime().newNotImplementedError("Unsupported digest algorithm (" + this.name + ")");
        }
        return this;
    }

    public IRubyObject update(IRubyObject obj) {
        try {
            this.data.append(obj);
            this.md.update(obj.toString().getBytes("PLAIN"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return this;
    }

    public IRubyObject reset() {
        this.md.reset();
        this.data = new StringBuffer();
        return this;
    }

    public IRubyObject digest() {
        try {
            this.md.reset();
            return this.getRuntime().newString(new String(this.md.digest(this.data.toString().getBytes("PLAIN")), "ISO8859_1"));
        }
        catch (UnsupportedEncodingException e) {
            return this.getRuntime().getNil();
        }
    }

    public IRubyObject name() {
        return this.getRuntime().newString(this.name);
    }

    public IRubyObject size() {
        return this.getRuntime().newFixnum(this.md.getDigestLength());
    }

    public IRubyObject hexdigest() {
        try {
            this.md.reset();
            return this.getRuntime().newString(Utils.toHex(this.md.digest(this.data.toString().getBytes("PLAIN"))));
        }
        catch (UnsupportedEncodingException e) {
            return this.getRuntime().getNil();
        }
    }

    public IRubyObject eq(IRubyObject oth) {
        boolean ret;
        boolean bl = ret = this == oth;
        if (!ret && oth instanceof Digest) {
            Digest b = (Digest)oth;
            ret = this.md.getAlgorithm().equals(b.md.getAlgorithm()) && this.digest().equals(b.digest());
        }
        return ret ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
    }

    public IRubyObject rbClone() {
        Digest clone = new Digest(this.getRuntime(), this.getMetaClass().getRealClass());
        clone.setMetaClass(this.getMetaClass().getSingletonClassClone());
        clone.setTaint(this.isTaint());
        clone.initCopy(this);
        clone.setFrozen(this.isFrozen());
        return clone;
    }

    String getAlgorithm() {
        return this.md.getAlgorithm();
    }
}

