/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.openssl;

import java.io.UnsupportedEncodingException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.jruby.IRuby;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.ext.openssl.Digest;
import org.jruby.ext.openssl.Utils;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.builtin.IRubyObject;

public class HMAC
extends RubyObject {
    private Mac mac;
    private byte[] key;
    private StringBuffer data = new StringBuffer();

    public static void createHMAC(IRuby runtime, RubyModule ossl) {
        RubyClass cHMAC = ossl.defineClassUnder("HMAC", runtime.getObject());
        ossl.defineClassUnder("HMACError", ossl.getClass("OpenSSLError"));
        CallbackFactory hmaccb = runtime.callbackFactory(HMAC.class);
        cHMAC.defineSingletonMethod("new", hmaccb.getOptSingletonMethod("newInstance"));
        cHMAC.defineSingletonMethod("digest", hmaccb.getSingletonMethod("s_digest", IRubyObject.class, IRubyObject.class, IRubyObject.class));
        cHMAC.defineSingletonMethod("hexdigest", hmaccb.getSingletonMethod("s_hexdigest", IRubyObject.class, IRubyObject.class, IRubyObject.class));
        cHMAC.defineMethod("initialize", hmaccb.getMethod("initialize", IRubyObject.class, IRubyObject.class));
        cHMAC.defineMethod("initialize_copy", hmaccb.getMethod("initialize_copy", IRubyObject.class));
        cHMAC.defineMethod("clone", hmaccb.getMethod("rbClone"));
        cHMAC.defineMethod("update", hmaccb.getMethod("update", IRubyObject.class));
        cHMAC.defineMethod("<<", hmaccb.getMethod("update", IRubyObject.class));
        cHMAC.defineMethod("digest", hmaccb.getMethod("digest"));
        cHMAC.defineMethod("hexdigest", hmaccb.getMethod("hexdigest"));
        cHMAC.defineMethod("inspect", hmaccb.getMethod("hexdigest"));
        cHMAC.defineMethod("to_s", hmaccb.getMethod("hexdigest"));
    }

    public static IRubyObject newInstance(IRubyObject recv, IRubyObject[] args) {
        HMAC result = new HMAC(recv.getRuntime(), (RubyClass)recv);
        result.callInit(args);
        return result;
    }

    public static IRubyObject s_digest(IRubyObject recv, IRubyObject digest, IRubyObject kay, IRubyObject data) {
        String name = "HMAC" + ((Digest)digest).getAlgorithm();
        try {
            Mac mac = Mac.getInstance(name);
            byte[] key = kay.toString().getBytes("PLAIN");
            SecretKeySpec keysp = new SecretKeySpec(key, name);
            mac.init(keysp);
            return recv.getRuntime().newString(new String(mac.doFinal(data.toString().getBytes("PLAIN")), "ISO8859_1"));
        }
        catch (Exception e) {
            throw recv.getRuntime().newNotImplementedError("Unsupported HMAC algorithm (" + name + ")");
        }
    }

    public static IRubyObject s_hexdigest(IRubyObject recv, IRubyObject digest, IRubyObject kay, IRubyObject data) {
        String name = "HMAC" + ((Digest)digest).getAlgorithm();
        try {
            Mac mac = Mac.getInstance(name);
            byte[] key = kay.toString().getBytes("PLAIN");
            SecretKeySpec keysp = new SecretKeySpec(key, name);
            mac.init(keysp);
            return recv.getRuntime().newString(Utils.toHex(mac.doFinal(data.toString().getBytes("PLAIN"))));
        }
        catch (Exception e) {
            throw recv.getRuntime().newNotImplementedError("Unsupported HMAC algorithm (" + name + ")");
        }
    }

    public HMAC(IRuby runtime, RubyClass type) {
        super(runtime, type);
    }

    public IRubyObject initialize(IRubyObject kay, IRubyObject digest) {
        String name = "HMAC" + ((Digest)digest).getAlgorithm();
        try {
            this.mac = Mac.getInstance(name);
            this.key = kay.toString().getBytes("PLAIN");
            SecretKeySpec keysp = new SecretKeySpec(this.key, name);
            this.mac.init(keysp);
        }
        catch (Exception e) {
            throw this.getRuntime().newNotImplementedError("Unsupported MAC algorithm (" + name + ")");
        }
        return this;
    }

    public IRubyObject initialize_copy(IRubyObject obj) {
        if (this == obj) {
            return this;
        }
        this.checkFrozen();
        String name = ((HMAC)obj).mac.getAlgorithm();
        try {
            this.mac = Mac.getInstance(name);
            this.key = ((HMAC)obj).key;
            SecretKeySpec keysp = new SecretKeySpec(this.key, name);
            this.mac.init(keysp);
        }
        catch (Exception e) {
            throw this.getRuntime().newNotImplementedError("Unsupported MAC algorithm (" + name + ")");
        }
        this.data = new StringBuffer(((HMAC)obj).data.toString());
        return this;
    }

    public IRubyObject update(IRubyObject obj) {
        this.data.append(obj);
        return this;
    }

    public IRubyObject digest() {
        try {
            this.mac.reset();
            return this.getRuntime().newString(new String(this.mac.doFinal(this.data.toString().getBytes("PLAIN")), "ISO8859_1"));
        }
        catch (UnsupportedEncodingException e) {
            return this.getRuntime().getNil();
        }
    }

    public IRubyObject hexdigest() {
        try {
            this.mac.reset();
            return this.getRuntime().newString(Utils.toHex(this.mac.doFinal(this.data.toString().getBytes("PLAIN"))));
        }
        catch (UnsupportedEncodingException e) {
            return this.getRuntime().getNil();
        }
    }

    public IRubyObject rbClone() {
        HMAC clone = new HMAC(this.getRuntime(), this.getMetaClass().getRealClass());
        clone.setMetaClass(this.getMetaClass().getSingletonClassClone());
        clone.setTaint(this.isTaint());
        clone.initCopy(this);
        clone.setFrozen(this.isFrozen());
        return clone;
    }

    String getAlgorithm() {
        return this.mac.getAlgorithm();
    }
}

