/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.openssl;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.jruby.IRuby;
import org.jruby.RubyModule;
import org.jruby.ext.openssl.ASN1;
import org.jruby.ext.openssl.Cipher;
import org.jruby.ext.openssl.Config;
import org.jruby.ext.openssl.Digest;
import org.jruby.ext.openssl.HMAC;
import org.jruby.ext.openssl.NetscapeSPKI;
import org.jruby.ext.openssl.PKCS7;
import org.jruby.ext.openssl.PKey;
import org.jruby.ext.openssl.Random;
import org.jruby.ext.openssl.SSL;
import org.jruby.ext.openssl.X509;

public class OpenSSLReal {
    public static void createOpenSSL(IRuby runtime) {
        RubyModule ossl = runtime.defineModule("OpenSSL");
        ossl.defineClassUnder("OpenSSLError", runtime.getClass("StandardError"));
        ASN1.createASN1(runtime, ossl);
        Digest.createDigest(runtime, ossl);
        Cipher.createCipher(runtime, ossl);
        Random.createRandom(runtime, ossl);
        PKey.createPKey(runtime, ossl);
        HMAC.createHMAC(runtime, ossl);
        X509.createX509(runtime, ossl);
        Config.createConfig(runtime, ossl);
        NetscapeSPKI.createNetscapeSPKI(runtime, ossl);
        PKCS7.createPKCS7(runtime, ossl);
        SSL.createSSL(runtime, ossl);
        ossl.setConstant("VERSION", runtime.newString("1.0.0"));
        ossl.setConstant("OPENSSL_VERSION", runtime.newString("OpenSSL 0.9.8b 04 May 2006 (Java fake)"));
        try {
            MessageDigest.getInstance("SHA224");
            ossl.setConstant("OPENSSL_VERSION_NUMBER", runtime.newFixnum(9469999L));
        }
        catch (NoSuchAlgorithmException e) {
            ossl.setConstant("OPENSSL_VERSION_NUMBER", runtime.newFixnum(0x908000L));
        }
    }
}

