/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.openssl;

import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.DSAParams;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.DSAPublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DEREncodableVector;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DERSequence;
import org.jruby.IRuby;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyModule;
import org.jruby.exceptions.RaiseException;
import org.jruby.ext.openssl.Cipher;
import org.jruby.ext.openssl.PKey;
import org.jruby.ext.openssl.x509store.PEM;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.builtin.IRubyObject;

public class PKeyDSA
extends PKey {
    private DSAPrivateKey privKey;
    private DSAPublicKey pubKey;

    public static void createPKeyDSA(IRuby runtime, RubyModule mPKey) {
        RubyClass cDSA = mPKey.defineClassUnder("DSA", mPKey.getClass("PKey"));
        mPKey.defineClassUnder("DSAError", mPKey.getClass("PKeyError"));
        CallbackFactory dsacb = runtime.callbackFactory(PKeyDSA.class);
        cDSA.defineSingletonMethod("new", dsacb.getOptSingletonMethod("newInstance"));
        cDSA.defineMethod("initialize", dsacb.getOptMethod("initialize"));
        cDSA.defineMethod("public?", dsacb.getMethod("public_p"));
        cDSA.defineMethod("private?", dsacb.getMethod("private_p"));
        cDSA.defineMethod("to_der", dsacb.getMethod("to_der"));
        cDSA.defineMethod("to_text", dsacb.getMethod("to_text"));
        cDSA.defineMethod("public_key", dsacb.getMethod("public_key"));
        cDSA.defineMethod("export", dsacb.getOptMethod("export"));
        cDSA.defineMethod("to_pem", dsacb.getOptMethod("export"));
        cDSA.defineMethod("to_s", dsacb.getOptMethod("export"));
        cDSA.defineMethod("syssign", dsacb.getMethod("syssign", IRubyObject.class));
        cDSA.defineMethod("sysverify", dsacb.getMethod("sysverify", IRubyObject.class, IRubyObject.class));
    }

    public static IRubyObject newInstance(IRubyObject recv, IRubyObject[] args) {
        PKeyDSA result = new PKeyDSA(recv.getRuntime(), (RubyClass)recv);
        result.callInit(args);
        return result;
    }

    public PKeyDSA(IRuby runtime, RubyClass type) {
        super(runtime, type);
    }

    PublicKey getPublicKey() {
        return this.pubKey;
    }

    PrivateKey getPrivateKey() {
        return this.privKey;
    }

    String getAlgorithm() {
        return "DSA";
    }

    public IRubyObject initialize(IRubyObject[] args) {
        IRubyObject pass = null;
        char[] passwd = null;
        if (this.checkArgumentCount(args, 0, 2) == 0) {
            Object rsa = null;
        } else {
            IRubyObject arg = args[0];
            if (args.length > 1) {
                pass = args[1];
            }
            if (!(arg instanceof RubyFixnum)) {
                if (pass != null && !pass.isNil()) {
                    passwd = pass.toString().toCharArray();
                }
                String input = arg.toString();
                Serializable val = null;
                KeyFactory fact = null;
                try {
                    fact = KeyFactory.getInstance("DSA");
                }
                catch (Exception e) {
                    throw this.getRuntime().newLoadError("unsupported key algorithm (DSA)");
                }
                if (null == val) {
                    try {
                        val = PEM.read_DSAPrivateKey(new StringReader(input), passwd);
                    }
                    catch (Exception e3) {
                        val = null;
                    }
                }
                if (null == val) {
                    try {
                        val = PEM.read_DSAPublicKey(new StringReader(input), passwd);
                    }
                    catch (Exception e3) {
                        val = null;
                    }
                }
                if (null == val) {
                    try {
                        val = PEM.read_DSA_PUBKEY(new StringReader(input), passwd);
                    }
                    catch (Exception e3) {
                        val = null;
                    }
                }
                if (null == val) {
                    try {
                        val = fact.generatePrivate(new PKCS8EncodedKeySpec(input.getBytes("PLAIN")));
                    }
                    catch (Exception e) {
                        val = null;
                    }
                }
                if (null == val) {
                    try {
                        val = fact.generatePublic(new X509EncodedKeySpec(input.getBytes("PLAIN")));
                    }
                    catch (Exception e) {
                        val = null;
                    }
                }
                if (null == val) {
                    throw new RaiseException(this.getRuntime(), (RubyClass)((RubyModule)this.getRuntime().getModule("OpenSSL").getConstant("PKey")).getConstant("DSAError"), "Neither PUB key nor PRIV key:", true);
                }
                if (val instanceof KeyPair) {
                    this.privKey = (DSAPrivateKey)((KeyPair)val).getPrivate();
                    this.pubKey = (DSAPublicKey)((KeyPair)val).getPublic();
                } else if (val instanceof DSAPrivateKey) {
                    this.privKey = (DSAPrivateKey)val;
                } else if (val instanceof DSAPublicKey) {
                    this.pubKey = (DSAPublicKey)val;
                    this.privKey = null;
                } else {
                    throw new RaiseException(this.getRuntime(), (RubyClass)((RubyModule)this.getRuntime().getModule("OpenSSL").getConstant("PKey")).getConstant("DSAError"), "Neither PUB key nor PRIV key:", true);
                }
            }
        }
        return this;
    }

    public IRubyObject public_p() {
        return this.pubKey != null ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
    }

    public IRubyObject private_p() {
        return this.privKey != null ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
    }

    public IRubyObject to_der() throws Exception {
        if (this.pubKey != null && this.privKey == null) {
            return this.getRuntime().newString(new String(this.pubKey.getEncoded(), "ISO8859_1"));
        }
        if (this.privKey != null && this.pubKey != null) {
            DSAParams params = this.privKey.getParams();
            ASN1EncodableVector v1 = new ASN1EncodableVector();
            v1.add((DEREncodable)new DERInteger(0));
            v1.add((DEREncodable)new DERInteger(params.getP()));
            v1.add((DEREncodable)new DERInteger(params.getQ()));
            v1.add((DEREncodable)new DERInteger(params.getG()));
            v1.add((DEREncodable)new DERInteger(this.pubKey.getY()));
            v1.add((DEREncodable)new DERInteger(this.privKey.getX()));
            return this.getRuntime().newString(new String(new DERSequence((DEREncodableVector)v1).getEncoded(), "ISO8859_1"));
        }
        return this.getRuntime().newString(new String(this.privKey.getEncoded(), "ISO8859_1"));
    }

    public IRubyObject to_text() throws Exception {
        return this.getRuntime().getNil();
    }

    public IRubyObject public_key() {
        PKeyDSA val = new PKeyDSA(this.getRuntime(), this.getMetaClass().getRealClass());
        val.privKey = null;
        val.pubKey = this.pubKey;
        return val;
    }

    public IRubyObject export(IRubyObject[] args) throws Exception {
        StringWriter w = new StringWriter();
        this.checkArgumentCount(args, 0, 2);
        char[] passwd = null;
        String algo = null;
        if (args.length > 0 && !args[0].isNil()) {
            algo = ((Cipher)args[0]).getAlgorithm();
            if (args.length > 1 && !args[1].isNil()) {
                passwd = args[1].toString().toCharArray();
            }
        }
        if (this.privKey != null) {
            PEM.write_DSAPrivateKey(w, this.privKey, algo, passwd);
        } else {
            PEM.write_DSAPublicKey(w, this.pubKey);
        }
        w.close();
        return this.getRuntime().newString(w.toString());
    }

    private String getPadding(int padding) {
        if (padding < 1 || padding > 4) {
            throw new RaiseException(this.getRuntime(), (RubyClass)((RubyModule)this.getRuntime().getModule("OpenSSL").getConstant("PKey")).getConstant("DSAError"), null, true);
        }
        String p = "/NONE/PKCS1Padding";
        if (padding == 3) {
            p = "/NONE/NoPadding";
        } else if (padding == 4) {
            p = "/NONE/OAEPWithMD5AndMGF1Padding";
        } else if (padding == 2) {
            p = "/NONE/ISO9796-1Padding";
        }
        return p;
    }

    public IRubyObject syssign(IRubyObject arg) {
        return this.getRuntime().getNil();
    }

    public IRubyObject sysverify(IRubyObject arg, IRubyObject arg2) {
        return this.getRuntime().getNil();
    }
}

