/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.openssl;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DEREncodableVector;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.DERString;
import org.jruby.IRuby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.exceptions.RaiseException;
import org.jruby.ext.openssl.ASN1;
import org.jruby.ext.openssl.Attribute;
import org.jruby.ext.openssl.Digest;
import org.jruby.ext.openssl.PKCS10CertificationRequestExt;
import org.jruby.ext.openssl.PKey;
import org.jruby.ext.openssl.X509Name;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class Request
extends RubyObject {
    private IRubyObject version;
    private IRubyObject subject;
    private IRubyObject public_key;
    private boolean valid = false;
    private List attrs = new ArrayList();
    private PKCS10CertificationRequestExt req;

    public static void createRequest(IRuby runtime, RubyModule mX509) {
        RubyClass cRequest = mX509.defineClassUnder("Request", runtime.getObject());
        mX509.defineClassUnder("RequestError", runtime.getModule("OpenSSL").getClass("OpenSSLError"));
        CallbackFactory reqcb = runtime.callbackFactory(Request.class);
        cRequest.defineSingletonMethod("new", reqcb.getOptSingletonMethod("newInstance"));
        cRequest.defineMethod("initialize", reqcb.getOptMethod("_initialize"));
        cRequest.defineMethod("initialize_copy", reqcb.getMethod("initialize_copy", IRubyObject.class));
        cRequest.defineMethod("clone", reqcb.getMethod("rbClone"));
        cRequest.defineMethod("to_pem", reqcb.getMethod("to_pem"));
        cRequest.defineMethod("to_der", reqcb.getMethod("to_der"));
        cRequest.defineMethod("to_s", reqcb.getMethod("to_pem"));
        cRequest.defineMethod("to_text", reqcb.getMethod("to_text"));
        cRequest.defineMethod("version", reqcb.getMethod("version"));
        cRequest.defineMethod("version=", reqcb.getMethod("set_version", IRubyObject.class));
        cRequest.defineMethod("subject", reqcb.getMethod("subject"));
        cRequest.defineMethod("subject=", reqcb.getMethod("set_subject", IRubyObject.class));
        cRequest.defineMethod("signature_algorithm", reqcb.getMethod("signature_algorithm"));
        cRequest.defineMethod("public_key", reqcb.getMethod("public_key"));
        cRequest.defineMethod("public_key=", reqcb.getMethod("set_public_key", IRubyObject.class));
        cRequest.defineMethod("sign", reqcb.getMethod("sign", IRubyObject.class, IRubyObject.class));
        cRequest.defineMethod("verify", reqcb.getMethod("verify", IRubyObject.class));
        cRequest.defineMethod("attributes", reqcb.getMethod("attributes"));
        cRequest.defineMethod("attributes=", reqcb.getMethod("set_attributes", IRubyObject.class));
        cRequest.defineMethod("add_attribute", reqcb.getMethod("add_attribute", IRubyObject.class));
    }

    public static IRubyObject newInstance(IRubyObject recv, IRubyObject[] args) {
        Request result = new Request(recv.getRuntime(), (RubyClass)recv);
        result.callInit(args);
        return result;
    }

    public Request(IRuby runtime, RubyClass type) {
        super(runtime, type);
    }

    public IRubyObject _initialize(IRubyObject[] args) throws Exception {
        if (this.checkArgumentCount(args, 0, 1) == 0) {
            return this;
        }
        this.req = new PKCS10CertificationRequestExt(args[0].toString().getBytes("PLAIN"));
        this.version = this.getRuntime().newFixnum(this.req.getVersion());
        String algo = this.req.getPublicKey().getAlgorithm();
        byte[] enc = this.req.getPublicKey().getEncoded();
        ThreadContext tc = this.getRuntime().getCurrentContext();
        if ("RSA".equalsIgnoreCase(algo)) {
            this.public_key = ((RubyModule)this.getRuntime().getModule("OpenSSL").getConstant("PKey")).getClass("RSA").callMethod(tc, "new", this.getRuntime().newString(new String(enc, "ISO8859_1")));
        } else if ("DSA".equalsIgnoreCase(algo)) {
            this.public_key = ((RubyModule)this.getRuntime().getModule("OpenSSL").getConstant("PKey")).getClass("DSA").callMethod(tc, "new", this.getRuntime().newString(new String(enc, "ISO8859_1")));
        } else {
            throw this.getRuntime().newLoadError("not implemented algo for public key: " + algo);
        }
        org.bouncycastle.asn1.x509.X509Name subName = this.req.getCertificationRequestInfo().getSubject();
        this.subject = ((RubyModule)this.getRuntime().getModule("OpenSSL").getConstant("X509")).getClass("Name").callMethod(tc, "new");
        DERSequence subNameD = (DERSequence)subName.toASN1Object();
        for (int i = 0; i < subNameD.size(); ++i) {
            DERSequence internal = (DERSequence)((DERSet)subNameD.getObjectAt(i)).getObjectAt(0);
            DEREncodable oid = internal.getObjectAt(0);
            String v = null;
            if (internal.getObjectAt(1) instanceof DERString) {
                v = ((DERString)internal.getObjectAt(1)).getString();
            }
            RubyFixnum t = this.getRuntime().newFixnum(ASN1.idForClass(internal.getObjectAt(1).getClass()));
            ((X509Name)this.subject).addEntry(oid, v, t);
        }
        ASN1Set in_attrs = this.req.getCertificationRequestInfo().getAttributes();
        Enumeration enm = in_attrs.getObjects();
        while (enm.hasMoreElements()) {
            DERSet obj = (DERSet)enm.nextElement();
            Enumeration enm2 = obj.getObjects();
            while (enm2.hasMoreElements()) {
                DERSequence val = (DERSequence)enm2.nextElement();
                DERObjectIdentifier v0 = (DERObjectIdentifier)val.getObjectAt(0);
                DERObject v1 = (DERObject)val.getObjectAt(1);
                RubyString a1 = this.getRuntime().newString((String)ASN1.getSymLookup(this.getRuntime()).get(v0));
                IRubyObject a2 = ASN1.decode(this.getRuntime().getModule("OpenSSL").getConstant("ASN1"), this.getRuntime().newString(new String(v1.getDEREncoded(), "ISO8859_1")));
                this.add_attribute(((RubyModule)this.getRuntime().getModule("OpenSSL").getConstant("X509")).getConstant("Attribute").callMethod(tc, "new", new IRubyObject[]{a1, a2}));
            }
        }
        this.valid = true;
        return this;
    }

    public IRubyObject initialize_copy(IRubyObject obj) {
        System.err.println("WARNING: unimplemented method called: init_copy");
        if (this == obj) {
            return this;
        }
        this.checkFrozen();
        this.version = this.getRuntime().getNil();
        this.subject = this.getRuntime().getNil();
        this.public_key = this.getRuntime().getNil();
        return this;
    }

    public IRubyObject to_pem() {
        System.err.println("WARNING: unimplemented method called: to_pem");
        return this.getRuntime().getNil();
    }

    public IRubyObject to_der() throws Exception {
        return this.getRuntime().newString(new String(this.req.getDEREncoded(), "ISO8859_1"));
    }

    public IRubyObject to_text() {
        System.err.println("WARNING: unimplemented method called: to_text");
        return this.getRuntime().getNil();
    }

    public IRubyObject version() {
        return this.version;
    }

    public IRubyObject set_version(IRubyObject val) {
        if (val != this.version) {
            this.valid = false;
        }
        this.version = val;
        if (!val.isNil() && this.req != null) {
            this.req.setVersion(RubyNumeric.fix2int(val));
        }
        return val;
    }

    public IRubyObject subject() {
        return this.subject;
    }

    public IRubyObject set_subject(IRubyObject val) {
        if (val != this.subject) {
            this.valid = false;
        }
        this.subject = val;
        return val;
    }

    public IRubyObject signature_algorithm() {
        System.err.println("WARNING: unimplemented method called: signature_algorithm");
        return this.getRuntime().getNil();
    }

    public IRubyObject public_key() {
        return this.public_key;
    }

    public IRubyObject set_public_key(IRubyObject val) {
        if (val != this.public_key) {
            this.valid = false;
        }
        this.public_key = val;
        return val;
    }

    public IRubyObject sign(IRubyObject key, IRubyObject digest) throws Exception {
        String keyAlg = ((PKey)this.public_key).getAlgorithm();
        String digAlg = ((Digest)digest).getAlgorithm();
        if ("DSA".equalsIgnoreCase(keyAlg) && "MD5".equalsIgnoreCase(digAlg) || "RSA".equalsIgnoreCase(keyAlg) && "DSS1".equals(((Digest)digest).name().toString()) || "DSA".equalsIgnoreCase(keyAlg) && "SHA1".equals(((Digest)digest).name().toString())) {
            throw new RaiseException(this.getRuntime(), (RubyClass)((RubyModule)this.getRuntime().getModule("OpenSSL").getConstant("X509")).getConstant("RequestError"), null, true);
        }
        ASN1EncodableVector v1 = new ASN1EncodableVector();
        Iterator iter = this.attrs.iterator();
        while (iter.hasNext()) {
            v1.add((DEREncodable)((Attribute)iter.next()).toASN1());
        }
        this.req = new PKCS10CertificationRequestExt(digAlg + "WITH" + keyAlg, ((X509Name)this.subject).getRealName(), ((PKey)this.public_key).getPublicKey(), (ASN1Set)new DERSet((DEREncodableVector)v1), ((PKey)key).getPrivateKey());
        this.req.setVersion(RubyNumeric.fix2int(this.version));
        this.valid = true;
        return this;
    }

    public IRubyObject verify(IRubyObject key) {
        try {
            return this.valid && this.req.verify(((PKey)key.callMethod(this.getRuntime().getCurrentContext(), "public_key")).getPublicKey()) ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
        }
        catch (Exception e) {
            return this.getRuntime().getFalse();
        }
    }

    public IRubyObject attributes() {
        return this.getRuntime().newArray(this.attrs);
    }

    public IRubyObject set_attributes(IRubyObject val) throws Exception {
        this.valid = false;
        this.attrs.clear();
        this.attrs.addAll(((RubyArray)val).getList());
        if (this.req != null) {
            ASN1EncodableVector v1 = new ASN1EncodableVector();
            Iterator iter = this.attrs.iterator();
            while (iter.hasNext()) {
                v1.add((DEREncodable)((Attribute)iter.next()).toASN1());
            }
            this.req.setAttributes(new DERSet((DEREncodableVector)v1));
        }
        return val;
    }

    public IRubyObject add_attribute(IRubyObject val) throws Exception {
        this.valid = false;
        this.attrs.add(val);
        if (this.req != null) {
            ASN1EncodableVector v1 = new ASN1EncodableVector();
            Iterator iter = this.attrs.iterator();
            while (iter.hasNext()) {
                v1.add((DEREncodable)((Attribute)iter.next()).toASN1());
            }
            this.req.setAttributes(new DERSet((DEREncodableVector)v1));
        }
        return this.getRuntime().getNil();
    }

    public IRubyObject rbClone() {
        Request clone = new Request(this.getRuntime(), this.getMetaClass().getRealClass());
        clone.setMetaClass(this.getMetaClass().getSingletonClassClone());
        clone.setTaint(this.isTaint());
        clone.initCopy(this);
        clone.setFrozen(this.isFrozen());
        return clone;
    }
}

