/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.openssl;

import java.net.Socket;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.X509ExtendedKeyManager;
import javax.net.ssl.X509TrustManager;
import org.jruby.IRuby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.ext.openssl.PKey;
import org.jruby.ext.openssl.X509Cert;
import org.jruby.ext.openssl.X509Store;
import org.jruby.ext.openssl.x509store.X509AuxCertificate;
import org.jruby.ext.openssl.x509store.X509_STORE;
import org.jruby.ext.openssl.x509store.X509_STORE_CTX;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.builtin.IRubyObject;

public class SSLContext
extends RubyObject {
    private static final String[] ctx_attrs = new String[]{"cert", "key", "client_ca", "ca_file", "ca_path", "timeout", "verify_mode", "verify_depth", "verify_callback", "options", "cert_store", "extra_chain_cert", "client_cert_cb", "tmp_dh_callback", "session_id_context"};
    private IRubyObject ciphers;
    private PKey t_key = null;
    private X509Cert t_cert = null;
    private X509Certificate peer_cert;

    public static void createSSLContext(IRuby runtime, RubyModule mSSL) {
        RubyClass cSSLContext = mSSL.defineClassUnder("SSLContext", runtime.getObject());
        for (int i = 0; i < ctx_attrs.length; ++i) {
            cSSLContext.attr_accessor(new IRubyObject[]{runtime.newSymbol(ctx_attrs[i])});
        }
        CallbackFactory ctxcb = runtime.callbackFactory(SSLContext.class);
        cSSLContext.defineSingletonMethod("new", ctxcb.getOptSingletonMethod("newInstance"));
        cSSLContext.defineMethod("initialize", ctxcb.getOptMethod("initialize"));
        cSSLContext.defineMethod("ciphers", ctxcb.getMethod("ciphers"));
        cSSLContext.defineMethod("ciphers=", ctxcb.getMethod("set_ciphers", IRubyObject.class));
    }

    public static IRubyObject newInstance(IRubyObject recv, IRubyObject[] args) {
        SSLContext result = new SSLContext(recv.getRuntime(), (RubyClass)recv);
        result.callInit(args);
        return result;
    }

    public SSLContext(IRuby runtime, RubyClass type) {
        super(runtime, type);
    }

    public void setPeer(X509Certificate p) {
        this.peer_cert = p;
    }

    public X509Certificate getPeer() {
        return this.peer_cert;
    }

    private void initFromCallback(IRubyObject cb) {
        IRubyObject out = cb.callMethod(this.getRuntime().getCurrentContext(), "call", this);
        this.t_cert = (X509Cert)((RubyArray)out).getList().get(0);
        this.t_key = (PKey)((RubyArray)out).getList().get(1);
    }

    public PKey getCallbackKey() {
        IRubyObject cb = this.callMethod(this.getRuntime().getCurrentContext(), "client_cert_cb");
        if (this.t_key == null && !cb.isNil()) {
            this.initFromCallback(cb);
        }
        return this.t_key;
    }

    public X509Cert getCallbackCert() {
        IRubyObject cb = this.callMethod(this.getRuntime().getCurrentContext(), "client_cert_cb");
        if (this.t_cert == null && !cb.isNil()) {
            this.initFromCallback(cb);
        }
        return this.t_cert;
    }

    public IRubyObject initialize(IRubyObject[] args) {
        this.ciphers = this.getRuntime().getNil();
        return this;
    }

    public IRubyObject ciphers() {
        return this.ciphers;
    }

    public IRubyObject set_ciphers(IRubyObject val) {
        this.ciphers = val;
        return val;
    }

    String[] getCipherSuites(SSLEngine engine) {
        ArrayList ciphs = new ArrayList();
        if (this.ciphers.isNil()) {
            return engine.getSupportedCipherSuites();
        }
        if (this.ciphers instanceof RubyArray) {
            Iterator iter = ((RubyArray)this.ciphers).getList().iterator();
            while (iter.hasNext()) {
                this.addCipher(ciphs, iter.next().toString(), engine);
            }
        } else {
            this.addCipher(ciphs, this.ciphers.toString(), engine);
        }
        return ciphs.toArray(new String[ciphs.size()]);
    }

    private void addCipher(List lst, String cipher, SSLEngine engine) {
        String[] supported = engine.getSupportedCipherSuites();
        if ("ADH".equals(cipher)) {
            for (int i = 0; i < supported.length; ++i) {
                if (supported[i].indexOf("DH_anon") == -1) continue;
                lst.add(supported[i]);
            }
        } else {
            for (int i = 0; i < supported.length; ++i) {
                if (supported[i].indexOf(cipher) == -1) continue;
                lst.add(supported[i]);
            }
        }
    }

    public KM getKM() {
        return new KM(this);
    }

    public TM getTM() {
        return new TM(this);
    }

    private static class TM
    implements X509TrustManager {
        private SSLContext ctt;

        public TM(SSLContext ctt) {
            this.ctt = ctt;
        }

        public void checkClientTrusted(X509Certificate[] chain, String authType) {
            if (chain != null && chain.length > 0) {
                this.ctt.setPeer(chain[0]);
            }
        }

        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            if (this.ctt.callMethod(this.ctt.getRuntime().getCurrentContext(), "verify_mode").isNil()) {
                if (chain != null && chain.length > 0) {
                    this.ctt.setPeer(chain[0]);
                }
                return;
            }
            int verify_mode = RubyNumeric.fix2int(this.ctt.callMethod(this.ctt.getRuntime().getCurrentContext(), "verify_mode"));
            if (chain != null && chain.length > 0) {
                this.ctt.setPeer(chain[0]);
                if ((verify_mode & 1) != 0) {
                    X509AuxCertificate x = X509_STORE_CTX.transform(chain[0]);
                    X509_STORE_CTX ctx = new X509_STORE_CTX();
                    IRubyObject str = this.ctt.callMethod(this.ctt.getRuntime().getCurrentContext(), "cert_store");
                    X509_STORE store = null;
                    if (!str.isNil()) {
                        store = ((X509Store)str).getStore();
                    }
                    if (ctx.init(store, x, X509_STORE_CTX.transform(chain)) == 0) {
                        throw new CertificateException("couldn't initialize store");
                    }
                    ctx.set_default("ssl_client");
                    try {
                        if (ctx.verify_cert() == 0) {
                            throw new CertificateException("certificate verify failed");
                        }
                    }
                    catch (Exception e) {
                        throw new CertificateException("certificate verify failed");
                    }
                }
            } else if ((verify_mode & 2) != 0) {
                throw new CertificateException("no peer certificate");
            }
        }

        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }
    }

    private static class KM
    extends X509ExtendedKeyManager {
        private SSLContext ctt;

        public KM(SSLContext ctt) {
            this.ctt = ctt;
        }

        public String chooseEngineClientAlias(String[] keyType, Principal[] issuers, SSLEngine engine) {
            PKey k = null;
            k = !this.ctt.callMethod(this.ctt.getRuntime().getCurrentContext(), "key").isNil() ? (PKey)this.ctt.callMethod(this.ctt.getRuntime().getCurrentContext(), "key") : this.ctt.getCallbackKey();
            if (k == null) {
                return null;
            }
            for (int i = 0; i < keyType.length; ++i) {
                if (!keyType[i].equalsIgnoreCase(k.getAlgorithm())) continue;
                return keyType[i];
            }
            return null;
        }

        public String chooseEngineServerAlias(String keyType, Principal[] issuers, SSLEngine engine) {
            PKey k = null;
            k = !this.ctt.callMethod(this.ctt.getRuntime().getCurrentContext(), "key").isNil() ? (PKey)this.ctt.callMethod(this.ctt.getRuntime().getCurrentContext(), "key") : this.ctt.getCallbackKey();
            if (k == null) {
                return null;
            }
            if (keyType.equalsIgnoreCase(k.getAlgorithm())) {
                return keyType;
            }
            return null;
        }

        public String chooseClientAlias(String[] keyType, Principal[] issuers, Socket socket) {
            return null;
        }

        public String chooseServerAlias(String keyType, Principal[] issuers, Socket socket) {
            return null;
        }

        public X509Certificate[] getCertificateChain(String alias) {
            X509Cert c = null;
            c = !this.ctt.callMethod(this.ctt.getRuntime().getCurrentContext(), "cert").isNil() ? (X509Cert)this.ctt.callMethod(this.ctt.getRuntime().getCurrentContext(), "cert") : this.ctt.getCallbackCert();
            if (c == null) {
                return null;
            }
            return new X509Certificate[]{c.getAuxCert()};
        }

        public String[] getClientAliases(String keyType, Principal[] issuers) {
            return null;
        }

        public PrivateKey getPrivateKey(String alias) {
            PKey k = null;
            k = !this.ctt.callMethod(this.ctt.getRuntime().getCurrentContext(), "key").isNil() ? (PKey)this.ctt.callMethod(this.ctt.getRuntime().getCurrentContext(), "key") : this.ctt.getCallbackKey();
            if (k == null) {
                return null;
            }
            return k.getPrivateKey();
        }

        public String[] getServerAliases(String keyType, Principal[] issuers) {
            return null;
        }
    }
}

