/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.openssl;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.Iterator;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import org.jruby.IRuby;
import org.jruby.RubyClass;
import org.jruby.RubyIO;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.exceptions.RaiseException;
import org.jruby.ext.openssl.SSLContext;
import org.jruby.ext.openssl.X509Cert;
import org.jruby.ext.openssl.X509Store;
import org.jruby.runtime.CallType;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class SSLSocket
extends RubyObject {
    private RubyClass sslError;
    private SSLEngine engine;
    private SocketChannel c = null;
    private ByteBuffer peerAppData;
    private ByteBuffer peerNetData;
    private ByteBuffer netData;
    private ByteBuffer dummy;
    private boolean initialHandshake = false;
    private SSLEngineResult.HandshakeStatus hsStatus;
    private SSLEngineResult.Status status = null;
    private String type = null;
    private Selector rsel;
    private Selector wsel;
    private Selector asel;
    static final /* synthetic */ boolean $assertionsDisabled;

    public static void createSSLSocket(IRuby runtime, RubyModule mSSL) {
        RubyClass cSSLSocket = mSSL.defineClassUnder("SSLSocket", runtime.getObject());
        cSSLSocket.attr_accessor(new IRubyObject[]{runtime.newSymbol("io")});
        cSSLSocket.attr_accessor(new IRubyObject[]{runtime.newSymbol("context")});
        cSSLSocket.attr_accessor(new IRubyObject[]{runtime.newSymbol("sync_close")});
        CallbackFactory sockcb = runtime.callbackFactory(SSLSocket.class);
        cSSLSocket.defineSingletonMethod("new", sockcb.getOptSingletonMethod("newInstance"));
        cSSLSocket.defineAlias("to_io", "io");
        cSSLSocket.defineMethod("initialize", sockcb.getOptMethod("_initialize"));
        cSSLSocket.defineMethod("connect", sockcb.getMethod("connect"));
        cSSLSocket.defineMethod("accept", sockcb.getMethod("accept"));
        cSSLSocket.defineMethod("sysread", sockcb.getOptMethod("sysread"));
        cSSLSocket.defineMethod("syswrite", sockcb.getMethod("syswrite", IRubyObject.class));
        cSSLSocket.defineMethod("sysclose", sockcb.getMethod("sysclose"));
        cSSLSocket.defineMethod("cert", sockcb.getMethod("cert"));
        cSSLSocket.defineMethod("peer_cert", sockcb.getMethod("peer_cert"));
        cSSLSocket.defineMethod("peer_cert_chain", sockcb.getMethod("peer_cert_chain"));
        cSSLSocket.defineMethod("cipher", sockcb.getMethod("cipher"));
        cSSLSocket.defineMethod("state", sockcb.getMethod("state"));
        cSSLSocket.defineMethod("pending", sockcb.getMethod("pending"));
    }

    public static IRubyObject newInstance(IRubyObject recv, IRubyObject[] args) {
        SSLSocket result = new SSLSocket(recv.getRuntime(), (RubyClass)recv);
        result.callInit(args);
        return result;
    }

    public SSLSocket(IRuby runtime, RubyClass type) {
        super(runtime, type);
        this.sslError = (RubyClass)((RubyModule)runtime.getModule("OpenSSL").getConstant("SSL")).getConstant("SSLError");
    }

    public IRubyObject _initialize(IRubyObject[] args) throws Exception {
        ThreadContext tc = this.getRuntime().getCurrentContext();
        IRubyObject ctx = this.checkArgumentCount(args, 1, 2) == 1 ? ((RubyModule)this.getRuntime().getModule("OpenSSL").getConstant("SSL")).getClass("SSLContext").callMethod(tc, "new") : args[1];
        IRubyObject io = args[0];
        this.callMethod(tc, "io=", io);
        this.c = (SocketChannel)((RubyIO)io).getChannel();
        this.callMethod(tc, "context=", ctx);
        this.callMethod(tc, "sync_close=", this.getRuntime().getFalse());
        return this.callMethod(tc, this.getMetaClass().getSuperClass(), "initialize", args, CallType.SUPER);
    }

    private void ossl_ssl_setup() throws Exception {
        if (null == this.engine) {
            ThreadContext tc = this.getRuntime().getCurrentContext();
            javax.net.ssl.SSLContext ctx = javax.net.ssl.SSLContext.getInstance("SSL");
            IRubyObject store = this.callMethod(tc, "context").callMethod(tc, "cert_store");
            this.callMethod(tc, "context").callMethod(tc, "verify_mode");
            if (store.isNil()) {
                ctx.init(new KeyManager[]{((SSLContext)this.callMethod(tc, "context")).getKM()}, new TrustManager[]{((SSLContext)this.callMethod(tc, "context")).getTM()}, null);
            } else {
                ctx.init(new KeyManager[]{((SSLContext)this.callMethod(tc, "context")).getKM()}, new TrustManager[]{((X509Store)store).getStore()}, null);
            }
            String peerHost = this.c.socket().getInetAddress().getHostName();
            int peerPort = this.c.socket().getPort();
            this.engine = ctx.createSSLEngine(peerHost, peerPort);
            this.engine.setEnabledCipherSuites(((SSLContext)this.callMethod(tc, "context")).getCipherSuites(this.engine));
            SSLSession session = this.engine.getSession();
            this.peerNetData = ByteBuffer.allocate(session.getPacketBufferSize());
            this.peerAppData = ByteBuffer.allocate(session.getApplicationBufferSize());
            this.netData = ByteBuffer.allocate(session.getPacketBufferSize());
            this.peerNetData.limit(0);
            this.peerAppData.limit(0);
            this.netData.limit(0);
            this.dummy = ByteBuffer.allocate(0);
            this.rsel = Selector.open();
            this.wsel = Selector.open();
            this.asel = Selector.open();
            this.c.register(this.rsel, 1);
            this.c.register(this.wsel, 4);
            this.c.register(this.asel, 5);
        }
    }

    public IRubyObject connect() throws Exception {
        try {
            this.ossl_ssl_setup();
            this.engine.setUseClientMode(true);
            this.engine.beginHandshake();
            this.type = "client";
            this.hsStatus = this.engine.getHandshakeStatus();
            this.initialHandshake = true;
            this.doHandshake();
        }
        catch (SSLHandshakeException e) {
            Throwable v = e;
            while (v.getCause() != null && v instanceof SSLHandshakeException) {
                v = v.getCause();
            }
            if (v instanceof CertificateException) {
                throw new RaiseException(this.getRuntime(), this.sslError, v.getMessage(), true);
            }
            throw new RaiseException(this.getRuntime(), this.sslError, null, true);
        }
        return this;
    }

    public IRubyObject accept() throws Exception {
        try {
            ThreadContext tc = this.getRuntime().getCurrentContext();
            int vfy = 0;
            this.ossl_ssl_setup();
            this.engine.setUseClientMode(false);
            IRubyObject ccc = this.callMethod(tc, "context");
            if (!ccc.isNil() && !ccc.callMethod(tc, "verify_mode").isNil()) {
                vfy = RubyNumeric.fix2int(ccc.callMethod(tc, "verify_mode"));
                if (vfy == 0) {
                    this.engine.setNeedClientAuth(false);
                    this.engine.setWantClientAuth(false);
                }
                if ((vfy & 1) != 0) {
                    this.engine.setWantClientAuth(true);
                }
                if ((vfy & 2) != 0) {
                    this.engine.setNeedClientAuth(true);
                }
            }
            this.engine.beginHandshake();
            this.type = "server";
            this.hsStatus = this.engine.getHandshakeStatus();
            this.initialHandshake = true;
            this.doHandshake();
        }
        catch (SSLHandshakeException e) {
            throw new RaiseException(this.getRuntime(), this.sslError, null, true);
        }
        return this;
    }

    private void waitSelect(Selector sel) {
        try {
            sel.select();
        }
        catch (Exception e) {
            return;
        }
        Iterator<SelectionKey> it = sel.selectedKeys().iterator();
        while (it.hasNext()) {
            it.next();
            it.remove();
        }
    }

    private void doHandshake() throws Exception {
        while (true) {
            this.waitSelect(this.asel);
            if (this.hsStatus == SSLEngineResult.HandshakeStatus.FINISHED) {
                if (this.initialHandshake) {
                    this.finishInitialHandshake();
                }
                return;
            }
            if (this.hsStatus == SSLEngineResult.HandshakeStatus.NEED_TASK) {
                this.doTasks();
                continue;
            }
            if (this.hsStatus == SSLEngineResult.HandshakeStatus.NEED_UNWRAP) {
                if (this.readAndUnwrap() != -1 || this.hsStatus == SSLEngineResult.HandshakeStatus.FINISHED) continue;
                throw new SSLHandshakeException("Socket closed");
            }
            if (this.hsStatus != SSLEngineResult.HandshakeStatus.NEED_WRAP) break;
            if (this.netData.hasRemaining()) {
                while (this.flushData()) {
                }
            }
            this.netData.clear();
            SSLEngineResult res = this.engine.wrap(this.dummy, this.netData);
            this.hsStatus = res.getHandshakeStatus();
            this.netData.flip();
            this.flushData();
        }
        if (!$assertionsDisabled) {
            throw new AssertionError((Object)"doHandshake() should never reach the NOT_HANDSHAKING state");
        }
    }

    private void doTasks() {
        Runnable task;
        while ((task = this.engine.getDelegatedTask()) != null) {
            task.run();
        }
        this.hsStatus = this.engine.getHandshakeStatus();
    }

    private boolean flushData() throws IOException {
        try {
            this.c.write(this.netData);
        }
        catch (IOException ioe) {
            this.netData.position(this.netData.limit());
            throw ioe;
        }
        return !this.netData.hasRemaining();
    }

    private void finishInitialHandshake() {
        this.initialHandshake = false;
    }

    public int write(ByteBuffer src) throws Exception {
        if (this.initialHandshake) {
            return 0;
        }
        if (this.netData.hasRemaining()) {
            return 0;
        }
        this.netData.clear();
        SSLEngineResult res = this.engine.wrap(src, this.netData);
        this.netData.flip();
        this.flushData();
        return res.bytesConsumed();
    }

    public int read(ByteBuffer dst) throws Exception {
        int appBytesProduced;
        if (this.initialHandshake) {
            return 0;
        }
        if (this.engine.isInboundDone()) {
            return -1;
        }
        if (!(this.peerAppData.hasRemaining() || (appBytesProduced = this.readAndUnwrap()) != -1 && appBytesProduced != 0)) {
            return appBytesProduced;
        }
        int limit = Math.min(this.peerAppData.remaining(), dst.remaining());
        for (int i = 0; i < limit; ++i) {
            dst.put(this.peerAppData.get());
        }
        return limit;
    }

    private int readAndUnwrap() throws Exception {
        SSLEngineResult res;
        int bytesRead = this.c.read(this.peerNetData);
        if (bytesRead == -1) {
            return -1;
        }
        this.peerAppData.clear();
        this.peerNetData.flip();
        while ((res = this.engine.unwrap(this.peerNetData, this.peerAppData)).getStatus() == SSLEngineResult.Status.OK && res.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_UNWRAP && res.bytesProduced() == 0) {
        }
        if (res.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.FINISHED) {
            this.finishInitialHandshake();
        }
        if (this.peerAppData.position() == 0 && res.getStatus() == SSLEngineResult.Status.OK && this.peerNetData.hasRemaining()) {
            res = this.engine.unwrap(this.peerNetData, this.peerAppData);
        }
        this.status = res.getStatus();
        this.hsStatus = res.getHandshakeStatus();
        if (this.status == SSLEngineResult.Status.CLOSED) {
            this.doShutdown();
            return -1;
        }
        this.peerNetData.compact();
        this.peerAppData.flip();
        if (!(this.initialHandshake || this.hsStatus != SSLEngineResult.HandshakeStatus.NEED_TASK && this.hsStatus != SSLEngineResult.HandshakeStatus.NEED_WRAP && this.hsStatus != SSLEngineResult.HandshakeStatus.FINISHED)) {
            this.doHandshake();
        }
        return this.peerAppData.remaining();
    }

    private void doShutdown() throws IOException {
        if (this.engine.isOutboundDone()) {
            return;
        }
        this.netData.clear();
        try {
            this.engine.wrap(this.dummy, this.netData);
        }
        catch (Exception e1) {
            return;
        }
        this.netData.flip();
        this.flushData();
    }

    public IRubyObject sysread(IRubyObject[] args) throws Exception {
        IRubyObject str;
        this.checkArgumentCount(args, 1, 2);
        int len = RubyNumeric.fix2int(args[0]);
        IRubyObject iRubyObject = str = args.length == 2 ? args[1] : this.getRuntime().newString("");
        if (len == 0) {
            return str;
        }
        this.waitSelect(this.rsel);
        ByteBuffer dst = ByteBuffer.allocate(len);
        String bef_dst = dst.toString();
        int rr = -1;
        rr = this.engine == null ? this.c.read(dst) : this.read(dst);
        String aft_dst = dst.toString();
        String out = null;
        boolean eof = false;
        if (rr == -1) {
            eof = true;
        } else {
            byte[] bss = new byte[rr];
            dst.position(dst.position() - rr);
            dst.get(bss);
            out = new String(bss, "ISO8859_1");
        }
        String aft_ag_dst = dst.toString();
        if (eof) {
            throw this.getRuntime().newEOFError();
        }
        str.callMethod(this.getRuntime().getCurrentContext(), "<<", this.getRuntime().newString(out));
        return str;
    }

    public IRubyObject syswrite(IRubyObject arg) throws Exception {
        if (this.engine == null) {
            this.waitSelect(this.wsel);
            byte[] bls = arg.toString().getBytes("PLAIN");
            ByteBuffer b1 = ByteBuffer.wrap(bls);
            this.c.write(b1);
            return this.getRuntime().newFixnum(bls.length);
        }
        this.waitSelect(this.wsel);
        byte[] bls = arg.toString().getBytes("PLAIN");
        ByteBuffer b1 = ByteBuffer.wrap(bls);
        this.write(b1);
        return this.getRuntime().newFixnum(bls.length);
    }

    private void close() throws Exception {
        this.engine.closeOutbound();
        if (this.netData.hasRemaining()) {
            return;
        }
        this.doShutdown();
    }

    public IRubyObject sysclose() throws Exception {
        this.close();
        ThreadContext tc = this.getRuntime().getCurrentContext();
        if (this.callMethod(tc, "sync_close").isTrue()) {
            this.c.close();
            this.callMethod(tc, "io").callMethod(tc, "close");
        }
        return this.getRuntime().getNil();
    }

    public IRubyObject cert() {
        System.err.println("WARNING: unimplemented method called: SSLSocket#cert");
        return this.getRuntime().getNil();
    }

    public IRubyObject peer_cert() throws Exception {
        Certificate[] c = this.engine.getSession().getPeerCertificates();
        if (c.length > 0) {
            return X509Cert.wrap(this.getRuntime(), c[0]);
        }
        return this.getRuntime().getNil();
    }

    public IRubyObject peer_cert_chain() {
        System.err.println("WARNING: unimplemented method called: SSLSocket#peer_cert_chain");
        return this.getRuntime().getNil();
    }

    public IRubyObject cipher() {
        System.err.println("WARNING: unimplemented method called: SSLSocket#cipher");
        return this.getRuntime().getNil();
    }

    public IRubyObject state() {
        System.err.println("WARNING: unimplemented method called: SSLSocket#state");
        return this.getRuntime().getNil();
    }

    public IRubyObject pending() {
        System.err.println("WARNING: unimplemented method called: SSLSocket#pending");
        return this.getRuntime().getNil();
    }

    static {
        $assertionsDisabled = !SSLSocket.class.desiredAssertionStatus();
    }
}

