/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.openssl;

import org.jruby.IRuby;
import org.jruby.RubyModule;
import org.jruby.ext.openssl.Attribute;
import org.jruby.ext.openssl.Request;
import org.jruby.ext.openssl.X509CRL;
import org.jruby.ext.openssl.X509Cert;
import org.jruby.ext.openssl.X509Extensions;
import org.jruby.ext.openssl.X509Name;
import org.jruby.ext.openssl.X509Revoked;
import org.jruby.ext.openssl.X509Store;

public class X509 {
    public static void createX509(IRuby runtime, RubyModule ossl) {
        RubyModule mX509 = ossl.defineModuleUnder("X509");
        X509Name.createX509Name(runtime, mX509);
        X509Cert.createX509Cert(runtime, mX509);
        X509Extensions.createX509Ext(runtime, mX509);
        X509CRL.createX509CRL(runtime, mX509);
        X509Revoked.createX509Revoked(runtime, mX509);
        X509Store.createX509Store(runtime, mX509);
        Request.createRequest(runtime, mX509);
        Attribute.createAttribute(runtime, mX509);
        mX509.setConstant("V_OK", runtime.newFixnum(0L));
        mX509.setConstant("V_ERR_UNABLE_TO_GET_ISSUER_CERT", runtime.newFixnum(2L));
        mX509.setConstant("V_ERR_UNABLE_TO_GET_CRL", runtime.newFixnum(3L));
        mX509.setConstant("V_ERR_UNABLE_TO_DECRYPT_CERT_SIGNATURE", runtime.newFixnum(4L));
        mX509.setConstant("V_ERR_UNABLE_TO_DECRYPT_CRL_SIGNATURE", runtime.newFixnum(5L));
        mX509.setConstant("V_ERR_UNABLE_TO_DECODE_ISSUER_PUBLIC_KEY", runtime.newFixnum(6L));
        mX509.setConstant("V_ERR_CERT_SIGNATURE_FAILURE", runtime.newFixnum(7L));
        mX509.setConstant("V_ERR_CRL_SIGNATURE_FAILURE", runtime.newFixnum(8L));
        mX509.setConstant("V_ERR_CERT_NOT_YET_VALID", runtime.newFixnum(9L));
        mX509.setConstant("V_ERR_CERT_HAS_EXPIRED", runtime.newFixnum(10L));
        mX509.setConstant("V_ERR_CRL_NOT_YET_VALID", runtime.newFixnum(11L));
        mX509.setConstant("V_ERR_CRL_HAS_EXPIRED", runtime.newFixnum(12L));
        mX509.setConstant("V_ERR_ERROR_IN_CERT_NOT_BEFORE_FIELD", runtime.newFixnum(13L));
        mX509.setConstant("V_ERR_ERROR_IN_CERT_NOT_AFTER_FIELD", runtime.newFixnum(14L));
        mX509.setConstant("V_ERR_ERROR_IN_CRL_LAST_UPDATE_FIELD", runtime.newFixnum(15L));
        mX509.setConstant("V_ERR_ERROR_IN_CRL_NEXT_UPDATE_FIELD", runtime.newFixnum(16L));
        mX509.setConstant("V_ERR_OUT_OF_MEM", runtime.newFixnum(17L));
        mX509.setConstant("V_ERR_DEPTH_ZERO_SELF_SIGNED_CERT", runtime.newFixnum(18L));
        mX509.setConstant("V_ERR_SELF_SIGNED_CERT_IN_CHAIN", runtime.newFixnum(19L));
        mX509.setConstant("V_ERR_UNABLE_TO_GET_ISSUER_CERT_LOCALLY", runtime.newFixnum(20L));
        mX509.setConstant("V_ERR_UNABLE_TO_VERIFY_LEAF_SIGNATURE", runtime.newFixnum(21L));
        mX509.setConstant("V_ERR_CERT_CHAIN_TOO_LONG", runtime.newFixnum(22L));
        mX509.setConstant("V_ERR_CERT_REVOKED", runtime.newFixnum(23L));
        mX509.setConstant("V_ERR_INVALID_CA", runtime.newFixnum(24L));
        mX509.setConstant("V_ERR_PATH_LENGTH_EXCEEDED", runtime.newFixnum(25L));
        mX509.setConstant("V_ERR_INVALID_PURPOSE", runtime.newFixnum(26L));
        mX509.setConstant("V_ERR_CERT_UNTRUSTED", runtime.newFixnum(27L));
        mX509.setConstant("V_ERR_CERT_REJECTED", runtime.newFixnum(28L));
        mX509.setConstant("V_ERR_SUBJECT_ISSUER_MISMATCH", runtime.newFixnum(29L));
        mX509.setConstant("V_ERR_AKID_SKID_MISMATCH", runtime.newFixnum(30L));
        mX509.setConstant("V_ERR_AKID_ISSUER_SERIAL_MISMATCH", runtime.newFixnum(31L));
        mX509.setConstant("V_ERR_KEYUSAGE_NO_CERTSIGN", runtime.newFixnum(32L));
        mX509.setConstant("V_ERR_APPLICATION_VERIFICATION", runtime.newFixnum(50L));
        mX509.setConstant("V_FLAG_CRL_CHECK", runtime.newFixnum(4L));
        mX509.setConstant("V_FLAG_CRL_CHECK_ALL", runtime.newFixnum(8L));
        mX509.setConstant("PURPOSE_SSL_CLIENT", runtime.newFixnum(1L));
        mX509.setConstant("PURPOSE_SSL_SERVER", runtime.newFixnum(2L));
        mX509.setConstant("PURPOSE_NS_SSL_SERVER", runtime.newFixnum(3L));
        mX509.setConstant("PURPOSE_SMIME_SIGN", runtime.newFixnum(4L));
        mX509.setConstant("PURPOSE_SMIME_ENCRYPT", runtime.newFixnum(5L));
        mX509.setConstant("PURPOSE_CRL_SIGN", runtime.newFixnum(6L));
        mX509.setConstant("PURPOSE_ANY", runtime.newFixnum(7L));
        mX509.setConstant("PURPOSE_OCSP_HELPER", runtime.newFixnum(8L));
        mX509.setConstant("TRUST_COMPAT", runtime.newFixnum(1L));
        mX509.setConstant("TRUST_SSL_CLIENT", runtime.newFixnum(2L));
        mX509.setConstant("TRUST_SSL_SERVER", runtime.newFixnum(3L));
        mX509.setConstant("TRUST_EMAIL", runtime.newFixnum(4L));
        mX509.setConstant("TRUST_OBJECT_SIGN", runtime.newFixnum(5L));
        mX509.setConstant("TRUST_OCSP_SIGN", runtime.newFixnum(6L));
        mX509.setConstant("TRUST_OCSP_REQUEST", runtime.newFixnum(7L));
        mX509.setConstant("DEFAULT_CERT_AREA", runtime.newString("/usr/lib/ssl"));
        mX509.setConstant("DEFAULT_CERT_DIR", runtime.newString("/usr/lib/ssl/certs"));
        mX509.setConstant("DEFAULT_CERT_FILE", runtime.newString("/usr/lib/ssl/cert.pem"));
        mX509.setConstant("DEFAULT_CERT_DIR_ENV", runtime.newString("SSL_CERT_DIR"));
        mX509.setConstant("DEFAULT_CERT_FILE_ENV", runtime.newString("SSL_CERT_FILE"));
        mX509.setConstant("DEFAULT_PRIVATE_DIR", runtime.newString("/usr/lib/ssl/private"));
    }
}

