/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.openssl;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.StringWriter;
import java.math.BigInteger;
import java.security.cert.CertificateFactory;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.DERBoolean;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DEREncodableVector;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.x509.X509Extensions;
import org.bouncycastle.x509.X509V2CRLGenerator;
import org.jruby.IRuby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyTime;
import org.jruby.exceptions.RaiseException;
import org.jruby.ext.openssl.ASN1;
import org.jruby.ext.openssl.Digest;
import org.jruby.ext.openssl.PKey;
import org.jruby.ext.openssl.X509Extensions;
import org.jruby.ext.openssl.X509Name;
import org.jruby.ext.openssl.X509Revoked;
import org.jruby.ext.openssl.x509store.PEM;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class X509CRL
extends RubyObject {
    private IRubyObject version;
    private IRubyObject issuer;
    private IRubyObject last_update;
    private IRubyObject next_update;
    private IRubyObject revoked;
    private List extensions;
    private IRubyObject sig_alg;
    private boolean changed = true;
    private X509V2CRLGenerator generator = new X509V2CRLGenerator();
    private java.security.cert.X509CRL crl;
    private DERObject crl_v;
    private static final String IND8 = "        ";
    private static final String IND12 = "            ";
    private static final String IND16 = "                ";
    private static final DateFormat ASN_DATE = new SimpleDateFormat("MMM dd HH:mm:ss yyyy zzz");

    public static void createX509CRL(IRuby runtime, RubyModule mX509) {
        RubyClass cX509CRL = mX509.defineClassUnder("CRL", runtime.getObject());
        mX509.defineClassUnder("CRLError", runtime.getModule("OpenSSL").getClass("OpenSSLError"));
        CallbackFactory crlcb = runtime.callbackFactory(X509CRL.class);
        cX509CRL.defineSingletonMethod("new", crlcb.getOptSingletonMethod("newInstance"));
        cX509CRL.defineMethod("initialize", crlcb.getOptMethod("_initialize"));
        cX509CRL.defineMethod("initialize_copy", crlcb.getMethod("initialize_copy", IRubyObject.class));
        cX509CRL.defineMethod("clone", crlcb.getMethod("rbClone"));
        cX509CRL.defineMethod("version", crlcb.getMethod("version"));
        cX509CRL.defineMethod("version=", crlcb.getMethod("set_version", IRubyObject.class));
        cX509CRL.defineMethod("signature_algorithm", crlcb.getMethod("signature_algorithm"));
        cX509CRL.defineMethod("issuer", crlcb.getMethod("issuer"));
        cX509CRL.defineMethod("issuer=", crlcb.getMethod("set_issuer", IRubyObject.class));
        cX509CRL.defineMethod("last_update", crlcb.getMethod("last_update"));
        cX509CRL.defineMethod("last_update=", crlcb.getMethod("set_last_update", IRubyObject.class));
        cX509CRL.defineMethod("next_update", crlcb.getMethod("next_update"));
        cX509CRL.defineMethod("next_update=", crlcb.getMethod("set_next_update", IRubyObject.class));
        cX509CRL.defineMethod("revoked", crlcb.getMethod("revoked"));
        cX509CRL.defineMethod("revoked=", crlcb.getMethod("set_revoked", IRubyObject.class));
        cX509CRL.defineMethod("add_revoked", crlcb.getMethod("add_revoked", IRubyObject.class));
        cX509CRL.defineMethod("sign", crlcb.getMethod("sign", IRubyObject.class, IRubyObject.class));
        cX509CRL.defineMethod("verify", crlcb.getMethod("verify", IRubyObject.class));
        cX509CRL.defineMethod("to_der", crlcb.getMethod("to_der"));
        cX509CRL.defineMethod("to_pem", crlcb.getMethod("to_pem"));
        cX509CRL.defineMethod("to_s", crlcb.getMethod("to_pem"));
        cX509CRL.defineMethod("to_text", crlcb.getMethod("to_text"));
        cX509CRL.defineMethod("extensions", crlcb.getMethod("extensions"));
        cX509CRL.defineMethod("extensions=", crlcb.getMethod("set_extensions", IRubyObject.class));
        cX509CRL.defineMethod("add_extension", crlcb.getMethod("add_extension", IRubyObject.class));
    }

    public static IRubyObject newInstance(IRubyObject recv, IRubyObject[] args) {
        X509CRL result = new X509CRL(recv.getRuntime(), (RubyClass)recv);
        result.callInit(args);
        return result;
    }

    java.security.cert.X509CRL getCRL() {
        return this.crl;
    }

    public X509CRL(IRuby runtime, RubyClass type) {
        super(runtime, type);
    }

    public IRubyObject _initialize(IRubyObject[] args) throws Exception {
        this.extensions = new ArrayList();
        if (this.checkArgumentCount(args, 0, 1) == 0) {
            this.version = this.getRuntime().getNil();
            this.issuer = this.getRuntime().getNil();
            this.last_update = this.getRuntime().getNil();
            this.next_update = this.getRuntime().getNil();
            this.revoked = this.getRuntime().newArray();
            return this;
        }
        ByteArrayInputStream bis = new ByteArrayInputStream(args[0].toString().getBytes("PLAIN"));
        CertificateFactory cf = CertificateFactory.getInstance("X.509", "BC");
        this.crl = (java.security.cert.X509CRL)cf.generateCRL(bis);
        this.crl_v = new ASN1InputStream((InputStream)new ByteArrayInputStream(args[0].toString().getBytes("PLAIN"))).readObject();
        DEREncodable v0 = ((DERSequence)((DERSequence)this.crl_v).getObjectAt(0)).getObjectAt(0);
        if (v0 instanceof DERInteger) {
            this.set_version(this.getRuntime().newFixnum(((DERInteger)v0).getValue().intValue()));
        } else {
            this.set_version(this.getRuntime().newFixnum(2L));
        }
        this.set_last_update(RubyTime.newTime(this.getRuntime(), this.crl.getThisUpdate().getTime()));
        this.set_next_update(RubyTime.newTime(this.getRuntime(), this.crl.getNextUpdate().getTime()));
        ThreadContext tc = this.getRuntime().getCurrentContext();
        this.set_issuer(((RubyModule)this.getRuntime().getModule("OpenSSL").getConstant("X509")).getConstant("Name").callMethod(tc, "new", this.getRuntime().newString(new String(this.crl.getIssuerX500Principal().getEncoded(), "PLAIN"))));
        this.revoked = this.getRuntime().newArray();
        DERSequence seqa = (DERSequence)((DERSequence)this.crl_v).getObjectAt(0);
        DERObject maybe_ext = (DERObject)seqa.getObjectAt(seqa.size() - 1);
        if (maybe_ext instanceof DERTaggedObject && ((DERTaggedObject)maybe_ext).getTagNo() == 0) {
            DERSequence exts = (DERSequence)((DERTaggedObject)maybe_ext).getObject();
            for (int i = 0; i < exts.size(); ++i) {
                DERSequence seq2 = (DERSequence)exts.getObjectAt(i);
                boolean critical = false;
                String oid = ((DERObjectIdentifier)seq2.getObjectAt(0)).getId();
                if (seq2.getObjectAt(1) == DERBoolean.TRUE) {
                    critical = true;
                }
                byte[] value = this.crl.getExtensionValue(oid);
                IRubyObject mASN1 = this.getRuntime().getModule("OpenSSL").getConstant("ASN1");
                IRubyObject rValue = null;
                try {
                    rValue = ASN1.decode(mASN1, ASN1.decode(mASN1, this.getRuntime().newString(new String(value, "PLAIN"))).callMethod(tc, "value"));
                }
                catch (Exception e) {
                    rValue = this.getRuntime().newString(new String(value, "PLAIN"));
                }
                X509Extensions.Extension ext1 = (X509Extensions.Extension)((RubyModule)this.getRuntime().getModule("OpenSSL").getConstant("X509")).getConstant("Extension").callMethod(tc, "new");
                ext1.setRealOid(ext1.getObjectIdentifier(oid));
                ext1.setRealValue(rValue);
                ext1.setRealCritical(critical);
                this.add_extension(ext1);
            }
        }
        this.changed = false;
        return this;
    }

    public IRubyObject initialize_copy(IRubyObject obj) {
        System.err.println("WARNING: unimplemented method called: CRL#init_copy");
        if (this == obj) {
            return this;
        }
        this.checkFrozen();
        return this;
    }

    public IRubyObject to_pem() throws Exception {
        StringWriter w = new StringWriter();
        PEM.write_X509_CRL(w, this.crl);
        w.close();
        return this.getRuntime().newString(w.toString());
    }

    public IRubyObject to_der() throws Exception {
        return this.getRuntime().newString(new String(this.crl_v.getEncoded(), "ISO8859_1"));
    }

    public IRubyObject to_text() throws Exception {
        StringBuffer sbe = new StringBuffer();
        sbe.append("Certificate Revocation List (CRL):\n");
        sbe.append(IND8).append("Version ").append(RubyNumeric.fix2int(this.version) + 1).append(" (0x");
        sbe.append(Integer.toString(RubyNumeric.fix2int(this.version), 16)).append(")\n");
        sbe.append(IND8).append("Signature Algorithm: ").append(ASN1.nid2ln(this.getRuntime(), ASN1.obj2nid(this.getRuntime(), (DERObjectIdentifier)((DERSequence)((DERSequence)this.crl_v).getObjectAt(1)).getObjectAt(0)))).append("\n");
        sbe.append(IND8).append("Issuer: ").append(this.issuer()).append("\n");
        sbe.append(IND8).append("Last Update: ").append(ASN_DATE.format(((RubyTime)this.last_update()).getJavaDate())).append("\n");
        if (!this.next_update().isNil()) {
            sbe.append(IND8).append("Next Update: ").append(ASN_DATE.format(((RubyTime)this.next_update()).getJavaDate())).append("\n");
        } else {
            sbe.append(IND8).append("Next Update: NONE\n");
        }
        if (this.extensions.size() > 0) {
            sbe.append(IND8).append("CRL extensions\n");
            Iterator iter = this.extensions.iterator();
            while (iter.hasNext()) {
                X509Extensions.Extension ext = (X509Extensions.Extension)iter.next();
                DERObjectIdentifier oiden = ext.getRealOid();
                sbe.append(IND12).append(ASN1.o2a(this.getRuntime(), oiden)).append(": ");
                if (ext.getRealCritical()) {
                    sbe.append("critical");
                }
                sbe.append("\n");
                sbe.append(IND16).append(ext.value()).append("\n");
            }
        }
        return this.getRuntime().newString(sbe.toString());
    }

    public IRubyObject version() {
        return this.version;
    }

    public IRubyObject set_version(IRubyObject val) {
        if (!val.equals(this.version)) {
            this.changed = true;
        }
        this.version = val;
        return val;
    }

    public IRubyObject signature_algorithm() {
        return this.sig_alg;
    }

    public IRubyObject issuer() {
        return this.issuer;
    }

    public IRubyObject set_issuer(IRubyObject val) {
        if (!val.equals(this.issuer)) {
            this.changed = true;
        }
        this.issuer = val;
        this.generator.setIssuerDN(((X509Name)this.issuer).getRealName());
        return val;
    }

    public IRubyObject last_update() {
        return this.last_update;
    }

    public IRubyObject set_last_update(IRubyObject val) {
        this.changed = true;
        this.last_update = val.callMethod(this.getRuntime().getCurrentContext(), "getutc");
        ((RubyTime)this.last_update).setMicroseconds(0L);
        this.generator.setThisUpdate(((RubyTime)this.last_update).getJavaDate());
        this.last_update = val;
        return val;
    }

    public IRubyObject next_update() {
        return this.next_update;
    }

    public IRubyObject set_next_update(IRubyObject val) {
        this.changed = true;
        this.next_update = val.callMethod(this.getRuntime().getCurrentContext(), "getutc");
        ((RubyTime)this.next_update).setMicroseconds(0L);
        this.generator.setNextUpdate(((RubyTime)this.next_update).getJavaDate());
        this.next_update = val;
        return val;
    }

    public IRubyObject revoked() {
        return this.revoked;
    }

    public IRubyObject set_revoked(IRubyObject val) {
        this.changed = true;
        this.revoked = val;
        return val;
    }

    public IRubyObject add_revoked(IRubyObject val) {
        this.changed = true;
        this.revoked.callMethod(this.getRuntime().getCurrentContext(), "<<", val);
        return val;
    }

    public IRubyObject extensions() {
        return this.getRuntime().newArray(this.extensions);
    }

    public IRubyObject set_extensions(IRubyObject val) {
        this.extensions = ((RubyArray)val).getList();
        return val;
    }

    public IRubyObject add_extension(IRubyObject val) {
        this.extensions.add(val);
        return val;
    }

    public IRubyObject sign(IRubyObject key, IRubyObject digest) throws Exception {
        String keyAlg = ((PKey)key).getAlgorithm();
        String digAlg = ((Digest)digest).getAlgorithm();
        if ("DSA".equalsIgnoreCase(keyAlg) && "MD5".equalsIgnoreCase(digAlg) || "RSA".equalsIgnoreCase(keyAlg) && "DSS1".equals(((Digest)digest).name().toString()) || "DSA".equalsIgnoreCase(keyAlg) && "SHA1".equals(((Digest)digest).name().toString())) {
            throw new RaiseException(this.getRuntime(), (RubyClass)((RubyModule)this.getRuntime().getModule("OpenSSL").getConstant("X509")).getConstant("CRLError"), null, true);
        }
        this.sig_alg = this.getRuntime().newString(digAlg);
        this.generator.setSignatureAlgorithm(digAlg + "WITH" + keyAlg);
        Iterator iter = ((RubyArray)this.revoked).getList().iterator();
        while (iter.hasNext()) {
            X509Revoked rev = (X509Revoked)iter.next();
            BigInteger serial = new BigInteger(rev.callMethod(this.getRuntime().getCurrentContext(), "serial").toString());
            IRubyObject t1 = rev.callMethod(this.getRuntime().getCurrentContext(), "time").callMethod(this.getRuntime().getCurrentContext(), "getutc");
            ((RubyTime)t1).setMicroseconds(0L);
            this.generator.addCRLEntry(serial, ((RubyTime)t1).getJavaDate(), new X509Extensions(new Hashtable()));
        }
        iter = this.extensions.iterator();
        while (iter.hasNext()) {
            Object arg = iter.next();
            this.generator.addExtension(((X509Extensions.Extension)arg).getRealOid(), ((X509Extensions.Extension)arg).getRealCritical(), ((X509Extensions.Extension)arg).getRealValueBytes());
        }
        this.crl = this.generator.generateX509CRL(((PKey)key).getPrivateKey());
        this.crl_v = new ASN1InputStream((InputStream)new ByteArrayInputStream(this.crl.getEncoded())).readObject();
        DERSequence v1 = (DERSequence)((DERSequence)this.crl_v).getObjectAt(0);
        ASN1EncodableVector build1 = new ASN1EncodableVector();
        int copyIndex = 0;
        if (v1.getObjectAt(0) instanceof DERInteger) {
            ++copyIndex;
        }
        build1.add((DEREncodable)new DERInteger(new BigInteger(this.version.toString())));
        while (copyIndex < v1.size()) {
            build1.add(v1.getObjectAt(copyIndex++));
        }
        ASN1EncodableVector build2 = new ASN1EncodableVector();
        build2.add((DEREncodable)new DERSequence((DEREncodableVector)build1));
        build2.add(((DERSequence)this.crl_v).getObjectAt(1));
        build2.add(((DERSequence)this.crl_v).getObjectAt(2));
        this.crl_v = new DERSequence((DEREncodableVector)build2);
        this.changed = false;
        return this;
    }

    public IRubyObject verify(IRubyObject key) {
        if (this.changed) {
            return this.getRuntime().getFalse();
        }
        try {
            this.crl.verify(((PKey)key).getPublicKey());
            return this.getRuntime().getTrue();
        }
        catch (Exception e) {
            return this.getRuntime().getFalse();
        }
    }

    public IRubyObject rbClone() {
        X509CRL clone = new X509CRL(this.getRuntime(), this.getMetaClass().getRealClass());
        clone.setMetaClass(this.getMetaClass().getSingletonClassClone());
        clone.setTaint(this.isTaint());
        clone.initCopy(this);
        clone.setFrozen(this.isFrozen());
        return clone;
    }
}

