/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.openssl;

import java.io.ByteArrayInputStream;
import java.io.StringWriter;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DEREncodableVector;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.x509.X509V3CertificateGenerator;
import org.jruby.IRuby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyTime;
import org.jruby.exceptions.RaiseException;
import org.jruby.ext.openssl.ASN1;
import org.jruby.ext.openssl.Digest;
import org.jruby.ext.openssl.OpenSSLImpl;
import org.jruby.ext.openssl.PKey;
import org.jruby.ext.openssl.X509Extensions;
import org.jruby.ext.openssl.X509Name;
import org.jruby.ext.openssl.x509store.PEM;
import org.jruby.ext.openssl.x509store.X509AuxCertificate;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class X509Cert
extends RubyObject {
    private IRubyObject serial;
    private IRubyObject not_before;
    private IRubyObject not_after;
    private IRubyObject issuer;
    private IRubyObject subject;
    private IRubyObject public_key;
    private IRubyObject sig_alg;
    private IRubyObject version;
    private List extensions;
    private boolean changed = true;
    private X509V3CertificateGenerator generator = new X509V3CertificateGenerator();
    private X509Certificate cert;

    public static void createX509Cert(IRuby runtime, RubyModule mX509) {
        RubyClass cX509Cert = mX509.defineClassUnder("Certificate", runtime.getObject());
        mX509.defineClassUnder("CertificateError", runtime.getModule("OpenSSL").getClass("OpenSSLError"));
        CallbackFactory certcb = runtime.callbackFactory(X509Cert.class);
        cX509Cert.defineSingletonMethod("new", certcb.getOptSingletonMethod("newInstance"));
        cX509Cert.defineMethod("initialize", certcb.getOptMethod("_initialize"));
        cX509Cert.defineMethod("initialize_copy", certcb.getMethod("initialize_copy", IRubyObject.class));
        cX509Cert.defineMethod("clone", certcb.getMethod("rbClone"));
        cX509Cert.defineMethod("to_der", certcb.getMethod("to_der"));
        cX509Cert.defineMethod("to_pem", certcb.getMethod("to_pem"));
        cX509Cert.defineMethod("to_s", certcb.getMethod("to_pem"));
        cX509Cert.defineMethod("to_text", certcb.getMethod("to_text"));
        cX509Cert.defineMethod("version", certcb.getMethod("version"));
        cX509Cert.defineMethod("version=", certcb.getMethod("set_version", IRubyObject.class));
        cX509Cert.defineMethod("signature_algorithm", certcb.getMethod("signature_algorithm"));
        cX509Cert.defineMethod("serial", certcb.getMethod("serial"));
        cX509Cert.defineMethod("serial=", certcb.getMethod("set_serial", IRubyObject.class));
        cX509Cert.defineMethod("subject", certcb.getMethod("subject"));
        cX509Cert.defineMethod("subject=", certcb.getMethod("set_subject", IRubyObject.class));
        cX509Cert.defineMethod("issuer", certcb.getMethod("issuer"));
        cX509Cert.defineMethod("issuer=", certcb.getMethod("set_issuer", IRubyObject.class));
        cX509Cert.defineMethod("not_before", certcb.getMethod("not_before"));
        cX509Cert.defineMethod("not_before=", certcb.getMethod("set_not_before", IRubyObject.class));
        cX509Cert.defineMethod("not_after", certcb.getMethod("not_after"));
        cX509Cert.defineMethod("not_after=", certcb.getMethod("set_not_after", IRubyObject.class));
        cX509Cert.defineMethod("public_key", certcb.getMethod("public_key"));
        cX509Cert.defineMethod("public_key=", certcb.getMethod("set_public_key", IRubyObject.class));
        cX509Cert.defineMethod("sign", certcb.getMethod("sign", IRubyObject.class, IRubyObject.class));
        cX509Cert.defineMethod("verify", certcb.getMethod("verify", IRubyObject.class));
        cX509Cert.defineMethod("check_private_key", certcb.getMethod("check_private_key", IRubyObject.class));
        cX509Cert.defineMethod("extensions", certcb.getMethod("extensions"));
        cX509Cert.defineMethod("extensions=", certcb.getMethod("set_extensions", IRubyObject.class));
        cX509Cert.defineMethod("add_extension", certcb.getMethod("add_extension", IRubyObject.class));
        cX509Cert.defineMethod("inspect", certcb.getMethod("inspect"));
    }

    public static IRubyObject newInstance(IRubyObject recv, IRubyObject[] args) {
        X509Cert result = new X509Cert(recv.getRuntime(), (RubyClass)recv);
        result.callInit(args);
        return result;
    }

    public X509Cert(IRuby runtime, RubyClass type) {
        super(runtime, type);
    }

    X509AuxCertificate getAuxCert() {
        if (null == this.cert) {
            return null;
        }
        if (this.cert instanceof X509AuxCertificate) {
            return (X509AuxCertificate)this.cert;
        }
        return new X509AuxCertificate(this.cert);
    }

    public static IRubyObject wrap(IRuby runtime, Certificate c) throws Exception {
        RubyClass cr = (RubyClass)((RubyModule)runtime.getModule("OpenSSL").getConstant("X509")).getConstant("Certificate");
        return cr.callMethod(runtime.getCurrentContext(), "new", runtime.newString(new String(c.getEncoded(), "ISO8859_1")));
    }

    public IRubyObject _initialize(IRubyObject[] args) throws Exception {
        Set<String> ncrit;
        this.extensions = new ArrayList();
        if (this.checkArgumentCount(args, 0, 1) == 0) {
            return this;
        }
        ThreadContext tc = this.getRuntime().getCurrentContext();
        IRubyObject arg = OpenSSLImpl.to_der_if_possible(args[0]);
        ByteArrayInputStream bis = new ByteArrayInputStream(arg.toString().getBytes("PLAIN"));
        CertificateFactory cf = CertificateFactory.getInstance("X.509", "BC");
        this.cert = (X509Certificate)cf.generateCertificate(bis);
        this.set_serial(RubyNumeric.str2inum(this.getRuntime(), this.getRuntime().newString(this.cert.getSerialNumber().toString()), 10));
        this.set_not_before(RubyTime.newTime(this.getRuntime(), this.cert.getNotBefore().getTime()));
        this.set_not_after(RubyTime.newTime(this.getRuntime(), this.cert.getNotAfter().getTime()));
        this.set_subject(((RubyModule)this.getRuntime().getModule("OpenSSL").getConstant("X509")).getConstant("Name").callMethod(tc, "new", this.getRuntime().newString(new String(this.cert.getSubjectX500Principal().getEncoded(), "ISO8859_1"))));
        this.set_issuer(((RubyModule)this.getRuntime().getModule("OpenSSL").getConstant("X509")).getConstant("Name").callMethod(tc, "new", this.getRuntime().newString(new String(this.cert.getIssuerX500Principal().getEncoded(), "ISO8859_1"))));
        IRubyObject extFact = ((RubyClass)((RubyModule)this.getRuntime().getModule("OpenSSL").getConstant("X509")).getConstant("ExtensionFactory")).callMethod(tc, "new");
        extFact.callMethod(tc, "subject_certificate=", this);
        Set<String> crit = this.cert.getCriticalExtensionOIDs();
        if (crit != null) {
            Iterator<String> iter = crit.iterator();
            while (iter.hasNext()) {
                String critOid = iter.next();
                byte[] value = this.cert.getExtensionValue(critOid);
                IRubyObject rValue = ASN1.decode(this.getRuntime().getModule("OpenSSL").getConstant("ASN1"), this.getRuntime().newString(new String(value, "PLAIN"))).callMethod(tc, "value");
                if (critOid.equals("2.5.29.17")) {
                    this.add_extension(extFact.callMethod(tc, "create_ext", new IRubyObject[]{this.getRuntime().newString(critOid), this.getRuntime().newString(rValue.toString()), this.getRuntime().getTrue()}));
                    continue;
                }
                this.add_extension(extFact.callMethod(tc, "create_ext", new IRubyObject[]{this.getRuntime().newString(critOid), this.getRuntime().newString(rValue.toString().substring(2)), this.getRuntime().getTrue()}));
            }
        }
        if ((ncrit = this.cert.getNonCriticalExtensionOIDs()) != null) {
            Iterator<String> iter = ncrit.iterator();
            while (iter.hasNext()) {
                String ncritOid = iter.next();
                byte[] value = this.cert.getExtensionValue(ncritOid);
                IRubyObject rValue = ASN1.decode(this.getRuntime().getModule("OpenSSL").getConstant("ASN1"), this.getRuntime().newString(new String(value, "PLAIN"))).callMethod(tc, "value");
                if (ncritOid.equals("2.5.29.17")) {
                    this.add_extension(extFact.callMethod(tc, "create_ext", new IRubyObject[]{this.getRuntime().newString(ncritOid), this.getRuntime().newString(rValue.toString()), this.getRuntime().getFalse()}));
                    continue;
                }
                this.add_extension(extFact.callMethod(tc, "create_ext", new IRubyObject[]{this.getRuntime().newString(ncritOid), this.getRuntime().newString(rValue.toString().substring(2)), this.getRuntime().getFalse()}));
            }
        }
        this.changed = false;
        return this;
    }

    public IRubyObject initialize_copy(IRubyObject obj) {
        if (this == obj) {
            return this;
        }
        this.checkFrozen();
        return this;
    }

    public IRubyObject to_der() throws Exception {
        return this.getRuntime().newString(new String(this.cert.getEncoded(), "ISO8859_1"));
    }

    public IRubyObject to_pem() throws Exception {
        StringWriter w = new StringWriter();
        PEM.write_X509(w, this.getAuxCert());
        w.close();
        return this.getRuntime().newString(w.toString());
    }

    public IRubyObject to_text() {
        return this.getRuntime().getNil();
    }

    public IRubyObject inspect() {
        return this.getRuntime().getNil();
    }

    public IRubyObject version() {
        return this.version;
    }

    public IRubyObject set_version(IRubyObject arg) {
        if (!arg.equals(this.version)) {
            this.changed = true;
        }
        this.version = arg;
        return arg;
    }

    public IRubyObject signature_algorithm() {
        return this.sig_alg;
    }

    public IRubyObject serial() {
        return this.serial;
    }

    public IRubyObject set_serial(IRubyObject num) {
        if (!num.equals(this.serial)) {
            this.changed = true;
        }
        this.serial = num;
        this.generator.setSerialNumber(new BigInteger(this.serial.toString()));
        return num;
    }

    public IRubyObject subject() {
        return this.subject;
    }

    public IRubyObject set_subject(IRubyObject arg) {
        if (!arg.equals(this.subject)) {
            this.changed = true;
        }
        this.subject = arg;
        this.generator.setSubjectDN(((X509Name)this.subject).getRealName());
        return arg;
    }

    public IRubyObject issuer() {
        return this.issuer;
    }

    public IRubyObject set_issuer(IRubyObject arg) {
        if (!arg.equals(this.issuer)) {
            this.changed = true;
        }
        this.issuer = arg;
        this.generator.setIssuerDN(((X509Name)this.issuer).getRealName());
        return arg;
    }

    public IRubyObject not_before() {
        return this.not_before;
    }

    public IRubyObject set_not_before(IRubyObject arg) {
        this.changed = true;
        this.not_before = arg.callMethod(this.getRuntime().getCurrentContext(), "getutc");
        ((RubyTime)this.not_before).setMicroseconds(0L);
        this.generator.setNotBefore(((RubyTime)this.not_before).getJavaDate());
        return arg;
    }

    public IRubyObject not_after() {
        return this.not_after;
    }

    public IRubyObject set_not_after(IRubyObject arg) {
        this.changed = true;
        this.not_after = arg.callMethod(this.getRuntime().getCurrentContext(), "getutc");
        ((RubyTime)this.not_after).setMicroseconds(0L);
        this.generator.setNotAfter(((RubyTime)this.not_after).getJavaDate());
        return arg;
    }

    public IRubyObject public_key() {
        return this.public_key;
    }

    public IRubyObject set_public_key(IRubyObject arg) {
        if (!arg.equals(this.public_key)) {
            this.changed = true;
        }
        this.public_key = arg;
        this.generator.setPublicKey(((PKey)this.public_key).getPublicKey());
        return arg;
    }

    public IRubyObject sign(IRubyObject key, IRubyObject digest) throws Exception {
        String keyAlg = ((PKey)key).getAlgorithm();
        String digAlg = ((Digest)digest).getAlgorithm();
        if ("DSA".equalsIgnoreCase(keyAlg) && "MD5".equalsIgnoreCase(digAlg) || "RSA".equalsIgnoreCase(keyAlg) && "DSS1".equals(((Digest)digest).name().toString()) || "DSA".equalsIgnoreCase(keyAlg) && "SHA1".equals(((Digest)digest).name().toString())) {
            throw new RaiseException(this.getRuntime(), (RubyClass)((RubyModule)this.getRuntime().getModule("OpenSSL").getConstant("X509")).getConstant("CertificateError"), null, true);
        }
        Iterator iter = this.extensions.iterator();
        while (iter.hasNext()) {
            X509Extensions.Extension ag = (X509Extensions.Extension)iter.next();
            this.generator.addExtension(ag.getRealOid(), ag.getRealCritical(), ag.getRealValueBytes());
        }
        this.sig_alg = this.getRuntime().newString(digAlg);
        this.generator.setSignatureAlgorithm(digAlg + "WITH" + keyAlg);
        this.cert = this.generator.generateX509Certificate(((PKey)key).getPrivateKey());
        this.changed = false;
        return this;
    }

    public IRubyObject verify(IRubyObject key) throws Exception {
        if (this.changed) {
            return this.getRuntime().getFalse();
        }
        try {
            this.cert.verify(((PKey)key).getPublicKey());
            return this.getRuntime().getTrue();
        }
        catch (InvalidKeyException e) {
            return this.getRuntime().getFalse();
        }
    }

    public IRubyObject check_private_key(IRubyObject arg) {
        return this.getRuntime().getNil();
    }

    public IRubyObject extensions() {
        return this.getRuntime().newArray(this.extensions);
    }

    public IRubyObject set_extensions(IRubyObject arg) {
        this.extensions = ((RubyArray)arg).getList();
        return arg;
    }

    public IRubyObject add_extension(IRubyObject arg) throws Exception {
        this.changed = true;
        if (((X509Extensions.Extension)arg).getRealOid().equals((Object)new DERObjectIdentifier("2.5.29.17"))) {
            boolean one = true;
            Iterator iter = this.extensions.iterator();
            while (iter.hasNext()) {
                int i;
                X509Extensions.Extension ag = (X509Extensions.Extension)iter.next();
                if (!ag.getRealOid().equals((Object)new DERObjectIdentifier("2.5.29.17"))) continue;
                GeneralName[] n1 = GeneralNames.getInstance((Object)new ASN1InputStream(ag.getRealValueBytes()).readObject()).getNames();
                GeneralName[] n2 = GeneralNames.getInstance((Object)new ASN1InputStream(((X509Extensions.Extension)arg).getRealValueBytes()).readObject()).getNames();
                ASN1EncodableVector v1 = new ASN1EncodableVector();
                for (i = 0; i < n1.length; ++i) {
                    v1.add((DEREncodable)n1[i]);
                }
                for (i = 0; i < n2.length; ++i) {
                    v1.add((DEREncodable)n2[i]);
                }
                ag.setRealValue(new String(new GeneralNames((ASN1Sequence)new DERSequence((DEREncodableVector)v1)).getDEREncoded(), "ISO8859_1"));
                one = false;
                break;
            }
            if (one) {
                this.extensions.add(arg);
            }
        } else {
            this.extensions.add(arg);
        }
        return arg;
    }

    public IRubyObject rbClone() {
        X509Cert clone = new X509Cert(this.getRuntime(), this.getMetaClass().getRealClass());
        clone.setMetaClass(this.getMetaClass().getSingletonClassClone());
        clone.setTaint(this.isTaint());
        clone.initCopy(this);
        clone.setFrozen(this.isFrozen());
        return clone;
    }
}

