/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.openssl;

import java.security.MessageDigest;
import java.util.Iterator;
import java.util.List;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DERBoolean;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DEREncodableVector;
import org.bouncycastle.asn1.DERIA5String;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERString;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.DERUnknownTag;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.jruby.IRuby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.exceptions.RaiseException;
import org.jruby.ext.openssl.ASN1;
import org.jruby.ext.openssl.OpenSSLImpl;
import org.jruby.ext.openssl.PKeyRSA;
import org.jruby.ext.openssl.Utils;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class X509Extensions {
    public static void createX509Ext(IRuby runtime, RubyModule mX509) {
        RubyClass cX509ExtFactory = mX509.defineClassUnder("ExtensionFactory", runtime.getObject());
        mX509.defineClassUnder("ExtensionError", runtime.getModule("OpenSSL").getClass("OpenSSLError"));
        CallbackFactory extfcb = runtime.callbackFactory(ExtensionFactory.class);
        cX509ExtFactory.defineSingletonMethod("new", extfcb.getOptSingletonMethod("newInstance"));
        cX509ExtFactory.defineMethod("initialize", extfcb.getOptMethod("initialize"));
        cX509ExtFactory.attr_reader(new IRubyObject[]{runtime.newString("issuer_certificate"), runtime.newString("subject_certificate"), runtime.newString("subject_request"), runtime.newString("crl"), runtime.newString("config")});
        cX509ExtFactory.defineMethod("issuer_certificate=", extfcb.getMethod("set_issuer_cert", IRubyObject.class));
        cX509ExtFactory.defineMethod("subject_certificate=", extfcb.getMethod("set_subject_cert", IRubyObject.class));
        cX509ExtFactory.defineMethod("subject_request=", extfcb.getMethod("set_subject_req", IRubyObject.class));
        cX509ExtFactory.defineMethod("crl=", extfcb.getMethod("set_crl", IRubyObject.class));
        cX509ExtFactory.defineMethod("config=", extfcb.getMethod("set_config", IRubyObject.class));
        cX509ExtFactory.defineMethod("create_ext", extfcb.getOptMethod("create_ext"));
        RubyClass cX509Ext = mX509.defineClassUnder("Extension", runtime.getObject());
        CallbackFactory extcb = runtime.callbackFactory(Extension.class);
        cX509Ext.defineSingletonMethod("new", extcb.getOptSingletonMethod("newInstance"));
        cX509Ext.defineMethod("initialize", extcb.getOptMethod("_initialize"));
        cX509Ext.defineMethod("oid=", extcb.getMethod("set_oid", IRubyObject.class));
        cX509Ext.defineMethod("value=", extcb.getMethod("set_value", IRubyObject.class));
        cX509Ext.defineMethod("critical=", extcb.getMethod("set_critical", IRubyObject.class));
        cX509Ext.defineMethod("oid", extcb.getMethod("oid"));
        cX509Ext.defineMethod("value", extcb.getMethod("value"));
        cX509Ext.defineMethod("critical?", extcb.getMethod("critical_p"));
        cX509Ext.defineMethod("to_der", extcb.getMethod("to_der"));
    }

    public static class Extension
    extends RubyObject {
        private DERObjectIdentifier oid;
        private Object value;
        private boolean critical;

        public static IRubyObject newInstance(IRubyObject recv, IRubyObject[] args) {
            Extension result = new Extension(recv.getRuntime(), (RubyClass)recv);
            result.callInit(args);
            return result;
        }

        public Extension(IRuby runtime, RubyClass type) {
            super(runtime, type);
        }

        void setRealOid(DERObjectIdentifier oid) {
            this.oid = oid;
        }

        void setRealValue(Object value) {
            this.value = value;
        }

        void setRealCritical(boolean critical) {
            this.critical = critical;
        }

        DERObjectIdentifier getRealOid() {
            return this.oid;
        }

        Object getRealValue() {
            return this.value;
        }

        byte[] getRealValueBytes() throws Exception {
            if (this.value instanceof RubyString || this.value instanceof String) {
                return this.value.toString().getBytes("PLAIN");
            }
            if (this.value instanceof DEROctetString) {
                return ((DEROctetString)this.value).getOctets();
            }
            return ((ASN1.ASN1Data)this.value).toASN1().getDEREncoded();
        }

        boolean getRealCritical() {
            return this.critical;
        }

        DERObjectIdentifier getObjectIdentifier(String nameOrOid) {
            Object val1 = ASN1.getOIDLookup(this.getRuntime()).get(nameOrOid.toLowerCase());
            if (null != val1) {
                return (DERObjectIdentifier)val1;
            }
            DERObjectIdentifier val2 = new DERObjectIdentifier(nameOrOid);
            return val2;
        }

        public IRubyObject _initialize(IRubyObject[] args) throws Exception {
            byte[] octets = null;
            if (args.length == 1) {
                ASN1InputStream is = new ASN1InputStream(OpenSSLImpl.to_der_if_possible(args[0]).toString().getBytes("PLAIN"));
                DERObject obj = is.readObject();
                ASN1Sequence seq = (ASN1Sequence)obj;
                this.setRealOid((DERObjectIdentifier)seq.getObjectAt(0));
                this.setRealCritical(((DERBoolean)seq.getObjectAt(1)).isTrue());
                octets = ((DEROctetString)seq.getObjectAt(2)).getOctets();
            } else if (args.length > 1) {
                this.setRealOid(this.getObjectIdentifier(args[0].toString()));
                this.setRealValue(args[1]);
            }
            if (args.length > 2) {
                this.setRealCritical(args[2].isTrue());
            }
            if (args.length > 0 && octets != null) {
                this.setRealValue(new String(octets, "ISO8859_1"));
            }
            return this;
        }

        public IRubyObject set_oid(IRubyObject arg) {
            System.err.println("WARNING: calling ext#oid=");
            return this.getRuntime().getNil();
        }

        public IRubyObject set_value(IRubyObject arg) {
            System.err.println("WARNING: calling ext#value=");
            return this.getRuntime().getNil();
        }

        public IRubyObject set_critical(IRubyObject arg) {
            System.err.println("WARNING: calling ext#critical=");
            return this.getRuntime().getNil();
        }

        public IRubyObject oid() {
            return this.getRuntime().newString((String)ASN1.getSymLookup(this.getRuntime()).get(this.oid));
        }

        public IRubyObject value() throws Exception {
            if (this.getRealOid().equals((Object)new DERObjectIdentifier("2.5.29.19"))) {
                ASN1Sequence seq2 = (ASN1Sequence)new ASN1InputStream(this.getRealValueBytes()).readObject();
                String c = "";
                String path = "";
                if (seq2.size() > 0) {
                    c = "CA:" + (((DERBoolean)seq2.getObjectAt(0)).isTrue() ? "TRUE" : "FALSE");
                }
                if (seq2.size() > 1) {
                    path = ", pathlen:" + seq2.getObjectAt(1).toString();
                }
                return this.getRuntime().newString(c + path);
            }
            if (this.getRealOid().equals((Object)new DERObjectIdentifier("2.5.29.15"))) {
                byte[] bx = this.getRealValueBytes();
                byte[] bs = new byte[bx.length - 2];
                System.arraycopy(bx, 2, bs, 0, bs.length);
                byte b1 = 0;
                byte b2 = bs[0];
                if (bs.length > 1) {
                    b1 = bs[1];
                }
                StringBuffer sbe = new StringBuffer();
                String sep = "";
                if ((b2 & 0xFFFFFF80) != 0) {
                    sbe.append(sep).append("Decipher Only");
                    sep = ", ";
                }
                if ((b1 & 0xFFFFFF80) != 0) {
                    sbe.append(sep).append("Digital Signature");
                    sep = ", ";
                }
                if ((b1 & 0x40) != 0) {
                    sbe.append(sep).append("Non Repudiation");
                    sep = ", ";
                }
                if ((b1 & 0x20) != 0) {
                    sbe.append(sep).append("Key Encipherment");
                    sep = ", ";
                }
                if ((b1 & 0x10) != 0) {
                    sbe.append(sep).append("Data Encipherment");
                    sep = ", ";
                }
                if ((b1 & 8) != 0) {
                    sbe.append(sep).append("Key Agreement");
                    sep = ", ";
                }
                if ((b1 & 4) != 0) {
                    sbe.append(sep).append("Key Cert Sign");
                    sep = ", ";
                }
                if ((b1 & 2) != 0) {
                    sbe.append(sep).append("cRLSign");
                    sep = ", ";
                }
                if ((b1 & 1) != 0) {
                    sbe.append(sep).append("Encipher Only");
                }
                return this.getRuntime().newString(sbe.toString());
            }
            if (this.getRealOid().equals((Object)new DERObjectIdentifier("2.5.29.14"))) {
                byte[] b1 = this.getRealValueBytes();
                byte[] b2 = new byte[b1.length - 2];
                System.arraycopy(b1, 2, b2, 0, b2.length);
                return this.getRuntime().newString(Utils.toHex(b2, ':'));
            }
            if (this.getRealOid().equals((Object)new DERObjectIdentifier("2.5.29.35"))) {
                DERSequence seq = (DERSequence)new ASN1InputStream(this.getRealValueBytes()).readObject();
                StringBuffer out1 = new StringBuffer();
                if (seq.size() > 0) {
                    out1.append("keyid:");
                    out1.append(Utils.toHex(((DEROctetString)seq.getObjectAt(0)).getOctets(), ':'));
                }
                return this.getRuntime().newString(out1.toString());
            }
            if (this.getRealOid().equals((Object)new DERObjectIdentifier("2.5.29.21"))) {
                switch (RubyNumeric.fix2int(((IRubyObject)this.value).callMethod(this.getRuntime().getCurrentContext(), "value"))) {
                    case 0: {
                        return this.getRuntime().newString("Unspecified");
                    }
                    case 1: {
                        return this.getRuntime().newString("Key Compromise");
                    }
                    case 2: {
                        return this.getRuntime().newString("CA Compromise");
                    }
                    case 3: {
                        return this.getRuntime().newString("Affiliation Changed");
                    }
                    case 4: {
                        return this.getRuntime().newString("Superseded");
                    }
                    case 5: {
                        return this.getRuntime().newString("Cessation Of Operation");
                    }
                    case 6: {
                        return this.getRuntime().newString("Certificate Hold");
                    }
                    case 8: {
                        return this.getRuntime().newString("Remove From CRL");
                    }
                    case 9: {
                        return this.getRuntime().newString("Privilege Withdrawn");
                    }
                }
                return this.getRuntime().newString("Unspecified");
            }
            if (this.getRealOid().equals((Object)new DERObjectIdentifier("2.5.29.17"))) {
                try {
                    DERObject seq = new ASN1InputStream(this.getRealValueBytes()).readObject();
                    GeneralName[] n1 = null;
                    n1 = seq instanceof DERUnknownTag ? new GeneralName[]{GeneralName.getInstance((Object)seq)} : (seq instanceof DERTaggedObject ? new GeneralName[]{GeneralName.getInstance((Object)seq)} : GeneralNames.getInstance((Object)seq).getNames());
                    StringBuffer sbe = new StringBuffer();
                    String sep = "";
                    for (int i = 0; i < n1.length; ++i) {
                        sbe.append(sep);
                        if (n1[i].getTagNo() == 2) {
                            sbe.append("DNS:");
                            sbe.append(((DERString)n1[i].getName()).getString());
                        } else if (n1[i].getTagNo() == 7) {
                            sbe.append("IP Address:");
                            byte[] bs = ((DEROctetString)n1[i].getName()).getOctets();
                            String sep2 = "";
                            for (int j = 0; j < bs.length; ++j) {
                                sbe.append(sep2);
                                sbe.append(bs[j] & 0xFF);
                                sep2 = ".";
                            }
                        } else {
                            sbe.append(n1[i].toString());
                        }
                        sep = ", ";
                    }
                    return this.getRuntime().newString(sbe.toString());
                }
                catch (Exception e) {
                    return this.getRuntime().newString(this.getRealValue().toString());
                }
            }
            try {
                return ASN1.decode(this.getRuntime().getModule("OpenSSL").getConstant("ASN1"), this.getRuntime().newString(new String(this.getRealValueBytes(), "ISO8859_1"))).callMethod(this.getRuntime().getCurrentContext(), "value").callMethod(this.getRuntime().getCurrentContext(), "to_s");
            }
            catch (Exception e) {
                return this.getRuntime().newString(this.getRealValue().toString());
            }
        }

        public IRubyObject critical_p() {
            return this.critical ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
        }

        public IRubyObject to_der() throws Exception {
            ASN1EncodableVector all = new ASN1EncodableVector();
            all.add((DEREncodable)this.getRealOid());
            all.add((DEREncodable)(this.getRealCritical() ? DERBoolean.TRUE : DERBoolean.FALSE));
            all.add((DEREncodable)new DEROctetString(this.getRealValueBytes()));
            return this.getRuntime().newString(new String(new DERSequence((DEREncodableVector)all).getDEREncoded(), "ISO8859_1"));
        }
    }

    public static class ExtensionFactory
    extends RubyObject {
        public static IRubyObject newInstance(IRubyObject recv, IRubyObject[] args) {
            ExtensionFactory result = new ExtensionFactory(recv.getRuntime(), (RubyClass)recv);
            result.callInit(args);
            return result;
        }

        public ExtensionFactory(IRuby runtime, RubyClass type) {
            super(runtime, type);
        }

        public IRubyObject initialize(IRubyObject[] args) {
            this.checkArgumentCount(args, 0, 4);
            if (args.length > 0 && !args[0].isNil()) {
                this.set_issuer_cert(args[0]);
            }
            if (args.length > 1 && !args[1].isNil()) {
                this.set_subject_cert(args[1]);
            }
            if (args.length > 2 && !args[2].isNil()) {
                this.set_subject_req(args[2]);
            }
            if (args.length > 3 && !args[3].isNil()) {
                this.set_crl(args[3]);
            }
            return this;
        }

        public IRubyObject set_issuer_cert(IRubyObject arg) {
            this.setInstanceVariable("@issuer_certificate", arg);
            return arg;
        }

        public IRubyObject set_subject_cert(IRubyObject arg) {
            this.setInstanceVariable("@subject_certificate", arg);
            return arg;
        }

        public IRubyObject set_subject_req(IRubyObject arg) {
            this.setInstanceVariable("@subject_request", arg);
            return arg;
        }

        public IRubyObject set_crl(IRubyObject arg) {
            this.setInstanceVariable("@crl", arg);
            return arg;
        }

        public IRubyObject set_config(IRubyObject arg) {
            this.setInstanceVariable("@config", arg);
            return arg;
        }

        private DERObjectIdentifier getObjectIdentifier(String nameOrOid) {
            Object val1 = ASN1.getOIDLookup(this.getRuntime()).get(nameOrOid.toLowerCase());
            if (null != val1) {
                return (DERObjectIdentifier)val1;
            }
            DERObjectIdentifier val2 = new DERObjectIdentifier(nameOrOid);
            return val2;
        }

        private static boolean isHexDigit(char c) {
            return '0' <= c && c <= '9' || 'A' <= c && c <= 'F' || 'a' <= c && c <= 'f';
        }

        public IRubyObject create_ext(IRubyObject[] args) throws Exception {
            IRubyObject critical = this.getRuntime().getFalse();
            if (this.checkArgumentCount(args, 2, 3) == 3 && !args[2].isNil()) {
                critical = args[2];
            }
            String oid = args[0].toString();
            String valuex = args[1].toString();
            Object value = valuex;
            DERObjectIdentifier r_oid = null;
            try {
                r_oid = this.getObjectIdentifier(oid);
            }
            catch (IllegalArgumentException e) {
                r_oid = null;
            }
            if (null == r_oid) {
                throw new RaiseException(this.getRuntime(), (RubyClass)((RubyModule)this.getRuntime().getModule("OpenSSL").getConstant("X509")).getConstant("ExtensionError"), "unknown OID `" + oid + "'", true);
            }
            ThreadContext tc = this.getRuntime().getCurrentContext();
            Extension ext = (Extension)((RubyClass)((RubyModule)this.getRuntime().getModule("OpenSSL").getConstant("X509")).getConstant("Extension")).callMethod(tc, "new");
            if (valuex.startsWith("critical,")) {
                critical = this.getRuntime().getTrue();
                value = valuex.substring(9).trim();
            }
            if (r_oid.equals((Object)new DERObjectIdentifier("2.5.29.14"))) {
                if ("hash".equalsIgnoreCase(valuex)) {
                    IRubyObject pkey = this.getInstanceVariable("@subject_certificate").callMethod(tc, "public_key");
                    IRubyObject val = null;
                    val = pkey instanceof PKeyRSA ? pkey.callMethod(tc, "to_der") : ASN1.decode(this.getRuntime().getModule("OpenSSL").getConstant("ASN1"), pkey.callMethod(tc, "to_der")).callMethod(tc, "value").callMethod(tc, "[]", this.getRuntime().newFixnum(1L)).callMethod(tc, "value");
                    byte[] b = MessageDigest.getInstance("SHA-1").digest(val.toString().getBytes("PLAIN"));
                    value = new String(new DEROctetString(b).getDEREncoded(), "ISO8859_1");
                } else if (valuex.length() == 20) {
                    value = new String(new DEROctetString(valuex.getBytes("PLAIN")).getDEREncoded(), "ISO8859_1");
                } else {
                    StringBuffer nstr = new StringBuffer();
                    for (int i = 0; i < valuex.length(); i += 2) {
                        if (i + 1 >= valuex.length()) {
                            throw new RaiseException(this.getRuntime(), (RubyClass)((RubyModule)this.getRuntime().getModule("OpenSSL").getConstant("X509")).getConstant("ExtensionError"), oid + " = " + value + ": odd number of digits", true);
                        }
                        char c1 = valuex.charAt(i);
                        char c2 = valuex.charAt(i + 1);
                        if (ExtensionFactory.isHexDigit(c1) && ExtensionFactory.isHexDigit(c2)) {
                            nstr.append(Character.toUpperCase(c1)).append(Character.toUpperCase(c2));
                        } else {
                            throw new RaiseException(this.getRuntime(), (RubyClass)((RubyModule)this.getRuntime().getModule("OpenSSL").getConstant("X509")).getConstant("ExtensionError"), oid + " = " + value + ": illegal hex digit", true);
                        }
                        while (i + 2 < valuex.length() && valuex.charAt(i + 2) == ':') {
                            ++i;
                        }
                    }
                    String v = nstr.toString();
                    byte[] arr = new byte[v.length() / 2];
                    for (int i = 0; i < v.length(); i += 2) {
                        arr[i / 2] = (byte)Integer.parseInt(v.substring(i, i + 2), 16);
                    }
                    value = new String(new DEROctetString(arr).getDEREncoded(), "ISO8859_1");
                }
            } else if (r_oid.equals((Object)new DERObjectIdentifier("2.5.29.35"))) {
                String ourV = valuex;
                ASN1EncodableVector asnv = new ASN1EncodableVector();
                if (ourV.startsWith("keyid:always")) {
                    ourV = ourV.substring("keyid:always".length());
                    IRubyObject pkey = this.getInstanceVariable("@issuer_certificate").callMethod(tc, "public_key");
                    IRubyObject val = null;
                    val = pkey instanceof PKeyRSA ? pkey.callMethod(tc, "to_der") : ASN1.decode(this.getRuntime().getModule("OpenSSL").getConstant("ASN1"), pkey.callMethod(tc, "to_der")).callMethod(tc, "value").callMethod(tc, "[]", this.getRuntime().newFixnum(1L)).callMethod(tc, "value");
                    byte[] b = MessageDigest.getInstance("SHA-1").digest(val.toString().getBytes("PLAIN"));
                    asnv.add((DEREncodable)new DEROctetString(b));
                } else if (ourV.startsWith("keyid")) {
                    ourV = ourV.substring("keyid".length());
                    IRubyObject pkey = this.getInstanceVariable("@issuer_certificate").callMethod(tc, "public_key");
                    IRubyObject val = null;
                    val = pkey instanceof PKeyRSA ? pkey.callMethod(tc, "to_der") : ASN1.decode(this.getRuntime().getModule("OpenSSL").getConstant("ASN1"), pkey.callMethod(tc, "to_der")).callMethod(tc, "value").callMethod(tc, "[]", this.getRuntime().newFixnum(1L)).callMethod(tc, "value");
                    byte[] b = MessageDigest.getInstance("SHA-1").digest(val.toString().getBytes("PLAIN"));
                    asnv.add((DEREncodable)new DEROctetString(b));
                }
                value = new String(new DERSequence((DEREncodableVector)asnv).getDEREncoded(), "ISO8859_1");
            } else if (r_oid.equals((Object)new DERObjectIdentifier("2.5.29.18"))) {
                if (valuex.startsWith("issuer:copy")) {
                    List exts = ((RubyArray)this.getInstanceVariable("@issuer_certificate").callMethod(tc, "extensions")).getList();
                    Iterator iter = exts.iterator();
                    while (iter.hasNext()) {
                        Extension exta = (Extension)iter.next();
                        if (!exta.getRealOid().equals((Object)new DERObjectIdentifier("2.5.29.17"))) continue;
                        value = exta.getRealValue();
                        break;
                    }
                }
            } else if (r_oid.equals((Object)new DERObjectIdentifier("2.5.29.19"))) {
                int i;
                String[] spl = valuex.split(",");
                for (int i2 = 0; i2 < spl.length; ++i2) {
                    spl[i2] = spl[i2].trim();
                }
                ASN1EncodableVector asnv = new ASN1EncodableVector();
                for (i = 0; i < spl.length; ++i) {
                    if (spl[i].length() <= 3 || !spl[i].substring(0, 3).equalsIgnoreCase("CA:")) continue;
                    asnv.add((DEREncodable)new DERBoolean("TRUE".equalsIgnoreCase(spl[i].substring(3).trim())));
                }
                for (i = 0; i < spl.length; ++i) {
                    if (spl[i].length() <= 8 || !spl[i].substring(0, 8).equalsIgnoreCase("pathlen:")) continue;
                    asnv.add((DEREncodable)new DERInteger(Integer.parseInt(spl[i].substring(8).trim())));
                }
                value = new String(new DERSequence((DEREncodableVector)asnv).getDEREncoded(), "ISO8859_1");
            } else if (r_oid.equals((Object)new DERObjectIdentifier("2.5.29.15"))) {
                int i;
                byte[] inp = null;
                inp = null;
                try {
                    String[] exx = valuex.split(":");
                    if (exx != null) {
                        inp = new byte[exx.length];
                        for (i = 0; i < exx.length; ++i) {
                            inp[i] = (byte)Integer.parseInt(exx[i], 16);
                        }
                    }
                }
                catch (Exception e) {
                    inp = null;
                }
                if (null == inp && valuex.length() < 3) {
                    inp = valuex.getBytes("PLAIN");
                }
                if (inp == null) {
                    int i3;
                    byte v1 = 0;
                    byte v2 = 0;
                    String[] spl = valuex.split(",");
                    for (i3 = 0; i3 < spl.length; ++i3) {
                        spl[i3] = spl[i3].trim();
                    }
                    for (i3 = 0; i3 < spl.length; ++i3) {
                        if ("decipherOnly".equals(spl[i3].trim()) || "Decipher Only".equals(spl[i3].trim())) {
                            v2 = (byte)(v2 | 0xFFFFFF80);
                            continue;
                        }
                        if ("digitalSignature".equals(spl[i3].trim()) || "Digital Signature".equals(spl[i3].trim())) {
                            v1 = (byte)(v1 | 0xFFFFFF80);
                            continue;
                        }
                        if ("nonRepudiation".equals(spl[i3].trim()) || "Non Repudiation".equals(spl[i3].trim())) {
                            v1 = (byte)(v1 | 0x40);
                            continue;
                        }
                        if ("keyEncipherment".equals(spl[i3].trim()) || "Key Encipherment".equals(spl[i3].trim())) {
                            v1 = (byte)(v1 | 0x20);
                            continue;
                        }
                        if ("dataEncipherment".equals(spl[i3].trim()) || "Data Encipherment".equals(spl[i3].trim())) {
                            v1 = (byte)(v1 | 0x10);
                            continue;
                        }
                        if ("keyAgreement".equals(spl[i3].trim()) || "Key Agreement".equals(spl[i3].trim())) {
                            v1 = (byte)(v1 | 8);
                            continue;
                        }
                        if ("keyCertSign".equals(spl[i3].trim()) || "Key Cert Sign".equals(spl[i3].trim())) {
                            v1 = (byte)(v1 | 4);
                            continue;
                        }
                        if ("cRLSign".equals(spl[i3].trim())) {
                            v1 = (byte)(v1 | 2);
                            continue;
                        }
                        if ("encipherOnly".equals(spl[i3].trim()) || "Encipher Only".equals(spl[i3].trim())) {
                            v1 = (byte)(v1 | 1);
                            continue;
                        }
                        throw new RaiseException(this.getRuntime(), (RubyClass)((RubyModule)this.getRuntime().getModule("OpenSSL").getConstant("X509")).getConstant("ExtensionError"), oid + " = " + valuex + ": unknown bit string argument", true);
                    }
                    inp = v2 != 0 ? new byte[]{v1, v2} : new byte[]{v1};
                }
                int unused = 0;
                for (i = inp.length - 1; i > -1; --i) {
                    if (inp[i] == 0) {
                        unused += 8;
                        continue;
                    }
                    byte a2 = inp[i];
                    int x = 8;
                    while (a2 != 0) {
                        a2 = (byte)(a2 << 1);
                        --x;
                    }
                    unused += x;
                    break;
                }
                value = new String(new DERBitString(inp, unused).getDEREncoded(), "ISO8859_1");
            } else if (r_oid.equals((Object)new DERObjectIdentifier("2.5.29.17"))) {
                if (valuex.startsWith("DNS:")) {
                    value = new String(new GeneralNames(new GeneralName(2, (ASN1Encodable)new DERIA5String(valuex.substring(4)))).getDEREncoded(), "ISO8859_1");
                } else if (valuex.startsWith("IP:")) {
                    String[] numbers = valuex.substring(3).split("\\.");
                    byte[] bs = new byte[]{(byte)(Integer.parseInt(numbers[0]) & 0xFF), (byte)(Integer.parseInt(numbers[1]) & 0xFF), (byte)(Integer.parseInt(numbers[2]) & 0xFF), (byte)(Integer.parseInt(numbers[3]) & 0xFF)};
                    value = new String(new GeneralNames(new GeneralName(7, (ASN1Encodable)new DEROctetString(bs))).getDEREncoded(), "ISO8859_1");
                } else if (valuex.startsWith("IP Address:")) {
                    String[] numbers = valuex.substring(11).split("\\.");
                    byte[] bs = new byte[]{(byte)(Integer.parseInt(numbers[0]) & 0xFF), (byte)(Integer.parseInt(numbers[1]) & 0xFF), (byte)(Integer.parseInt(numbers[2]) & 0xFF), (byte)(Integer.parseInt(numbers[3]) & 0xFF)};
                    value = new String(new GeneralNames(new GeneralName(7, (ASN1Encodable)new DEROctetString(bs))).getDEREncoded(), "ISO8859_1");
                }
            } else {
                value = new DEROctetString(new DEROctetString(valuex.getBytes("PLAIN")).getDEREncoded());
            }
            ext.setRealOid(r_oid);
            ext.setRealValue(value);
            ext.setRealCritical(critical.isTrue());
            return ext;
        }
    }
}

