/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.openssl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jruby.IRuby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.RubyTime;
import org.jruby.exceptions.RaiseException;
import org.jruby.ext.openssl.X509Cert;
import org.jruby.ext.openssl.X509Store;
import org.jruby.ext.openssl.x509store.X509;
import org.jruby.ext.openssl.x509store.X509AuxCertificate;
import org.jruby.ext.openssl.x509store.X509_STORE;
import org.jruby.ext.openssl.x509store.X509_STORE_CTX;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.builtin.IRubyObject;

public class X509StoreCtx
extends RubyObject {
    private X509_STORE_CTX ctx = new X509_STORE_CTX();
    private RubyClass cStoreError;
    private RubyClass cX509Cert;

    public static void createX509StoreCtx(IRuby runtime, RubyModule mX509) {
        RubyClass cX509StoreContext = mX509.defineClassUnder("StoreContext", runtime.getObject());
        CallbackFactory storectxcb = runtime.callbackFactory(X509StoreCtx.class);
        cX509StoreContext.defineSingletonMethod("new", storectxcb.getOptSingletonMethod("newInstance"));
        cX509StoreContext.defineMethod("initialize", storectxcb.getOptMethod("_initialize"));
        cX509StoreContext.defineMethod("verify", storectxcb.getMethod("verify"));
        cX509StoreContext.defineMethod("chain", storectxcb.getMethod("chain"));
        cX509StoreContext.defineMethod("error", storectxcb.getMethod("error"));
        cX509StoreContext.defineMethod("error=", storectxcb.getMethod("set_error", IRubyObject.class));
        cX509StoreContext.defineMethod("error_string", storectxcb.getMethod("error_string"));
        cX509StoreContext.defineMethod("error_depth", storectxcb.getMethod("error_depth"));
        cX509StoreContext.defineMethod("current_cert", storectxcb.getMethod("current_cert"));
        cX509StoreContext.defineMethod("current_crl", storectxcb.getMethod("current_crl"));
        cX509StoreContext.defineMethod("cleanup", storectxcb.getMethod("cleanup"));
        cX509StoreContext.defineMethod("flags=", storectxcb.getMethod("set_flags", IRubyObject.class));
        cX509StoreContext.defineMethod("purpose=", storectxcb.getMethod("set_purpose", IRubyObject.class));
        cX509StoreContext.defineMethod("trust=", storectxcb.getMethod("set_trust", IRubyObject.class));
        cX509StoreContext.defineMethod("time=", storectxcb.getMethod("set_time", IRubyObject.class));
    }

    public static IRubyObject newInstance(IRubyObject recv, IRubyObject[] args) {
        X509StoreCtx result = new X509StoreCtx(recv.getRuntime(), (RubyClass)recv);
        result.callInit(args);
        return result;
    }

    public X509StoreCtx(IRuby runtime, RubyClass type) {
        super(runtime, type);
        this.cStoreError = (RubyClass)((RubyModule)runtime.getModule("OpenSSL").getConstant("X509")).getConstant("StoreError");
        this.cX509Cert = (RubyClass)((RubyModule)runtime.getModule("OpenSSL").getConstant("X509")).getConstant("Certificate");
    }

    private void raise(String msg) {
        throw new RaiseException(this.getRuntime(), this.cStoreError, msg, true);
    }

    public IRubyObject _initialize(IRubyObject[] args) throws Exception {
        IRubyObject t;
        IRubyObject cert = this.getRuntime().getNil();
        IRubyObject chain = this.getRuntime().getNil();
        X509AuxCertificate x509 = null;
        ArrayList<X509AuxCertificate> x509s = new ArrayList<X509AuxCertificate>();
        if (this.checkArgumentCount(args, 1, 3) > 1) {
            cert = args[1];
        }
        if (args.length > 2) {
            chain = args[2];
        }
        IRubyObject store = args[0];
        X509_STORE x509st = ((X509Store)store).getStore();
        if (!cert.isNil()) {
            x509 = ((X509Cert)cert).getAuxCert();
        }
        if (!chain.isNil()) {
            x509s = new ArrayList();
            Iterator iter = ((RubyArray)chain).getList().iterator();
            while (iter.hasNext()) {
                x509s.add(((X509Cert)iter.next()).getAuxCert());
            }
        }
        if (this.ctx.init(x509st, x509, x509s) != 1) {
            this.raise(null);
        }
        if (!(t = store.getInstanceVariable("@time")).isNil()) {
            this.set_time(t);
        }
        this.setInstanceVariable("@verify_callback", store.getInstanceVariable("@verify_callback"));
        this.setInstanceVariable("@cert", cert);
        return this;
    }

    public IRubyObject verify() throws Exception {
        this.ctx.set_ex_data(1, this.getInstanceVariable("@verify_callback"));
        int result = this.ctx.verify_cert();
        return result != 0 ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
    }

    public IRubyObject chain() throws Exception {
        List chain = this.ctx.get_chain();
        if (chain == null) {
            return this.getRuntime().getNil();
        }
        ArrayList<IRubyObject> ary = new ArrayList<IRubyObject>();
        Iterator iter = chain.iterator();
        while (iter.hasNext()) {
            X509AuxCertificate x509 = (X509AuxCertificate)iter.next();
            ary.add(this.cX509Cert.callMethod(this.getRuntime().getCurrentContext(), "new", this.getRuntime().newString(new String(x509.getEncoded(), "ISO8859_1"))));
        }
        return this.getRuntime().newArray(ary);
    }

    public IRubyObject error() {
        return this.getRuntime().newFixnum(this.ctx.get_error());
    }

    public IRubyObject set_error(IRubyObject arg) {
        System.err.println("WARNING: unimplemented method called: StoreContext#set_error");
        return this.getRuntime().getNil();
    }

    public IRubyObject error_string() {
        int err = this.ctx.get_error();
        return this.getRuntime().newString(X509.verify_cert_error_string(err));
    }

    public IRubyObject error_depth() {
        System.err.println("WARNING: unimplemented method called: StoreContext#error_depth");
        return this.getRuntime().getNil();
    }

    public IRubyObject current_cert() {
        System.err.println("WARNING: unimplemented method called: StoreContext#current_cert");
        return this.getRuntime().getNil();
    }

    public IRubyObject current_crl() {
        System.err.println("WARNING: unimplemented method called: StoreContext#current_crl");
        return this.getRuntime().getNil();
    }

    public IRubyObject cleanup() {
        System.err.println("WARNING: unimplemented method called: StoreContext#cleanup");
        return this.getRuntime().getNil();
    }

    public IRubyObject set_flags(IRubyObject arg) {
        System.err.println("WARNING: unimplemented method called: StoreContext#set_flags");
        return this.getRuntime().getNil();
    }

    public IRubyObject set_purpose(IRubyObject arg) {
        System.err.println("WARNING: unimplemented method called: StoreContext#set_purpose");
        return this.getRuntime().getNil();
    }

    public IRubyObject set_trust(IRubyObject arg) {
        System.err.println("WARNING: unimplemented method called: StoreContext#set_trust");
        return this.getRuntime().getNil();
    }

    public IRubyObject set_time(IRubyObject arg) {
        this.ctx.set_time(0L, ((RubyTime)arg).getJavaDate());
        return arg;
    }
}

