/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.openssl.x509store;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.math.BigInteger;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.cert.CRLException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.DSAPrivateKeySpec;
import java.security.spec.DSAPublicKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Iterator;
import java.util.StringTokenizer;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1OutputStream;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DEREncodableVector;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.DERUTF8String;
import org.bouncycastle.asn1.cms.ContentInfo;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.pkcs.RSAPrivateKeyStructure;
import org.bouncycastle.asn1.x509.DSAParameter;
import org.bouncycastle.asn1.x509.RSAPublicKeyStructure;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.crypto.PBEParametersGenerator;
import org.bouncycastle.crypto.generators.OpenSSLPBEParametersGenerator;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.util.encoders.Base64;
import org.bouncycastle.util.encoders.Hex;
import org.jruby.ext.openssl.PKCS10CertificationRequestExt;
import org.jruby.ext.openssl.x509store.X509AuxCertificate;
import org.jruby.ext.openssl.x509store.X509_AUX;

public class PEM {
    public static final String BEF = "-----";
    public static final String AFT = "-----";
    public static final String BEF_G = "-----BEGIN ";
    public static final String BEF_E = "-----END ";
    public static final String PEM_STRING_X509_OLD = "X509 CERTIFICATE";
    public static final String PEM_STRING_X509 = "CERTIFICATE";
    public static final String PEM_STRING_X509_PAIR = "CERTIFICATE PAIR";
    public static final String PEM_STRING_X509_TRUSTED = "TRUSTED CERTIFICATE";
    public static final String PEM_STRING_X509_REQ_OLD = "NEW CERTIFICATE REQUEST";
    public static final String PEM_STRING_X509_REQ = "CERTIFICATE REQUEST";
    public static final String PEM_STRING_X509_CRL = "X509 CRL";
    public static final String PEM_STRING_EVP_PKEY = "ANY PRIVATE KEY";
    public static final String PEM_STRING_PUBLIC = "PUBLIC KEY";
    public static final String PEM_STRING_RSA = "RSA PRIVATE KEY";
    public static final String PEM_STRING_RSA_PUBLIC = "RSA PUBLIC KEY";
    public static final String PEM_STRING_DSA = "DSA PRIVATE KEY";
    public static final String PEM_STRING_DSA_PUBLIC = "DSA PUBLIC KEY";
    public static final String PEM_STRING_PKCS7 = "PKCS7";
    public static final String PEM_STRING_PKCS8 = "ENCRYPTED PRIVATE KEY";
    public static final String PEM_STRING_PKCS8INF = "PRIVATE KEY";
    public static final String PEM_STRING_DHPARAMS = "DH PARAMETERS";
    public static final String PEM_STRING_SSL_SESSION = "SSL SESSION PARAMETERS";
    public static final String PEM_STRING_DSAPARAMS = "DSA PARAMETERS";
    public static final String PEM_STRING_ECDSA_PUBLIC = "ECDSA PUBLIC KEY";
    public static final String PEM_STRING_ECPARAMETERS = "EC PARAMETERS";
    public static final String PEM_STRING_ECPRIVATEKEY = "EC PRIVATE KEY";
    private static SecureRandom random;

    private static BufferedReader into(Reader in) {
        if (in instanceof BufferedReader) {
            return (BufferedReader)in;
        }
        return new BufferedReader(in);
    }

    private static BufferedWriter outo(Writer out) {
        if (out instanceof BufferedWriter) {
            return (BufferedWriter)out;
        }
        return new BufferedWriter(out);
    }

    public static Object read(Reader in, char[] f) throws IOException {
        String line;
        BufferedReader _in = PEM.into(in);
        while ((line = _in.readLine()) != null) {
            if (line.indexOf("-----BEGIN PUBLIC KEY") != -1) {
                try {
                    return PEM.readPublicKey(_in, "-----END PUBLIC KEY");
                }
                catch (Exception e) {
                    throw new IOException("problem creating public key: " + e.toString());
                }
            }
            if (line.indexOf("-----BEGIN DSA PRIVATE KEY") != -1) {
                try {
                    return PEM.readKeyPair(_in, f, "DSA", "-----END DSA PRIVATE KEY");
                }
                catch (Exception e) {
                    throw new IOException("problem creating DSA private key: " + e.toString());
                }
            }
            if (line.indexOf("-----BEGIN RSA PUBLIC KEY") != -1) {
                try {
                    return PEM.readPublicKey(_in, "-----END RSA PUBLIC KEY");
                }
                catch (Exception e) {
                    throw new IOException("problem creating RSA public key: " + e.toString());
                }
            }
            if (line.indexOf("-----BEGIN X509 CERTIFICATE") != -1) {
                try {
                    return PEM.readAuxCertificate(_in, "-----END X509 CERTIFICATE");
                }
                catch (Exception e) {
                    throw new IOException("problem creating X509 Aux certificate: " + e.toString());
                }
            }
            if (line.indexOf("-----BEGIN CERTIFICATE") != -1) {
                try {
                    return PEM.readAuxCertificate(_in, "-----END CERTIFICATE");
                }
                catch (Exception e) {
                    throw new IOException("problem creating X509 Aux certificate: " + e.toString());
                }
            }
            if (line.indexOf("-----BEGIN TRUSTED CERTIFICATE") != -1) {
                try {
                    return PEM.readAuxCertificate(_in, "-----END TRUSTED CERTIFICATE");
                }
                catch (Exception e) {
                    throw new IOException("problem creating X509 Aux certificate: " + e.toString());
                }
            }
            if (line.indexOf("-----BEGIN X509 CRL") != -1) {
                try {
                    return PEM.readCRL(_in, "-----END X509 CRL");
                }
                catch (Exception e) {
                    throw new IOException("problem creating X509 CRL: " + e.toString());
                }
            }
            if (line.indexOf("-----BEGIN CERTIFICATE REQUEST") == -1) continue;
            try {
                return PEM.readCertificateRequest(_in, "-----END CERTIFICATE REQUEST");
            }
            catch (Exception e) {
                throw new IOException("problem creating X509 REQ: " + e.toString());
            }
        }
        return null;
    }

    public static DSAPublicKey read_DSA_PUBKEY(Reader in, char[] f) throws IOException {
        return null;
    }

    public static DSAPublicKey read_DSAPublicKey(Reader in, char[] f) throws IOException {
        String line;
        BufferedReader _in = PEM.into(in);
        while ((line = _in.readLine()) != null) {
            if (line.indexOf("-----BEGIN PUBLIC KEY") == -1) continue;
            try {
                return (DSAPublicKey)PEM.readPublicKey(_in, "DSA", "-----END PUBLIC KEY");
            }
            catch (Exception e) {
                throw new IOException("problem creating DSA public key: " + e.toString());
            }
        }
        return null;
    }

    public static KeyPair read_DSAPrivateKey(Reader in, char[] f) throws IOException {
        String line;
        BufferedReader _in = PEM.into(in);
        while ((line = _in.readLine()) != null) {
            if (line.indexOf("-----BEGIN DSA PRIVATE KEY") == -1) continue;
            try {
                return PEM.readKeyPair(_in, f, "DSA", "-----END DSA PRIVATE KEY");
            }
            catch (Exception e) {
                throw new IOException("problem creating DSA private key: " + e.toString());
            }
        }
        return null;
    }

    public static RSAPublicKey read_RSA_PUBKEY(Reader in, char[] f) throws IOException {
        String line;
        BufferedReader _in = PEM.into(in);
        while ((line = _in.readLine()) != null) {
            if (line.indexOf("-----BEGIN PUBLIC KEY") != -1) {
                try {
                    return PEM.readRSAPublicKey(_in, "-----END PUBLIC KEY");
                }
                catch (Exception e) {
                    throw new IOException("problem creating RSA public key: " + e.toString());
                }
            }
            if (line.indexOf("-----BEGIN RSA PUBLIC KEY") == -1) continue;
            try {
                return PEM.readRSAPublicKey(_in, "-----END RSA PUBLIC KEY");
            }
            catch (Exception e) {
                throw new IOException("problem creating RSA public key: " + e.toString());
            }
        }
        return null;
    }

    public static RSAPublicKey read_RSAPublicKey(Reader in, char[] f) throws IOException {
        String line;
        BufferedReader _in = PEM.into(in);
        while ((line = _in.readLine()) != null) {
            if (line.indexOf("-----BEGIN PUBLIC KEY") != -1) {
                try {
                    return (RSAPublicKey)PEM.readPublicKey(_in, "RSA", "-----END PUBLIC KEY");
                }
                catch (Exception e) {
                    throw new IOException("problem creating RSA public key: " + e.toString());
                }
            }
            if (line.indexOf("-----BEGIN RSA PUBLIC KEY") == -1) continue;
            try {
                return (RSAPublicKey)PEM.readPublicKey(_in, "RSA", "-----END RSA PUBLIC KEY");
            }
            catch (Exception e) {
                throw new IOException("problem creating RSA public key: " + e.toString());
            }
        }
        return null;
    }

    public static KeyPair read_RSAPrivateKey(Reader in, char[] f) throws IOException {
        String line;
        BufferedReader _in = PEM.into(in);
        while ((line = _in.readLine()) != null) {
            if (line.indexOf("-----BEGIN RSA PRIVATE KEY") == -1) continue;
            try {
                return PEM.readKeyPair(_in, f, "RSA", "-----END RSA PRIVATE KEY");
            }
            catch (Exception e) {
                throw new IOException("problem creating RSA private key: " + e.toString());
            }
        }
        return null;
    }

    public static CMSSignedData read_PKCS7(Reader in, char[] f) throws IOException {
        String line;
        BufferedReader _in = PEM.into(in);
        while ((line = _in.readLine()) != null) {
            if (line.indexOf("-----BEGIN PKCS7") == -1) continue;
            try {
                return PEM.readPKCS7(_in, f, "-----END PKCS7");
            }
            catch (Exception e) {
                throw new IOException("problem creating PKCS7: " + e.toString());
            }
        }
        return null;
    }

    public static X509AuxCertificate read_X509(Reader in, char[] f) throws IOException {
        String line;
        BufferedReader _in = PEM.into(in);
        while ((line = _in.readLine()) != null) {
            if (line.indexOf("-----BEGIN X509 CERTIFICATE") != -1) {
                try {
                    return new X509AuxCertificate(PEM.readCertificate(_in, "-----END X509 CERTIFICATE"));
                }
                catch (Exception e) {
                    throw new IOException("problem creating X509 certificate: " + e.toString());
                }
            }
            if (line.indexOf("-----BEGIN CERTIFICATE") != -1) {
                try {
                    return new X509AuxCertificate(PEM.readCertificate(_in, "-----END CERTIFICATE"));
                }
                catch (Exception e) {
                    throw new IOException("problem creating X509 certificate: " + e.toString());
                }
            }
            if (line.indexOf("-----BEGIN TRUSTED CERTIFICATE") == -1) continue;
            try {
                return new X509AuxCertificate(PEM.readCertificate(_in, "-----END TRUSTED CERTIFICATE"));
            }
            catch (Exception e) {
                throw new IOException("problem creating X509 certificate: " + e.toString());
            }
        }
        return null;
    }

    public static X509AuxCertificate read_X509_AUX(Reader in, char[] f) throws IOException {
        String line;
        BufferedReader _in = PEM.into(in);
        while ((line = _in.readLine()) != null) {
            if (line.indexOf("-----BEGIN X509 CERTIFICATE") != -1) {
                try {
                    return PEM.readAuxCertificate(_in, "-----END X509 CERTIFICATE");
                }
                catch (Exception e) {
                    throw new IOException("problem creating X509 Aux certificate: " + e.toString());
                }
            }
            if (line.indexOf("-----BEGIN CERTIFICATE") != -1) {
                try {
                    return PEM.readAuxCertificate(_in, "-----END CERTIFICATE");
                }
                catch (Exception e) {
                    throw new IOException("problem creating X509 Aux certificate: " + e.toString());
                }
            }
            if (line.indexOf("-----BEGIN TRUSTED CERTIFICATE") == -1) continue;
            try {
                return PEM.readAuxCertificate(_in, "-----END TRUSTED CERTIFICATE");
            }
            catch (Exception e) {
                throw new IOException("problem creating X509 Aux certificate: " + e.toString());
            }
        }
        return null;
    }

    public static X509CRL read_X509_CRL(Reader in, char[] f) throws IOException {
        String line;
        BufferedReader _in = PEM.into(in);
        while ((line = _in.readLine()) != null) {
            if (line.indexOf("-----BEGIN X509 CRL") == -1) continue;
            try {
                return PEM.readCRL(_in, "-----END X509 CRL");
            }
            catch (Exception e) {
                throw new IOException("problem creating X509 CRL: " + e.toString());
            }
        }
        return null;
    }

    public static PKCS10CertificationRequestExt read_X509_REQ(Reader in, char[] f) throws IOException {
        String line;
        BufferedReader _in = PEM.into(in);
        while ((line = _in.readLine()) != null) {
            if (line.indexOf("-----BEGIN CERTIFICATE REQUEST") == -1) continue;
            try {
                return PEM.readCertificateRequest(_in, "-----END CERTIFICATE REQUEST");
            }
            catch (Exception e) {
                throw new IOException("problem creating X509 REQ: " + e.toString());
            }
        }
        return null;
    }

    public static void write_DSAPublicKey(Writer _out, DSAPublicKey obj) throws IOException {
        BufferedWriter out = PEM.outo(_out);
        byte[] encoding = obj.getEncoded();
        out.write("-----BEGIN PUBLIC KEY-----");
        out.newLine();
        PEM.writeEncoded(out, encoding);
        out.write("-----END PUBLIC KEY-----");
        out.newLine();
        out.flush();
    }

    public static void write_RSAPublicKey(Writer _out, RSAPublicKey obj) throws IOException {
        BufferedWriter out = PEM.outo(_out);
        byte[] encoding = obj.getEncoded();
        out.write("-----BEGIN PUBLIC KEY-----");
        out.newLine();
        PEM.writeEncoded(out, encoding);
        out.write("-----END PUBLIC KEY-----");
        out.newLine();
        out.flush();
    }

    public static void write_PKCS7(Writer _out, ContentInfo obj) throws IOException {
        BufferedWriter out = PEM.outo(_out);
        byte[] encoding = obj.getEncoded();
        out.write("-----BEGIN PKCS7-----");
        out.newLine();
        PEM.writeEncoded(out, encoding);
        out.write("-----END PKCS7-----");
        out.newLine();
        out.flush();
    }

    public static void write_PKCS7(Writer _out, CMSSignedData obj) throws IOException {
        BufferedWriter out = PEM.outo(_out);
        byte[] encoding = obj.getEncoded();
        out.write("-----BEGIN PKCS7-----");
        out.newLine();
        PEM.writeEncoded(out, encoding);
        out.write("-----END PKCS7-----");
        out.newLine();
        out.flush();
    }

    public static void write_X509(Writer _out, X509Certificate obj) throws IOException {
        BufferedWriter out = PEM.outo(_out);
        try {
            byte[] encoding = obj.getEncoded();
            out.write("-----BEGIN CERTIFICATE-----");
            out.newLine();
            PEM.writeEncoded(out, encoding);
            out.write("-----END CERTIFICATE-----");
            out.newLine();
            out.flush();
        }
        catch (CertificateEncodingException e) {
            throw new IOException("problem with encoding object in write_X509");
        }
    }

    public static void write_X509_AUX(Writer _out, X509AuxCertificate obj) throws IOException {
        BufferedWriter out = PEM.outo(_out);
        byte[] encoding = null;
        try {
            if (obj.getAux() == null) {
                encoding = obj.getEncoded();
            } else {
                Iterator iter;
                ASN1EncodableVector a2;
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                byte[] ymp = obj.getEncoded();
                baos.write(ymp, 0, ymp.length);
                X509_AUX aux = obj.getAux();
                ASN1EncodableVector a1 = new ASN1EncodableVector();
                if (aux.trust.size() > 0) {
                    a2 = new ASN1EncodableVector();
                    iter = aux.trust.iterator();
                    while (iter.hasNext()) {
                        a2.add((DEREncodable)new DERObjectIdentifier((String)iter.next()));
                    }
                    a1.add((DEREncodable)new DERSequence((DEREncodableVector)a2));
                }
                if (aux.reject.size() > 0) {
                    a2 = new ASN1EncodableVector();
                    iter = aux.reject.iterator();
                    while (iter.hasNext()) {
                        a2.add((DEREncodable)new DERObjectIdentifier((String)iter.next()));
                    }
                    a1.add((DEREncodable)new DERTaggedObject(0, (DEREncodable)new DERSequence((DEREncodableVector)a2)));
                }
                if (aux.alias != null) {
                    a1.add((DEREncodable)new DERUTF8String(aux.alias));
                }
                if (aux.keyid != null) {
                    a1.add((DEREncodable)new DEROctetString(aux.keyid));
                }
                if (aux.other.size() > 0) {
                    a2 = new ASN1EncodableVector();
                    iter = aux.other.iterator();
                    while (iter.hasNext()) {
                        a2.add((DEREncodable)((DERObject)iter.next()));
                    }
                    a1.add((DEREncodable)new DERTaggedObject(1, (DEREncodable)new DERSequence((DEREncodableVector)a2)));
                }
                ymp = new DERSequence((DEREncodableVector)a1).getEncoded();
                baos.write(ymp, 0, ymp.length);
                encoding = baos.toByteArray();
            }
        }
        catch (CertificateEncodingException e) {
            throw new IOException("problem with encoding object in write_X509_AUX");
        }
        out.write("-----BEGIN TRUSTED CERTIFICATE-----");
        out.newLine();
        PEM.writeEncoded(out, encoding);
        out.write("-----END TRUSTED CERTIFICATE-----");
        out.newLine();
        out.flush();
    }

    public static void write_X509_CRL(Writer _out, X509CRL obj) throws IOException {
        BufferedWriter out = PEM.outo(_out);
        try {
            byte[] encoding = obj.getEncoded();
            out.write("-----BEGIN X509 CRL-----");
            out.newLine();
            PEM.writeEncoded(out, encoding);
            out.write("-----END X509 CRL-----");
            out.newLine();
            out.flush();
        }
        catch (CRLException e) {
            throw new IOException("problem with encoding object in write_X509_CRL");
        }
    }

    public static void write_X509_REQ(Writer _out, PKCS10CertificationRequestExt obj) throws IOException {
        BufferedWriter out = PEM.outo(_out);
        byte[] encoding = obj.getEncoded();
        out.write("-----BEGIN CERTIFICATE REQUEST-----");
        out.newLine();
        PEM.writeEncoded(out, encoding);
        out.write("-----END CERTIFICATE REQUEST-----");
        out.newLine();
        out.flush();
    }

    public static void write_DSAPrivateKey(Writer _out, DSAPrivateKey obj, String algo, char[] f) throws IOException {
        BufferedWriter out = PEM.outo(_out);
        ByteArrayInputStream bIn = new ByteArrayInputStream(obj.getEncoded());
        ASN1InputStream aIn = new ASN1InputStream((InputStream)bIn);
        PrivateKeyInfo info = new PrivateKeyInfo((ASN1Sequence)aIn.readObject());
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        ASN1OutputStream aOut = new ASN1OutputStream((OutputStream)bOut);
        DSAParameter p = DSAParameter.getInstance((Object)info.getAlgorithmId().getParameters());
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add((DEREncodable)new DERInteger(0));
        v.add((DEREncodable)new DERInteger(p.getP()));
        v.add((DEREncodable)new DERInteger(p.getQ()));
        v.add((DEREncodable)new DERInteger(p.getG()));
        BigInteger x = obj.getX();
        BigInteger y = p.getG().modPow(x, p.getP());
        v.add((DEREncodable)new DERInteger(y));
        v.add((DEREncodable)new DERInteger(x));
        aOut.writeObject((Object)new DERSequence((DEREncodableVector)v));
        byte[] encoding = bOut.toByteArray();
        if (algo != null && f != null) {
            byte[] salt = new byte[8];
            byte[] encData = null;
            random.nextBytes(salt);
            OpenSSLPBEParametersGenerator pGen = new OpenSSLPBEParametersGenerator();
            pGen.init(PBEParametersGenerator.PKCS5PasswordToBytes((char[])f), salt);
            SecretKeySpec secretKey = null;
            if (!algo.equalsIgnoreCase("DESEDE")) {
                throw new IOException("unknown algorithm in write_DSAPrivateKey");
            }
            int keyLength = 24;
            secretKey = new SecretKeySpec(((KeyParameter)pGen.generateDerivedParameters(keyLength * 8)).getKey(), algo);
            try {
                Cipher c = Cipher.getInstance("DESede/CBC/PKCS5Padding", "BC");
                c.init(1, (Key)secretKey, new IvParameterSpec(salt));
                encData = c.doFinal(encoding);
            }
            catch (Exception e) {
                throw new IOException("exception using cipher: " + e.toString());
            }
            out.write("-----BEGIN DSA PRIVATE KEY-----");
            out.newLine();
            out.write("Proc-Type: 4,ENCRYPTED");
            out.newLine();
            out.write("DEK-Info: DES-EDE3-CBC,");
            PEM.writeHexEncoded(out, salt);
            out.newLine();
            out.newLine();
            PEM.writeEncoded(out, encData);
            out.write("-----END DSA PRIVATE KEY-----");
            out.flush();
        } else {
            out.write("-----BEGIN DSA PRIVATE KEY-----");
            out.newLine();
            PEM.writeEncoded(out, encoding);
            out.write("-----END DSA PRIVATE KEY-----");
            out.newLine();
            out.flush();
        }
    }

    public static void write_RSAPrivateKey(Writer _out, RSAPrivateCrtKey obj, String algo, char[] f) throws IOException {
        BufferedWriter out = PEM.outo(_out);
        RSAPrivateKeyStructure keyStruct = new RSAPrivateKeyStructure(obj.getModulus(), obj.getPublicExponent(), obj.getPrivateExponent(), obj.getPrimeP(), obj.getPrimeQ(), obj.getPrimeExponentP(), obj.getPrimeExponentQ(), obj.getCrtCoefficient());
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        ASN1OutputStream aOut = new ASN1OutputStream((OutputStream)bOut);
        aOut.writeObject((Object)keyStruct);
        aOut.close();
        byte[] encoding = bOut.toByteArray();
        if (algo != null && f != null) {
            byte[] salt = new byte[8];
            byte[] encData = null;
            random.nextBytes(salt);
            OpenSSLPBEParametersGenerator pGen = new OpenSSLPBEParametersGenerator();
            pGen.init(PBEParametersGenerator.PKCS5PasswordToBytes((char[])f), salt);
            SecretKeySpec secretKey = null;
            if (!algo.equalsIgnoreCase("DESEDE")) {
                throw new IOException("unknown algorithm in write_DSAPrivateKey");
            }
            int keyLength = 24;
            secretKey = new SecretKeySpec(((KeyParameter)pGen.generateDerivedParameters(keyLength * 8)).getKey(), algo);
            try {
                Cipher c = Cipher.getInstance("DESede/CBC/PKCS5Padding", "BC");
                c.init(1, (Key)secretKey, new IvParameterSpec(salt));
                encData = c.doFinal(encoding);
            }
            catch (Exception e) {
                throw new IOException("exception using cipher: " + e.toString());
            }
            out.write("-----BEGIN RSA PRIVATE KEY-----");
            out.newLine();
            out.write("Proc-Type: 4,ENCRYPTED");
            out.newLine();
            out.write("DEK-Info: DES-EDE3-CBC,");
            PEM.writeHexEncoded(out, salt);
            out.newLine();
            out.newLine();
            PEM.writeEncoded(out, encData);
            out.write("-----END RSA PRIVATE KEY-----");
            out.flush();
        } else {
            out.write("-----BEGIN RSA PRIVATE KEY-----");
            out.newLine();
            PEM.writeEncoded(out, encoding);
            out.write("-----END RSA PRIVATE KEY-----");
            out.newLine();
            out.flush();
        }
    }

    private static byte[] readBytes(BufferedReader in, String endMarker) throws IOException {
        String line;
        StringBuffer buf = new StringBuffer();
        while ((line = in.readLine()) != null && line.indexOf(endMarker) == -1) {
            buf.append(line.trim());
        }
        if (line == null) {
            throw new IOException(endMarker + " not found");
        }
        return Base64.decode((String)buf.toString());
    }

    private static SecretKey getKey(char[] k1, String algorithm, int keyLength, byte[] salt) throws IOException {
        byte[] key = new byte[keyLength];
        boolean offset = false;
        int bytesNeeded = keyLength;
        char[] password = k1;
        if (password == null) {
            throw new IOException("Password is null, but a password is required");
        }
        OpenSSLPBEParametersGenerator pGen = new OpenSSLPBEParametersGenerator();
        pGen.init(PBEParametersGenerator.PKCS5PasswordToBytes((char[])password), salt);
        return new SecretKeySpec(((KeyParameter)pGen.generateDerivedParameters(keyLength * 8)).getKey(), algorithm);
    }

    private static RSAPublicKey readRSAPublicKey(BufferedReader in, String endMarker) throws IOException {
        ByteArrayInputStream bAIS = new ByteArrayInputStream(PEM.readBytes(in, endMarker));
        ASN1InputStream ais = new ASN1InputStream((InputStream)bAIS);
        DERObject asnObject = ais.readObject();
        ASN1Sequence sequence = (ASN1Sequence)asnObject;
        RSAPublicKeyStructure rsaPubStructure = new RSAPublicKeyStructure(sequence);
        RSAPublicKeySpec keySpec = new RSAPublicKeySpec(rsaPubStructure.getModulus(), rsaPubStructure.getPublicExponent());
        try {
            KeyFactory keyFact = KeyFactory.getInstance("RSA", "BC");
            return (RSAPublicKey)keyFact.generatePublic(keySpec);
        }
        catch (NoSuchAlgorithmException e) {
        }
        catch (InvalidKeySpecException e) {
        }
        catch (NoSuchProviderException e) {
            throw new RuntimeException("can't find provider BC");
        }
        return null;
    }

    private static PublicKey readPublicKey(BufferedReader in, String alg, String endMarker) throws IOException {
        X509EncodedKeySpec keySpec = new X509EncodedKeySpec(PEM.readBytes(in, endMarker));
        try {
            KeyFactory keyFact = KeyFactory.getInstance(alg, "BC");
            PublicKey pubKey = keyFact.generatePublic(keySpec);
            return pubKey;
        }
        catch (NoSuchAlgorithmException e) {
        }
        catch (InvalidKeySpecException e) {
        }
        catch (NoSuchProviderException e) {
            throw new RuntimeException("can't find provider BC");
        }
        return null;
    }

    private static PublicKey readPublicKey(BufferedReader in, String endMarker) throws IOException {
        X509EncodedKeySpec keySpec = new X509EncodedKeySpec(PEM.readBytes(in, endMarker));
        String[] algs = new String[]{"RSA", "DSA"};
        for (int i = 0; i < algs.length; ++i) {
            try {
                KeyFactory keyFact = KeyFactory.getInstance(algs[i], "BC");
                PublicKey pubKey = keyFact.generatePublic(keySpec);
                return pubKey;
            }
            catch (NoSuchAlgorithmException e) {
                continue;
            }
            catch (InvalidKeySpecException e) {
                continue;
            }
            catch (NoSuchProviderException e) {
                throw new RuntimeException("can't find provider BC");
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static KeyPair readKeyPair(BufferedReader _in, char[] passwd, String type, String endMarker) throws Exception {
        void var10_16;
        void var9_12;
        DERInteger v;
        boolean isEncrypted = false;
        String line = null;
        String dekInfo = null;
        StringBuffer buf = new StringBuffer();
        while ((line = _in.readLine()) != null) {
            if (line.startsWith("Proc-Type: 4,ENCRYPTED")) {
                isEncrypted = true;
                continue;
            }
            if (line.startsWith("DEK-Info:")) {
                dekInfo = line.substring(10);
                continue;
            }
            if (line.indexOf(endMarker) != -1) break;
            buf.append(line.trim());
        }
        byte[] keyBytes = null;
        if (isEncrypted) {
            Cipher c;
            SecretKey sKey;
            byte[] iv;
            String alg;
            StringTokenizer stringTokenizer = new StringTokenizer(dekInfo, ",");
            String string = stringTokenizer.nextToken();
            if (string.equals("DES-EDE3-CBC")) {
                alg = "DESede";
                iv = Hex.decode((String)stringTokenizer.nextToken());
                sKey = PEM.getKey(passwd, alg, 24, iv);
                c = Cipher.getInstance("DESede/CBC/PKCS5Padding", "BC");
                c.init(2, (Key)sKey, new IvParameterSpec(iv));
                keyBytes = c.doFinal(Base64.decode((String)buf.toString()));
            } else {
                if (!string.equals("DES-CBC")) throw new IOException("unknown encryption with private key");
                alg = "DES";
                iv = Hex.decode((String)stringTokenizer.nextToken());
                sKey = PEM.getKey(passwd, alg, 8, iv);
                c = Cipher.getInstance("DES/CBC/PKCS5Padding", "BC");
                c.init(2, (Key)sKey, new IvParameterSpec(iv));
                keyBytes = c.doFinal(Base64.decode((String)buf.toString()));
            }
        } else {
            keyBytes = Base64.decode((String)buf.toString());
        }
        ByteArrayInputStream bIn = new ByteArrayInputStream(keyBytes);
        ASN1InputStream aIn = new ASN1InputStream((InputStream)bIn);
        ASN1Sequence seq = (ASN1Sequence)aIn.readObject();
        if (type.equals("RSA")) {
            v = (DERInteger)seq.getObjectAt(0);
            DERInteger mod = (DERInteger)seq.getObjectAt(1);
            DERInteger pubExp = (DERInteger)seq.getObjectAt(2);
            DERInteger privExp = (DERInteger)seq.getObjectAt(3);
            DERInteger p1 = (DERInteger)seq.getObjectAt(4);
            DERInteger p2 = (DERInteger)seq.getObjectAt(5);
            DERInteger exp1 = (DERInteger)seq.getObjectAt(6);
            DERInteger exp2 = (DERInteger)seq.getObjectAt(7);
            DERInteger crtCoef = (DERInteger)seq.getObjectAt(8);
            RSAPublicKeySpec rSAPublicKeySpec = new RSAPublicKeySpec(mod.getValue(), pubExp.getValue());
            RSAPrivateCrtKeySpec rSAPrivateCrtKeySpec = new RSAPrivateCrtKeySpec(mod.getValue(), pubExp.getValue(), privExp.getValue(), p1.getValue(), p2.getValue(), exp1.getValue(), exp2.getValue(), crtCoef.getValue());
        } else {
            v = (DERInteger)seq.getObjectAt(0);
            DERInteger p = (DERInteger)seq.getObjectAt(1);
            DERInteger q = (DERInteger)seq.getObjectAt(2);
            DERInteger g = (DERInteger)seq.getObjectAt(3);
            DERInteger y = (DERInteger)seq.getObjectAt(4);
            DERInteger x = (DERInteger)seq.getObjectAt(5);
            DSAPrivateKeySpec dSAPrivateKeySpec = new DSAPrivateKeySpec(x.getValue(), p.getValue(), q.getValue(), g.getValue());
            DSAPublicKeySpec dSAPublicKeySpec = new DSAPublicKeySpec(y.getValue(), p.getValue(), q.getValue(), g.getValue());
        }
        KeyFactory fact = KeyFactory.getInstance(type, "BC");
        return new KeyPair(fact.generatePublic((KeySpec)var9_12), fact.generatePrivate((KeySpec)var10_16));
    }

    private static X509Certificate readCertificate(BufferedReader in, String endMarker) throws IOException {
        String line;
        StringBuffer buf = new StringBuffer();
        while ((line = in.readLine()) != null && line.indexOf(endMarker) == -1) {
            buf.append(line.trim());
        }
        if (line == null) {
            throw new IOException(endMarker + " not found");
        }
        ByteArrayInputStream bIn = new ByteArrayInputStream(Base64.decode((String)buf.toString()));
        try {
            CertificateFactory certFact = CertificateFactory.getInstance("X.509", "BC");
            return (X509Certificate)certFact.generateCertificate(bIn);
        }
        catch (Exception e) {
            throw new IOException("problem parsing cert: " + e.toString());
        }
    }

    private static X509AuxCertificate readAuxCertificate(BufferedReader in, String endMarker) throws IOException {
        String line;
        StringBuffer buf = new StringBuffer();
        while ((line = in.readLine()) != null && line.indexOf(endMarker) == -1) {
            buf.append(line.trim());
        }
        if (line == null) {
            throw new IOException(endMarker + " not found");
        }
        ASN1InputStream try1 = new ASN1InputStream(Base64.decode((String)buf.toString()));
        ByteArrayInputStream bIn = new ByteArrayInputStream(try1.readObject().getEncoded());
        try {
            CertificateFactory certFact = CertificateFactory.getInstance("X.509", "BC");
            X509Certificate bCert = (X509Certificate)certFact.generateCertificate(bIn);
            DERSequence aux = (DERSequence)try1.readObject();
            X509_AUX ax = null;
            if (aux != null) {
                int i;
                ax = new X509_AUX();
                int ix = 0;
                if (aux.size() > ix && aux.getObjectAt(ix) instanceof DERSequence) {
                    DERSequence trust = (DERSequence)aux.getObjectAt(ix++);
                    for (i = 0; i < trust.size(); ++i) {
                        ax.trust.add(((DERObjectIdentifier)trust.getObjectAt(i)).getId());
                    }
                }
                if (aux.size() > ix && aux.getObjectAt(ix) instanceof DERTaggedObject && ((DERTaggedObject)aux.getObjectAt(ix)).getTagNo() == 0) {
                    DERSequence reject = (DERSequence)((DERTaggedObject)aux.getObjectAt(ix++)).getObject();
                    for (i = 0; i < reject.size(); ++i) {
                        ax.reject.add(((DERObjectIdentifier)reject.getObjectAt(i)).getId());
                    }
                }
                if (aux.size() > ix && aux.getObjectAt(ix) instanceof DERUTF8String) {
                    ax.alias = ((DERUTF8String)aux.getObjectAt(ix++)).getString();
                }
                if (aux.size() > ix && aux.getObjectAt(ix) instanceof DEROctetString) {
                    ax.keyid = ((DEROctetString)aux.getObjectAt(ix++)).getOctets();
                }
                if (aux.size() > ix && aux.getObjectAt(ix) instanceof DERTaggedObject && ((DERTaggedObject)aux.getObjectAt(ix)).getTagNo() == 1) {
                    DERSequence other = (DERSequence)((DERTaggedObject)aux.getObjectAt(ix++)).getObject();
                    for (i = 0; i < other.size(); ++i) {
                        ax.other.add(other.getObjectAt(i));
                    }
                }
            }
            return new X509AuxCertificate(bCert, ax);
        }
        catch (Exception e) {
            throw new IOException("problem parsing cert: " + e.toString());
        }
    }

    private static X509CRL readCRL(BufferedReader in, String endMarker) throws IOException {
        String line;
        StringBuffer buf = new StringBuffer();
        while ((line = in.readLine()) != null && line.indexOf(endMarker) == -1) {
            buf.append(line.trim());
        }
        if (line == null) {
            throw new IOException(endMarker + " not found");
        }
        ByteArrayInputStream bIn = new ByteArrayInputStream(Base64.decode((String)buf.toString()));
        try {
            CertificateFactory certFact = CertificateFactory.getInstance("X.509", "BC");
            return (X509CRL)certFact.generateCRL(bIn);
        }
        catch (Exception e) {
            throw new IOException("problem parsing cert: " + e.toString());
        }
    }

    private static PKCS10CertificationRequestExt readCertificateRequest(BufferedReader in, String endMarker) throws IOException {
        String line;
        StringBuffer buf = new StringBuffer();
        while ((line = in.readLine()) != null && line.indexOf(endMarker) == -1) {
            buf.append(line.trim());
        }
        if (line == null) {
            throw new IOException(endMarker + " not found");
        }
        try {
            return new PKCS10CertificationRequestExt(Base64.decode((String)buf.toString()));
        }
        catch (Exception e) {
            throw new IOException("problem parsing cert: " + e.toString());
        }
    }

    private static void writeHexEncoded(BufferedWriter out, byte[] bytes) throws IOException {
        bytes = Hex.encode((byte[])bytes);
        for (int i = 0; i != bytes.length; ++i) {
            out.write((char)bytes[i]);
        }
    }

    private static void writeEncoded(BufferedWriter out, byte[] bytes) throws IOException {
        char[] buf = new char[64];
        bytes = Base64.encode((byte[])bytes);
        for (int i = 0; i < bytes.length; i += buf.length) {
            int index;
            for (index = 0; index != buf.length && i + index < bytes.length; ++index) {
                buf[index] = (char)bytes[i + index];
            }
            out.write(buf, 0, index);
            out.newLine();
        }
    }

    private static CMSSignedData readPKCS7(BufferedReader in, char[] p, String endMarker) throws IOException {
        String line;
        StringBuffer buf = new StringBuffer();
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        while ((line = in.readLine()) != null && line.indexOf(endMarker) == -1) {
            line = line.trim();
            buf.append(line.trim());
            Base64.decode((String)buf.substring(0, buf.length() / 4 * 4), (OutputStream)bOut);
            buf.delete(0, buf.length() / 4 * 4);
        }
        if (buf.length() != 0) {
            throw new RuntimeException("base64 data appears to be truncated");
        }
        if (line == null) {
            throw new IOException(endMarker + " not found");
        }
        ByteArrayInputStream bIn = new ByteArrayInputStream(bOut.toByteArray());
        try {
            ASN1InputStream aIn = new ASN1InputStream((InputStream)bIn);
            return new CMSSignedData(ContentInfo.getInstance((Object)aIn.readObject()));
        }
        catch (Exception e) {
            throw new IOException("problem parsing PKCS7 object: " + e.toString());
        }
    }

    static {
        try {
            random = SecureRandom.getInstance("SHA1PRNG");
        }
        catch (Exception e) {
            random = null;
        }
    }
}

