/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.openssl.x509store;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.InputStreamReader;
import java.math.BigInteger;
import java.security.cert.CRL;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jruby.ext.openssl.x509store.Err;
import org.jruby.ext.openssl.x509store.Function1;
import org.jruby.ext.openssl.x509store.Function4;
import org.jruby.ext.openssl.x509store.Function5;
import org.jruby.ext.openssl.x509store.PEM;
import org.jruby.ext.openssl.x509store.X509;
import org.jruby.ext.openssl.x509store.X509AuxCertificate;
import org.jruby.ext.openssl.x509store.X509_CERT_FILE_CTX;
import org.jruby.ext.openssl.x509store.X509_HASH_DIR_CTX;
import org.jruby.ext.openssl.x509store.X509_LOOKUP_METHOD;
import org.jruby.ext.openssl.x509store.X509_NAME;
import org.jruby.ext.openssl.x509store.X509_OBJECT;
import org.jruby.ext.openssl.x509store.X509_STORE;
import org.jruby.ext.openssl.x509store.X509_STORE_CTX;

public class X509_LOOKUP {
    public boolean init = false;
    public boolean skip = false;
    public X509_LOOKUP_METHOD method;
    public Object method_data;
    public X509_STORE store_ctx;
    public static final int X509_L_FILE_LOAD = 1;
    public static final int X509_L_ADD_DIR = 2;
    private static final X509_LOOKUP_METHOD x509_file_lookup = new X509_LOOKUP_METHOD();
    private static final X509_LOOKUP_METHOD x509_dir_lookup = new X509_LOOKUP_METHOD();

    public X509_LOOKUP(X509_LOOKUP_METHOD method) throws Exception {
        this.method = method;
        this.method_data = null;
        this.store_ctx = null;
        if (method.new_item != null && method.new_item != Function1.iZ && method.new_item.call(this) == 0) {
            throw new Exception();
        }
    }

    public int load_file(X509_CERT_FILE_CTX.Path file) throws Exception {
        return this.ctrl(1, file.name, file.type, null);
    }

    public int add_dir(X509_HASH_DIR_CTX.Dir dir) throws Exception {
        return this.ctrl(2, dir.name, dir.type, null);
    }

    public static X509_LOOKUP_METHOD hash_dir() {
        return x509_dir_lookup;
    }

    public static X509_LOOKUP_METHOD file() {
        return x509_file_lookup;
    }

    public int ctrl(int cmd, String argc, long argl, String[] ret) throws Exception {
        if (this.method == null) {
            return -1;
        }
        if (this.method.ctrl != null && this.method.ctrl != Function5.iZ) {
            return this.method.ctrl.call(this, new Integer(cmd), argc, new Long(argl), ret);
        }
        return 1;
    }

    public int load_cert_file(String file, int type) throws Exception {
        if (file == null) {
            return 1;
        }
        int count = 0;
        int ret = 0;
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));
        X509AuxCertificate x = null;
        if (type == 1) {
            InputStreamReader r = new InputStreamReader(in);
            while (null != (x = PEM.read_X509_AUX(r, null))) {
                int i = this.store_ctx.add_cert(x);
                if (i == 0) {
                    return ret;
                }
                ++count;
                x = null;
            }
            ret = count;
        } else if (type == 2) {
            CertificateFactory cf = CertificateFactory.getInstance("X.509", "BC");
            x = X509_STORE_CTX.transform((X509Certificate)cf.generateCertificate(in));
            if (x == null) {
                Err.PUT_err(13);
                return ret;
            }
            int i = this.store_ctx.add_cert(x);
            if (i == 0) {
                return ret;
            }
            ret = i;
        } else {
            Err.PUT_err(100);
        }
        return ret;
    }

    public int load_crl_file(String file, int type) throws Exception {
        if (file == null) {
            return 1;
        }
        int count = 0;
        int ret = 0;
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));
        CRL x = null;
        if (type == 1) {
            InputStreamReader r = new InputStreamReader(in);
            while (null != (x = PEM.read_X509_CRL(r, null))) {
                int i = this.store_ctx.add_crl(x);
                if (i == 0) {
                    return ret;
                }
                ++count;
                x = null;
            }
            ret = count;
        } else if (type == 2) {
            CertificateFactory cf = CertificateFactory.getInstance("X.509", "BC");
            x = cf.generateCRL(in);
            if (x == null) {
                Err.PUT_err(13);
                return ret;
            }
            int i = this.store_ctx.add_crl(x);
            if (i == 0) {
                return ret;
            }
            ret = i;
        } else {
            Err.PUT_err(100);
        }
        return ret;
    }

    public int load_cert_crl_file(String file, int type) throws Exception {
        Object v;
        if (type != 1) {
            return this.load_cert_file(file, type);
        }
        int count = 0;
        FileReader r = new FileReader(file);
        while (null != (v = PEM.read(r, null))) {
            if (v instanceof X509Certificate) {
                this.store_ctx.add_cert(X509_STORE_CTX.transform((X509Certificate)v));
                ++count;
                continue;
            }
            if (!(v instanceof CRL)) continue;
            this.store_ctx.add_crl((CRL)v);
            ++count;
        }
        return count;
    }

    public void free() throws Exception {
        if (this.method != null && this.method.free != null && this.method.free != Function1.iZ) {
            this.method.free.call(this);
        }
    }

    public int init() throws Exception {
        if (this.method == null) {
            return 0;
        }
        if (this.method.init != null && this.method.init != Function1.iZ) {
            return this.method.init.call(this);
        }
        return 1;
    }

    public int by_subject(int type, X509_NAME name, X509_OBJECT[] ret) throws Exception {
        if (this.method == null || this.method.get_by_subject == null || this.method.get_by_subject == Function4.iZ) {
            return 0;
        }
        if (this.skip) {
            return 0;
        }
        return this.method.get_by_subject.call(this, new Integer(type), name, ret);
    }

    public int by_issuer_serial(int type, X509_NAME name, BigInteger serial, X509_OBJECT[] ret) throws Exception {
        if (this.method == null || this.method.get_by_issuer_serial == null || this.method.get_by_issuer_serial == Function5.iZ) {
            return 0;
        }
        return this.method.get_by_issuer_serial.call(this, new Integer(type), name, serial, ret);
    }

    public int by_fingerprint(int type, String bytes, X509_OBJECT[] ret) throws Exception {
        if (this.method == null || this.method.get_by_fingerprint == null || this.method.get_by_fingerprint == Function4.iZ) {
            return 0;
        }
        return this.method.get_by_fingerprint.call(this, new Integer(type), bytes, ret);
    }

    public int by_alias(int type, String str, X509_OBJECT[] ret) throws Exception {
        if (this.method == null || this.method.get_by_alias == null || this.method.get_by_alias == Function4.iZ) {
            return 0;
        }
        return this.method.get_by_alias.call(this, new Integer(type), str, ret);
    }

    public int shutdown() throws Exception {
        if (this.method == null) {
            return 0;
        }
        if (this.method.shutdown != null && this.method.shutdown != Function1.iZ) {
            return this.method.shutdown.call(this);
        }
        return 1;
    }

    static {
        X509_LOOKUP.x509_file_lookup.name = "Load file into cache";
        X509_LOOKUP.x509_file_lookup.ctrl = new File_ByFileCtrl();
        X509_LOOKUP.x509_dir_lookup.name = "Load certs from files in a directory";
        X509_LOOKUP.x509_dir_lookup.new_item = new Dir_New();
        X509_LOOKUP.x509_dir_lookup.free = new Dir_Free();
        X509_LOOKUP.x509_dir_lookup.ctrl = new Dir_Ctrl();
        X509_LOOKUP.x509_dir_lookup.get_by_subject = new Dir_GetCertBySubject();
    }

    private static class Dir_GetCertBySubject
    implements Function4 {
        private Dir_GetCertBySubject() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int call(Object _xl, Object _type, Object _name, Object _ret) throws Exception {
            X509_LOOKUP x1 = (X509_LOOKUP)_xl;
            int type = (Integer)_type;
            X509_NAME name = (X509_NAME)_name;
            X509_OBJECT[] ret = (X509_OBJECT[])_ret;
            X509_OBJECT tmp = null;
            int ok = 0;
            StringBuffer b = new StringBuffer();
            if (null == name) {
                return 0;
            }
            String postfix = "";
            if (type != 1) {
                if (type == 2) {
                    postfix = "r";
                } else {
                    Err.PUT_err(112);
                    return ok;
                }
            }
            BY_DIR ctx = (BY_DIR)x1.method_data;
            long h = name.hash();
            Iterator iter = ctx.dirs.iterator();
            Iterator iter2 = ctx.dirs_type.iterator();
            while (iter.hasNext()) {
                String cdir = (String)iter.next();
                int tp = (Integer)iter2.next();
                int k = 0;
                do {
                    int c = 47;
                    b.append(String.format("%s/%08lx.%s%d", cdir, new Long(h), postfix, new Integer(k)));
                    ++k;
                } while (new File(b.toString()).exists() && !(type == 1 ? x1.load_cert_file(b.toString(), tp) == 0 : type == 2 && x1.load_crl_file(b.toString(), tp) == 0));
                Object object = X509.CRYPTO_LOCK_X509_STORE;
                synchronized (object) {
                    tmp = null;
                    Iterator iterx = x1.store_ctx.objs.iterator();
                    while (iterx.hasNext()) {
                        X509_OBJECT o = (X509_OBJECT)iterx.next();
                        if (o.type() != type || !o.isName(name)) continue;
                        tmp = o;
                        break;
                    }
                }
                if (tmp == null) continue;
                ok = 1;
                ret[0] = tmp;
                break;
            }
            return ok;
        }
    }

    private static class Dir_Ctrl
    implements Function5 {
        private Dir_Ctrl() {
        }

        public int call(Object _ctx, Object _cmd, Object _argp, Object _argl, Object _retp) {
            X509_LOOKUP ctx = (X509_LOOKUP)_ctx;
            int cmd = (Integer)_cmd;
            String argp = (String)_argp;
            long argl = (Long)_argl;
            String[] retp = (String[])_retp;
            int ret = 0;
            BY_DIR ld = (BY_DIR)ctx.method_data;
            String dir = null;
            switch (cmd) {
                case 2: {
                    if (argl == 3L) {
                        dir = System.getenv(X509.get_default_cert_dir_env());
                        ret = null != dir ? this.add_cert_dir(ld, dir, 1) : this.add_cert_dir(ld, X509.get_default_cert_dir(), 1);
                        if (ret != 0) break;
                        Err.PUT_err(103);
                        break;
                    }
                    ret = this.add_cert_dir(ld, argp, (int)argl);
                }
            }
            return ret;
        }

        private int add_cert_dir(BY_DIR ctx, String dir, int type) {
            if (dir == null || "".equals(dir)) {
                Err.PUT_err(113);
                return 0;
            }
            String[] dirs = dir.split(System.getProperty("path.separator"));
            for (int i = 0; i < dirs.length; ++i) {
                if (dirs[i].length() == 0 || ctx.dirs.contains(dirs[i])) continue;
                ctx.dirs_type.add(new Integer(type));
                ctx.dirs.add(dirs[i]);
            }
            return 1;
        }
    }

    private static class Dir_Free
    implements Function1 {
        private Dir_Free() {
        }

        public int call(Object _lu) {
            X509_LOOKUP lu = (X509_LOOKUP)_lu;
            BY_DIR a = (BY_DIR)lu.method_data;
            a.dirs = null;
            a.dirs_type = null;
            a.buffer = null;
            lu.method_data = null;
            return -1;
        }
    }

    private static class Dir_New
    implements Function1 {
        private Dir_New() {
        }

        public int call(Object _lu) {
            X509_LOOKUP lu = (X509_LOOKUP)_lu;
            BY_DIR a = new BY_DIR();
            a.buffer = new StringBuffer();
            a.dirs = new ArrayList();
            a.dirs_type = new ArrayList();
            lu.method_data = a;
            return 1;
        }
    }

    private static class BY_DIR {
        StringBuffer buffer;
        List dirs;
        List dirs_type;

        private BY_DIR() {
        }
    }

    private static class File_ByFileCtrl
    implements Function5 {
        private File_ByFileCtrl() {
        }

        public int call(Object _ctx, Object _cmd, Object _argp, Object _argl, Object _ret) throws Exception {
            X509_LOOKUP ctx = (X509_LOOKUP)_ctx;
            int cmd = (Integer)_cmd;
            String argp = (String)_argp;
            long argl = (Long)_argl;
            String[] ret = (String[])_ret;
            int ok = 0;
            String file = null;
            switch (cmd) {
                case 1: {
                    if (argl == 3L) {
                        file = System.getenv(X509.get_default_cert_file_env());
                        if (file != null) {
                            ok = ctx.load_cert_crl_file(file, 1) != 0 ? 1 : 0;
                        } else {
                            int n = ok = ctx.load_cert_crl_file(X509.get_default_cert_file(), 1) != 0 ? 1 : 0;
                        }
                        if (ok != 0) break;
                        Err.PUT_err(104);
                        break;
                    }
                    ok = argl == 1L ? (ctx.load_cert_crl_file(argp, 1) != 0 ? 1 : 0) : (ctx.load_cert_file(argp, (int)argl) != 0 ? 1 : 0);
                }
            }
            return ok;
        }
    }
}

