/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.openssl.x509store;

import java.security.cert.CRL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.net.ssl.X509TrustManager;
import org.jruby.ext.openssl.x509store.Err;
import org.jruby.ext.openssl.x509store.Function1;
import org.jruby.ext.openssl.x509store.Function2;
import org.jruby.ext.openssl.x509store.Function3;
import org.jruby.ext.openssl.x509store.X509;
import org.jruby.ext.openssl.x509store.X509AuxCertificate;
import org.jruby.ext.openssl.x509store.X509_CERT_FILE_CTX;
import org.jruby.ext.openssl.x509store.X509_HASH_DIR_CTX;
import org.jruby.ext.openssl.x509store.X509_LOOKUP;
import org.jruby.ext.openssl.x509store.X509_LOOKUP_METHOD;
import org.jruby.ext.openssl.x509store.X509_OBJECT;
import org.jruby.ext.openssl.x509store.X509_OBJECT_CERT;
import org.jruby.ext.openssl.x509store.X509_OBJECT_CRL;
import org.jruby.ext.openssl.x509store.X509_STORE_CTX;
import org.jruby.ext.openssl.x509store.X509_VERIFY_PARAM;

public class X509_STORE
implements X509TrustManager {
    public int cache = 1;
    public List objs = new ArrayList();
    public List get_cert_methods = new ArrayList();
    public X509_VERIFY_PARAM param;
    public Function1 verify = Function1.iZ;
    public Function2 verify_cb = Function2.iZ;
    public Function3 get_issuer;
    public Function3 check_issued;
    public Function1 check_revocation;
    public Function3 get_crl;
    public Function2 check_crl;
    public Function3 cert_crl;
    public Function1 cleanup;
    public List ex_data;
    public int references = 1;

    public X509_STORE() {
        this.param = new X509_VERIFY_PARAM();
        this.get_issuer = Function3.iZ;
        this.check_issued = Function3.iZ;
        this.check_revocation = Function1.iZ;
        this.get_crl = Function3.iZ;
        this.check_crl = Function2.iZ;
        this.cert_crl = Function3.iZ;
        this.cleanup = Function1.iZ;
        this.ex_data = new ArrayList();
        this.ex_data.add(null);
        this.ex_data.add(null);
        this.ex_data.add(null);
        this.ex_data.add(null);
        this.ex_data.add(null);
        this.ex_data.add(null);
        this.ex_data.add(null);
        this.ex_data.add(null);
        this.ex_data.add(null);
    }

    public void set_verify_func(Function1 func) {
        this.verify = func;
    }

    public void set_verify_cb_func(Function2 func) {
        this.verify_cb = func;
    }

    public void free() throws Exception {
        Iterator iter = this.get_cert_methods.iterator();
        while (iter.hasNext()) {
            X509_LOOKUP lu = (X509_LOOKUP)iter.next();
            lu.shutdown();
            lu.free();
        }
        if (this.param != null) {
            this.param.free();
        }
    }

    public int set_ex_data(int idx, Object data) {
        this.ex_data.set(idx, data);
        return 1;
    }

    public Object get_ex_data(int idx) {
        return this.ex_data.get(idx);
    }

    public int set_depth(int depth) {
        this.param.set_depth(depth);
        return 1;
    }

    public int set_flags(long flags) {
        return this.param.set_flags(flags);
    }

    public int set_purpose(int purpose) {
        return this.param.set_purpose(purpose);
    }

    public int set_trust(int trust) {
        return this.param.set_trust(trust);
    }

    public int set1_param(X509_VERIFY_PARAM pm) {
        return this.param.set1(this.param);
    }

    public X509_LOOKUP add_lookup(X509_LOOKUP_METHOD m) throws Exception {
        X509_LOOKUP lu;
        Iterator iter = this.get_cert_methods.iterator();
        while (iter.hasNext()) {
            lu = (X509_LOOKUP)iter.next();
            if (!lu.equals(m)) continue;
            return lu;
        }
        lu = new X509_LOOKUP(m);
        lu.store_ctx = this;
        this.get_cert_methods.add(lu);
        return lu;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int add_cert(X509Certificate x) {
        int ret = 1;
        if (x == null) {
            return 0;
        }
        X509_OBJECT_CERT obj = new X509_OBJECT_CERT();
        obj.x509 = X509_STORE_CTX.transform(x);
        Object object = X509.CRYPTO_LOCK_X509_STORE;
        synchronized (object) {
            if (X509_OBJECT.retrieve_match(this.objs, obj) != null) {
                Err.PUT_err(101);
                ret = 0;
            } else {
                this.objs.add(obj);
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int add_crl(CRL x) {
        int ret = 1;
        if (null == x) {
            return 0;
        }
        X509_OBJECT_CRL obj = new X509_OBJECT_CRL();
        obj.crl = x;
        Object object = X509.CRYPTO_LOCK_X509_STORE;
        synchronized (object) {
            if (X509_OBJECT.retrieve_match(this.objs, obj) != null) {
                Err.PUT_err(101);
                ret = 0;
            } else {
                this.objs.add(obj);
            }
        }
        return ret;
    }

    public int load_locations(String file, String path) throws Exception {
        X509_LOOKUP lookup;
        if (file != null) {
            lookup = this.add_lookup(X509_LOOKUP.file());
            if (lookup == null) {
                return 0;
            }
            if (lookup.load_file(new X509_CERT_FILE_CTX.Path(file, 1)) != 1) {
                return 0;
            }
        }
        if (path != null) {
            lookup = this.add_lookup(X509_LOOKUP.hash_dir());
            if (lookup == null) {
                return 0;
            }
            if (lookup.add_dir(new X509_HASH_DIR_CTX.Dir(path, 1)) != 1) {
                return 0;
            }
        }
        if (path == null && file == null) {
            return 0;
        }
        return 1;
    }

    public int set_default_paths() throws Exception {
        X509_LOOKUP lookup = this.add_lookup(X509_LOOKUP.file());
        if (lookup == null) {
            return 0;
        }
        lookup.load_file(new X509_CERT_FILE_CTX.Path(null, 3));
        lookup = this.add_lookup(X509_LOOKUP.hash_dir());
        if (lookup == null) {
            return 0;
        }
        lookup.add_dir(new X509_HASH_DIR_CTX.Dir(null, 3));
        Err.clear_error();
        return 1;
    }

    public void checkClientTrusted(X509Certificate[] chain, String authType) {
    }

    public void checkServerTrusted(X509Certificate[] chain, String authType) {
    }

    public X509Certificate[] getAcceptedIssuers() {
        ArrayList<X509AuxCertificate> l = new ArrayList<X509AuxCertificate>();
        Iterator iter = this.objs.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof X509_OBJECT_CERT)) continue;
            l.add(((X509_OBJECT_CERT)o).x509);
        }
        return l.toArray(new X509Certificate[l.size()]);
    }
}

