/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.openssl.x509store;

import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.bouncycastle.asn1.DERObject;
import org.jruby.ext.openssl.x509store.X509_PURPOSE;
import org.jruby.ext.openssl.x509store.X509_TRUST;

public class X509_VERIFY_PARAM {
    public String name;
    public Date check_time;
    public long inh_flags;
    public long flags;
    public int purpose;
    public int trust;
    public int depth;
    public List policies;
    private static final X509_VERIFY_PARAM[] default_table = new X509_VERIFY_PARAM[]{new X509_VERIFY_PARAM("default", 0L, 0L, 0L, 0, 0, 9, null), new X509_VERIFY_PARAM("pkcs7", 0L, 0L, 0L, 4, 4, -1, null), new X509_VERIFY_PARAM("ssl_client", 0L, 0L, 0L, 1, 2, -1, null), new X509_VERIFY_PARAM("ssl_server", 0L, 0L, 0L, 2, 3, -1, null)};
    private static final List param_table = new ArrayList();

    public X509_VERIFY_PARAM() {
        this.zero();
    }

    public X509_VERIFY_PARAM(String n, long t, long i_f, long f, int p, int trs, int d, List pol) {
        this.name = n;
        this.check_time = new Date(t);
        this.inh_flags = i_f;
        this.flags = f;
        this.purpose = p;
        this.trust = trs;
        this.depth = d;
        this.policies = pol;
    }

    private void zero() {
        this.name = null;
        this.purpose = 0;
        this.trust = 0;
        this.inh_flags = 1L;
        this.flags = 0L;
        this.depth = -1;
        this.policies = null;
    }

    public void free() {
        this.zero();
    }

    public int inherit(X509_VERIFY_PARAM src) {
        boolean to_o;
        if (src == null) {
            return 1;
        }
        long inh_flags = src.inh_flags | this.inh_flags;
        if ((inh_flags & 0x10L) != 0L) {
            this.inh_flags = 0L;
        }
        if ((inh_flags & 8L) != 0L) {
            return 1;
        }
        boolean to_d = (inh_flags & 1L) != 0L;
        boolean bl = to_o = (inh_flags & 2L) != 0L;
        if (to_o || src.purpose != 0 && (to_d || this.purpose == 0)) {
            this.purpose = src.purpose;
        }
        if (to_o || src.trust != 0 && (to_d || this.trust == 0)) {
            this.trust = src.trust;
        }
        if (to_o || src.depth != -1 && (to_d || this.depth == -1)) {
            this.depth = src.depth;
        }
        if (to_o || (this.flags & 2L) == 0L) {
            this.check_time = src.check_time;
            this.flags &= 0xFFFFFFFFFFFFFFFDL;
        }
        if ((inh_flags & 4L) != 0L) {
            this.flags = 0L;
        }
        this.flags |= src.flags;
        if (to_o || src.policies != null && (to_d || this.policies == null)) {
            this.set1_policies(src.policies);
        }
        return 1;
    }

    public int set1(X509_VERIFY_PARAM from) {
        this.inh_flags |= 1L;
        return this.inherit(from);
    }

    public int set1_name(String name) {
        this.name = name;
        return 1;
    }

    public int set_flags(long flags) {
        this.flags |= flags;
        if ((flags & 0x780L) == 1920L) {
            this.flags |= 0x80L;
        }
        return 1;
    }

    public int clear_flags(long flags) {
        this.flags &= flags ^ 0xFFFFFFFFFFFFFFFFL;
        return 1;
    }

    public long get_flags() {
        return this.flags;
    }

    public int set_purpose(int purpose) {
        int[] arg = new int[]{this.purpose};
        int v = X509_PURPOSE.set(arg, purpose);
        this.purpose = arg[0];
        return v;
    }

    public int set_trust(int trust) {
        int[] arg = new int[]{this.trust};
        int v = X509_TRUST.set(arg, trust);
        this.trust = arg[0];
        return v;
    }

    public void set_depth(int depth) {
        this.depth = depth;
    }

    public void set_time(Date t) {
        this.check_time = t;
        this.flags |= 2L;
    }

    public int add0_policy(DERObject policy) {
        if (this.policies == null) {
            this.policies = new ArrayList();
        }
        this.policies.add(policy);
        return 1;
    }

    public int set1_policies(List policies) {
        if (policies == null) {
            this.policies = null;
            return 1;
        }
        this.policies = new ArrayList();
        this.policies.addAll(policies);
        this.flags |= 0x80L;
        return 1;
    }

    public int get_depth() {
        return this.depth;
    }

    public int add0_table() {
        Iterator iter = param_table.iterator();
        while (iter.hasNext()) {
            X509_VERIFY_PARAM v = (X509_VERIFY_PARAM)iter.next();
            if (!this.name.equals(v.name)) continue;
            iter.remove();
        }
        param_table.add(this);
        return 1;
    }

    public static X509_VERIFY_PARAM lookup(String name) {
        Iterator iter = param_table.iterator();
        while (iter.hasNext()) {
            X509_VERIFY_PARAM v = (X509_VERIFY_PARAM)iter.next();
            if (!name.equals(v.name)) continue;
            return v;
        }
        for (int i = 0; i < default_table.length; ++i) {
            if (!name.equals(X509_VERIFY_PARAM.default_table[i].name)) continue;
            return default_table[i];
        }
        return null;
    }

    public static void table_cleanup() {
        param_table.clear();
    }
}

