/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.internal.runtime;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.jruby.IRuby;
import org.jruby.exceptions.RaiseException;
import org.jruby.internal.runtime.GlobalVariable;
import org.jruby.internal.runtime.ReadonlyAccessor;
import org.jruby.internal.runtime.UndefinedAccessor;
import org.jruby.runtime.IAccessor;
import org.jruby.runtime.builtin.IRubyObject;

public class GlobalVariables {
    private IRuby runtime;
    private Map globalVariables = new HashMap();
    static final /* synthetic */ boolean $assertionsDisabled;

    public GlobalVariables(IRuby runtime) {
        this.runtime = runtime;
    }

    public void define(String name, IAccessor accessor) {
        if (!$assertionsDisabled && name == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && accessor == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !name.startsWith("$")) {
            throw new AssertionError();
        }
        this.globalVariables.put(name, new GlobalVariable(accessor));
    }

    public void defineReadonly(String name, IAccessor accessor) {
        if (!$assertionsDisabled && name == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && accessor == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !name.startsWith("$")) {
            throw new AssertionError();
        }
        this.globalVariables.put(name, new GlobalVariable(new ReadonlyAccessor(name, accessor)));
    }

    public boolean isDefined(String name) {
        if (!$assertionsDisabled && name == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !name.startsWith("$")) {
            throw new AssertionError();
        }
        GlobalVariable variable = (GlobalVariable)this.globalVariables.get(name);
        return variable != null && !(variable.getAccessor() instanceof UndefinedAccessor);
    }

    public void alias(String name, String oldName) {
        if (!$assertionsDisabled && name == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && oldName == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !name.startsWith("$")) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !oldName.startsWith("$")) {
            throw new AssertionError();
        }
        if (this.runtime.getSafeLevel() >= 4) {
            throw this.runtime.newSecurityError("Insecure: can't alias global variable");
        }
        GlobalVariable oldVariable = this.createIfNotDefined(oldName);
        GlobalVariable variable = (GlobalVariable)this.globalVariables.get(name);
        if (variable != null && oldVariable != variable && variable.isTracing()) {
            throw new RaiseException(this.runtime, this.runtime.getClass("RuntimeError"), "can't alias in tracer", false);
        }
        this.globalVariables.put(name, oldVariable);
    }

    public IRubyObject get(String name) {
        if (!$assertionsDisabled && name == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !name.startsWith("$")) {
            throw new AssertionError();
        }
        GlobalVariable variable = (GlobalVariable)this.globalVariables.get(name);
        if (variable != null) {
            return variable.getAccessor().getValue();
        }
        this.runtime.getWarnings().warning("global variable `" + name + "' not initialized");
        return this.runtime.getNil();
    }

    public IRubyObject set(String name, IRubyObject value) {
        if (!$assertionsDisabled && name == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !name.startsWith("$")) {
            throw new AssertionError();
        }
        if (this.runtime.getSafeLevel() >= 4) {
            throw this.runtime.newSecurityError("Insecure: can't change global variable value");
        }
        GlobalVariable variable = this.createIfNotDefined(name);
        IRubyObject result = variable.getAccessor().setValue(value);
        return result;
    }

    public Iterator getNames() {
        return this.globalVariables.keySet().iterator();
    }

    private GlobalVariable createIfNotDefined(String name) {
        GlobalVariable variable = (GlobalVariable)this.globalVariables.get(name);
        if (variable == null) {
            variable = GlobalVariable.newUndefined(this.runtime, name);
            this.globalVariables.put(name, variable);
        }
        return variable;
    }

    static {
        $assertionsDisabled = !GlobalVariables.class.desiredAssertionStatus();
    }
}

