/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.internal.runtime.methods;

import org.jruby.RubyModule;
import org.jruby.internal.runtime.methods.AbstractMethod;
import org.jruby.internal.runtime.methods.MultiStub;
import org.jruby.runtime.Arity;
import org.jruby.runtime.ICallable;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

public class MultiStubMethod
extends AbstractMethod
implements Cloneable {
    private Arity arity;
    private MultiStub stub;
    private int index;
    static final /* synthetic */ boolean $assertionsDisabled;

    public MultiStubMethod(MultiStub stub, int index, RubyModule implementationClass, Arity arity, Visibility visibility) {
        super(implementationClass, visibility);
        this.arity = arity;
        this.stub = stub;
        this.index = index;
        if (!$assertionsDisabled && arity == null) {
            throw new AssertionError();
        }
    }

    public void preMethod(ThreadContext context, RubyModule lastClass, IRubyObject recv, String name, IRubyObject[] args, boolean noSuper) {
        context.preReflectedMethodInternalCall(this.implementationClass, lastClass, recv, name, args, noSuper);
    }

    public void postMethod(ThreadContext context) {
        context.postReflectedMethodInternalCall();
    }

    public IRubyObject internalCall(ThreadContext context, IRubyObject receiver, RubyModule lastClass, String name, IRubyObject[] args, boolean noSuper) {
        switch (this.index) {
            case 0: {
                return this.stub.method0(context, receiver, args);
            }
            case 1: {
                return this.stub.method1(context, receiver, args);
            }
            case 2: {
                return this.stub.method2(context, receiver, args);
            }
            case 3: {
                return this.stub.method3(context, receiver, args);
            }
            case 4: {
                return this.stub.method4(context, receiver, args);
            }
            case 5: {
                return this.stub.method5(context, receiver, args);
            }
            case 6: {
                return this.stub.method6(context, receiver, args);
            }
            case 7: {
                return this.stub.method7(context, receiver, args);
            }
            case 8: {
                return this.stub.method8(context, receiver, args);
            }
            case 9: {
                return this.stub.method9(context, receiver, args);
            }
        }
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
        return null;
    }

    public Arity getArity() {
        return this.arity;
    }

    public ICallable dup() {
        try {
            MultiStubMethod msm = (MultiStubMethod)this.clone();
            return msm;
        }
        catch (CloneNotSupportedException cnse) {
            return null;
        }
    }

    static {
        $assertionsDisabled = !MultiStubMethod.class.desiredAssertionStatus();
    }
}

