/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime;

import org.jruby.IRuby;
import org.jruby.RubyModule;
import org.jruby.ast.Node;
import org.jruby.parser.BlockStaticScope;
import org.jruby.runtime.Arity;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.Frame;
import org.jruby.runtime.ICallable;
import org.jruby.runtime.Iter;
import org.jruby.runtime.Scope;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.collections.SinglyLinkedList;
import org.jruby.util.collections.StackElement;

public class Block
implements StackElement {
    private Node var;
    private ICallable method;
    private IRubyObject self;
    private Frame frame;
    private SinglyLinkedList cref;
    private Scope scope;
    private RubyModule klass;
    private Iter iter;
    private DynamicScope dynamicScope;
    private IRubyObject blockObject = null;
    public boolean isLambda = false;
    private Block next;
    static final /* synthetic */ boolean $assertionsDisabled;

    public static Block createBlock(Node var, DynamicScope dynamicScope, ICallable method, IRubyObject self) {
        ThreadContext context = self.getRuntime().getCurrentContext();
        return new Block(var, method, self, context.getCurrentFrame(), context.peekCRef(), context.getFrameScope(), context.getRubyClass(), context.getCurrentIter(), dynamicScope);
    }

    public Block(Node var, ICallable method, IRubyObject self, Frame frame, SinglyLinkedList cref, Scope scope, RubyModule klass, Iter iter, DynamicScope dynamicScope) {
        this.var = var;
        this.method = method;
        this.self = self;
        this.frame = frame;
        this.scope = scope;
        this.klass = klass;
        this.iter = iter;
        this.cref = cref;
        this.dynamicScope = dynamicScope;
    }

    public static Block createBinding(RubyModule wrapper, Iter iter, Frame frame, DynamicScope dynamicScope) {
        ThreadContext context = frame.getSelf().getRuntime().getCurrentContext();
        DynamicScope extraScope = dynamicScope.getBindingScope();
        if (extraScope == null) {
            DynamicScope parent = dynamicScope.getNextCapturedScope();
            if (parent != null && parent.getBindingScope() == dynamicScope) {
                extraScope = dynamicScope;
            } else {
                extraScope = new DynamicScope(new BlockStaticScope(dynamicScope.getStaticScope()), dynamicScope);
                dynamicScope.setBindingScope(extraScope);
            }
        }
        return new Block(null, null, frame.getSelf(), frame, context.peekCRef(), frame.getScope(), context.getRubyClass(), iter, extraScope);
    }

    public IRubyObject call(IRubyObject[] args, IRubyObject replacementSelf) {
        Block newBlock;
        IRuby runtime = this.self.getRuntime();
        ThreadContext context = runtime.getCurrentContext();
        if (this.dynamicScope == null) {
            newBlock = this;
        } else {
            newBlock = this.cloneBlock();
            if (replacementSelf != null) {
                newBlock.self = replacementSelf;
            }
        }
        return context.yieldSpecificBlock(newBlock, runtime.newArray(args), null, null, true);
    }

    public Block cloneBlock() {
        Block newBlock = new Block(this.var, this.method, this.self, this.frame, this.cref, this.scope, this.klass, this.iter, this.dynamicScope == null ? null : this.dynamicScope.cloneScope());
        newBlock.isLambda = this.isLambda;
        if (this.getNext() != null) {
            newBlock.setNext(this.getNext());
        }
        return newBlock;
    }

    public Arity arity() {
        return this.method.getArity();
    }

    public Visibility getVisibility() {
        return this.scope.getVisibility();
    }

    public void setVisibility(Visibility visibility) {
        this.scope.setVisibility(visibility);
    }

    public StackElement getNext() {
        return this.next;
    }

    public SinglyLinkedList getCRef() {
        return this.cref;
    }

    public void setNext(StackElement newNext) {
        if (!$assertionsDisabled && this == newNext) {
            throw new AssertionError();
        }
        this.next = (Block)newNext;
    }

    public IRubyObject getBlockObject() {
        return this.blockObject;
    }

    public void setBlockObject(IRubyObject blockObject) {
        this.blockObject = blockObject;
    }

    public DynamicScope getDynamicScope() {
        return this.dynamicScope;
    }

    public Frame getFrame() {
        return this.frame;
    }

    public Iter getIter() {
        return this.iter;
    }

    public void setIter(Iter iter) {
        this.iter = iter;
    }

    public RubyModule getKlass() {
        return this.klass;
    }

    public ICallable getMethod() {
        return this.method;
    }

    public Scope getScope() {
        return this.scope;
    }

    public IRubyObject getSelf() {
        return this.self;
    }

    public Node getVar() {
        return this.var;
    }

    static {
        $assertionsDisabled = !Block.class.desiredAssertionStatus();
    }
}

