/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime;

import org.jruby.IRuby;
import org.jruby.RubyModule;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.runtime.Block;
import org.jruby.runtime.Iter;
import org.jruby.runtime.Scope;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class Frame {
    private IRubyObject self;
    private IRubyObject[] args;
    private String lastFunc;
    private RubyModule lastClass;
    private final ISourcePosition position;
    private Iter iter;
    private IRuby runtime;
    private Block blockArg;
    private boolean callingZSuper;
    private Scope scope;

    public Frame(ThreadContext threadContext, Iter iter, Block blockArg) {
        this(threadContext.getRuntime(), null, IRubyObject.NULL_ARRAY, null, null, threadContext.getPosition(), iter, blockArg);
    }

    public Frame(ThreadContext threadContext, IRubyObject self, IRubyObject[] args, String lastFunc, RubyModule lastClass, ISourcePosition position, Iter iter, Block blockArg) {
        this(threadContext.getRuntime(), self, args, lastFunc, lastClass, position, iter, blockArg);
    }

    private Frame(IRuby runtime, IRubyObject self, IRubyObject[] args, String lastFunc, RubyModule lastClass, ISourcePosition position, Iter iter, Block blockArg) {
        this.self = self;
        this.args = args;
        this.lastFunc = lastFunc;
        this.lastClass = lastClass;
        this.position = position;
        this.iter = iter;
        this.runtime = runtime;
        this.blockArg = blockArg;
    }

    IRubyObject[] getArgs() {
        return this.args;
    }

    void setArgs(IRubyObject[] args) {
        this.args = args;
    }

    ISourcePosition getPosition() {
        return this.position;
    }

    Iter getIter() {
        return this.iter;
    }

    void setIter(Iter iter) {
        this.iter = iter;
    }

    boolean isBlockGiven() {
        return this.iter.isBlockGiven();
    }

    RubyModule getLastClass() {
        return this.lastClass;
    }

    public void setLastClass(RubyModule lastClass) {
        this.lastClass = lastClass;
    }

    public void setLastFunc(String lastFunc) {
        this.lastFunc = lastFunc;
    }

    String getLastFunc() {
        return this.lastFunc;
    }

    IRubyObject getSelf() {
        return this.self;
    }

    void setSelf(IRubyObject self) {
        this.self = self;
    }

    public void newScope() {
        this.setScope(new Scope());
    }

    Scope getScope() {
        return this.scope;
    }

    Scope setScope(Scope newScope) {
        Scope oldScope = this.scope;
        this.scope = newScope;
        return oldScope;
    }

    public Frame duplicate() {
        IRubyObject[] newArgs;
        if (this.args.length != 0) {
            newArgs = new IRubyObject[this.args.length];
            System.arraycopy(this.args, 0, newArgs, 0, this.args.length);
        } else {
            newArgs = this.args;
        }
        return new Frame(this.runtime, this.self, newArgs, this.lastFunc, this.lastClass, this.position, this.iter, this.blockArg);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(50);
        sb.append(this.position != null ? this.position.toString() : "-1");
        sb.append(':');
        sb.append(this.lastClass + " " + this.lastFunc);
        if (this.lastFunc != null) {
            sb.append("in ");
            sb.append(this.lastFunc);
        }
        return sb.toString();
    }

    Block getBlockArg() {
        return this.blockArg;
    }

    public boolean getCallingZSuper() {
        return this.callingZSuper;
    }

    public void setCallingZSuper(boolean callingZSuper) {
        this.callingZSuper = callingZSuper;
    }
}

