/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime.builtin.meta;

import org.jruby.IRuby;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.internal.runtime.methods.ReflectedMethod;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.collections.SinglyLinkedList;

public abstract class AbstractMetaClass
extends RubyClass {
    protected Class builtinClass;
    static final /* synthetic */ boolean $assertionsDisabled;

    protected Meta getMeta() {
        return null;
    }

    protected AbstractMetaClass(IRuby runtime, RubyClass metaClass, RubyClass superClass, SinglyLinkedList parentCRef, String name, Class builtinClass) {
        super(runtime, metaClass, superClass, parentCRef, name);
        this.builtinClass = builtinClass;
    }

    protected AbstractMetaClass(String name, Class builtinClass, RubyClass superClass) {
        this(name, builtinClass, superClass, superClass.getRuntime().getClass("Object").getCRef(), true);
    }

    protected AbstractMetaClass(String name, Class builtinClass, RubyClass superClass, SinglyLinkedList parentCRef) {
        this(name, builtinClass, superClass, parentCRef, false);
    }

    protected AbstractMetaClass(String name, Class builtinClass, RubyClass superClass, SinglyLinkedList parentCRef, boolean init) {
        super(superClass.getRuntime(), superClass.getRuntime().getClass("Class"), superClass, parentCRef, name);
        if (!$assertionsDisabled && name == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && builtinClass == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && superClass == null) {
            throw new AssertionError();
        }
        this.builtinClass = builtinClass;
        this.makeMetaClass(superClass.getMetaClass(), superClass.getRuntime().getCurrentContext().peekCRef());
        this.inheritedBy(superClass);
        if (name != null) {
            ((RubyModule)parentCRef.getValue()).setConstant(name, this);
        }
        if (init) {
            this.getMeta().initializeClass();
        }
    }

    public AbstractMetaClass(IRuby runtime, RubyClass metaClass, RubyClass superClass, SinglyLinkedList parentCRef, String name) {
        super(runtime, metaClass, superClass, parentCRef, name);
    }

    public void defineMethod(String name, Arity arity) {
        this.defineMethod(name, arity, name);
    }

    public void defineMethod(String name, Arity arity, String java_name) {
        if (!$assertionsDisabled && name == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && arity == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && java_name == null) {
            throw new AssertionError();
        }
        Visibility visibility = name.equals("initialize") ? Visibility.PRIVATE : Visibility.PUBLIC;
        this.addMethod(name, new ReflectedMethod(this, this.builtinClass, java_name, arity, visibility));
    }

    public void definePrivateMethod(String name, Arity arity) {
        this.addMethod(name, new ReflectedMethod(this, this.builtinClass, name, arity, Visibility.PRIVATE));
    }

    public void definePrivateMethod(String name, Arity arity, String java_name) {
        this.addMethod(name, new ReflectedMethod(this, this.builtinClass, java_name, arity, Visibility.PRIVATE));
    }

    public void defineSingletonMethod(String name, Arity arity) {
        this.defineSingletonMethod(name, arity, name);
    }

    public void defineSingletonMethod(String name, Arity arity, String java_name) {
        if (!$assertionsDisabled && name == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && arity == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && java_name == null) {
            throw new AssertionError();
        }
        Visibility visibility = name.equals("initialize") ? Visibility.PRIVATE : Visibility.PUBLIC;
        this.getSingletonClass().addMethod(name, new ReflectedMethod(this, this.getClass(), java_name, arity, visibility));
    }

    public void initializeBootstrapClass() {
        this.getMeta().initializeClass();
    }

    static {
        $assertionsDisabled = !AbstractMetaClass.class.desiredAssertionStatus();
    }

    protected abstract class Meta {
        protected Meta() {
        }

        protected abstract void initializeClass();

        protected Object[][] getPublicMethods() {
            return new Object[0][];
        }

        protected Object[][] getDefineConstants() {
            return new Object[0][];
        }

        protected Object[][] getSetConstants() {
            return new Object[0][];
        }

        protected Object[][] getSingletonMethods() {
            return new Object[0][];
        }

        protected String[][] getAliases() {
            return new String[0][];
        }

        protected Object[][] getPrivateMethods() {
            return new Object[0][];
        }

        protected String[] getIncludedModules() {
            return new String[0];
        }

        protected String[] getUndefineMethods() {
            return new String[0];
        }

        protected String[] getUndefineSingletonMethods() {
            return new String[0];
        }

        public void undefineMethods(String[] undefineMethods, boolean singleton) {
            for (int i = 0; i < undefineMethods.length; ++i) {
                if (singleton) {
                    AbstractMetaClass.this.getSingletonClass().undefineMethod(undefineMethods[i]);
                    continue;
                }
                AbstractMetaClass.this.undefineMethod(undefineMethods[i]);
            }
        }

        public void defineConstants(Object[][] constants, boolean singleton) {
            for (int i = 0; i < constants.length; ++i) {
                if (singleton) {
                    AbstractMetaClass.this.getSingletonClass().defineConstant((String)constants[i][0], (IRubyObject)constants[i][1]);
                    continue;
                }
                AbstractMetaClass.this.defineConstant((String)constants[i][0], (IRubyObject)constants[i][1]);
            }
        }

        public void setConstants(Object[][] constants, boolean singleton) {
            for (int i = 0; i < constants.length; ++i) {
                if (singleton) {
                    AbstractMetaClass.this.getSingletonClass().setConstant((String)constants[i][0], (IRubyObject)constants[i][1]);
                    continue;
                }
                AbstractMetaClass.this.setConstant((String)constants[i][0], (IRubyObject)constants[i][1]);
            }
        }

        public void includeModules(String[] includedModules) {
            for (int i = 0; i < includedModules.length; ++i) {
                AbstractMetaClass.this.includeModule(AbstractMetaClass.this.getRuntime().getModule(includedModules[i]));
            }
        }

        public void defineAliases(Object[][] aliases) {
            for (int i = 0; i < aliases.length; ++i) {
                AbstractMetaClass.this.defineAlias((String)aliases[i][0], (String)aliases[i][1]);
            }
        }
    }
}

