/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime.builtin.meta;

import org.jruby.IRuby;
import org.jruby.RubyClass;
import org.jruby.RubyNumeric;
import org.jruby.runtime.Arity;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.builtin.meta.AbstractMetaClass;
import org.jruby.runtime.builtin.meta.ObjectMetaClass;
import org.jruby.util.collections.SinglyLinkedList;

public class NumericMetaClass
extends ObjectMetaClass {
    public NumericMetaClass(IRuby runtime) {
        super("Numeric", RubyNumeric.class, runtime.getObject());
    }

    public NumericMetaClass(String name, RubyClass superClass, SinglyLinkedList parentCRef) {
        super(name, RubyNumeric.class, superClass, parentCRef);
    }

    public NumericMetaClass(String name, Class clazz, RubyClass superClass) {
        super(name, clazz, superClass);
    }

    public NumericMetaClass(String name, Class clazz, RubyClass superClass, SinglyLinkedList parentCRef) {
        super(name, clazz, superClass, parentCRef);
    }

    protected AbstractMetaClass.Meta getMeta() {
        return new NumericMeta();
    }

    public RubyClass newSubClass(String name, SinglyLinkedList parentCRef) {
        return new NumericMetaClass(name, (RubyClass)this, parentCRef);
    }

    protected IRubyObject allocateObject() {
        RubyNumeric instance = this.getRuntime().newNumeric();
        instance.setMetaClass(this);
        return instance;
    }

    protected class NumericMeta
    extends AbstractMetaClass.Meta {
        protected NumericMeta() {
        }

        protected void initializeClass() {
            NumericMetaClass.this.includeModule(NumericMetaClass.this.getRuntime().getModule("Comparable"));
            NumericMetaClass.this.defineMethod("+@", Arity.noArguments(), "op_uplus");
            NumericMetaClass.this.defineMethod("-@", Arity.noArguments(), "op_uminus");
            NumericMetaClass.this.defineMethod("<=>", Arity.singleArgument(), "cmp");
            NumericMetaClass.this.defineMethod("==", Arity.singleArgument(), "equal");
            NumericMetaClass.this.defineMethod("equal?", Arity.singleArgument(), "veryEqual");
            NumericMetaClass.this.defineMethod("===", Arity.singleArgument(), "equal");
            NumericMetaClass.this.defineMethod("abs", Arity.noArguments());
            NumericMetaClass.this.defineMethod("ceil", Arity.noArguments());
            NumericMetaClass.this.defineMethod("coerce", Arity.singleArgument());
            NumericMetaClass.this.defineMethod("clone", Arity.noArguments(), "rbClone");
            NumericMetaClass.this.defineMethod("divmod", Arity.singleArgument(), "divmod");
            NumericMetaClass.this.defineMethod("eql?", Arity.singleArgument(), "eql");
            NumericMetaClass.this.defineMethod("floor", Arity.noArguments());
            NumericMetaClass.this.defineMethod("integer?", Arity.noArguments(), "int_p");
            NumericMetaClass.this.defineMethod("modulo", Arity.singleArgument());
            NumericMetaClass.this.defineMethod("nonzero?", Arity.noArguments(), "nonzero_p");
            NumericMetaClass.this.defineMethod("remainder", Arity.singleArgument());
            NumericMetaClass.this.defineMethod("round", Arity.noArguments());
            NumericMetaClass.this.defineMethod("truncate", Arity.noArguments());
            NumericMetaClass.this.defineMethod("to_int", Arity.noArguments());
            NumericMetaClass.this.defineMethod("zero?", Arity.noArguments(), "zero_p");
            NumericMetaClass.this.defineMethod(">=", Arity.singleArgument(), "op_ge");
            NumericMetaClass.this.defineMethod(">", Arity.singleArgument(), "op_gt");
            NumericMetaClass.this.defineMethod("<=", Arity.singleArgument(), "op_le");
            NumericMetaClass.this.defineMethod("<", Arity.singleArgument(), "op_lt");
            NumericMetaClass.this.defineSingletonMethod("new", Arity.optional(), "newInstance");
        }
    }
}

