/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime.builtin.meta;

import java.util.Locale;
import org.jruby.IRuby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyInteger;
import org.jruby.RubyString;
import org.jruby.javasupport.JavaUtil;
import org.jruby.runtime.Arity;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.builtin.meta.AbstractMetaClass;
import org.jruby.runtime.builtin.meta.ObjectMetaClass;
import org.jruby.util.PrintfFormat;
import org.jruby.util.collections.SinglyLinkedList;

public class StringMetaClass
extends ObjectMetaClass {
    public RubyString.StringMethod hash = new RubyString.StringMethod(this, Arity.noArguments(), Visibility.PUBLIC){

        public IRubyObject invoke(RubyString self, IRubyObject[] args) {
            return self.getRuntime().newFixnum(self.toString().hashCode());
        }
    };
    public RubyString.StringMethod to_s = new RubyString.StringMethod(this, Arity.noArguments(), Visibility.PUBLIC){

        public IRubyObject invoke(RubyString self, IRubyObject[] args) {
            return self;
        }
    };
    public RubyString.StringMethod op_cmp = new RubyString.StringMethod(this, Arity.singleArgument(), Visibility.PUBLIC){

        public IRubyObject invoke(RubyString self, IRubyObject[] args) {
            IRubyObject tmp;
            if (args[0] instanceof RubyString) {
                return StringMetaClass.this.getRuntime().newFixnum(self.cmp((RubyString)args[0]));
            }
            ThreadContext context = self.getRuntime().getCurrentContext();
            if (args[0].respondsTo("to_str") && args[0].respondsTo("<=>") && !(tmp = args[0].callMethod(context, "<=>", self)).isNil()) {
                return tmp instanceof RubyFixnum ? tmp.callMethod(context, "-") : StringMetaClass.this.getRuntime().newFixnum(0L).callMethod(context, "-", tmp);
            }
            return StringMetaClass.this.getRuntime().getNil();
        }
    };
    public RubyString.StringMethod equal = new RubyString.StringMethod(this, Arity.singleArgument(), Visibility.PUBLIC){

        public IRubyObject invoke(RubyString self, IRubyObject[] args) {
            IRubyObject other = args[0];
            if (other == self) {
                return self.getRuntime().getTrue();
            }
            if (!(other instanceof RubyString)) {
                return self.getRuntime().getFalse();
            }
            return self.getRuntime().newBoolean(self.toString().equals(((RubyString)other).toString()));
        }
    };
    public RubyString.StringMethod veryEqual = new RubyString.StringMethod(this, Arity.singleArgument(), Visibility.PUBLIC){

        public IRubyObject invoke(RubyString self, IRubyObject[] args) {
            IRubyObject other = args[0];
            IRubyObject truth = self.callMethod(self.getRuntime().getCurrentContext(), "==", other);
            return truth == self.getRuntime().getNil() ? self.getRuntime().getFalse() : truth;
        }
    };
    public RubyString.StringMethod op_plus = new RubyString.StringMethod(this, Arity.singleArgument(), Visibility.PUBLIC){

        public IRubyObject invoke(RubyString self, IRubyObject[] args) {
            IRubyObject other = args[0];
            RubyString str = RubyString.stringValue(other);
            return (RubyString)self.newString(self.toString() + str.toString()).infectBy(str);
        }
    };
    public RubyString.StringMethod op_mul = new RubyString.StringMethod(this, Arity.singleArgument(), Visibility.PUBLIC){

        public IRubyObject invoke(RubyString self, IRubyObject[] args) {
            IRubyObject other = args[0];
            RubyInteger otherInteger = (RubyInteger)other.convertType(class$org$jruby$RubyInteger == null ? (class$org$jruby$RubyInteger = StringMetaClass.class$("org.jruby.RubyInteger")) : class$org$jruby$RubyInteger, "Integer", "to_i");
            long len = otherInteger.getLongValue();
            if (len < 0L) {
                throw self.getRuntime().newArgumentError("negative argument");
            }
            if (len > 0L && Long.MAX_VALUE / len < (long)self.getValue().length()) {
                throw self.getRuntime().newArgumentError("argument too big");
            }
            StringBuffer sb = new StringBuffer((int)((long)self.getValue().length() * len));
            int i = 0;
            while ((long)i < len) {
                sb.append(self.getValue());
                ++i;
            }
            RubyString newString = self.newString(sb.toString());
            newString.setTaint(self.isTaint());
            return newString;
        }
    };
    public RubyString.StringMethod format = new RubyString.StringMethod(this, Arity.singleArgument(), Visibility.PUBLIC){

        public IRubyObject invoke(RubyString self, IRubyObject[] args) {
            IRubyObject arg = args[0];
            if (arg instanceof RubyArray) {
                Object[] args2 = new Object[((RubyArray)arg).getLength()];
                for (int i = 0; i < args2.length; ++i) {
                    args2[i] = JavaUtil.convertRubyToJava(((RubyArray)arg).entry(i));
                }
                return self.getRuntime().newString(new PrintfFormat(Locale.US, self.toString()).sprintf(args2));
            }
            return self.getRuntime().newString(new PrintfFormat(Locale.US, self.toString()).sprintf(JavaUtil.convertRubyToJava(arg)));
        }
    };
    static /* synthetic */ Class class$org$jruby$RubyInteger;

    public StringMetaClass(IRuby runtime) {
        super("String", RubyString.class, runtime.getObject());
    }

    private StringMetaClass(String name, RubyClass superClass, SinglyLinkedList parentCRef) {
        super(name, RubyString.class, superClass, parentCRef);
    }

    protected AbstractMetaClass.Meta getMeta() {
        return new StringMeta();
    }

    public RubyClass newSubClass(String name, SinglyLinkedList parentCRef) {
        return new StringMetaClass(name, (RubyClass)this, parentCRef);
    }

    protected IRubyObject allocateObject() {
        RubyString newString = this.getRuntime().newString("");
        newString.setMetaClass(this);
        return newString;
    }

    protected class StringMeta
    extends AbstractMetaClass.Meta {
        protected StringMeta() {
        }

        protected void initializeClass() {
            StringMetaClass.this.includeModule(StringMetaClass.this.getRuntime().getModule("Comparable"));
            StringMetaClass.this.includeModule(StringMetaClass.this.getRuntime().getModule("Enumerable"));
            StringMetaClass.this.addMethod("<=>", StringMetaClass.this.op_cmp);
            StringMetaClass.this.addMethod("==", StringMetaClass.this.equal);
            StringMetaClass.this.addMethod("===", StringMetaClass.this.veryEqual);
            StringMetaClass.this.addMethod("+", StringMetaClass.this.op_plus);
            StringMetaClass.this.addMethod("*", StringMetaClass.this.op_mul);
            StringMetaClass.this.addMethod("%", StringMetaClass.this.format);
            StringMetaClass.this.addMethod("hash", StringMetaClass.this.hash);
            StringMetaClass.this.addMethod("to_s", StringMetaClass.this.to_s);
            StringMetaClass.this.defineMethod(">=", Arity.singleArgument(), "op_ge");
            StringMetaClass.this.defineMethod(">", Arity.singleArgument(), "op_gt");
            StringMetaClass.this.defineMethod("<=", Arity.singleArgument(), "op_le");
            StringMetaClass.this.defineMethod("<", Arity.singleArgument(), "op_lt");
            StringMetaClass.this.defineMethod("[]", Arity.optional(), "aref");
            StringMetaClass.this.defineMethod("[]=", Arity.optional(), "aset");
            StringMetaClass.this.defineMethod("=~", Arity.singleArgument(), "match");
            StringMetaClass.this.defineMethod("~", Arity.noArguments(), "match2");
            StringMetaClass.this.defineMethod("capitalize", Arity.noArguments());
            StringMetaClass.this.defineMethod("capitalize!", Arity.noArguments(), "capitalize_bang");
            StringMetaClass.this.defineMethod("casecmp", Arity.singleArgument());
            StringMetaClass.this.defineMethod("center", Arity.optional());
            StringMetaClass.this.defineMethod("chop", Arity.noArguments());
            StringMetaClass.this.defineMethod("chop!", Arity.noArguments(), "chop_bang");
            StringMetaClass.this.defineMethod("chomp", Arity.optional());
            StringMetaClass.this.defineMethod("chomp!", Arity.optional(), "chomp_bang");
            StringMetaClass.this.defineMethod("clone", Arity.noArguments(), "rbClone");
            StringMetaClass.this.defineMethod("concat", Arity.singleArgument());
            StringMetaClass.this.defineMethod("count", Arity.optional());
            StringMetaClass.this.defineMethod("crypt", Arity.singleArgument());
            StringMetaClass.this.defineMethod("delete", Arity.optional());
            StringMetaClass.this.defineMethod("delete!", Arity.optional(), "delete_bang");
            StringMetaClass.this.defineMethod("downcase", Arity.noArguments());
            StringMetaClass.this.defineMethod("downcase!", Arity.noArguments(), "downcase_bang");
            StringMetaClass.this.defineMethod("dump", Arity.noArguments());
            StringMetaClass.this.defineMethod("dup", Arity.noArguments());
            StringMetaClass.this.defineMethod("each_line", Arity.optional());
            StringMetaClass.this.defineMethod("each_byte", Arity.noArguments());
            StringMetaClass.this.defineMethod("empty?", Arity.noArguments(), "empty");
            StringMetaClass.this.defineMethod("gsub", Arity.optional());
            StringMetaClass.this.defineMethod("gsub!", Arity.optional(), "gsub_bang");
            StringMetaClass.this.defineMethod("hex", Arity.noArguments());
            StringMetaClass.this.defineMethod("include?", Arity.singleArgument(), "include");
            StringMetaClass.this.defineMethod("index", Arity.optional());
            StringMetaClass.this.defineMethod("initialize", Arity.optional(), "initialize");
            StringMetaClass.this.defineMethod("initialize_copy", Arity.singleArgument(), "replace");
            StringMetaClass.this.defineMethod("insert", Arity.twoArguments());
            StringMetaClass.this.defineMethod("inspect", Arity.noArguments());
            StringMetaClass.this.defineMethod("length", Arity.noArguments());
            StringMetaClass.this.defineMethod("ljust", Arity.optional());
            StringMetaClass.this.defineMethod("lstrip", Arity.noArguments());
            StringMetaClass.this.defineMethod("lstrip!", Arity.noArguments(), "lstrip_bang");
            StringMetaClass.this.defineMethod("match", Arity.singleArgument(), "match3");
            StringMetaClass.this.defineMethod("oct", Arity.noArguments());
            StringMetaClass.this.defineMethod("replace", Arity.singleArgument());
            StringMetaClass.this.defineMethod("reverse", Arity.noArguments());
            StringMetaClass.this.defineMethod("reverse!", Arity.noArguments(), "reverse_bang");
            StringMetaClass.this.defineMethod("rindex", Arity.optional());
            StringMetaClass.this.defineMethod("rjust", Arity.optional());
            StringMetaClass.this.defineMethod("rstrip", Arity.noArguments());
            StringMetaClass.this.defineMethod("rstrip!", Arity.noArguments(), "rstrip_bang");
            StringMetaClass.this.defineMethod("scan", Arity.singleArgument());
            StringMetaClass.this.defineMethod("slice!", Arity.optional(), "slice_bang");
            StringMetaClass.this.defineMethod("split", Arity.optional());
            StringMetaClass.this.defineMethod("strip", Arity.noArguments());
            StringMetaClass.this.defineMethod("strip!", Arity.noArguments(), "strip_bang");
            StringMetaClass.this.defineMethod("succ", Arity.noArguments());
            StringMetaClass.this.defineMethod("succ!", Arity.noArguments(), "succ_bang");
            StringMetaClass.this.defineMethod("squeeze", Arity.optional());
            StringMetaClass.this.defineMethod("squeeze!", Arity.optional(), "squeeze_bang");
            StringMetaClass.this.defineMethod("sub", Arity.optional());
            StringMetaClass.this.defineMethod("sub!", Arity.optional(), "sub_bang");
            StringMetaClass.this.defineMethod("sum", Arity.optional());
            StringMetaClass.this.defineMethod("swapcase", Arity.noArguments());
            StringMetaClass.this.defineMethod("swapcase!", Arity.noArguments(), "swapcase_bang");
            StringMetaClass.this.defineMethod("to_f", Arity.noArguments());
            StringMetaClass.this.defineMethod("to_i", Arity.optional());
            StringMetaClass.this.defineMethod("to_str", Arity.noArguments());
            StringMetaClass.this.defineMethod("to_sym", Arity.noArguments());
            StringMetaClass.this.defineMethod("tr", Arity.twoArguments());
            StringMetaClass.this.defineMethod("tr!", Arity.twoArguments(), "tr_bang");
            StringMetaClass.this.defineMethod("tr_s", Arity.twoArguments());
            StringMetaClass.this.defineMethod("tr_s!", Arity.twoArguments(), "tr_s_bang");
            StringMetaClass.this.defineMethod("unpack", Arity.singleArgument());
            StringMetaClass.this.defineMethod("upcase", Arity.noArguments());
            StringMetaClass.this.defineMethod("upcase!", Arity.noArguments(), "upcase_bang");
            StringMetaClass.this.defineMethod("upto", Arity.singleArgument());
            StringMetaClass.this.defineAlias("<<", "concat");
            StringMetaClass.this.defineAlias("each", "each_line");
            StringMetaClass.this.defineAlias("eql?", "==");
            StringMetaClass.this.defineAlias("intern", "to_sym");
            StringMetaClass.this.defineAlias("next", "succ");
            StringMetaClass.this.defineAlias("next!", "succ!");
            StringMetaClass.this.defineAlias("size", "length");
            StringMetaClass.this.defineAlias("slice", "[]");
        }
    }
}

