/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import org.jruby.IRuby;
import org.jruby.RubyIO;
import org.jruby.util.DataInputBridgeStream;
import org.jruby.util.DataOutputBridgeStream;
import org.jruby.util.IOHandler;
import org.jruby.util.IOHandlerJavaIO;
import org.jruby.util.IOModes;
import org.jruby.util.JRubyFile;

public class IOHandlerSeekable
extends IOHandlerJavaIO {
    protected RandomAccessFile file;
    protected String path;

    public IOHandlerSeekable(IRuby runtime, String path, IOModes modes) throws IOException, IOHandler.InvalidValueException {
        super(runtime);
        this.path = path;
        this.modes = modes;
        JRubyFile theFile = JRubyFile.create(runtime.getCurrentDirectory(), path);
        if (theFile.exists()) {
            if (modes.shouldTruncate() && !theFile.delete()) {
                // empty if block
            }
        } else if (modes.isReadable() && !modes.isWriteable()) {
            throw new FileNotFoundException();
        }
        String javaMode = "r";
        if (modes.isWriteable()) {
            javaMode = javaMode + "w";
        }
        this.file = new RandomAccessFile(theFile, javaMode);
        this.isOpen = true;
        if (modes.isAppendable()) {
            this.seek(0L, 2);
        }
        this.fileno = RubyIO.getNewFileno();
    }

    public IOHandler cloneIOHandler() throws IOException, IOHandler.PipeException, IOHandler.InvalidValueException {
        IOHandlerSeekable newHandler = new IOHandlerSeekable(this.getRuntime(), this.path, this.modes);
        ((IOHandler)newHandler).seek(this.pos(), 1);
        return newHandler;
    }

    public void close() throws IOException, IOHandler.BadDescriptorException {
        if (!this.isOpen()) {
            throw new IOHandler.BadDescriptorException();
        }
        this.isOpen = false;
        this.file.close();
    }

    public void flush() throws IOException, IOHandler.BadDescriptorException {
        this.checkWriteable();
    }

    public InputStream getInputStream() {
        return new BufferedInputStream(new DataInputBridgeStream(this.file));
    }

    public OutputStream getOutputStream() {
        return new BufferedOutputStream(new DataOutputBridgeStream(this.file));
    }

    public boolean isEOF() throws IOException, IOHandler.BadDescriptorException {
        this.checkReadable();
        int c = this.file.read();
        if (c == -1) {
            return true;
        }
        this.file.seek(this.file.getFilePointer() - 1L);
        return false;
    }

    public int pid() {
        return -1;
    }

    public long pos() throws IOException {
        this.checkOpen();
        return this.file.getFilePointer();
    }

    public void resetByModes(IOModes newModes) throws IOException, IOHandler.InvalidValueException {
        if (newModes.isAppendable()) {
            this.seek(0L, 2);
        } else if (newModes.isWriteable()) {
            this.rewind();
        }
    }

    public void rewind() throws IOException, IOHandler.InvalidValueException {
        this.seek(0L, 0);
    }

    public void seek(long offset, int type) throws IOException, IOHandler.InvalidValueException {
        this.checkOpen();
        try {
            switch (type) {
                case 0: {
                    this.file.seek(offset);
                    break;
                }
                case 1: {
                    this.file.seek(this.file.getFilePointer() + offset);
                    break;
                }
                case 2: {
                    this.file.seek(this.file.length() + offset);
                }
            }
        }
        catch (IOException e) {
            throw new IOHandler.InvalidValueException();
        }
    }

    public void sync() throws IOException {
        this.file.getFD().sync();
    }

    public int sysread() throws IOException {
        return this.file.read();
    }

    public int syswrite(String buf) throws IOException, IOHandler.BadDescriptorException {
        this.getRuntime().secure(4);
        this.checkWriteable();
        if (buf == null || buf.length() == 0) {
            return 0;
        }
        this.file.writeBytes(buf);
        if (this.isSync()) {
            this.sync();
        }
        return buf.length();
    }

    public int syswrite(int c) throws IOException, IOHandler.BadDescriptorException {
        this.getRuntime().secure(4);
        this.checkWriteable();
        this.file.write(c);
        if (this.isSync()) {
            this.sync();
        }
        return 1;
    }

    public void truncate(long newLength) throws IOException {
        this.file.setLength(newLength);
    }

    public FileChannel getFileChannel() {
        return this.file.getChannel();
    }
}

